/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.IntDef;
import android.media.AudioTrack;
import android.media.MediaPlayer;
import android.media.PlayerBase;
import android.media.PlayerProxy;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Objects;

public final class VolumeShaper {
    private int mId;
    private final WeakReference<PlayerBase> mWeakPlayerBase;
    private final WeakReference<PlayerProxy> mWeakPlayerProxy;
    private PlayerProxy mPlayerProxy;

    public VolumeShaper(Configuration configuration, AudioTrack audioTrack) {
        this(configuration, (PlayerBase)audioTrack);
    }

    public VolumeShaper(Configuration configuration, MediaPlayer mediaPlayer) {
        this(configuration, (PlayerBase)mediaPlayer);
    }

    VolumeShaper(Configuration configuration, PlayerBase playerBase) {
        this.mWeakPlayerBase = new WeakReference<PlayerBase>(playerBase);
        this.mPlayerProxy = null;
        this.mWeakPlayerProxy = null;
        this.mId = this.applyPlayer(configuration, new Operation.Builder().defer().build());
    }

    public VolumeShaper(Configuration configuration, PlayerProxy playerProxy, boolean keepReference) {
        if (configuration.getId() < 0) {
            throw new IllegalArgumentException("playerProxy configuration id must be specified");
        }
        if (keepReference) {
            this.mPlayerProxy = playerProxy;
            this.mWeakPlayerProxy = null;
        } else {
            this.mWeakPlayerProxy = new WeakReference<PlayerProxy>(playerProxy);
            this.mPlayerProxy = null;
        }
        this.mWeakPlayerBase = null;
        this.mId = this.applyPlayer(configuration, new Operation.Builder().defer().build());
    }

    int getId() {
        return this.mId;
    }

    public void apply(Operation operation) {
        this.applyPlayer(new Configuration(this.mId), operation);
    }

    public void replace(Configuration configuration, Operation operation, boolean join) {
        this.mId = this.applyPlayer(configuration, new Operation.Builder(operation).replace(this.mId, join).build());
    }

    public float getVolume() {
        return this.getStatePlayer(this.mId).getVolume();
    }

    public void release() {
        try {
            this.applyPlayer(new Configuration(this.mId), new Operation.Builder().terminate().build());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.mWeakPlayerBase != null) {
            this.mWeakPlayerBase.clear();
        }
        if (this.mWeakPlayerProxy != null) {
            this.mWeakPlayerProxy.clear();
        }
        this.mPlayerProxy = null;
    }

    protected void finalize() {
        this.release();
    }

    private int applyPlayer(Configuration configuration, Operation operation) {
        int id2;
        if (this.mPlayerProxy != null || this.mWeakPlayerProxy != null) {
            PlayerProxy player;
            PlayerProxy playerProxy = player = this.mWeakPlayerProxy != null ? (PlayerProxy)this.mWeakPlayerProxy.get() : this.mPlayerProxy;
            if (player == null) {
                throw new IllegalStateException("player deallocated");
            }
            id2 = configuration.getId();
            if (id2 < 0) {
                throw new IllegalArgumentException("proxy requires configuration with id");
            }
            player.applyVolumeShaper(configuration, operation);
        } else if (this.mWeakPlayerBase != null) {
            PlayerBase player = (PlayerBase)this.mWeakPlayerBase.get();
            if (player == null) {
                throw new IllegalStateException("player deallocated");
            }
            id2 = player.playerApplyVolumeShaper(configuration, operation);
        } else {
            throw new IllegalStateException("uninitialized shaper");
        }
        if (id2 < 0) {
            int VOLUME_SHAPER_INVALID_OPERATION = -38;
            if (id2 == -38) {
                throw new IllegalStateException("player or volume shaper deallocated");
            }
            throw new IllegalArgumentException("invalid configuration or operation: " + id2);
        }
        return id2;
    }

    private State getStatePlayer(int id2) {
        PlayerBase player;
        if (this.mPlayerProxy != null || this.mWeakPlayerProxy != null) {
            throw new IllegalStateException("getStatePlayer not permitted through proxy");
        }
        if (this.mWeakPlayerBase != null) {
            player = (PlayerBase)this.mWeakPlayerBase.get();
            if (player == null) {
                throw new IllegalStateException("player deallocated");
            }
        } else {
            throw new IllegalStateException("uninitialized shaper");
        }
        State state = player.playerGetVolumeShaperState(id2);
        if (state == null) {
            throw new IllegalStateException("shaper cannot be found");
        }
        return state;
    }

    public static final class State
    implements Parcelable {
        private float mVolume;
        private float mXOffset;
        public static final Parcelable.Creator<State> CREATOR = new Parcelable.Creator<State>(){

            @Override
            public State createFromParcel(Parcel p) {
                return new State(p.readFloat(), p.readFloat());
            }

            public State[] newArray(int size) {
                return new State[size];
            }
        };

        public String toString() {
            return "VolumeShaper.State[mVolume=" + this.mVolume + ",mXOffset" + this.mXOffset + "]";
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.mVolume), Float.valueOf(this.mXOffset));
        }

        public boolean equals(Object o) {
            if (!(o instanceof State)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            State other = (State)o;
            return this.mVolume == other.mVolume && this.mXOffset == other.mXOffset;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeFloat(this.mVolume);
            dest.writeFloat(this.mXOffset);
        }

        State(float volume, float xOffset) {
            this.mVolume = volume;
            this.mXOffset = xOffset;
        }

        public float getVolume() {
            return this.mVolume;
        }

        public double getXOffset() {
            return this.mXOffset;
        }
    }

    public static final class Operation
    implements Parcelable {
        public static final Operation PLAY = new Builder().build();
        public static final Operation REVERSE = new Builder().reverse().build();
        private static final int FLAG_NONE = 0;
        private static final int FLAG_REVERSE = 1;
        private static final int FLAG_TERMINATE = 2;
        private static final int FLAG_JOIN = 4;
        private static final int FLAG_DEFER = 8;
        private static final int FLAG_PUBLIC_ALL = 3;
        private final int mFlags;
        private final int mReplaceId;
        public static final Parcelable.Creator<Operation> CREATOR = new Parcelable.Creator<Operation>(){

            @Override
            public Operation createFromParcel(Parcel p) {
                return new Operation(p.readInt(), p.readInt());
            }

            public Operation[] newArray(int size) {
                return new Operation[size];
            }
        };

        public String toString() {
            return "VolumeShaper.Operation[mFlags=" + this.mFlags + ",mReplaceId" + this.mReplaceId + "]";
        }

        public int hashCode() {
            return Objects.hash(this.mFlags, this.mReplaceId);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Operation)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Operation other = (Operation)o;
            return this.mFlags == other.mFlags && this.mReplaceId == other.mReplaceId;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mFlags);
            dest.writeInt(this.mReplaceId);
        }

        private Operation(int flags, int replaceId) {
            this.mFlags = flags;
            this.mReplaceId = replaceId;
        }

        public static final class Builder {
            int mFlags;
            int mReplaceId;

            public Builder() {
                this.mFlags = 0;
                this.mReplaceId = -1;
            }

            public Builder(Operation operation) {
                this.mReplaceId = operation.mReplaceId;
                this.mFlags = operation.mFlags;
            }

            public Builder replace(int id2, boolean join) {
                this.mReplaceId = id2;
                this.mFlags = join ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
                return this;
            }

            public Builder defer() {
                this.mFlags |= 8;
                return this;
            }

            public Builder terminate() {
                this.mFlags |= 2;
                return this;
            }

            public Builder reverse() {
                this.mFlags ^= 1;
                return this;
            }

            private Builder setFlags(int flags) {
                if ((flags & 0xFFFFFFFC) != 0) {
                    throw new IllegalArgumentException("flag has unknown bits set: " + flags);
                }
                this.mFlags = this.mFlags & 0xFFFFFFFC | flags;
                return this;
            }

            public Operation build() {
                return new Operation(this.mFlags, this.mReplaceId);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L, 4L, 8L})
        public static @interface Flag {
        }
    }

    public static final class Configuration
    implements Parcelable {
        private static final int MAXIMUM_CURVE_POINTS = 16;
        static final int TYPE_ID = 0;
        static final int TYPE_SCALE = 1;
        public static final int INTERPOLATOR_TYPE_STEP = 0;
        public static final int INTERPOLATOR_TYPE_LINEAR = 1;
        public static final int INTERPOLATOR_TYPE_CUBIC = 2;
        public static final int INTERPOLATOR_TYPE_CUBIC_MONOTONIC = 3;
        public static final int OPTION_FLAG_VOLUME_IN_DBFS = 1;
        public static final int OPTION_FLAG_CLOCK_TIME = 2;
        private static final int OPTION_FLAG_PUBLIC_ALL = 3;
        public static final Configuration LINEAR_RAMP = new Builder().setInterpolatorType(1).setCurve(new float[]{0.0f, 1.0f}, new float[]{0.0f, 1.0f}).setDurationMs(1000.0).build();
        public static final Configuration CUBIC_RAMP = new Builder().setInterpolatorType(2).setCurve(new float[]{0.0f, 1.0f}, new float[]{0.0f, 1.0f}).setDurationMs(1000.0).build();
        public static final Configuration SINE_RAMP;
        public static final Configuration SCURVE_RAMP;
        private final int mType;
        private final int mId;
        private final int mInterpolatorType;
        private final int mOptionFlags;
        private final double mDurationMs;
        private final float[] mTimes;
        private final float[] mVolumes;
        public static final Parcelable.Creator<Configuration> CREATOR;

        public static int getMaximumCurvePoints() {
            return 16;
        }

        public String toString() {
            return "VolumeShaper.Configuration[mType=" + this.mType + (this.mType == 0 ? ",mId" + this.mId : ",mInterpolatorType=" + this.mInterpolatorType + ",mOptionFlags=" + this.mOptionFlags + ",mDurationMs=" + this.mDurationMs + ",mTimes[]=" + this.mTimes + ",mVolumes[]=" + this.mVolumes + "]");
        }

        public int hashCode() {
            return this.mType == 0 ? Objects.hash(this.mType, this.mId) : Objects.hash(this.mType, this.mInterpolatorType, this.mDurationMs, this.mTimes, this.mVolumes);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Configuration)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Configuration other = (Configuration)o;
            return this.mType == other.mType && (this.mType == 0 ? this.mId == other.mId : this.mInterpolatorType == other.mInterpolatorType && this.mDurationMs == other.mDurationMs && this.mTimes == other.mTimes && this.mVolumes == other.mVolumes);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeInt(this.mId);
            if (this.mType != 0) {
                dest.writeInt(this.mInterpolatorType);
                dest.writeInt(this.mOptionFlags);
                dest.writeDouble(this.mDurationMs);
                dest.writeFloatArray(this.mTimes);
                dest.writeFloatArray(this.mVolumes);
            }
        }

        private Configuration(int id2) {
            if (id2 < 0) {
                throw new IllegalArgumentException("negative id " + id2);
            }
            this.mType = 0;
            this.mId = id2;
            this.mInterpolatorType = 0;
            this.mOptionFlags = 0;
            this.mDurationMs = 0.0;
            this.mTimes = null;
            this.mVolumes = null;
        }

        private Configuration(int type, int id2, int interpolatorType, int optionFlags, double durationMs, float[] times, float[] volumes) {
            this.mType = type;
            this.mId = id2;
            this.mInterpolatorType = interpolatorType;
            this.mOptionFlags = optionFlags;
            this.mDurationMs = durationMs;
            this.mTimes = times;
            this.mVolumes = volumes;
        }

        public int getType() {
            return this.mType;
        }

        public int getId() {
            return this.mId;
        }

        public int getInterpolatorType() {
            return this.mInterpolatorType;
        }

        public int getOptionFlags() {
            return this.mOptionFlags & 3;
        }

        int getAllOptionFlags() {
            return this.mOptionFlags;
        }

        public double getDurationMs() {
            return this.mDurationMs;
        }

        public float[] getTimes() {
            return this.mTimes;
        }

        public float[] getVolumes() {
            return this.mVolumes;
        }

        private static String checkCurveForErrors(float[] times, float[] volumes, boolean log) {
            int i;
            if (times.length != volumes.length) {
                return "array length must match";
            }
            if (times.length < 2) {
                return "array length must be at least 2";
            }
            if (times.length > 16) {
                return "array length must be no larger than 16";
            }
            if (times[0] != 0.0f) {
                return "times must start at 0.f";
            }
            if (times[times.length - 1] != 1.0f) {
                return "times must end at 1.f";
            }
            for (i = 1; i < times.length; ++i) {
                if (times[i] > times[i - 1]) continue;
                return "times not monotonic increasing, check index " + i;
            }
            if (log) {
                for (i = 0; i < volumes.length; ++i) {
                    if (volumes[i] <= 0.0f) continue;
                    return "volumes for log scale cannot be positive, check index " + i;
                }
            } else {
                for (i = 0; i < volumes.length; ++i) {
                    if (volumes[i] >= 0.0f && volumes[i] <= 1.0f) continue;
                    return "volumes for linear scale must be between 0.f and 1.f, check index " + i;
                }
            }
            return null;
        }

        private static void checkValidVolume(float volume, boolean log) {
            if (log) {
                if (!(volume <= 0.0f)) {
                    throw new IllegalArgumentException("dbfs volume must be 0.f or less");
                }
            } else if (!(volume >= 0.0f) || !(volume <= 1.0f)) {
                throw new IllegalArgumentException("volume must be >= 0.f and <= 1.f");
            }
        }

        private static void clampVolume(float[] volumes, boolean log) {
            if (log) {
                for (int i = 0; i < volumes.length; ++i) {
                    if (volumes[i] <= 0.0f) continue;
                    volumes[i] = 0.0f;
                }
            } else {
                for (int i = 0; i < volumes.length; ++i) {
                    if (!(volumes[i] >= 0.0f)) {
                        volumes[i] = 0.0f;
                        continue;
                    }
                    if (volumes[i] <= 1.0f) continue;
                    volumes[i] = 1.0f;
                }
            }
        }

        static {
            int POINTS = 16;
            float[] times = new float[16];
            float[] sines = new float[16];
            float[] scurve = new float[16];
            for (int i = 0; i < 16; ++i) {
                float sine;
                times[i] = (float)i / 15.0f;
                sines[i] = sine = (float)Math.sin((double)times[i] * Math.PI / 2.0);
                scurve[i] = sine * sine;
            }
            SINE_RAMP = new Builder().setInterpolatorType(2).setCurve(times, sines).setDurationMs(1000.0).build();
            SCURVE_RAMP = new Builder().setInterpolatorType(2).setCurve(times, scurve).setDurationMs(1000.0).build();
            CREATOR = new Parcelable.Creator<Configuration>(){

                @Override
                public Configuration createFromParcel(Parcel p) {
                    int type = p.readInt();
                    int id2 = p.readInt();
                    if (type == 0) {
                        return new Configuration(id2);
                    }
                    return new Configuration(type, id2, p.readInt(), p.readInt(), p.readDouble(), p.createFloatArray(), p.createFloatArray());
                }

                public Configuration[] newArray(int size) {
                    return new Configuration[size];
                }
            };
        }

        public static final class Builder {
            private int mType = 1;
            private int mId = -1;
            private int mInterpolatorType = 2;
            private int mOptionFlags = 0;
            private double mDurationMs = 1000.0;
            private float[] mTimes = null;
            private float[] mVolumes = null;

            public Builder() {
            }

            public Builder(Configuration configuration) {
                this.mType = configuration.getType();
                this.mId = configuration.getId();
                this.mOptionFlags = configuration.getAllOptionFlags();
                this.mInterpolatorType = configuration.getInterpolatorType();
                this.mDurationMs = configuration.getDurationMs();
                this.mTimes = configuration.getTimes();
                this.mVolumes = configuration.getVolumes();
            }

            public Builder setId(int id2) {
                this.mId = id2;
                return this;
            }

            public Builder setInterpolatorType(int interpolatorType) {
                switch (interpolatorType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.mInterpolatorType = interpolatorType;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid interpolatorType: " + interpolatorType);
                    }
                }
                return this;
            }

            public Builder setOptionFlags(int optionFlags) {
                if ((optionFlags & 0xFFFFFFFC) != 0) {
                    throw new IllegalArgumentException("invalid bits in flag: " + optionFlags);
                }
                this.mOptionFlags = this.mOptionFlags & 0xFFFFFFFC | optionFlags;
                return this;
            }

            public Builder setDurationMs(double durationMs) {
                if (durationMs <= 0.0) {
                    throw new IllegalArgumentException("duration: " + durationMs + " not positive");
                }
                this.mDurationMs = durationMs;
                return this;
            }

            public Builder setCurve(float[] times, float[] volumes) {
                String error = Configuration.checkCurveForErrors(times, volumes, (this.mOptionFlags & 1) != 0);
                if (error != null) {
                    throw new IllegalArgumentException(error);
                }
                this.mTimes = (float[])times.clone();
                this.mVolumes = (float[])volumes.clone();
                return this;
            }

            public Builder reflectTimes() {
                int i;
                for (i = 0; i < this.mTimes.length / 2; ++i) {
                    float temp = this.mTimes[0];
                    this.mTimes[i] = 1.0f - this.mTimes[this.mTimes.length - 1 - i];
                    this.mTimes[this.mTimes.length - 1 - i] = 1.0f - temp;
                }
                if ((this.mTimes.length & 1) != 0) {
                    this.mTimes[i] = 1.0f - this.mTimes[i];
                }
                return this;
            }

            public Builder invertVolumes() {
                if (this.mVolumes.length >= 2) {
                    float min = this.mVolumes[0];
                    float max = this.mVolumes[0];
                    for (int i = 1; i < this.mVolumes.length; ++i) {
                        if (this.mVolumes[i] < min) {
                            min = this.mVolumes[i];
                            continue;
                        }
                        if (!(this.mVolumes[i] > max)) continue;
                        max = this.mVolumes[i];
                    }
                    float maxmin = max + min;
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = maxmin - this.mVolumes[i];
                    }
                }
                return this;
            }

            public Builder scaleToEndVolume(float volume) {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkValidVolume(volume, log);
                float startVolume = this.mVolumes[0];
                float endVolume = this.mVolumes[this.mVolumes.length - 1];
                if (endVolume == startVolume) {
                    float offset = volume - startVolume;
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = this.mVolumes[i] + offset * this.mTimes[i];
                    }
                } else {
                    float scale = (volume - startVolume) / (endVolume - startVolume);
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = scale * (this.mVolumes[i] - startVolume) + startVolume;
                    }
                }
                Configuration.clampVolume(this.mVolumes, log);
                return this;
            }

            public Builder scaleToStartVolume(float volume) {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkValidVolume(volume, log);
                float startVolume = this.mVolumes[0];
                float endVolume = this.mVolumes[this.mVolumes.length - 1];
                if (endVolume == startVolume) {
                    float offset = volume - startVolume;
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = this.mVolumes[i] + offset * (1.0f - this.mTimes[i]);
                    }
                } else {
                    float scale = (volume - endVolume) / (startVolume - endVolume);
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = scale * (this.mVolumes[i] - endVolume) + endVolume;
                    }
                }
                Configuration.clampVolume(this.mVolumes, log);
                return this;
            }

            public Configuration build() {
                String error = Configuration.checkCurveForErrors(this.mTimes, this.mVolumes, (this.mOptionFlags & 1) != 0);
                if (error != null) {
                    throw new IllegalArgumentException(error);
                }
                return new Configuration(this.mType, this.mId, this.mInterpolatorType, this.mOptionFlags, this.mDurationMs, this.mTimes, this.mVolumes);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={1L, 2L})
        public static @interface OptionFlag {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L, 3L})
        public static @interface InterpolatorType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L})
        public static @interface Type {
        }
    }
}

