/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.StringDef;
import android.content.ComponentName;
import android.content.ContentUris;
import android.net.Uri;
import android.provider.BaseColumns;
import android.text.TextUtils;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TvContract {
    public static final String AUTHORITY = "android.media.tv";
    public static final String PERMISSION_READ_TV_LISTINGS = "android.permission.READ_TV_LISTINGS";
    private static final String PATH_CHANNEL = "channel";
    private static final String PATH_PROGRAM = "program";
    private static final String PATH_RECORDED_PROGRAM = "recorded_program";
    private static final String PATH_PREVIEW_PROGRAM = "preview_program";
    private static final String PATH_PASSTHROUGH = "passthrough";
    public static final String PARAM_INPUT = "input";
    public static final String PARAM_CHANNEL = "channel";
    public static final String PARAM_START_TIME = "start_time";
    public static final String PARAM_END_TIME = "end_time";
    public static final String PARAM_BROWSABLE_ONLY = "browsable_only";
    public static final String PARAM_CANONICAL_GENRE = "canonical_genre";

    public static final String buildInputId(ComponentName name) {
        return name.flattenToShortString();
    }

    public static final Uri buildChannelUri(long channelId) {
        return ContentUris.withAppendedId(Channels.CONTENT_URI, channelId);
    }

    public static final Uri buildChannelUriForPassthroughInput(String inputId) {
        return new Uri.Builder().scheme("content").authority(AUTHORITY).appendPath(PATH_PASSTHROUGH).appendPath(inputId).build();
    }

    public static final Uri buildChannelLogoUri(long channelId) {
        return TvContract.buildChannelLogoUri(TvContract.buildChannelUri(channelId));
    }

    public static final Uri buildChannelLogoUri(Uri channelUri) {
        if (!TvContract.isChannelUriForTunerInput(channelUri)) {
            throw new IllegalArgumentException("Not a channel: " + channelUri);
        }
        return Uri.withAppendedPath(channelUri, "logo");
    }

    public static final Uri buildChannelsUriForInput(String inputId) {
        return TvContract.buildChannelsUriForInput(inputId, false);
    }

    public static final Uri buildChannelsUriForInput(String inputId, boolean browsableOnly) {
        Uri.Builder builder = Channels.CONTENT_URI.buildUpon();
        if (inputId != null) {
            builder.appendQueryParameter(PARAM_INPUT, inputId);
        }
        return builder.appendQueryParameter(PARAM_BROWSABLE_ONLY, String.valueOf(browsableOnly)).build();
    }

    public static final Uri buildChannelsUriForInput(String inputId, String genre, boolean browsableOnly) {
        if (genre == null) {
            return TvContract.buildChannelsUriForInput(inputId, browsableOnly);
        }
        if (!Programs.Genres.isCanonical(genre)) {
            throw new IllegalArgumentException("Not a canonical genre: '" + genre + "'");
        }
        return TvContract.buildChannelsUriForInput(inputId, browsableOnly).buildUpon().appendQueryParameter(PARAM_CANONICAL_GENRE, genre).build();
    }

    public static final Uri buildProgramUri(long programId) {
        return ContentUris.withAppendedId(Programs.CONTENT_URI, programId);
    }

    public static final Uri buildProgramsUriForChannel(long channelId) {
        return Programs.CONTENT_URI.buildUpon().appendQueryParameter("channel", String.valueOf(channelId)).build();
    }

    public static final Uri buildProgramsUriForChannel(Uri channelUri) {
        if (!TvContract.isChannelUriForTunerInput(channelUri)) {
            throw new IllegalArgumentException("Not a channel: " + channelUri);
        }
        return TvContract.buildProgramsUriForChannel(ContentUris.parseId(channelUri));
    }

    public static final Uri buildProgramsUriForChannel(long channelId, long startTime, long endTime) {
        Uri uri = TvContract.buildProgramsUriForChannel(channelId);
        return uri.buildUpon().appendQueryParameter(PARAM_START_TIME, String.valueOf(startTime)).appendQueryParameter(PARAM_END_TIME, String.valueOf(endTime)).build();
    }

    public static final Uri buildProgramsUriForChannel(Uri channelUri, long startTime, long endTime) {
        if (!TvContract.isChannelUriForTunerInput(channelUri)) {
            throw new IllegalArgumentException("Not a channel: " + channelUri);
        }
        return TvContract.buildProgramsUriForChannel(ContentUris.parseId(channelUri), startTime, endTime);
    }

    public static final Uri buildRecordedProgramUri(long recordedProgramId) {
        return ContentUris.withAppendedId(RecordedPrograms.CONTENT_URI, recordedProgramId);
    }

    public static final Uri buildPreviewProgramUri(long previewProgramId) {
        return ContentUris.withAppendedId(PreviewPrograms.CONTENT_URI, previewProgramId);
    }

    public static final Uri buildPreviewProgramsUriForChannel(long channelId) {
        return PreviewPrograms.CONTENT_URI.buildUpon().appendQueryParameter("channel", String.valueOf(channelId)).build();
    }

    public static final Uri buildPreviewProgramsUriForChannel(Uri channelUri) {
        if (!TvContract.isChannelUriForTunerInput(channelUri)) {
            throw new IllegalArgumentException("Not a channel: " + channelUri);
        }
        return TvContract.buildPreviewProgramsUriForChannel(ContentUris.parseId(channelUri));
    }

    public static final Uri buildWatchedProgramUri(long watchedProgramId) {
        return ContentUris.withAppendedId(WatchedPrograms.CONTENT_URI, watchedProgramId);
    }

    private static boolean isTvUri(Uri uri) {
        return uri != null && "content".equals(uri.getScheme()) && AUTHORITY.equals(uri.getAuthority());
    }

    private static boolean isTwoSegmentUriStartingWith(Uri uri, String pathSegment) {
        List<String> pathSegments = uri.getPathSegments();
        return pathSegments.size() == 2 && pathSegment.equals(pathSegments.get(0));
    }

    public static final boolean isChannelUri(Uri uri) {
        return TvContract.isChannelUriForTunerInput(uri) || TvContract.isChannelUriForPassthroughInput(uri);
    }

    public static final boolean isChannelUriForTunerInput(Uri uri) {
        return TvContract.isTvUri(uri) && TvContract.isTwoSegmentUriStartingWith(uri, "channel");
    }

    public static final boolean isChannelUriForPassthroughInput(Uri uri) {
        return TvContract.isTvUri(uri) && TvContract.isTwoSegmentUriStartingWith(uri, PATH_PASSTHROUGH);
    }

    public static final boolean isProgramUri(Uri uri) {
        return TvContract.isTvUri(uri) && TvContract.isTwoSegmentUriStartingWith(uri, PATH_PROGRAM);
    }

    private TvContract() {
    }

    public static final class WatchedPrograms
    implements BaseTvColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://android.media.tv/watched_program");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/watched_program";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/watched_program";
        public static final String COLUMN_WATCH_START_TIME_UTC_MILLIS = "watch_start_time_utc_millis";
        public static final String COLUMN_WATCH_END_TIME_UTC_MILLIS = "watch_end_time_utc_millis";
        public static final String COLUMN_CHANNEL_ID = "channel_id";
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_START_TIME_UTC_MILLIS = "start_time_utc_millis";
        public static final String COLUMN_END_TIME_UTC_MILLIS = "end_time_utc_millis";
        public static final String COLUMN_DESCRIPTION = "description";
        public static final String COLUMN_INTERNAL_TUNE_PARAMS = "tune_params";
        public static final String COLUMN_INTERNAL_SESSION_TOKEN = "session_token";

        private WatchedPrograms() {
        }
    }

    public static final class PreviewPrograms
    implements BaseProgramColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://android.media.tv/preview_program");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/preview_program";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/preview_program";
        public static final String TYPE_MOVIE = "TYPE_MOVIE";
        public static final String TYPE_TV_SERIES = "TYPE_TV_SERIES";
        public static final String TYPE_TV_SEASON = "TYPE_TV_SEASON";
        public static final String TYPE_TV_EPISODE = "TYPE_TV_EPISODE";
        public static final String TYPE_CLIP = "TYPE_CLIP";
        public static final String TYPE_EVENT = "TYPE_EVENT";
        public static final String TYPE_CHANNEL = "TYPE_CHANNEL";
        public static final String TYPE_TRACK = "TYPE_TRACK";
        public static final String TYPE_ALBUM = "TYPE_ALBUM";
        public static final String TYPE_ARTIST = "TYPE_ARTIST";
        public static final String TYPE_PLAYLIST = "TYPE_PLAYLIST";
        public static final String TYPE_STATION = "TYPE_STATION";
        public static final String WATCH_NEXT_TYPE_CONTINUE = "WATCH_NEXT_TYPE_CONTINUE";
        public static final String WATCH_NEXT_TYPE_NEXT = "WATCH_NEXT_TYPE_NEXT";
        public static final String WATCH_NEXT_TYPE_NEW = "WATCH_NEXT_TYPE_NEW";
        public static final String ASPECT_RATIO_16_9 = "ASPECT_RATIO_16_9";
        public static final String ASPECT_RATIO_3_2 = "ASPECT_RATIO_3_2";
        public static final String ASPECT_RATIO_1_1 = "ASPECT_RATIO_1_1";
        public static final String ASPECT_RATIO_2_3 = "ASPECT_RATIO_2_3";
        public static final String AVAILABILITY_AVAILABLE = "AVAILABILITY_AVAILABLE";
        public static final String AVAILABILITY_FREE_WITH_SUBSCRIPTION = "AVAILABILITY_FREE_WITH_SUBSCRIPTION";
        public static final String AVAILABILITY_PAID_CONTENT = "AVAILABILITY_PAID_CONTENT";
        public static final String INTERACTION_TYPE_LISTENS = "INTERACTION_TYPE_LISTENS";
        public static final String INTERACTION_TYPE_FOLLOWERS = "INTERACTION_TYPE_FOLLOWERS";
        public static final String INTERACTION_TYPE_FANS = "INTERACTION_TYPE_FANS";
        public static final String INTERACTION_TYPE_LIKES = "INTERACTION_TYPE_LIKES";
        public static final String INTERACTION_TYPE_THUMBS = "INTERACTION_TYPE_THUMBS";
        public static final String INTERACTION_TYPE_VIEWS = "INTERACTION_TYPE_VIEWS";
        public static final String INTERACTION_TYPE_VIEWERS = "INTERACTION_TYPE_VIEWERS";
        public static final String REVIEW_RATING_STYLE_STARS = "REVIEW_RATING_STYLE_STARS";
        public static final String REVIEW_RATING_STYLE_THUMBS_UP_DOWN = "REVIEW_RATING_STYLE_THUMBS_UP_DOWN";
        public static final String REVIEW_RATING_STYLE_PERCENTAGE = "REVIEW_RATING_STYLE_PERCENTAGE";
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_WATCH_NEXT_TYPE = "watch_next_type";
        public static final String COLUMN_POSTER_ART_ASPECT_RATIO = "poster_art_aspect_ratio";
        public static final String COLUMN_THUMBNAIL_ASPECT_RATIO = "poster_thumbnail_aspect_ratio";
        public static final String COLUMN_LOGO_URI = "logo_uri";
        public static final String COLUMN_AVAILABILITY = "availability";
        public static final String COLUMN_STARTING_PRICE = "starting_price";
        public static final String COLUMN_OFFER_PRICE = "offer_price";
        public static final String COLUMN_RELEASE_DATE = "release_date";
        public static final String COLUMN_ITEM_COUNT = "item_count";
        public static final String COLUMN_LIVE = "live";
        public static final String COLUMN_INTERNAL_PROVIDER_ID = "internal_provider_id";
        public static final String COLUMN_PREVIEW_VIDEO_URI = "preview_video_uri";
        public static final String COLUMN_LAST_PLAYBACK_POSITION_MILLIS = "last_playback_position_millis";
        public static final String COLUMN_DURATION_MILLIS = "duration_millis";
        public static final String COLUMN_APP_LINK_INTENT_URI = "app_link_intent_uri";
        public static final String COLUMN_WEIGHT = "weight";
        public static final String COLUMN_TRANSIENT = "transient";
        public static final String COLUMN_INTERACTION_TYPE = "interaction_type";
        public static final String COLUMN_INTERACTION_COUNT = "interaction_count";
        public static final String COLUMN_AUTHOR = "author";
        public static final String COLUMN_REVIEW_RATING_STYLE = "review_rating_style";
        public static final String COLUMN_REVIEW_RATING = "review_rating";
        public static final String COLUMN_BROWSABLE = "browsable";

        private PreviewPrograms() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"REVIEW_RATING_STYLE_STARS", "REVIEW_RATING_STYLE_THUMBS_UP_DOWN", "REVIEW_RATING_STYLE_PERCENTAGE"})
        public static @interface ReviewRatingStyle {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"INTERACTION_TYPE_LISTENS", "INTERACTION_TYPE_FOLLOWERS", "INTERACTION_TYPE_FANS", "INTERACTION_TYPE_LIKES", "INTERACTION_TYPE_THUMBS", "INTERACTION_TYPE_VIEWS", "INTERACTION_TYPE_VIEWERS"})
        public static @interface InteractionType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"AVAILABILITY_AVAILABLE", "AVAILABILITY_FREE_WITH_SUBSCRIPTION", "AVAILABILITY_PAID_CONTENT"})
        public static @interface Availability {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"ASPECT_RATIO_16_9", "ASPECT_RATIO_3_2", "ASPECT_RATIO_1_1", "ASPECT_RATIO_2_3"})
        public static @interface AspectRatio {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"WATCH_NEXT_TYPE_CONTINUE", "WATCH_NEXT_TYPE_NEXT", "WATCH_NEXT_TYPE_NEW"})
        public static @interface WatchNextType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"TYPE_MOVIE", "TYPE_TV_SERIES", "TYPE_TV_SEASON", "TYPE_TV_EPISODE", "TYPE_CLIP", "TYPE_EVENT", "TYPE_CHANNEL", "TYPE_TRACK", "TYPE_ALBUM", "TYPE_ARTIST", "TYPE_PLAYLIST", "TYPE_STATION"})
        public static @interface Type {
        }
    }

    public static final class RecordedPrograms
    implements BaseProgramColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://android.media.tv/recorded_program");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/recorded_program";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/recorded_program";
        public static final String COLUMN_INPUT_ID = "input_id";
        public static final String COLUMN_START_TIME_UTC_MILLIS = "start_time_utc_millis";
        public static final String COLUMN_END_TIME_UTC_MILLIS = "end_time_utc_millis";
        public static final String COLUMN_BROADCAST_GENRE = "broadcast_genre";
        public static final String COLUMN_RECORDING_DATA_URI = "recording_data_uri";
        public static final String COLUMN_RECORDING_DATA_BYTES = "recording_data_bytes";
        public static final String COLUMN_RECORDING_DURATION_MILLIS = "recording_duration_millis";
        public static final String COLUMN_RECORDING_EXPIRE_TIME_UTC_MILLIS = "recording_expire_time_utc_millis";

        private RecordedPrograms() {
        }
    }

    public static final class Programs
    implements BaseProgramColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://android.media.tv/program");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/program";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/program";
        @Deprecated
        public static final String COLUMN_SEASON_NUMBER = "season_number";
        @Deprecated
        public static final String COLUMN_EPISODE_NUMBER = "episode_number";
        public static final String COLUMN_START_TIME_UTC_MILLIS = "start_time_utc_millis";
        public static final String COLUMN_END_TIME_UTC_MILLIS = "end_time_utc_millis";
        public static final String COLUMN_BROADCAST_GENRE = "broadcast_genre";
        public static final String COLUMN_RECORDING_PROHIBITED = "recording_prohibited";

        private Programs() {
        }

        public static final class Genres {
            public static final String FAMILY_KIDS = "FAMILY_KIDS";
            public static final String SPORTS = "SPORTS";
            public static final String SHOPPING = "SHOPPING";
            public static final String MOVIES = "MOVIES";
            public static final String COMEDY = "COMEDY";
            public static final String TRAVEL = "TRAVEL";
            public static final String DRAMA = "DRAMA";
            public static final String EDUCATION = "EDUCATION";
            public static final String ANIMAL_WILDLIFE = "ANIMAL_WILDLIFE";
            public static final String NEWS = "NEWS";
            public static final String GAMING = "GAMING";
            public static final String ARTS = "ARTS";
            public static final String ENTERTAINMENT = "ENTERTAINMENT";
            public static final String LIFE_STYLE = "LIFE_STYLE";
            public static final String MUSIC = "MUSIC";
            public static final String PREMIER = "PREMIER";
            public static final String TECH_SCIENCE = "TECH_SCIENCE";
            private static final ArraySet<String> CANONICAL_GENRES = new ArraySet();
            private static final char DOUBLE_QUOTE = '\"';
            private static final char COMMA = ',';
            private static final String DELIMITER = ",";
            private static final String[] EMPTY_STRING_ARRAY;

            private Genres() {
            }

            public static String encode(String ... genres) {
                if (genres == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                String separator = "";
                for (String genre : genres) {
                    sb.append(separator).append(Genres.encodeToCsv(genre));
                    separator = DELIMITER;
                }
                return sb.toString();
            }

            private static String encodeToCsv(String genre) {
                StringBuilder sb = new StringBuilder();
                int length = genre.length();
                for (int i = 0; i < length; ++i) {
                    char c = genre.charAt(i);
                    switch (c) {
                        case '\"': {
                            sb.append('\"');
                            break;
                        }
                        case ',': {
                            sb.append('\"');
                        }
                    }
                    sb.append(c);
                }
                return sb.toString();
            }

            /*
             * Enabled aggressive block sorting
             */
            public static String[] decode(String genres) {
                if (TextUtils.isEmpty(genres)) {
                    return EMPTY_STRING_ARRAY;
                }
                if (genres.indexOf(44) == -1 && genres.indexOf(34) == -1) {
                    return new String[]{genres.trim()};
                }
                StringBuilder sb = new StringBuilder();
                ArrayList<String> results = new ArrayList<String>();
                int length = genres.length();
                boolean escape = false;
                block4: for (int i = 0; i < length; ++i) {
                    char c = genres.charAt(i);
                    switch (c) {
                        case '\"': {
                            if (escape) break;
                            escape = true;
                            continue block4;
                        }
                        case ',': {
                            if (escape) break;
                            String string2 = sb.toString().trim();
                            if (string2.length() > 0) {
                                results.add(string2);
                            }
                            sb = new StringBuilder();
                            continue block4;
                        }
                    }
                    sb.append(c);
                    escape = false;
                }
                String string3 = sb.toString().trim();
                if (string3.length() > 0) {
                    results.add(string3);
                }
                return results.toArray(new String[results.size()]);
            }

            public static boolean isCanonical(String genre) {
                return CANONICAL_GENRES.contains(genre);
            }

            static {
                CANONICAL_GENRES.add(FAMILY_KIDS);
                CANONICAL_GENRES.add(SPORTS);
                CANONICAL_GENRES.add(SHOPPING);
                CANONICAL_GENRES.add(MOVIES);
                CANONICAL_GENRES.add(COMEDY);
                CANONICAL_GENRES.add(TRAVEL);
                CANONICAL_GENRES.add(DRAMA);
                CANONICAL_GENRES.add(EDUCATION);
                CANONICAL_GENRES.add(ANIMAL_WILDLIFE);
                CANONICAL_GENRES.add(NEWS);
                CANONICAL_GENRES.add(GAMING);
                CANONICAL_GENRES.add(ARTS);
                CANONICAL_GENRES.add(ENTERTAINMENT);
                CANONICAL_GENRES.add(LIFE_STYLE);
                CANONICAL_GENRES.add(MUSIC);
                CANONICAL_GENRES.add(PREMIER);
                CANONICAL_GENRES.add(TECH_SCIENCE);
                EMPTY_STRING_ARRAY = new String[0];
            }

            @Retention(value=RetentionPolicy.SOURCE)
            @StringDef(value={"FAMILY_KIDS", "SPORTS", "SHOPPING", "MOVIES", "COMEDY", "TRAVEL", "DRAMA", "EDUCATION", "ANIMAL_WILDLIFE", "NEWS", "GAMING", "ARTS", "ENTERTAINMENT", "LIFE_STYLE", "MUSIC", "PREMIER", "TECH_SCIENCE"})
            public static @interface Genre {
            }
        }
    }

    public static final class Channels
    implements BaseTvColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://android.media.tv/channel");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/channel";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/channel";
        public static final String TYPE_OTHER = "TYPE_OTHER";
        public static final String TYPE_NTSC = "TYPE_NTSC";
        public static final String TYPE_PAL = "TYPE_PAL";
        public static final String TYPE_SECAM = "TYPE_SECAM";
        public static final String TYPE_DVB_T = "TYPE_DVB_T";
        public static final String TYPE_DVB_T2 = "TYPE_DVB_T2";
        public static final String TYPE_DVB_S = "TYPE_DVB_S";
        public static final String TYPE_DVB_S2 = "TYPE_DVB_S2";
        public static final String TYPE_DVB_C = "TYPE_DVB_C";
        public static final String TYPE_DVB_C2 = "TYPE_DVB_C2";
        public static final String TYPE_DVB_H = "TYPE_DVB_H";
        public static final String TYPE_DVB_SH = "TYPE_DVB_SH";
        public static final String TYPE_ATSC_T = "TYPE_ATSC_T";
        public static final String TYPE_ATSC_C = "TYPE_ATSC_C";
        public static final String TYPE_ATSC_M_H = "TYPE_ATSC_M_H";
        public static final String TYPE_ISDB_T = "TYPE_ISDB_T";
        public static final String TYPE_ISDB_TB = "TYPE_ISDB_TB";
        public static final String TYPE_ISDB_S = "TYPE_ISDB_S";
        public static final String TYPE_ISDB_C = "TYPE_ISDB_C";
        public static final String TYPE_1SEG = "TYPE_1SEG";
        public static final String TYPE_DTMB = "TYPE_DTMB";
        public static final String TYPE_CMMB = "TYPE_CMMB";
        public static final String TYPE_T_DMB = "TYPE_T_DMB";
        public static final String TYPE_S_DMB = "TYPE_S_DMB";
        public static final String TYPE_PREVIEW = "TYPE_PREVIEW";
        public static final String SERVICE_TYPE_OTHER = "SERVICE_TYPE_OTHER";
        public static final String SERVICE_TYPE_AUDIO_VIDEO = "SERVICE_TYPE_AUDIO_VIDEO";
        public static final String SERVICE_TYPE_AUDIO = "SERVICE_TYPE_AUDIO";
        public static final String VIDEO_FORMAT_240P = "VIDEO_FORMAT_240P";
        public static final String VIDEO_FORMAT_360P = "VIDEO_FORMAT_360P";
        public static final String VIDEO_FORMAT_480I = "VIDEO_FORMAT_480I";
        public static final String VIDEO_FORMAT_480P = "VIDEO_FORMAT_480P";
        public static final String VIDEO_FORMAT_576I = "VIDEO_FORMAT_576I";
        public static final String VIDEO_FORMAT_576P = "VIDEO_FORMAT_576P";
        public static final String VIDEO_FORMAT_720P = "VIDEO_FORMAT_720P";
        public static final String VIDEO_FORMAT_1080I = "VIDEO_FORMAT_1080I";
        public static final String VIDEO_FORMAT_1080P = "VIDEO_FORMAT_1080P";
        public static final String VIDEO_FORMAT_2160P = "VIDEO_FORMAT_2160P";
        public static final String VIDEO_FORMAT_4320P = "VIDEO_FORMAT_4320P";
        public static final String VIDEO_RESOLUTION_SD = "VIDEO_RESOLUTION_SD";
        public static final String VIDEO_RESOLUTION_ED = "VIDEO_RESOLUTION_ED";
        public static final String VIDEO_RESOLUTION_HD = "VIDEO_RESOLUTION_HD";
        public static final String VIDEO_RESOLUTION_FHD = "VIDEO_RESOLUTION_FHD";
        public static final String VIDEO_RESOLUTION_UHD = "VIDEO_RESOLUTION_UHD";
        private static final Map<String, String> VIDEO_FORMAT_TO_RESOLUTION_MAP = new HashMap<String, String>();
        public static final String COLUMN_INPUT_ID = "input_id";
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_SERVICE_TYPE = "service_type";
        public static final String COLUMN_ORIGINAL_NETWORK_ID = "original_network_id";
        public static final String COLUMN_TRANSPORT_STREAM_ID = "transport_stream_id";
        public static final String COLUMN_SERVICE_ID = "service_id";
        public static final String COLUMN_DISPLAY_NUMBER = "display_number";
        public static final String COLUMN_DISPLAY_NAME = "display_name";
        public static final String COLUMN_NETWORK_AFFILIATION = "network_affiliation";
        public static final String COLUMN_DESCRIPTION = "description";
        public static final String COLUMN_VIDEO_FORMAT = "video_format";
        public static final String COLUMN_BROWSABLE = "browsable";
        public static final String COLUMN_SEARCHABLE = "searchable";
        public static final String COLUMN_LOCKED = "locked";
        public static final String COLUMN_APP_LINK_ICON_URI = "app_link_icon_uri";
        public static final String COLUMN_APP_LINK_POSTER_ART_URI = "app_link_poster_art_uri";
        public static final String COLUMN_APP_LINK_TEXT = "app_link_text";
        public static final String COLUMN_APP_LINK_COLOR = "app_link_color";
        public static final String COLUMN_APP_LINK_INTENT_URI = "app_link_intent_uri";
        public static final String COLUMN_INTERNAL_PROVIDER_ID = "internal_provider_id";
        public static final String COLUMN_INTERNAL_PROVIDER_DATA = "internal_provider_data";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG1 = "internal_provider_flag1";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG2 = "internal_provider_flag2";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG3 = "internal_provider_flag3";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG4 = "internal_provider_flag4";
        public static final String COLUMN_VERSION_NUMBER = "version_number";
        public static final String COLUMN_TRANSIENT = "transient";
        public static final String COLUMN_SYSTEM_APPROVED = "system_approved";

        public static final String getVideoResolution(String videoFormat) {
            return VIDEO_FORMAT_TO_RESOLUTION_MAP.get(videoFormat);
        }

        private Channels() {
        }

        static {
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_480I, VIDEO_RESOLUTION_SD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_480P, VIDEO_RESOLUTION_ED);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_576I, VIDEO_RESOLUTION_SD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_576P, VIDEO_RESOLUTION_ED);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_720P, VIDEO_RESOLUTION_HD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_1080I, VIDEO_RESOLUTION_HD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_1080P, VIDEO_RESOLUTION_FHD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_2160P, VIDEO_RESOLUTION_UHD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_4320P, VIDEO_RESOLUTION_UHD);
        }

        public static final class Logo {
            public static final String CONTENT_DIRECTORY = "logo";

            private Logo() {
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"VIDEO_RESOLUTION_SD", "VIDEO_RESOLUTION_ED", "VIDEO_RESOLUTION_HD", "VIDEO_RESOLUTION_FHD", "VIDEO_RESOLUTION_UHD"})
        public static @interface VideoResolution {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"VIDEO_FORMAT_240P", "VIDEO_FORMAT_360P", "VIDEO_FORMAT_480I", "VIDEO_FORMAT_576I", "VIDEO_FORMAT_576P", "VIDEO_FORMAT_720P", "VIDEO_FORMAT_1080I", "VIDEO_FORMAT_1080P", "VIDEO_FORMAT_2160P", "VIDEO_FORMAT_4320P"})
        public static @interface VideoFormat {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"SERVICE_TYPE_OTHER", "SERVICE_TYPE_AUDIO_VIDEO", "SERVICE_TYPE_AUDIO"})
        public static @interface ServiceType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @StringDef(value={"TYPE_OTHER", "TYPE_NTSC", "TYPE_PAL", "TYPE_SECAM", "TYPE_DVB_T", "TYPE_DVB_T2", "TYPE_DVB_S", "TYPE_DVB_S2", "TYPE_DVB_C", "TYPE_DVB_C2", "TYPE_DVB_H", "TYPE_DVB_SH", "TYPE_ATSC_T", "TYPE_ATSC_C", "TYPE_ATSC_M_H", "TYPE_ISDB_T", "TYPE_ISDB_TB", "TYPE_ISDB_S", "TYPE_ISDB_C", "TYPE_1SEG", "TYPE_DTMB", "TYPE_CMMB", "TYPE_T_DMB", "TYPE_S_DMB", "TYPE_PREVIEW"})
        public static @interface Type {
        }
    }

    public static interface BaseProgramColumns
    extends BaseTvColumns {
        public static final String COLUMN_CHANNEL_ID = "channel_id";
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_SEASON_DISPLAY_NUMBER = "season_display_number";
        public static final String COLUMN_SEASON_TITLE = "season_title";
        public static final String COLUMN_EPISODE_DISPLAY_NUMBER = "episode_display_number";
        public static final String COLUMN_EPISODE_TITLE = "episode_title";
        public static final String COLUMN_CANONICAL_GENRE = "canonical_genre";
        public static final String COLUMN_SHORT_DESCRIPTION = "short_description";
        public static final String COLUMN_LONG_DESCRIPTION = "long_description";
        public static final String COLUMN_VIDEO_WIDTH = "video_width";
        public static final String COLUMN_VIDEO_HEIGHT = "video_height";
        public static final String COLUMN_AUDIO_LANGUAGE = "audio_language";
        public static final String COLUMN_CONTENT_RATING = "content_rating";
        public static final String COLUMN_POSTER_ART_URI = "poster_art_uri";
        public static final String COLUMN_THUMBNAIL_URI = "thumbnail_uri";
        public static final String COLUMN_SEARCHABLE = "searchable";
        public static final String COLUMN_INTERNAL_PROVIDER_DATA = "internal_provider_data";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG1 = "internal_provider_flag1";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG2 = "internal_provider_flag2";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG3 = "internal_provider_flag3";
        public static final String COLUMN_INTERNAL_PROVIDER_FLAG4 = "internal_provider_flag4";
        public static final String COLUMN_VERSION_NUMBER = "version_number";
    }

    public static interface BaseTvColumns
    extends BaseColumns {
        public static final String COLUMN_PACKAGE_NAME = "package_name";
    }
}

