/*
 * Decompiled with CFR 0.152.
 */
package android.metrics;

import android.metrics.LogMaker;
import com.android.internal.logging.legacy.EventLogCollector;
import com.android.internal.logging.legacy.LegacyConversionLogger;
import java.util.Queue;

public class MetricsReader {
    private EventLogCollector mReader;
    private Queue<LogMaker> mEventQueue;
    private long mLastEventMs;
    private long mCheckpointMs;

    public void read(long startMs) {
        EventLogCollector reader = EventLogCollector.getInstance();
        LegacyConversionLogger logger = new LegacyConversionLogger();
        this.mLastEventMs = reader.collect(logger, startMs);
        this.mEventQueue = logger.getEvents();
    }

    public void checkpoint() {
        this.read(0L);
        this.mCheckpointMs = this.mLastEventMs;
        this.mEventQueue = null;
    }

    public void reset() {
        this.read(this.mCheckpointMs);
    }

    public boolean hasNext() {
        return this.mEventQueue == null ? false : !this.mEventQueue.isEmpty();
    }

    public LogMaker next() {
        return this.mEventQueue == null ? null : this.mEventQueue.remove();
    }
}

