/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.net.ConnectivityMetricsEvent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IConnectivityMetricsLogger
extends IInterface {
    public long logEvent(ConnectivityMetricsEvent var1) throws RemoteException;

    public long logEvents(ConnectivityMetricsEvent[] var1) throws RemoteException;

    public ConnectivityMetricsEvent[] getEvents(ConnectivityMetricsEvent.Reference var1) throws RemoteException;

    public boolean register(PendingIntent var1) throws RemoteException;

    public void unregister(PendingIntent var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IConnectivityMetricsLogger {
        private static final String DESCRIPTOR = "android.net.IConnectivityMetricsLogger";
        static final int TRANSACTION_logEvent = 1;
        static final int TRANSACTION_logEvents = 2;
        static final int TRANSACTION_getEvents = 3;
        static final int TRANSACTION_register = 4;
        static final int TRANSACTION_unregister = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IConnectivityMetricsLogger asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IConnectivityMetricsLogger) {
                return (IConnectivityMetricsLogger)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    ConnectivityMetricsEvent _arg0 = 0 != data.readInt() ? ConnectivityMetricsEvent.CREATOR.createFromParcel(data) : null;
                    long _result = this.logEvent(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    ConnectivityMetricsEvent[] _arg0 = data.createTypedArray(ConnectivityMetricsEvent.CREATOR);
                    long _result = this.logEvents(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    ConnectivityMetricsEvent.Reference _arg0 = 0 != data.readInt() ? ConnectivityMetricsEvent.Reference.CREATOR.createFromParcel(data) : null;
                    Parcelable[] _result = this.getEvents(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.register(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    this.unregister(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IConnectivityMetricsLogger {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long logEvent(ConnectivityMetricsEvent event) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (event != null) {
                        _data.writeInt(1);
                        event.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long logEvents(ConnectivityMetricsEvent[] events) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(events, 0);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ConnectivityMetricsEvent[] getEvents(ConnectivityMetricsEvent.Reference reference) throws RemoteException {
                ConnectivityMetricsEvent[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (reference != null) {
                        _data.writeInt(1);
                        reference.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(ConnectivityMetricsEvent.CREATOR);
                    if (0 != _reply.readInt()) {
                        reference.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean register(PendingIntent newEventsIntent) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (newEventsIntent != null) {
                        _data.writeInt(1);
                        newEventsIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregister(PendingIntent newEventsIntent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (newEventsIntent != null) {
                        _data.writeInt(1);
                        newEventsIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }
}

