/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.IntDef;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class NetworkBadging {
    public static final int BADGING_NONE = 0;
    public static final int BADGING_SD = 10;
    public static final int BADGING_HD = 20;
    public static final int BADGING_4K = 30;

    private NetworkBadging() {
    }

    public static Drawable getWifiIcon(int signalLevel, int badging, Resources.Theme theme) {
        Resources resources = Resources.getSystem();
        if (badging == 0) {
            return resources.getDrawable(NetworkBadging.getWifiSignalResource(signalLevel), theme);
        }
        Drawable[] layers = new Drawable[]{resources.getDrawable(NetworkBadging.getBadgedWifiSignalResource(signalLevel), theme), resources.getDrawable(NetworkBadging.getWifiBadgeResource(badging), theme)};
        return new LayerDrawable(layers);
    }

    private static int getWifiSignalResource(int signalLevel) {
        switch (signalLevel) {
            case 0: {
                return 17302633;
            }
            case 1: {
                return 17302634;
            }
            case 2: {
                return 17302635;
            }
            case 3: {
                return 17302636;
            }
            case 4: {
                return 17302637;
            }
        }
        throw new IllegalArgumentException("Invalid signal level: " + signalLevel);
    }

    private static int getBadgedWifiSignalResource(int signalLevel) {
        switch (signalLevel) {
            case 0: {
                return 17302596;
            }
            case 1: {
                return 17302597;
            }
            case 2: {
                return 17302598;
            }
            case 3: {
                return 17302599;
            }
            case 4: {
                return 17302600;
            }
        }
        throw new IllegalArgumentException("Invalid signal level: " + signalLevel);
    }

    private static int getWifiBadgeResource(int badging) {
        switch (badging) {
            case 0: {
                return -1;
            }
            case 10: {
                return 17302604;
            }
            case 20: {
                return 17302602;
            }
            case 30: {
                return 17302601;
            }
        }
        throw new IllegalArgumentException("No resource found for badge: " + badging);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 10L, 20L, 30L})
    public static @interface Badging {
    }
}

