/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.INetworkRecommendationProvider;
import android.net.NetworkKey;
import android.net.RecommendationRequest;
import android.net.RecommendationResult;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.RemoteException;
import android.util.Log;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NetworkRecommendationProvider {
    private static final String TAG = "NetworkRecProvider";
    private static final boolean VERBOSE = Build.IS_DEBUGGABLE && Log.isLoggable("NetworkRecProvider", 2);
    public static final String EXTRA_RECOMMENDATION_RESULT = "android.net.extra.RECOMMENDATION_RESULT";
    public static final String EXTRA_SEQUENCE = "android.net.extra.SEQUENCE";
    private final IBinder mService;

    public NetworkRecommendationProvider(Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("The provided handler cannot be null.");
        }
        this.mService = new ServiceWrapper(handler);
    }

    public abstract void onRequestRecommendation(RecommendationRequest var1, ResultCallback var2);

    public abstract void onRequestScores(NetworkKey[] var1);

    public final IBinder getBinder() {
        return this.mService;
    }

    private final class ServiceWrapper
    extends INetworkRecommendationProvider.Stub {
        private final Handler mHandler;

        ServiceWrapper(Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void requestRecommendation(final RecommendationRequest request, final IRemoteCallback callback, final int sequence) throws RemoteException {
            if (VERBOSE) {
                Log.v(NetworkRecommendationProvider.TAG, "requestRecommendation(seq=" + sequence + ")");
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (VERBOSE) {
                        Log.v(NetworkRecommendationProvider.TAG, "requestRecommendation(seq=" + sequence + ") running...");
                    }
                    ResultCallback resultCallback = new ResultCallback(callback, sequence);
                    NetworkRecommendationProvider.this.onRequestRecommendation(request, resultCallback);
                }
            });
        }

        @Override
        public void requestScores(final NetworkKey[] networks) throws RemoteException {
            if (networks != null && networks.length > 0) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NetworkRecommendationProvider.this.onRequestScores(networks);
                    }
                });
            }
        }
    }

    public static class ResultCallback {
        private final IRemoteCallback mCallback;
        private final int mSequence;
        private final AtomicBoolean mCallbackRun;

        public ResultCallback(IRemoteCallback callback, int sequence) {
            this.mCallback = callback;
            this.mSequence = sequence;
            this.mCallbackRun = new AtomicBoolean(false);
        }

        public void onResult(RecommendationResult result) {
            if (VERBOSE) {
                Log.v(NetworkRecommendationProvider.TAG, "onResult(seq=" + this.mSequence + ")");
            }
            if (!this.mCallbackRun.compareAndSet(false, true)) {
                throw new IllegalStateException("The callback cannot be run more than once. seq=" + this.mSequence);
            }
            Bundle data = new Bundle();
            data.putInt(NetworkRecommendationProvider.EXTRA_SEQUENCE, this.mSequence);
            data.putParcelable(NetworkRecommendationProvider.EXTRA_RECOMMENDATION_RESULT, result);
            try {
                this.mCallback.sendResult(data);
            }
            catch (RemoteException e) {
                Log.w(NetworkRecommendationProvider.TAG, "Callback failed for seq: " + this.mSequence, e);
            }
            if (VERBOSE) {
                Log.v(NetworkRecommendationProvider.TAG, "onResult() complete. seq=" + this.mSequence);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResultCallback that = (ResultCallback)o;
            return this.mSequence == that.mSequence && Objects.equals(this.mCallback, that.mCallback);
        }

        public int hashCode() {
            return Objects.hash(this.mCallback, this.mSequence);
        }
    }
}

