/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.IntDef;
import android.content.Context;
import android.net.INetworkScoreCache;
import android.net.INetworkScoreService;
import android.net.NetworkKey;
import android.net.NetworkScorerAppManager;
import android.net.RecommendationRequest;
import android.net.RecommendationResult;
import android.net.ScoredNetwork;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class NetworkScoreManager {
    public static final String ACTION_CHANGE_ACTIVE = "android.net.scoring.CHANGE_ACTIVE";
    public static final String EXTRA_PACKAGE_NAME = "packageName";
    public static final String ACTION_SCORE_NETWORKS = "android.net.scoring.SCORE_NETWORKS";
    public static final String EXTRA_NETWORKS_TO_SCORE = "networksToScore";
    public static final String ACTION_CUSTOM_ENABLE = "android.net.scoring.CUSTOM_ENABLE";
    public static final String USE_OPEN_WIFI_PACKAGE_META_DATA = "android.net.wifi.use_open_wifi_package";
    public static final String ACTION_SCORER_CHANGED = "android.net.scoring.SCORER_CHANGED";
    public static final String ACTION_RECOMMEND_NETWORKS = "android.net.action.RECOMMEND_NETWORKS";
    public static final String EXTRA_NEW_SCORER = "newScorer";
    public static final int CACHE_FILTER_NONE = 0;
    public static final int CACHE_FILTER_CURRENT_NETWORK = 1;
    public static final int CACHE_FILTER_SCAN_RESULTS = 2;
    private final Context mContext;
    private final INetworkScoreService mService;

    public NetworkScoreManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = INetworkScoreService.Stub.asInterface(ServiceManager.getServiceOrThrow("network_score"));
    }

    public String getActiveScorerPackage() {
        try {
            return this.mService.getActiveScorerPackage();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public NetworkScorerAppManager.NetworkScorerAppData getActiveScorer() {
        try {
            return this.mService.getActiveScorer();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<NetworkScorerAppManager.NetworkScorerAppData> getAllValidScorers() {
        try {
            return this.mService.getAllValidScorers();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean updateScores(ScoredNetwork[] networks) throws SecurityException {
        try {
            return this.mService.updateScores(networks);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean clearScores() throws SecurityException {
        try {
            return this.mService.clearScores();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean setActiveScorer(String packageName) throws SecurityException {
        try {
            return this.mService.setActiveScorer(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disableScoring() throws SecurityException {
        try {
            this.mService.disableScoring();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean requestScores(NetworkKey[] networks) throws SecurityException {
        try {
            return this.mService.requestScores(networks);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void registerNetworkScoreCache(int networkType, INetworkScoreCache scoreCache) {
        this.registerNetworkScoreCache(networkType, scoreCache, 0);
    }

    public void registerNetworkScoreCache(int networkType, INetworkScoreCache scoreCache, int filterType) {
        try {
            this.mService.registerNetworkScoreCache(networkType, scoreCache, filterType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterNetworkScoreCache(int networkType, INetworkScoreCache scoreCache) {
        try {
            this.mService.unregisterNetworkScoreCache(networkType, scoreCache);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public RecommendationResult requestRecommendation(RecommendationRequest request) throws SecurityException {
        try {
            return this.mService.requestRecommendation(request);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isCallerActiveScorer(int callingUid) {
        try {
            return this.mService.isCallerActiveScorer(callingUid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public CompletableFuture<RecommendationResult> requestRecommendation(RecommendationRequest request, Handler handler) {
        Preconditions.checkNotNull(request, "RecommendationRequest cannot be null.");
        final CompletableFuture<RecommendationResult> futureResult = new CompletableFuture<RecommendationResult>();
        RemoteCallback remoteCallback = new RemoteCallback(new RemoteCallback.OnResultListener(){

            @Override
            public void onResult(Bundle data) {
                RecommendationResult result = (RecommendationResult)data.getParcelable("android.net.extra.RECOMMENDATION_RESULT");
                futureResult.complete(result);
            }
        }, handler);
        try {
            this.mService.requestRecommendationAsync(request, remoteCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return futureResult;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface CacheUpdateFilter {
    }
}

