/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class NetworkScorerAppManager {
    private static final String TAG = "NetworkScorerAppManager";
    private static final boolean DEBUG = Log.isLoggable("NetworkScorerAppManager", 3);
    private static final boolean VERBOSE = Log.isLoggable("NetworkScorerAppManager", 2);
    private final Context mContext;

    public NetworkScorerAppManager(Context context) {
        this.mContext = context;
    }

    public List<NetworkScorerAppData> getAllValidScorers() {
        return Collections.emptyList();
    }

    public NetworkScorerAppData getNetworkRecommendationProviderData() {
        if (UserHandle.getCallingUserId() != 0) {
            return null;
        }
        List<String> potentialPkgs = this.getPotentialRecommendationProviderPackages();
        if (potentialPkgs.isEmpty()) {
            if (DEBUG) {
                Log.d(TAG, "No Network Recommendation Providers specified.");
            }
            return null;
        }
        for (int i = 0; i < potentialPkgs.size(); ++i) {
            String potentialPkg = potentialPkgs.get(i);
            ServiceInfo serviceInfo = this.findRecommendationService(potentialPkg);
            if (serviceInfo != null) {
                ComponentName serviceComponentName = new ComponentName(potentialPkg, serviceInfo.name);
                ComponentName useOpenWifiNetworksActivity = this.findUseOpenWifiNetworksActivity(serviceInfo);
                return new NetworkScorerAppData(serviceInfo.applicationInfo.uid, serviceComponentName, useOpenWifiNetworksActivity);
            }
            if (!DEBUG) continue;
            Log.d(TAG, potentialPkg + " does not have the required components, skipping.");
        }
        return null;
    }

    private ComponentName findUseOpenWifiNetworksActivity(ServiceInfo serviceInfo) {
        if (serviceInfo.metaData == null) {
            if (DEBUG) {
                Log.d(TAG, "No metadata found on recommendation service.");
            }
            return null;
        }
        String useOpenWifiPackage = serviceInfo.metaData.getString("android.net.wifi.use_open_wifi_package");
        if (TextUtils.isEmpty(useOpenWifiPackage)) {
            if (DEBUG) {
                Log.d(TAG, "No use_open_wifi_package metadata found.");
            }
            return null;
        }
        Intent enableUseOpenWifiIntent = new Intent("android.net.scoring.CUSTOM_ENABLE").setPackage(useOpenWifiPackage);
        ResolveInfo resolveActivityInfo = this.mContext.getPackageManager().resolveActivity(enableUseOpenWifiIntent, 0);
        if (VERBOSE) {
            Log.d(TAG, "Resolved " + enableUseOpenWifiIntent + " to " + serviceInfo);
        }
        if (resolveActivityInfo != null && resolveActivityInfo.activityInfo != null) {
            return resolveActivityInfo.activityInfo.getComponentName();
        }
        return null;
    }

    public List<String> getPotentialRecommendationProviderPackages() {
        Object[] packageArray = this.mContext.getResources().getStringArray(17236010);
        if (packageArray == null || packageArray.length == 0) {
            if (DEBUG) {
                Log.d(TAG, "No Network Recommendation Providers specified.");
            }
            return Collections.emptyList();
        }
        if (VERBOSE) {
            Log.d(TAG, "Configured packages: " + TextUtils.join((CharSequence)", ", packageArray));
        }
        ArrayList<String> packages = new ArrayList<String>();
        PackageManager pm = this.mContext.getPackageManager();
        for (Object potentialPkg : packageArray) {
            if (pm.checkPermission("android.permission.SCORE_NETWORKS", (String)potentialPkg) == 0) {
                packages.add((String)potentialPkg);
                continue;
            }
            if (!DEBUG) continue;
            Log.d(TAG, (String)potentialPkg + " has not been granted " + "android.permission.SCORE_NETWORKS" + ", skipping.");
        }
        return packages;
    }

    private ServiceInfo findRecommendationService(String packageName) {
        PackageManager pm = this.mContext.getPackageManager();
        int resolveFlags = 128;
        Intent serviceIntent = new Intent("android.net.action.RECOMMEND_NETWORKS");
        serviceIntent.setPackage(packageName);
        ResolveInfo resolveServiceInfo = pm.resolveService(serviceIntent, 128);
        if (VERBOSE) {
            Log.d(TAG, "Resolved " + serviceIntent + " to " + resolveServiceInfo);
        }
        if (resolveServiceInfo != null && resolveServiceInfo.serviceInfo != null) {
            return resolveServiceInfo.serviceInfo;
        }
        if (VERBOSE) {
            Log.v(TAG, packageName + " does not have a service for " + serviceIntent);
        }
        return null;
    }

    public NetworkScorerAppData getActiveScorer() {
        if (this.isNetworkRecommendationsDisabled()) {
            return null;
        }
        return this.getNetworkRecommendationProviderData();
    }

    @Deprecated
    public boolean setActiveScorer(String packageName) {
        return false;
    }

    private boolean isNetworkRecommendationsDisabled() {
        ContentResolver cr = this.mContext.getContentResolver();
        return Settings.Global.getInt(cr, "network_recommendations_enabled", 0) != 1;
    }

    public static final class NetworkScorerAppData
    implements Parcelable {
        public final int packageUid;
        private final ComponentName mRecommendationService;
        private final ComponentName mEnableUseOpenWifiActivity;
        public static final Parcelable.Creator<NetworkScorerAppData> CREATOR = new Parcelable.Creator<NetworkScorerAppData>(){

            @Override
            public NetworkScorerAppData createFromParcel(Parcel in) {
                return new NetworkScorerAppData(in);
            }

            public NetworkScorerAppData[] newArray(int size) {
                return new NetworkScorerAppData[size];
            }
        };

        public NetworkScorerAppData(int packageUid, ComponentName recommendationServiceComp, ComponentName enableUseOpenWifiActivity) {
            this.packageUid = packageUid;
            this.mRecommendationService = recommendationServiceComp;
            this.mEnableUseOpenWifiActivity = enableUseOpenWifiActivity;
        }

        protected NetworkScorerAppData(Parcel in) {
            this.packageUid = in.readInt();
            this.mRecommendationService = ComponentName.readFromParcel(in);
            this.mEnableUseOpenWifiActivity = ComponentName.readFromParcel(in);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.packageUid);
            ComponentName.writeToParcel(this.mRecommendationService, dest);
            ComponentName.writeToParcel(this.mEnableUseOpenWifiActivity, dest);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String getRecommendationServicePackageName() {
            return this.mRecommendationService.getPackageName();
        }

        public ComponentName getRecommendationServiceComponent() {
            return this.mRecommendationService;
        }

        public ComponentName getEnableUseOpenWifiActivity() {
            return this.mEnableUseOpenWifiActivity;
        }

        public String toString() {
            return "NetworkScorerAppData{packageUid=" + this.packageUid + ", mRecommendationService=" + this.mRecommendationService + ", mEnableUseOpenWifiActivity=" + this.mEnableUseOpenWifiActivity + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NetworkScorerAppData that = (NetworkScorerAppData)o;
            return this.packageUid == that.packageUid && Objects.equals(this.mRecommendationService, that.mRecommendationService) && Objects.equals(this.mEnableUseOpenWifiActivity, that.mEnableUseOpenWifiActivity);
        }

        public int hashCode() {
            return Objects.hash(this.packageUid, this.mRecommendationService, this.mEnableUseOpenWifiActivity);
        }
    }
}

