/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.os.Parcel;
import android.os.Parcelable;

public final class RecommendationRequest
implements Parcelable {
    private final ScanResult[] mScanResults;
    private final WifiConfiguration mDefaultConfig;
    private WifiConfiguration mConnectedConfig;
    private WifiConfiguration[] mConnectableConfigs;
    private final int mLastSelectedNetworkId;
    private final long mLastSelectedNetworkTimestamp;
    public static final Parcelable.Creator<RecommendationRequest> CREATOR = new Parcelable.Creator<RecommendationRequest>(){

        @Override
        public RecommendationRequest createFromParcel(Parcel in) {
            return new RecommendationRequest(in);
        }

        public RecommendationRequest[] newArray(int size) {
            return new RecommendationRequest[size];
        }
    };

    public ScanResult[] getScanResults() {
        return this.mScanResults;
    }

    public WifiConfiguration getDefaultWifiConfig() {
        return this.mDefaultConfig;
    }

    public WifiConfiguration getConnectedConfig() {
        return this.mConnectedConfig;
    }

    public WifiConfiguration[] getConnectableConfigs() {
        return this.mConnectableConfigs;
    }

    public void setConnectedConfig(WifiConfiguration connectedConfig) {
        this.mConnectedConfig = connectedConfig;
    }

    public void setConnectableConfigs(WifiConfiguration[] connectableConfigs) {
        this.mConnectableConfigs = connectableConfigs;
    }

    public int getLastSelectedNetworkId() {
        return this.mLastSelectedNetworkId;
    }

    public long getLastSelectedNetworkTimestamp() {
        return this.mLastSelectedNetworkTimestamp;
    }

    RecommendationRequest(ScanResult[] scanResults, WifiConfiguration defaultWifiConfig, WifiConfiguration connectedWifiConfig, WifiConfiguration[] connectableConfigs, int lastSelectedNetworkId, long lastSelectedNetworkTimestamp) {
        this.mScanResults = scanResults;
        this.mDefaultConfig = defaultWifiConfig;
        this.mConnectedConfig = connectedWifiConfig;
        this.mConnectableConfigs = connectableConfigs;
        this.mLastSelectedNetworkId = lastSelectedNetworkId;
        this.mLastSelectedNetworkTimestamp = lastSelectedNetworkTimestamp;
    }

    protected RecommendationRequest(Parcel in) {
        int resultCount = in.readInt();
        if (resultCount > 0) {
            this.mScanResults = new ScanResult[resultCount];
            ClassLoader classLoader = ScanResult.class.getClassLoader();
            for (int i = 0; i < resultCount; ++i) {
                this.mScanResults[i] = (ScanResult)in.readParcelable(classLoader);
            }
        } else {
            this.mScanResults = null;
        }
        this.mDefaultConfig = (WifiConfiguration)in.readParcelable(WifiConfiguration.class.getClassLoader());
        this.mConnectedConfig = (WifiConfiguration)in.readParcelable(WifiConfiguration.class.getClassLoader());
        int configCount = in.readInt();
        if (configCount > 0) {
            this.mConnectableConfigs = new WifiConfiguration[configCount];
            ClassLoader classLoader = WifiConfiguration.class.getClassLoader();
            for (int i = 0; i < configCount; ++i) {
                this.mConnectableConfigs[i] = (WifiConfiguration)in.readParcelable(classLoader);
            }
        } else {
            this.mConnectableConfigs = null;
        }
        this.mLastSelectedNetworkId = in.readInt();
        this.mLastSelectedNetworkTimestamp = in.readLong();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int i;
        if (this.mScanResults != null) {
            dest.writeInt(this.mScanResults.length);
            for (i = 0; i < this.mScanResults.length; ++i) {
                dest.writeParcelable(this.mScanResults[i], flags);
            }
        } else {
            dest.writeInt(0);
        }
        dest.writeParcelable(this.mDefaultConfig, flags);
        dest.writeParcelable(this.mConnectedConfig, flags);
        if (this.mConnectableConfigs != null) {
            dest.writeInt(this.mConnectableConfigs.length);
            for (i = 0; i < this.mConnectableConfigs.length; ++i) {
                dest.writeParcelable(this.mConnectableConfigs[i], flags);
            }
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mLastSelectedNetworkId);
        dest.writeLong(this.mLastSelectedNetworkTimestamp);
    }

    public static final class Builder {
        private ScanResult[] mScanResults;
        private WifiConfiguration mDefaultConfig;
        private WifiConfiguration mConnectedConfig;
        private WifiConfiguration[] mConnectableConfigs;
        private int mLastSelectedNetworkId = -1;
        private long mLastSelectedTimestamp;

        public Builder setScanResults(ScanResult[] scanResults) {
            this.mScanResults = scanResults;
            return this;
        }

        public Builder setDefaultWifiConfig(WifiConfiguration config) {
            this.mDefaultConfig = config;
            return this;
        }

        public Builder setConnectedWifiConfig(WifiConfiguration config) {
            this.mConnectedConfig = config;
            return this;
        }

        public Builder setConnectableConfigs(WifiConfiguration[] connectableConfigs) {
            this.mConnectableConfigs = connectableConfigs;
            return this;
        }

        public Builder setLastSelectedNetwork(int networkId, long timestamp) {
            this.mLastSelectedNetworkId = networkId;
            this.mLastSelectedTimestamp = timestamp;
            return this;
        }

        public RecommendationRequest build() {
            return new RecommendationRequest(this.mScanResults, this.mDefaultConfig, this.mConnectedConfig, this.mConnectableConfigs, this.mLastSelectedNetworkId, this.mLastSelectedTimestamp);
        }
    }
}

