/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.wifi.WifiConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

public final class RecommendationResult
implements Parcelable {
    private final WifiConfiguration mWifiConfiguration;
    public static final Parcelable.Creator<RecommendationResult> CREATOR = new Parcelable.Creator<RecommendationResult>(){

        @Override
        public RecommendationResult createFromParcel(Parcel in) {
            return new RecommendationResult(in);
        }

        public RecommendationResult[] newArray(int size) {
            return new RecommendationResult[size];
        }
    };

    public static RecommendationResult createDoNotConnectRecommendation() {
        return new RecommendationResult((WifiConfiguration)null);
    }

    public static RecommendationResult createConnectRecommendation(WifiConfiguration wifiConfiguration) {
        Preconditions.checkNotNull(wifiConfiguration, "wifiConfiguration must not be null");
        Preconditions.checkNotNull(wifiConfiguration.SSID, "SSID must not be null");
        Preconditions.checkNotNull(wifiConfiguration.BSSID, "BSSID must not be null");
        return new RecommendationResult(wifiConfiguration);
    }

    private RecommendationResult(WifiConfiguration wifiConfiguration) {
        this.mWifiConfiguration = wifiConfiguration;
    }

    private RecommendationResult(Parcel in) {
        this.mWifiConfiguration = (WifiConfiguration)in.readParcelable(WifiConfiguration.class.getClassLoader());
    }

    public boolean hasRecommendation() {
        return this.mWifiConfiguration != null;
    }

    public WifiConfiguration getWifiConfiguration() {
        return this.mWifiConfiguration;
    }

    public String toString() {
        return "RecommendationResult{mWifiConfiguration=" + this.mWifiConfiguration + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mWifiConfiguration, flags);
    }
}

