/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

public class RssiCurve
implements Parcelable {
    private static final int DEFAULT_ACTIVE_NETWORK_RSSI_BOOST = 25;
    public final int start;
    public final int bucketWidth;
    public final byte[] rssiBuckets;
    public final int activeNetworkRssiBoost;
    public static final Parcelable.Creator<RssiCurve> CREATOR = new Parcelable.Creator<RssiCurve>(){

        @Override
        public RssiCurve createFromParcel(Parcel in) {
            return new RssiCurve(in);
        }

        public RssiCurve[] newArray(int size) {
            return new RssiCurve[size];
        }
    };

    public RssiCurve(int start, int bucketWidth, byte[] rssiBuckets) {
        this(start, bucketWidth, rssiBuckets, 25);
    }

    public RssiCurve(int start, int bucketWidth, byte[] rssiBuckets, int activeNetworkRssiBoost) {
        this.start = start;
        this.bucketWidth = bucketWidth;
        if (rssiBuckets == null || rssiBuckets.length == 0) {
            throw new IllegalArgumentException("rssiBuckets must be at least one element large.");
        }
        this.rssiBuckets = rssiBuckets;
        this.activeNetworkRssiBoost = activeNetworkRssiBoost;
    }

    private RssiCurve(Parcel in) {
        this.start = in.readInt();
        this.bucketWidth = in.readInt();
        int bucketCount = in.readInt();
        this.rssiBuckets = new byte[bucketCount];
        in.readByteArray(this.rssiBuckets);
        this.activeNetworkRssiBoost = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.start);
        out.writeInt(this.bucketWidth);
        out.writeInt(this.rssiBuckets.length);
        out.writeByteArray(this.rssiBuckets);
        out.writeInt(this.activeNetworkRssiBoost);
    }

    public byte lookupScore(int rssi) {
        return this.lookupScore(rssi, false);
    }

    public byte lookupScore(int rssi, boolean isActiveNetwork) {
        int index;
        if (isActiveNetwork) {
            rssi += this.activeNetworkRssiBoost;
        }
        if ((index = (rssi - this.start) / this.bucketWidth) < 0) {
            index = 0;
        } else if (index > this.rssiBuckets.length - 1) {
            index = this.rssiBuckets.length - 1;
        }
        return this.rssiBuckets[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RssiCurve rssiCurve = (RssiCurve)o;
        return this.start == rssiCurve.start && this.bucketWidth == rssiCurve.bucketWidth && Arrays.equals(this.rssiBuckets, rssiCurve.rssiBuckets) && this.activeNetworkRssiBoost == rssiCurve.activeNetworkRssiBoost;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.bucketWidth, this.activeNetworkRssiBoost) ^ Arrays.hashCode(this.rssiBuckets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RssiCurve[start=").append(this.start).append(",bucketWidth=").append(this.bucketWidth).append(",activeNetworkRssiBoost=").append(this.activeNetworkRssiBoost);
        sb.append(",buckets=");
        for (int i = 0; i < this.rssiBuckets.length; ++i) {
            sb.append(this.rssiBuckets[i]);
            if (i >= this.rssiBuckets.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

