/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.NetworkUtils;
import android.net.ip.ConnectivityPacketTracker$PacketListener$$Lambda$10;
import android.net.util.BlockingSocketReader;
import android.net.util.ConnectivityPacketSummary;
import android.os.Handler;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.PacketSocketAddress;
import android.util.LocalLog;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import libcore.util.HexEncoding;

public class ConnectivityPacketTracker {
    private static final String TAG = ConnectivityPacketTracker.class.getSimpleName();
    private static final boolean DBG = false;
    private static final String MARK_START = "--- START ---";
    private static final String MARK_STOP = "--- STOP ---";
    private final String mTag;
    private final Handler mHandler;
    private final LocalLog mLog;
    private final BlockingSocketReader mPacketListener;

    public ConnectivityPacketTracker(NetworkInterface netif, LocalLog log) {
        int mtu;
        byte[] hwaddr;
        int ifindex;
        String ifname;
        try {
            ifname = netif.getName();
            ifindex = netif.getIndex();
            hwaddr = netif.getHardwareAddress();
            mtu = netif.getMTU();
        }
        catch (NullPointerException | SocketException e) {
            throw new IllegalArgumentException("bad network interface", e);
        }
        this.mTag = TAG + "." + ifname;
        this.mHandler = new Handler();
        this.mLog = log;
        this.mPacketListener = new PacketListener(ifindex, hwaddr, mtu);
    }

    public void start() {
        this.mLog.log(MARK_START);
        this.mPacketListener.start();
    }

    public void stop() {
        this.mPacketListener.stop();
        this.mLog.log(MARK_STOP);
    }

    private final class PacketListener
    extends BlockingSocketReader {
        private final int mIfIndex;
        private final byte[] mHwAddr;

        PacketListener(int ifindex, byte[] hwaddr, int mtu) {
            super(mtu);
            this.mIfIndex = ifindex;
            this.mHwAddr = hwaddr;
        }

        @Override
        protected FileDescriptor createSocket() {
            FileDescriptor s = null;
            try {
                s = Os.socket(OsConstants.AF_PACKET, OsConstants.SOCK_RAW, 0);
                NetworkUtils.attachControlPacketFilter(s, OsConstants.ARPHRD_ETHER);
                Os.bind(s, new PacketSocketAddress((short)OsConstants.ETH_P_ALL, this.mIfIndex));
            }
            catch (ErrnoException | IOException e) {
                this.logError("Failed to create packet tracking socket: ", e);
                PacketListener.closeSocket(s);
                return null;
            }
            return s;
        }

        @Override
        protected void handlePacket(byte[] recvbuf, int length) {
            String summary = ConnectivityPacketSummary.summarize(this.mHwAddr, recvbuf, length);
            if (summary == null) {
                return;
            }
            this.addLogEntry(summary + "\n[" + new String(HexEncoding.encode(recvbuf, 0, length)) + "]");
        }

        @Override
        protected void logError(String msg, Exception e) {
            Log.e(ConnectivityPacketTracker.this.mTag, msg, e);
            this.addLogEntry(msg + e);
        }

        private void addLogEntry(String entry) {
            ConnectivityPacketTracker.this.mHandler.post(ConnectivityPacketTracker$PacketListener$$Lambda$10.get$Lambda(this, entry));
        }

        final /* synthetic */ void lambda$addLogEntry$4$ConnectivityPacketTracker$PacketListener(String string2) {
            ConnectivityPacketTracker.this.mLog.log(string2);
        }
    }
}

