/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.system.OsConstants;
import android.util.IntArray;
import android.util.SparseIntArray;
import com.android.internal.util.TokenBucket;
import com.android.server.connectivity.metrics.nano.IpConnectivityLogClass;

public class ConnectStats {
    private static final int EALREADY = OsConstants.EALREADY;
    private static final int EINPROGRESS = OsConstants.EINPROGRESS;
    private final SparseIntArray mErrnos = new SparseIntArray();
    private final IntArray mLatencies = new IntArray();
    private final TokenBucket mLatencyTb;
    private final int mMaxLatencyRecords;
    private int mConnectCount = 0;
    private int mIpv6ConnectCount = 0;

    public ConnectStats(TokenBucket tb, int maxLatencyRecords) {
        this.mLatencyTb = tb;
        this.mMaxLatencyRecords = maxLatencyRecords;
    }

    public IpConnectivityLogClass.ConnectStatistics toProto() {
        IpConnectivityLogClass.ConnectStatistics stats = new IpConnectivityLogClass.ConnectStatistics();
        stats.connectCount = this.mConnectCount;
        stats.ipv6AddrCount = this.mIpv6ConnectCount;
        stats.latenciesMs = this.mLatencies.toArray();
        stats.errnosCounters = ConnectStats.toPairArrays(this.mErrnos);
        return stats;
    }

    public void addEvent(int errno, int latencyMs, String ipAddr) {
        if (ConnectStats.isSuccess(errno)) {
            this.countConnect(ipAddr);
            this.countLatency(errno, latencyMs);
        } else {
            this.countError(errno);
        }
    }

    private void countConnect(String ipAddr) {
        ++this.mConnectCount;
        if (ConnectStats.isIPv6(ipAddr)) {
            ++this.mIpv6ConnectCount;
        }
    }

    private void countLatency(int errno, int ms) {
        if (ConnectStats.isNonBlocking(errno)) {
            return;
        }
        if (!this.mLatencyTb.get()) {
            return;
        }
        if (this.mLatencies.size() >= this.mMaxLatencyRecords) {
            return;
        }
        this.mLatencies.add(ms);
    }

    private void countError(int errno) {
        int newcount = this.mErrnos.get(errno, 0) + 1;
        this.mErrnos.put(errno, newcount);
    }

    private static boolean isSuccess(int errno) {
        return errno == 0 || ConnectStats.isNonBlocking(errno);
    }

    private static boolean isNonBlocking(int errno) {
        return errno == EINPROGRESS || errno == EALREADY;
    }

    private static boolean isIPv6(String ipAddr) {
        return ipAddr.contains(":");
    }

    private static IpConnectivityLogClass.Pair[] toPairArrays(SparseIntArray counts) {
        int s = counts.size();
        IpConnectivityLogClass.Pair[] pairs = new IpConnectivityLogClass.Pair[s];
        for (int i = 0; i < s; ++i) {
            IpConnectivityLogClass.Pair p = new IpConnectivityLogClass.Pair();
            p.key = counts.keyAt(i);
            p.value = counts.valueAt(i);
            pairs[i] = p;
        }
        return pairs;
    }
}

