/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.net.ConnectivityMetricsEvent;
import android.net.IIpConnectivityMetrics;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class IpConnectivityLog {
    private static final String TAG = IpConnectivityLog.class.getSimpleName();
    private static final boolean DBG = false;
    public static final String SERVICE_NAME = "connmetrics";
    private IIpConnectivityMetrics mService;

    public IpConnectivityLog() {
    }

    public IpConnectivityLog(IIpConnectivityMetrics service) {
        this.mService = service;
    }

    private boolean checkLoggerService() {
        if (this.mService != null) {
            return true;
        }
        IIpConnectivityMetrics service = IIpConnectivityMetrics.Stub.asInterface(ServiceManager.getService(SERVICE_NAME));
        if (service == null) {
            return false;
        }
        this.mService = service;
        return true;
    }

    public boolean log(long timestamp, Parcelable data) {
        if (!this.checkLoggerService()) {
            return false;
        }
        try {
            int left = this.mService.logEvent(new ConnectivityMetricsEvent(timestamp, 0, 0, data));
            return left >= 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error logging event", e);
            return false;
        }
    }

    public void log(Parcelable event) {
        this.log(System.currentTimeMillis(), event);
    }
}

