/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.annotation.IntDef;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.android.internal.util.MessageUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class NetworkEvent
implements Parcelable {
    public static final int NETWORK_CONNECTED = 1;
    public static final int NETWORK_VALIDATED = 2;
    public static final int NETWORK_VALIDATION_FAILED = 3;
    public static final int NETWORK_CAPTIVE_PORTAL_FOUND = 4;
    public static final int NETWORK_LINGER = 5;
    public static final int NETWORK_UNLINGER = 6;
    public static final int NETWORK_DISCONNECTED = 7;
    public static final int NETWORK_FIRST_VALIDATION_SUCCESS = 8;
    public static final int NETWORK_REVALIDATION_SUCCESS = 9;
    public static final int NETWORK_FIRST_VALIDATION_PORTAL_FOUND = 10;
    public static final int NETWORK_REVALIDATION_PORTAL_FOUND = 11;
    public final int netId;
    public final int eventType;
    public final long durationMs;
    public static final Parcelable.Creator<NetworkEvent> CREATOR = new Parcelable.Creator<NetworkEvent>(){

        @Override
        public NetworkEvent createFromParcel(Parcel in) {
            return new NetworkEvent(in);
        }

        public NetworkEvent[] newArray(int size) {
            return new NetworkEvent[size];
        }
    };

    public NetworkEvent(int netId, int eventType, long durationMs) {
        this.netId = netId;
        this.eventType = eventType;
        this.durationMs = durationMs;
    }

    public NetworkEvent(int netId, int eventType) {
        this(netId, eventType, 0L);
    }

    private NetworkEvent(Parcel in) {
        this.netId = in.readInt();
        this.eventType = in.readInt();
        this.durationMs = in.readLong();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.netId);
        out.writeInt(this.eventType);
        out.writeLong(this.durationMs);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static void logEvent(int netId, int eventType) {
    }

    public static void logValidated(int netId, long durationMs) {
    }

    public static void logCaptivePortalFound(int netId, long durationMs) {
    }

    public String toString() {
        return String.format("NetworkEvent(%d, %s, %dms)", this.netId, Decoder.constants.get(this.eventType), this.durationMs);
    }

    static final class Decoder {
        static final SparseArray<String> constants = MessageUtils.findMessageNames(new Class[]{NetworkEvent.class}, new String[]{"NETWORK_"});

        Decoder() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L})
    public static @interface EventType {
    }
}

