/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.os.Parcel;
import android.os.Parcelable;

public final class RaEvent
implements Parcelable {
    public static final long NO_LIFETIME = -1L;
    public final long routerLifetime;
    public final long prefixValidLifetime;
    public final long prefixPreferredLifetime;
    public final long routeInfoLifetime;
    public final long rdnssLifetime;
    public final long dnsslLifetime;
    public static final Parcelable.Creator<RaEvent> CREATOR = new Parcelable.Creator<RaEvent>(){

        @Override
        public RaEvent createFromParcel(Parcel in) {
            return new RaEvent(in);
        }

        public RaEvent[] newArray(int size) {
            return new RaEvent[size];
        }
    };

    public RaEvent(long routerLifetime, long prefixValidLifetime, long prefixPreferredLifetime, long routeInfoLifetime, long rdnssLifetime, long dnsslLifetime) {
        this.routerLifetime = routerLifetime;
        this.prefixValidLifetime = prefixValidLifetime;
        this.prefixPreferredLifetime = prefixPreferredLifetime;
        this.routeInfoLifetime = routeInfoLifetime;
        this.rdnssLifetime = rdnssLifetime;
        this.dnsslLifetime = dnsslLifetime;
    }

    private RaEvent(Parcel in) {
        this.routerLifetime = in.readLong();
        this.prefixValidLifetime = in.readLong();
        this.prefixPreferredLifetime = in.readLong();
        this.routeInfoLifetime = in.readLong();
        this.rdnssLifetime = in.readLong();
        this.dnsslLifetime = in.readLong();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.routerLifetime);
        out.writeLong(this.prefixValidLifetime);
        out.writeLong(this.prefixPreferredLifetime);
        out.writeLong(this.routeInfoLifetime);
        out.writeLong(this.rdnssLifetime);
        out.writeLong(this.dnsslLifetime);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "RaEvent(lifetimes: " + String.format("router=%ds, ", this.routerLifetime) + String.format("prefix_valid=%ds, ", this.prefixValidLifetime) + String.format("prefix_preferred=%ds, ", this.prefixPreferredLifetime) + String.format("route_info=%ds, ", this.routeInfoLifetime) + String.format("rdnss=%ds, ", this.rdnssLifetime) + String.format("dnssl=%ds)", this.dnsslLifetime);
    }

    public static class Builder {
        long routerLifetime = -1L;
        long prefixValidLifetime = -1L;
        long prefixPreferredLifetime = -1L;
        long routeInfoLifetime = -1L;
        long rdnssLifetime = -1L;
        long dnsslLifetime = -1L;

        public RaEvent build() {
            return new RaEvent(this.routerLifetime, this.prefixValidLifetime, this.prefixPreferredLifetime, this.routeInfoLifetime, this.rdnssLifetime, this.dnsslLifetime);
        }

        public Builder updateRouterLifetime(long lifetime) {
            this.routerLifetime = this.updateLifetime(this.routerLifetime, lifetime);
            return this;
        }

        public Builder updatePrefixValidLifetime(long lifetime) {
            this.prefixValidLifetime = this.updateLifetime(this.prefixValidLifetime, lifetime);
            return this;
        }

        public Builder updatePrefixPreferredLifetime(long lifetime) {
            this.prefixPreferredLifetime = this.updateLifetime(this.prefixPreferredLifetime, lifetime);
            return this;
        }

        public Builder updateRouteInfoLifetime(long lifetime) {
            this.routeInfoLifetime = this.updateLifetime(this.routeInfoLifetime, lifetime);
            return this;
        }

        public Builder updateRdnssLifetime(long lifetime) {
            this.rdnssLifetime = this.updateLifetime(this.rdnssLifetime, lifetime);
            return this;
        }

        public Builder updateDnsslLifetime(long lifetime) {
            this.dnsslLifetime = this.updateLifetime(this.dnsslLifetime, lifetime);
            return this;
        }

        private long updateLifetime(long currentLifetime, long newLifetime) {
            if (currentLifetime == -1L) {
                return newLifetime;
            }
            return Math.min(currentLifetime, newLifetime);
        }
    }
}

