/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.wifi.RttManager;
import android.net.wifi.aware.PeerHandle;
import android.net.wifi.aware.SubscribeDiscoverySession;
import android.net.wifi.aware.WifiAwareManager;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

public class DiscoverySession {
    private static final String TAG = "DiscoverySession";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private static final int MAX_SEND_RETRY_COUNT = 5;
    protected WeakReference<WifiAwareManager> mMgr;
    protected final int mClientId;
    protected final int mSessionId;
    protected boolean mTerminated = false;
    private final CloseGuard mCloseGuard = CloseGuard.get();

    public static int getMaxSendRetryCount() {
        return 5;
    }

    public DiscoverySession(WifiAwareManager manager, int clientId, int sessionId) {
        this.mMgr = new WeakReference<WifiAwareManager>(manager);
        this.mClientId = clientId;
        this.mSessionId = sessionId;
        this.mCloseGuard.open("destroy");
    }

    public void destroy() {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "destroy: called post GC on WifiAwareManager");
            return;
        }
        mgr.terminateSession(this.mClientId, this.mSessionId);
        this.mTerminated = true;
        this.mMgr.clear();
        this.mCloseGuard.close();
    }

    public void setTerminated() {
        if (this.mTerminated) {
            Log.w(TAG, "terminate: already terminated.");
            return;
        }
        this.mTerminated = true;
        this.mMgr.clear();
        this.mCloseGuard.close();
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.mTerminated) {
                this.mCloseGuard.warnIfOpen();
                this.destroy();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void sendMessage(PeerHandle peerHandle, int messageId, byte[] message, int retryCount) {
        if (this.mTerminated) {
            Log.w(TAG, "sendMessage: called on terminated session");
            return;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "sendMessage: called post GC on WifiAwareManager");
            return;
        }
        mgr.sendMessage(this.mClientId, this.mSessionId, peerHandle, message, messageId, retryCount);
    }

    public void sendMessage(PeerHandle peerHandle, int messageId, byte[] message) {
        this.sendMessage(peerHandle, messageId, message, 0);
    }

    public void startRanging(RttManager.RttParams[] params, RttManager.RttListener listener) {
        if (this.mTerminated) {
            Log.w(TAG, "startRanging: called on terminated session");
            return;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "startRanging: called post GC on WifiAwareManager");
            return;
        }
        mgr.startRanging(this.mClientId, this.mSessionId, params, listener);
    }

    public String createNetworkSpecifier(PeerHandle peerHandle, byte[] token) {
        if (this.mTerminated) {
            Log.w(TAG, "createNetworkSpecifier: called on terminated session");
            return null;
        }
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "createNetworkSpecifier: called post GC on WifiAwareManager");
            return null;
        }
        int role = this instanceof SubscribeDiscoverySession ? 0 : 1;
        return mgr.createNetworkSpecifier(this.mClientId, role, this.mSessionId, peerHandle, token);
    }
}

