/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.IntDef;
import android.net.wifi.aware.Characteristics;
import android.net.wifi.aware.TlvBufferUtils;
import android.net.wifi.aware.WifiAwareUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import libcore.util.HexEncoding;

public final class SubscribeConfig
implements Parcelable {
    public static final int SUBSCRIBE_TYPE_PASSIVE = 0;
    public static final int SUBSCRIBE_TYPE_ACTIVE = 1;
    public static final int MATCH_STYLE_FIRST_ONLY = 0;
    public static final int MATCH_STYLE_ALL = 1;
    public final byte[] mServiceName;
    public final byte[] mServiceSpecificInfo;
    public final byte[] mMatchFilter;
    public final int mSubscribeType;
    public final int mSubscribeCount;
    public final int mTtlSec;
    public final int mMatchStyle;
    public final boolean mEnableTerminateNotification;
    public static final Parcelable.Creator<SubscribeConfig> CREATOR = new Parcelable.Creator<SubscribeConfig>(){

        public SubscribeConfig[] newArray(int size) {
            return new SubscribeConfig[size];
        }

        @Override
        public SubscribeConfig createFromParcel(Parcel in) {
            byte[] serviceName = in.createByteArray();
            byte[] ssi = in.createByteArray();
            byte[] matchFilter = in.createByteArray();
            int subscribeType = in.readInt();
            int subscribeCount = in.readInt();
            int ttlSec = in.readInt();
            int matchStyle = in.readInt();
            boolean enableTerminateNotification = in.readInt() != 0;
            return new SubscribeConfig(serviceName, ssi, matchFilter, subscribeType, subscribeCount, ttlSec, matchStyle, enableTerminateNotification);
        }
    };

    public SubscribeConfig(byte[] serviceName, byte[] serviceSpecificInfo, byte[] matchFilter, int subscribeType, int publichCount, int ttlSec, int matchStyle, boolean enableTerminateNotification) {
        this.mServiceName = serviceName;
        this.mServiceSpecificInfo = serviceSpecificInfo;
        this.mMatchFilter = matchFilter;
        this.mSubscribeType = subscribeType;
        this.mSubscribeCount = publichCount;
        this.mTtlSec = ttlSec;
        this.mMatchStyle = matchStyle;
        this.mEnableTerminateNotification = enableTerminateNotification;
    }

    public String toString() {
        return "SubscribeConfig [mServiceName='" + this.mServiceName + ", mServiceSpecificInfo='" + (this.mServiceSpecificInfo == null ? "null" : (Object)HexEncoding.encode(this.mServiceSpecificInfo)) + ", mMatchFilter=" + new TlvBufferUtils.TlvIterable(0, 1, this.mMatchFilter).toString() + ", mSubscribeType=" + this.mSubscribeType + ", mSubscribeCount=" + this.mSubscribeCount + ", mTtlSec=" + this.mTtlSec + ", mMatchType=" + this.mMatchStyle + ", mEnableTerminateNotification=" + this.mEnableTerminateNotification + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mServiceName);
        dest.writeByteArray(this.mServiceSpecificInfo);
        dest.writeByteArray(this.mMatchFilter);
        dest.writeInt(this.mSubscribeType);
        dest.writeInt(this.mSubscribeCount);
        dest.writeInt(this.mTtlSec);
        dest.writeInt(this.mMatchStyle);
        dest.writeInt(this.mEnableTerminateNotification ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscribeConfig)) {
            return false;
        }
        SubscribeConfig lhs = (SubscribeConfig)o;
        return Arrays.equals(this.mServiceName, lhs.mServiceName) && Arrays.equals(this.mServiceSpecificInfo, lhs.mServiceSpecificInfo) && Arrays.equals(this.mMatchFilter, lhs.mMatchFilter) && this.mSubscribeType == lhs.mSubscribeType && this.mSubscribeCount == lhs.mSubscribeCount && this.mTtlSec == lhs.mTtlSec && this.mMatchStyle == lhs.mMatchStyle && this.mEnableTerminateNotification == lhs.mEnableTerminateNotification;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Arrays.hashCode(this.mServiceName);
        result = 31 * result + Arrays.hashCode(this.mServiceSpecificInfo);
        result = 31 * result + Arrays.hashCode(this.mMatchFilter);
        result = 31 * result + this.mSubscribeType;
        result = 31 * result + this.mSubscribeCount;
        result = 31 * result + this.mTtlSec;
        result = 31 * result + this.mMatchStyle;
        result = 31 * result + (this.mEnableTerminateNotification ? 1 : 0);
        return result;
    }

    public void assertValid(Characteristics characteristics) throws IllegalArgumentException {
        WifiAwareUtils.validateServiceName(this.mServiceName);
        if (!TlvBufferUtils.isValid(this.mMatchFilter, 0, 1)) {
            throw new IllegalArgumentException("Invalid matchFilter configuration - LV fields do not match up to length");
        }
        if (this.mSubscribeType < 0 || this.mSubscribeType > 1) {
            throw new IllegalArgumentException("Invalid subscribeType - " + this.mSubscribeType);
        }
        if (this.mSubscribeCount < 0) {
            throw new IllegalArgumentException("Invalid subscribeCount - must be non-negative");
        }
        if (this.mTtlSec < 0) {
            throw new IllegalArgumentException("Invalid ttlSec - must be non-negative");
        }
        if (this.mMatchStyle != 0 && this.mMatchStyle != 1) {
            throw new IllegalArgumentException("Invalid matchType - must be MATCH_FIRST_ONLY or MATCH_ALL");
        }
        if (characteristics != null) {
            int maxServiceNameLength = characteristics.getMaxServiceNameLength();
            if (maxServiceNameLength != 0 && this.mServiceName.length > maxServiceNameLength) {
                throw new IllegalArgumentException("Service name longer than supported by device characteristics");
            }
            int maxServiceSpecificInfoLength = characteristics.getMaxServiceSpecificInfoLength();
            if (maxServiceSpecificInfoLength != 0 && this.mServiceSpecificInfo != null && this.mServiceSpecificInfo.length > maxServiceSpecificInfoLength) {
                throw new IllegalArgumentException("Service specific info longer than supported by device characteristics");
            }
            int maxMatchFilterLength = characteristics.getMaxMatchFilterLength();
            if (maxMatchFilterLength != 0 && this.mMatchFilter != null && this.mMatchFilter.length > maxMatchFilterLength) {
                throw new IllegalArgumentException("Match filter longer than supported by device characteristics");
            }
        }
    }

    public static final class Builder {
        private byte[] mServiceName;
        private byte[] mServiceSpecificInfo;
        private byte[] mMatchFilter;
        private int mSubscribeType = 0;
        private int mSubscribeCount = 0;
        private int mTtlSec = 0;
        private int mMatchStyle = 1;
        private boolean mEnableTerminateNotification = true;

        public Builder setServiceName(String serviceName) {
            if (serviceName == null) {
                throw new IllegalArgumentException("Invalid service name - must be non-null");
            }
            this.mServiceName = serviceName.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public Builder setServiceSpecificInfo(byte[] serviceSpecificInfo) {
            this.mServiceSpecificInfo = serviceSpecificInfo;
            return this;
        }

        public Builder setMatchFilter(List<byte[]> matchFilter) {
            this.mMatchFilter = new TlvBufferUtils.TlvConstructor(0, 1).allocateAndPut(matchFilter).getArray();
            return this;
        }

        public Builder setSubscribeType(int subscribeType) {
            if (subscribeType < 0 || subscribeType > 1) {
                throw new IllegalArgumentException("Invalid subscribeType - " + subscribeType);
            }
            this.mSubscribeType = subscribeType;
            return this;
        }

        public Builder setSubscribeCount(int subscribeCount) {
            if (subscribeCount < 0) {
                throw new IllegalArgumentException("Invalid subscribeCount - must be non-negative");
            }
            this.mSubscribeCount = subscribeCount;
            return this;
        }

        public Builder setTtlSec(int ttlSec) {
            if (ttlSec < 0) {
                throw new IllegalArgumentException("Invalid ttlSec - must be non-negative");
            }
            this.mTtlSec = ttlSec;
            return this;
        }

        public Builder setMatchStyle(int matchStyle) {
            if (matchStyle != 0 && matchStyle != 1) {
                throw new IllegalArgumentException("Invalid matchType - must be MATCH_FIRST_ONLY or MATCH_ALL");
            }
            this.mMatchStyle = matchStyle;
            return this;
        }

        public Builder setTerminateNotificationEnabled(boolean enable) {
            this.mEnableTerminateNotification = enable;
            return this;
        }

        public SubscribeConfig build() {
            return new SubscribeConfig(this.mServiceName, this.mServiceSpecificInfo, this.mMatchFilter, this.mSubscribeType, this.mSubscribeCount, this.mTtlSec, this.mMatchStyle, this.mEnableTerminateNotification);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    public static @interface MatchStyles {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    public static @interface SubscribeTypes {
    }
}

