/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.opengl.EGL14;
import android.os.GraphicsEnvironment$$Lambda$34;
import android.os.SystemProperties;
import android.util.Log;
import dalvik.system.VMRuntime;
import java.io.File;

public final class GraphicsEnvironment {
    private static final boolean DEBUG = false;
    private static final String TAG = "GraphicsEnvironment";
    private static final String PROPERTY_GFX_DRIVER = "ro.gfx.driver.0";

    public static void setupGraphicsEnvironment(Context context) {
        GraphicsEnvironment.chooseDriver(context);
        Thread eglInitThread = new Thread(GraphicsEnvironment$$Lambda$34.get$Lambda(), "EGL Init");
        eglInitThread.start();
    }

    private static void chooseDriver(Context context) {
        ApplicationInfo driverInfo;
        String driverPackageName = SystemProperties.get(PROPERTY_GFX_DRIVER);
        if (driverPackageName == null || driverPackageName.isEmpty()) {
            return;
        }
        ApplicationInfo ai = context.getApplicationInfo();
        if (ai.isPrivilegedApp() || ai.isSystemApp() && !ai.isUpdatedSystemApp()) {
            return;
        }
        try {
            driverInfo = context.getPackageManager().getApplicationInfo(driverPackageName, 0x100000);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "driver package '" + driverPackageName + "' not installed");
            return;
        }
        String abi = GraphicsEnvironment.chooseAbi(driverInfo);
        if (abi == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(driverInfo.nativeLibraryDir).append(File.pathSeparator);
        sb.append(driverInfo.sourceDir).append("!/lib/").append(abi);
        String paths = sb.toString();
        GraphicsEnvironment.setDriverPath(paths);
    }

    private static String chooseAbi(ApplicationInfo ai) {
        String isa = VMRuntime.getCurrentInstructionSet();
        if (ai.primaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.primaryCpuAbi))) {
            return ai.primaryCpuAbi;
        }
        if (ai.secondaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.secondaryCpuAbi))) {
            return ai.secondaryCpuAbi;
        }
        return null;
    }

    private static native void setDriverPath(String var0);

    static final /* synthetic */ void lambda$setupGraphicsEnvironment$33$GraphicsEnvironment() {
        EGL14.eglGetDisplay(0);
    }
}

