/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.HwBlob;
import android.os.IHwBinder;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.util.NativeAllocationRegistry;

public class HwParcel {
    private static final String TAG = "HwParcel";
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_ERROR = -1;
    private static final NativeAllocationRegistry sNativeRegistry;
    private long mNativeContext;

    private HwParcel(boolean allocate) {
        this.native_setup(allocate);
        sNativeRegistry.registerNativeAllocation((Object)this, this.mNativeContext);
    }

    public HwParcel() {
        this.native_setup(true);
        sNativeRegistry.registerNativeAllocation((Object)this, this.mNativeContext);
    }

    public final native void writeInterfaceToken(String var1);

    public final native void writeBool(boolean var1);

    public final native void writeInt8(byte var1);

    public final native void writeInt16(short var1);

    public final native void writeInt32(int var1);

    public final native void writeInt64(long var1);

    public final native void writeFloat(float var1);

    public final native void writeDouble(double var1);

    public final native void writeString(String var1);

    private final native void writeBoolVector(boolean[] var1);

    private final native void writeInt8Vector(byte[] var1);

    private final native void writeInt16Vector(short[] var1);

    private final native void writeInt32Vector(int[] var1);

    private final native void writeInt64Vector(long[] var1);

    private final native void writeFloatVector(float[] var1);

    private final native void writeDoubleVector(double[] var1);

    private final native void writeStringVector(String[] var1);

    public final void writeBoolVector(ArrayList<Boolean> val) {
        int n = val.size();
        boolean[] array2 = new boolean[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeBoolVector(array2);
    }

    public final void writeInt8Vector(ArrayList<Byte> val) {
        int n = val.size();
        byte[] array2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeInt8Vector(array2);
    }

    public final void writeInt16Vector(ArrayList<Short> val) {
        int n = val.size();
        short[] array2 = new short[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeInt16Vector(array2);
    }

    public final void writeInt32Vector(ArrayList<Integer> val) {
        int n = val.size();
        int[] array2 = new int[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeInt32Vector(array2);
    }

    public final void writeInt64Vector(ArrayList<Long> val) {
        int n = val.size();
        long[] array2 = new long[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeInt64Vector(array2);
    }

    public final void writeFloatVector(ArrayList<Float> val) {
        int n = val.size();
        float[] array2 = new float[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i).floatValue();
        }
        this.writeFloatVector(array2);
    }

    public final void writeDoubleVector(ArrayList<Double> val) {
        int n = val.size();
        double[] array2 = new double[n];
        for (int i = 0; i < n; ++i) {
            array2[i] = val.get(i);
        }
        this.writeDoubleVector(array2);
    }

    public final void writeStringVector(ArrayList<String> val) {
        this.writeStringVector(val.toArray(new String[val.size()]));
    }

    public final native void writeStrongBinder(IHwBinder var1);

    public final native void enforceInterface(String var1);

    public final native boolean readBool();

    public final native byte readInt8();

    public final native short readInt16();

    public final native int readInt32();

    public final native long readInt64();

    public final native float readFloat();

    public final native double readDouble();

    public final native String readString();

    private final native boolean[] readBoolVectorAsArray();

    private final native byte[] readInt8VectorAsArray();

    private final native short[] readInt16VectorAsArray();

    private final native int[] readInt32VectorAsArray();

    private final native long[] readInt64VectorAsArray();

    private final native float[] readFloatVectorAsArray();

    private final native double[] readDoubleVectorAsArray();

    private final native String[] readStringVectorAsArray();

    public final ArrayList<Boolean> readBoolVector() {
        Boolean[] array2 = HwBlob.wrapArray(this.readBoolVectorAsArray());
        return new ArrayList<Boolean>(Arrays.asList(array2));
    }

    public final ArrayList<Byte> readInt8Vector() {
        Byte[] array2 = HwBlob.wrapArray(this.readInt8VectorAsArray());
        return new ArrayList<Byte>(Arrays.asList(array2));
    }

    public final ArrayList<Short> readInt16Vector() {
        Short[] array2 = HwBlob.wrapArray(this.readInt16VectorAsArray());
        return new ArrayList<Short>(Arrays.asList(array2));
    }

    public final ArrayList<Integer> readInt32Vector() {
        Integer[] array2 = HwBlob.wrapArray(this.readInt32VectorAsArray());
        return new ArrayList<Integer>(Arrays.asList(array2));
    }

    public final ArrayList<Long> readInt64Vector() {
        Long[] array2 = HwBlob.wrapArray(this.readInt64VectorAsArray());
        return new ArrayList<Long>(Arrays.asList(array2));
    }

    public final ArrayList<Float> readFloatVector() {
        Float[] array2 = HwBlob.wrapArray(this.readFloatVectorAsArray());
        return new ArrayList<Float>(Arrays.asList(array2));
    }

    public final ArrayList<Double> readDoubleVector() {
        Double[] array2 = HwBlob.wrapArray(this.readDoubleVectorAsArray());
        return new ArrayList<Double>(Arrays.asList(array2));
    }

    public final ArrayList<String> readStringVector() {
        return new ArrayList<String>(Arrays.asList(this.readStringVectorAsArray()));
    }

    public final native IHwBinder readStrongBinder();

    public final native HwBlob readBuffer();

    public final native HwBlob readEmbeddedBuffer(long var1, long var3, boolean var5);

    public final native void writeBuffer(HwBlob var1);

    public final native void writeStatus(int var1);

    public final native void verifySuccess();

    public final native void releaseTemporaryStorage();

    public final native void send();

    private static final native long native_init();

    private final native void native_setup(boolean var1);

    static {
        long freeFunction = HwParcel.native_init();
        sNativeRegistry = new NativeAllocationRegistry(HwParcel.class.getClassLoader(), freeFunction, 128L);
    }
}

