/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BaseBundle;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class PersistableBundle
extends BaseBundle
implements Cloneable,
Parcelable,
XmlUtils.WriteMapCallback {
    private static final String TAG_PERSISTABLEMAP = "pbundle_as_map";
    public static final PersistableBundle EMPTY = new PersistableBundle();
    public static final Parcelable.Creator<PersistableBundle> CREATOR;

    public static boolean isValidType(Object value) {
        return value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof String || value instanceof int[] || value instanceof long[] || value instanceof double[] || value instanceof String[] || value instanceof PersistableBundle || value == null || value instanceof Boolean || value instanceof boolean[];
    }

    public PersistableBundle() {
        this.mFlags = 1;
    }

    public PersistableBundle(int capacity) {
        super(capacity);
        this.mFlags = 1;
    }

    public PersistableBundle(PersistableBundle b) {
        super(b);
        this.mFlags = b.mFlags;
    }

    public PersistableBundle(Bundle b) {
        this(b.getMap());
    }

    private PersistableBundle(ArrayMap<String, Object> map) {
        this.mFlags = 1;
        this.putAll(map);
        int N = this.mMap.size();
        for (int i = 0; i < N; ++i) {
            Object value = this.mMap.valueAt(i);
            if (value instanceof ArrayMap) {
                this.mMap.setValueAt(i, new PersistableBundle((ArrayMap)value));
                continue;
            }
            if (value instanceof Bundle) {
                this.mMap.setValueAt(i, new PersistableBundle((Bundle)value));
                continue;
            }
            if (PersistableBundle.isValidType(value)) continue;
            throw new IllegalArgumentException("Bad value in PersistableBundle key=" + (String)this.mMap.keyAt(i) + " value=" + value);
        }
    }

    PersistableBundle(Parcel parcelledData, int length) {
        super(parcelledData, length);
        this.mFlags = 1;
    }

    PersistableBundle(boolean doInit) {
        super(doInit);
    }

    public static PersistableBundle forPair(String key, String value) {
        PersistableBundle b = new PersistableBundle(1);
        b.putString(key, value);
        return b;
    }

    public Object clone() {
        return new PersistableBundle(this);
    }

    public PersistableBundle deepcopy() {
        PersistableBundle b = new PersistableBundle(false);
        b.copyInternal(this, true);
        return b;
    }

    public void putPersistableBundle(String key, PersistableBundle value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public PersistableBundle getPersistableBundle(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (PersistableBundle)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Bundle", e);
            return null;
        }
    }

    @Override
    public void writeUnknownObject(Object v, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (!(v instanceof PersistableBundle)) {
            throw new XmlPullParserException("Unknown Object o=" + v);
        }
        out.startTag(null, TAG_PERSISTABLEMAP);
        out.attribute(null, "name", name);
        ((PersistableBundle)v).saveToXml(out);
        out.endTag(null, TAG_PERSISTABLEMAP);
    }

    public void saveToXml(XmlSerializer out) throws IOException, XmlPullParserException {
        this.unparcel();
        XmlUtils.writeMapXml((Map)this.mMap, out, this);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        boolean oldAllowFds = parcel.pushAllowFds(false);
        try {
            this.writeToParcelInner(parcel, flags);
        }
        finally {
            parcel.restoreAllowFds(oldAllowFds);
        }
    }

    public static PersistableBundle restoreFromXml(XmlPullParser in) throws IOException, XmlPullParserException {
        int event;
        int outerDepth = in.getDepth();
        String startTag = in.getName();
        String[] tagName = new String[1];
        while ((event = in.next()) != 1 && (event != 3 || in.getDepth() < outerDepth)) {
            if (event != 2) continue;
            return new PersistableBundle(XmlUtils.readThisArrayMapXml(in, startTag, tagName, new MyReadMapCallback()));
        }
        return EMPTY;
    }

    public synchronized String toString() {
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                return "PersistableBundle[EMPTY_PARCEL]";
            }
            return "PersistableBundle[mParcelledData.dataSize=" + this.mParcelledData.dataSize() + "]";
        }
        return "PersistableBundle[" + this.mMap.toString() + "]";
    }

    static {
        PersistableBundle.EMPTY.mMap = ArrayMap.EMPTY;
        CREATOR = new Parcelable.Creator<PersistableBundle>(){

            @Override
            public PersistableBundle createFromParcel(Parcel in) {
                return in.readPersistableBundle();
            }

            public PersistableBundle[] newArray(int size) {
                return new PersistableBundle[size];
            }
        };
    }

    static class MyReadMapCallback
    implements XmlUtils.ReadMapCallback {
        MyReadMapCallback() {
        }

        @Override
        public Object readThisUnknownObjectXml(XmlPullParser in, String tag) throws XmlPullParserException, IOException {
            if (PersistableBundle.TAG_PERSISTABLEMAP.equals(tag)) {
                return PersistableBundle.restoreFromXml(in);
            }
            throw new XmlPullParserException("Unknown tag=" + tag);
        }
    }
}

