/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.app.ActivityThread;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.graphics.fonts.FontRequest;
import android.graphics.fonts.FontResult;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.ParcelFileDescriptor;
import android.os.ResultReceiver;
import android.provider.BaseColumns;
import android.provider.FontsContract$$Lambda$97;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class FontsContract {
    private static final String TAG = "FontsContract";
    public static final String PARCEL_FONT_RESULTS = "font_results";
    public static final int RESULT_CODE_OK = 0;
    public static final int RESULT_CODE_FONT_NOT_FOUND = 1;
    public static final int RESULT_CODE_PROVIDER_NOT_FOUND = 2;
    private static final int THREAD_RENEWAL_THRESHOLD_MS = 10000;
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private Handler mHandler;
    @GuardedBy(value="mLock")
    private HandlerThread mThread;
    private final Runnable mReplaceDispatcherThreadRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = FontsContract.this.mLock;
            synchronized (object) {
                if (FontsContract.this.mThread != null) {
                    FontsContract.this.mThread.quitSafely();
                    FontsContract.this.mThread = null;
                    FontsContract.this.mHandler = null;
                }
            }
        }
    };

    public FontsContract() {
        this.mContext = ActivityThread.currentActivityThread().getSystemContext();
        this.mPackageManager = this.mContext.getPackageManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFont(FontRequest request, ResultReceiver receiver) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHandler == null) {
                this.mThread = new HandlerThread("fonts", 10);
                this.mThread.start();
                this.mHandler = new Handler(this.mThread.getLooper());
            }
            this.mHandler.post(FontsContract$$Lambda$97.get$Lambda(this, request, receiver));
            this.mHandler.removeCallbacks(this.mReplaceDispatcherThreadRunnable);
            this.mHandler.postDelayed(this.mReplaceDispatcherThreadRunnable, 10000L);
        }
    }

    private Bundle getFontFromProvider(FontRequest request, ResultReceiver receiver, ProviderInfo providerInfo) {
        ArrayList<FontResult> result = null;
        Uri uri = new Uri.Builder().scheme("content").authority(providerInfo.authority).build();
        try (Cursor cursor = this.mContext.getContentResolver().query(uri, new String[]{"_id", "font_ttc_index", "font_variation_settings", "font_style"}, "query = ?", new String[]{request.getQuery()}, null);){
            if (cursor != null && cursor.getCount() > 0) {
                result = new ArrayList<FontResult>();
                int idColumnIndex = cursor.getColumnIndex("_id");
                int ttcIndexColumnIndex = cursor.getColumnIndex("font_ttc_index");
                int vsColumnIndex = cursor.getColumnIndex("font_variation_settings");
                int styleColumnIndex = cursor.getColumnIndex("font_style");
                while (cursor.moveToNext()) {
                    long id2 = cursor.getLong(idColumnIndex);
                    Uri fileUri = ContentUris.withAppendedId(uri, id2);
                    try {
                        ParcelFileDescriptor pfd = this.mContext.getContentResolver().openFileDescriptor(fileUri, "r");
                        int ttcIndex = cursor.getInt(ttcIndexColumnIndex);
                        String variationSettings = cursor.getString(vsColumnIndex);
                        int style2 = cursor.getInt(styleColumnIndex);
                        result.add(new FontResult(pfd, ttcIndex, variationSettings, style2));
                    }
                    catch (FileNotFoundException e) {
                        Log.e(TAG, "FileNotFoundException raised when interacting with content provider " + providerInfo.authority, e);
                    }
                }
            }
        }
        if (result != null && !result.isEmpty()) {
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList(PARCEL_FONT_RESULTS, result);
            return bundle;
        }
        return null;
    }

    final /* synthetic */ void lambda$getFont$8$FontsContract(FontRequest fontRequest, ResultReceiver resultReceiver) {
        String providerAuthority = fontRequest.getProviderAuthority();
        ProviderInfo providerInfo = this.mPackageManager.resolveContentProvider(providerAuthority, 0x100000);
        if (providerInfo == null) {
            resultReceiver.send(2, null);
            return;
        }
        Bundle result = this.getFontFromProvider(fontRequest, resultReceiver, providerInfo);
        if (result == null) {
            resultReceiver.send(1, null);
            return;
        }
        resultReceiver.send(0, result);
    }

    public static final class Columns
    implements BaseColumns {
        public static final String TTC_INDEX = "font_ttc_index";
        public static final String VARIATION_SETTINGS = "font_variation_settings";
        public static final String STYLE = "font_style";
    }
}

