/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.provider.Settings;
import android.text.TextUtils;
import com.android.internal.util.ArrayUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;

public class SettingsStringUtil {
    public static final String DELIMITER = ":";

    private SettingsStringUtil() {
    }

    public static class SettingStringHelper {
        private final ContentResolver mContentResolver;
        private final String mSettingName;
        private final int mUserId;

        public SettingStringHelper(ContentResolver contentResolver, String name, int userId) {
            this.mContentResolver = contentResolver;
            this.mUserId = userId;
            this.mSettingName = name;
        }

        public String read() {
            return Settings.Secure.getStringForUser(this.mContentResolver, this.mSettingName, this.mUserId);
        }

        public boolean write(String value) {
            return Settings.Secure.putStringForUser(this.mContentResolver, this.mSettingName, value, this.mUserId);
        }

        public boolean modify(Function<String, String> change) {
            return this.write(change.apply(this.read()));
        }
    }

    public static class ComponentNameSet
    extends ColonDelimitedSet<ComponentName> {
        public ComponentNameSet(String colonSeparatedPackageNames) {
            super(colonSeparatedPackageNames);
        }

        @Override
        protected ComponentName itemFromString(String s) {
            return ComponentName.unflattenFromString(s);
        }

        @Override
        protected String itemToString(ComponentName item) {
            return item.flattenToString();
        }

        public static String add(String delimitedElements, ComponentName element) {
            ComponentNameSet set = new ComponentNameSet(delimitedElements);
            if (set.contains(element)) {
                return delimitedElements;
            }
            set.add(element);
            return set.toString();
        }

        public static String remove(String delimitedElements, ComponentName element) {
            ComponentNameSet set = new ComponentNameSet(delimitedElements);
            if (!set.contains(element)) {
                return delimitedElements;
            }
            set.remove(element);
            return set.toString();
        }

        public static boolean contains(String delimitedElements, ComponentName element) {
            return ColonDelimitedSet.OfStrings.contains(delimitedElements, element.flattenToString());
        }
    }

    public static abstract class ColonDelimitedSet<T>
    extends HashSet<T> {
        public ColonDelimitedSet(String colonSeparatedItems) {
            for (String cn : TextUtils.split(TextUtils.emptyIfNull(colonSeparatedItems), SettingsStringUtil.DELIMITER)) {
                this.add(this.itemFromString(cn));
            }
        }

        protected abstract T itemFromString(String var1);

        protected String itemToString(T item) {
            return String.valueOf(item);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator it = this.iterator();
            if (it.hasNext()) {
                sb.append(this.itemToString(it.next()));
                while (it.hasNext()) {
                    sb.append(SettingsStringUtil.DELIMITER);
                    sb.append(this.itemToString(it.next()));
                }
            }
            return sb.toString();
        }

        public static class OfStrings
        extends ColonDelimitedSet<String> {
            public OfStrings(String colonSeparatedItems) {
                super(colonSeparatedItems);
            }

            @Override
            protected String itemFromString(String s) {
                return s;
            }

            public static String add(String delimitedElements, String element) {
                OfStrings set = new OfStrings(delimitedElements);
                if (set.contains(element)) {
                    return delimitedElements;
                }
                set.add(element);
                return set.toString();
            }

            public static String remove(String delimitedElements, String element) {
                OfStrings set = new OfStrings(delimitedElements);
                if (!set.contains(element)) {
                    return delimitedElements;
                }
                set.remove(element);
                return set.toString();
            }

            public static boolean contains(String delimitedElements, String element) {
                String[] elements = TextUtils.split(delimitedElements, SettingsStringUtil.DELIMITER);
                return ArrayUtils.indexOf(elements, element) != -1;
            }
        }
    }
}

