/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.Credentials;
import android.security.KeyStore;
import android.security.keymaster.KeyCharacteristics;
import android.security.keymaster.KeymasterArguments;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyProperties;
import android.security.keystore.KeyStoreCryptoOperationUtils;
import android.security.keystore.KeymasterUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import libcore.util.EmptyArray;

public abstract class AndroidKeyStoreKeyGeneratorSpi
extends KeyGeneratorSpi {
    private final KeyStore mKeyStore = KeyStore.getInstance();
    private final int mKeymasterAlgorithm;
    private final int mKeymasterDigest;
    private final int mDefaultKeySizeBits;
    private KeyGenParameterSpec mSpec;
    private SecureRandom mRng;
    protected int mKeySizeBits;
    private int[] mKeymasterPurposes;
    private int[] mKeymasterBlockModes;
    private int[] mKeymasterPaddings;
    private int[] mKeymasterDigests;

    protected AndroidKeyStoreKeyGeneratorSpi(int keymasterAlgorithm, int defaultKeySizeBits) {
        this(keymasterAlgorithm, -1, defaultKeySizeBits);
    }

    protected AndroidKeyStoreKeyGeneratorSpi(int keymasterAlgorithm, int keymasterDigest, int defaultKeySizeBits) {
        this.mKeymasterAlgorithm = keymasterAlgorithm;
        this.mKeymasterDigest = keymasterDigest;
        this.mDefaultKeySizeBits = defaultKeySizeBits;
        if (this.mDefaultKeySizeBits <= 0) {
            throw new IllegalArgumentException("Default key size must be positive");
        }
        if (this.mKeymasterAlgorithm == 128 && this.mKeymasterDigest == -1) {
            throw new IllegalArgumentException("Digest algorithm must be specified for HMAC key");
        }
    }

    @Override
    protected void engineInit(SecureRandom random) {
        throw new UnsupportedOperationException("Cannot initialize without a " + KeyGenParameterSpec.class.getName() + " parameter");
    }

    @Override
    protected void engineInit(int keySize, SecureRandom random) {
        throw new UnsupportedOperationException("Cannot initialize without a " + KeyGenParameterSpec.class.getName() + " parameter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.resetAll();
        boolean success = false;
        try {
            if (params == null || !(params instanceof KeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Cannot initialize without a " + KeyGenParameterSpec.class.getName() + " parameter");
            }
            KeyGenParameterSpec spec = (KeyGenParameterSpec)params;
            if (spec.getKeystoreAlias() == null) {
                throw new InvalidAlgorithmParameterException("KeyStore entry alias not provided");
            }
            this.mRng = random;
            this.mSpec = spec;
            int n = this.mKeySizeBits = spec.getKeySize() != -1 ? spec.getKeySize() : this.mDefaultKeySizeBits;
            if (this.mKeySizeBits <= 0) {
                throw new InvalidAlgorithmParameterException("Key size must be positive: " + this.mKeySizeBits);
            }
            if (this.mKeySizeBits % 8 != 0) {
                throw new InvalidAlgorithmParameterException("Key size must be a multiple of 8: " + this.mKeySizeBits);
            }
            try {
                this.mKeymasterPurposes = KeyProperties.Purpose.allToKeymaster(spec.getPurposes());
                this.mKeymasterPaddings = KeyProperties.EncryptionPadding.allToKeymaster(spec.getEncryptionPaddings());
                if (spec.getSignaturePaddings().length > 0) {
                    throw new InvalidAlgorithmParameterException("Signature paddings not supported for symmetric key algorithms");
                }
                this.mKeymasterBlockModes = KeyProperties.BlockMode.allToKeymaster(spec.getBlockModes());
                if ((spec.getPurposes() & 1) != 0 && spec.isRandomizedEncryptionRequired()) {
                    for (int keymasterBlockMode : this.mKeymasterBlockModes) {
                        if (KeymasterUtils.isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto(keymasterBlockMode)) continue;
                        throw new InvalidAlgorithmParameterException("Randomized encryption (IND-CPA) required but may be violated by block mode: " + KeyProperties.BlockMode.fromKeymaster(keymasterBlockMode) + ". See " + KeyGenParameterSpec.class.getName() + " documentation.");
                    }
                }
                if (this.mKeymasterAlgorithm == 128) {
                    int[] keymasterDigestsFromSpec;
                    if (this.mKeySizeBits < 64) {
                        throw new InvalidAlgorithmParameterException("HMAC key size must be at least 64 bits.");
                    }
                    this.mKeymasterDigests = new int[]{this.mKeymasterDigest};
                    if (spec.isDigestsSpecified() && ((keymasterDigestsFromSpec = KeyProperties.Digest.allToKeymaster(spec.getDigests())).length != 1 || keymasterDigestsFromSpec[0] != this.mKeymasterDigest)) {
                        throw new InvalidAlgorithmParameterException("Unsupported digests specification: " + Arrays.asList(spec.getDigests()) + ". Only " + KeyProperties.Digest.fromKeymaster(this.mKeymasterDigest) + " supported for this HMAC key algorithm");
                    }
                } else {
                    this.mKeymasterDigests = spec.isDigestsSpecified() ? KeyProperties.Digest.allToKeymaster(spec.getDigests()) : EmptyArray.INT;
                }
                KeymasterUtils.addUserAuthArgs(new KeymasterArguments(), spec.isUserAuthenticationRequired(), spec.getUserAuthenticationValidityDurationSeconds(), spec.isUserAuthenticationValidWhileOnBody(), spec.isInvalidatedByBiometricEnrollment(), 0L);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new InvalidAlgorithmParameterException(e);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    private void resetAll() {
        this.mSpec = null;
        this.mRng = null;
        this.mKeySizeBits = -1;
        this.mKeymasterPurposes = null;
        this.mKeymasterPaddings = null;
        this.mKeymasterBlockModes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateKey() {
        KeyGenParameterSpec spec = this.mSpec;
        if (spec == null) {
            throw new IllegalStateException("Not initialized");
        }
        KeymasterArguments args = new KeymasterArguments();
        args.addUnsignedInt(0x30000003, this.mKeySizeBits);
        args.addEnum(0x10000002, this.mKeymasterAlgorithm);
        args.addEnums(0x20000001, this.mKeymasterPurposes);
        args.addEnums(0x20000004, this.mKeymasterBlockModes);
        args.addEnums(0x20000006, this.mKeymasterPaddings);
        args.addEnums(0x20000005, this.mKeymasterDigests);
        KeymasterUtils.addUserAuthArgs(args, spec.isUserAuthenticationRequired(), spec.getUserAuthenticationValidityDurationSeconds(), spec.isUserAuthenticationValidWhileOnBody(), spec.isInvalidatedByBiometricEnrollment(), 0L);
        KeymasterUtils.addMinMacLengthAuthorizationIfNecessary(args, this.mKeymasterAlgorithm, this.mKeymasterBlockModes, this.mKeymasterDigests);
        args.addDateIfNotNull(1610613136, spec.getKeyValidityStart());
        args.addDateIfNotNull(1610613137, spec.getKeyValidityForOriginationEnd());
        args.addDateIfNotNull(1610613138, spec.getKeyValidityForConsumptionEnd());
        if ((spec.getPurposes() & 1) != 0 && !spec.isRandomizedEncryptionRequired()) {
            args.addBoolean(0x70000007);
        }
        byte[] additionalEntropy = KeyStoreCryptoOperationUtils.getRandomBytesToMixIntoKeystoreRng(this.mRng, (this.mKeySizeBits + 7) / 8);
        int flags = 0;
        String keyAliasInKeystore = "USRSKEY_" + spec.getKeystoreAlias();
        KeyCharacteristics resultingKeyCharacteristics = new KeyCharacteristics();
        boolean success = false;
        try {
            String keyAlgorithmJCA;
            Credentials.deleteAllTypesForAlias(this.mKeyStore, spec.getKeystoreAlias(), spec.getUid());
            int errorCode = this.mKeyStore.generateKey(keyAliasInKeystore, args, additionalEntropy, spec.getUid(), flags, resultingKeyCharacteristics);
            if (errorCode != 1) {
                throw new ProviderException("Keystore operation failed", KeyStore.getKeyStoreException(errorCode));
            }
            try {
                keyAlgorithmJCA = KeyProperties.KeyAlgorithm.fromKeymasterSecretKeyAlgorithm(this.mKeymasterAlgorithm, this.mKeymasterDigest);
            }
            catch (IllegalArgumentException e) {
                throw new ProviderException("Failed to obtain JCA secret key algorithm name", e);
            }
            AndroidKeyStoreSecretKey result = new AndroidKeyStoreSecretKey(keyAliasInKeystore, spec.getUid(), keyAlgorithmJCA);
            success = true;
            AndroidKeyStoreSecretKey androidKeyStoreSecretKey = result;
            return androidKeyStoreSecretKey;
        }
        finally {
            if (!success) {
                Credentials.deleteAllTypesForAlias(this.mKeyStore, spec.getKeystoreAlias(), spec.getUid());
            }
        }
    }

    public static class HmacSHA512
    extends HmacBase {
        public HmacSHA512() {
            super(6);
        }
    }

    public static class HmacSHA384
    extends HmacBase {
        public HmacSHA384() {
            super(5);
        }
    }

    public static class HmacSHA256
    extends HmacBase {
        public HmacSHA256() {
            super(4);
        }
    }

    public static class HmacSHA224
    extends HmacBase {
        public HmacSHA224() {
            super(3);
        }
    }

    public static class HmacSHA1
    extends HmacBase {
        public HmacSHA1() {
            super(2);
        }
    }

    protected static abstract class HmacBase
    extends AndroidKeyStoreKeyGeneratorSpi {
        protected HmacBase(int keymasterDigest) {
            super(128, keymasterDigest, KeymasterUtils.getDigestOutputSizeBits(keymasterDigest));
        }
    }

    public static class AES
    extends AndroidKeyStoreKeyGeneratorSpi {
        public AES() {
            super(32, 128);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            super.engineInit(params, random);
            if (this.mKeySizeBits != 128 && this.mKeySizeBits != 192 && this.mKeySizeBits != 256) {
                throw new InvalidAlgorithmParameterException("Unsupported key size: " + this.mKeySizeBits + ". Supported: 128, 192, 256.");
            }
        }
    }
}

