/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.security.KeyStore;
import android.security.keymaster.KeyCharacteristics;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.KeymasterCertificateChain;
import android.security.keystore.DeviceIdAttestationException;
import android.telephony.TelephonyManager;
import android.util.ArraySet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AttestationUtils {
    private static AtomicInteger sSequenceNumber = new AtomicInteger(0);
    public static final int ID_TYPE_SERIAL = 1;
    public static final int ID_TYPE_IMEI = 2;
    public static final int ID_TYPE_MEID = 3;

    private AttestationUtils() {
    }

    public static X509Certificate[] attestDeviceIds(Context context, int[] idTypes, byte[] attestationChallenge) throws DeviceIdAttestationException {
        if (idTypes == null) {
            throw new NullPointerException("Missing id types");
        }
        if (attestationChallenge == null) {
            throw new NullPointerException("Missing attestation challenge");
        }
        KeymasterArguments attestArgs = new KeymasterArguments();
        attestArgs.addBytes(-1879047484, attestationChallenge);
        ArraySet<Integer> idTypesSet = new ArraySet<Integer>(idTypes.length);
        for (int idType : idTypes) {
            idTypesSet.add(idType);
        }
        TelephonyManager telephonyService = null;
        if ((idTypesSet.contains(2) || idTypesSet.contains(3)) && (telephonyService = (TelephonyManager)context.getSystemService("phone")) == null) {
            throw new DeviceIdAttestationException("Unable to access telephony service");
        }
        block12: for (Integer idType : idTypesSet) {
            switch (idType) {
                case 1: {
                    attestArgs.addBytes(-1879047479, Build.getSerial().getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
                case 2: {
                    String imei = telephonyService.getImei(0);
                    if (imei == null) {
                        throw new DeviceIdAttestationException("Unable to retrieve IMEI");
                    }
                    attestArgs.addBytes(-1879047478, imei.getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
                case 3: {
                    String meid = telephonyService.getDeviceId();
                    if (meid == null) {
                        throw new DeviceIdAttestationException("Unable to retrieve MEID");
                    }
                    attestArgs.addBytes(-1879047477, meid.getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unknown device ID type " + idType);
        }
        attestArgs.addBytes(-1879047482, Build.BRAND.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047481, Build.DEVICE.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047480, Build.PRODUCT.getBytes(StandardCharsets.UTF_8));
        KeyStore keyStore = KeyStore.getInstance();
        String keyAlias = "android_internal_device_id_attestation-" + Process.myPid() + "-" + sSequenceNumber.incrementAndGet();
        if (!keyStore.delete(keyAlias)) {
            throw new DeviceIdAttestationException("Unable to remove temporary key");
        }
        try {
            KeymasterArguments generateArgs = new KeymasterArguments();
            generateArgs.addEnum(0x20000001, 3);
            generateArgs.addEnum(0x10000002, 1);
            generateArgs.addEnum(0x20000006, 1);
            generateArgs.addEnum(0x20000005, 0);
            generateArgs.addBoolean(1879048695);
            generateArgs.addUnsignedInt(0x30000003, 2048L);
            generateArgs.addUnsignedLong(1342177480, RSAKeyGenParameterSpec.F4);
            int errorCode = keyStore.generateKey(keyAlias, generateArgs, null, 0, new KeyCharacteristics());
            if (errorCode != 1) {
                throw new DeviceIdAttestationException("Unable to create temporary key", KeyStore.getKeyStoreException(errorCode));
            }
            KeymasterCertificateChain outChain = new KeymasterCertificateChain();
            errorCode = keyStore.attestKey(keyAlias, attestArgs, outChain);
            if (errorCode != 1) {
                throw new DeviceIdAttestationException("Unable to perform attestation", KeyStore.getKeyStoreException(errorCode));
            }
            List<byte[]> rawChain = outChain.getCertificates();
            if (rawChain.size() < 2) {
                throw new DeviceIdAttestationException("Attestation certificate chain contained " + rawChain.size() + " entries. At least two are required.");
            }
            ByteArrayOutputStream concatenatedRawChain = new ByteArrayOutputStream();
            try {
                for (byte[] cert : rawChain) {
                    concatenatedRawChain.write(cert);
                }
                X509Certificate[] x509CertificateArray = CertificateFactory.getInstance("X.509").generateCertificates(new ByteArrayInputStream(concatenatedRawChain.toByteArray())).toArray(new X509Certificate[0]);
                return x509CertificateArray;
            }
            catch (Exception e) {
                throw new DeviceIdAttestationException("Unable to construct certificate chain", e);
            }
        }
        finally {
            keyStore.delete(keyAlias);
        }
    }
}

