/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.autofill.AutoFillId;
import android.view.autofill.AutoFillValue;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;

public final class Dataset
implements Parcelable {
    private final ArrayList<AutoFillId> mFieldIds;
    private final ArrayList<AutoFillValue> mFieldValues;
    private final RemoteViews mPresentation;
    private final IntentSender mAuthentication;
    public static final Parcelable.Creator<Dataset> CREATOR = new Parcelable.Creator<Dataset>(){

        @Override
        public Dataset createFromParcel(Parcel parcel) {
            Builder builder = new Builder((RemoteViews)parcel.readParcelable(null));
            ArrayList ids = parcel.readTypedArrayList(null);
            ArrayList values = parcel.readTypedArrayList(null);
            int idCount = ids != null ? ids.size() : 0;
            int valueCount = values != null ? values.size() : 0;
            for (int i = 0; i < idCount; ++i) {
                AutoFillId id2 = (AutoFillId)ids.get(i);
                AutoFillValue value = valueCount > i ? (AutoFillValue)values.get(i) : null;
                builder.setValue(id2, value);
            }
            builder.setAuthentication((IntentSender)parcel.readParcelable(null));
            return builder.build();
        }

        public Dataset[] newArray(int size) {
            return new Dataset[size];
        }
    };

    private Dataset(Builder builder) {
        this.mFieldIds = builder.mFieldIds;
        this.mFieldValues = builder.mFieldValues;
        this.mPresentation = builder.mPresentation;
        this.mAuthentication = builder.mAuthentication;
    }

    public ArrayList<AutoFillId> getFieldIds() {
        return this.mFieldIds;
    }

    public ArrayList<AutoFillValue> getFieldValues() {
        return this.mFieldValues;
    }

    public RemoteViews getPresentation() {
        return this.mPresentation;
    }

    public IntentSender getAuthentication() {
        return this.mAuthentication;
    }

    public boolean isEmpty() {
        return this.mFieldIds == null || this.mFieldIds.isEmpty();
    }

    public String toString() {
        return "Dataset [" + ", fieldIds=" + this.mFieldIds + ", fieldValues=" + this.mFieldValues + ", hasPresentation=" + (this.mPresentation != null) + ", hasAuthentication=" + (this.mAuthentication != null) + ']';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mPresentation, flags);
        parcel.writeTypedArrayList(this.mFieldIds, flags);
        parcel.writeTypedArrayList(this.mFieldValues, flags);
        parcel.writeParcelable(this.mAuthentication, flags);
    }

    public static final class Builder {
        private ArrayList<AutoFillId> mFieldIds;
        private ArrayList<AutoFillValue> mFieldValues;
        private RemoteViews mPresentation;
        private IntentSender mAuthentication;
        private boolean mDestroyed;

        public Builder(RemoteViews presentation) {
            Preconditions.checkNotNull(presentation, "presentation must be non-null");
            this.mPresentation = presentation;
        }

        public Builder setAuthentication(IntentSender authentication) {
            this.throwIfDestroyed();
            this.mAuthentication = authentication;
            return this;
        }

        public Builder setValue(AutoFillId id2, AutoFillValue value) {
            this.throwIfDestroyed();
            Preconditions.checkNotNull(id2, "id cannot be null");
            Preconditions.checkNotNull(value, "value cannot be null");
            if (this.mFieldIds != null) {
                int existingIdx = this.mFieldIds.indexOf(id2);
                if (existingIdx >= 0) {
                    this.mFieldValues.set(existingIdx, value);
                    return this;
                }
            } else {
                this.mFieldIds = new ArrayList();
                this.mFieldValues = new ArrayList();
            }
            this.mFieldIds.add(id2);
            this.mFieldValues.add(value);
            return this;
        }

        public Dataset build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            if (this.mFieldIds == null) {
                throw new IllegalArgumentException("at least one value must be set");
            }
            return new Dataset(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }
    }
}

