/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.RemoteException;
import android.service.autofill.FillResponse;
import android.service.autofill.IFillCallback;

public final class FillCallback {
    private final IFillCallback mCallback;
    private boolean mCalled;

    public FillCallback(IFillCallback callback) {
        this.mCallback = callback;
    }

    public void onSuccess(FillResponse response) {
        this.assertNotCalled();
        this.mCalled = true;
        try {
            this.mCallback.onSuccess(response);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    public void onFailure(CharSequence message) {
        this.assertNotCalled();
        this.mCalled = true;
        try {
            this.mCallback.onFailure(message);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private void assertNotCalled() {
        if (this.mCalled) {
            throw new IllegalStateException("Already called");
        }
    }
}

