/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.Dataset;
import android.util.ArraySet;
import android.view.autofill.AutoFillId;
import android.widget.RemoteViews;
import java.util.ArrayList;

public final class FillResponse
implements Parcelable {
    private final ArrayList<Dataset> mDatasets;
    private final ArraySet<AutoFillId> mSavableIds;
    private final Bundle mExtras;
    private final RemoteViews mPresentation;
    private final IntentSender mAuthentication;
    public static final Parcelable.Creator<FillResponse> CREATOR = new Parcelable.Creator<FillResponse>(){

        @Override
        public FillResponse createFromParcel(Parcel parcel) {
            Builder builder = new Builder();
            ArrayList datasets = parcel.readTypedArrayList(null);
            int datasetCount = datasets != null ? datasets.size() : 0;
            for (int i = 0; i < datasetCount; ++i) {
                builder.addDataset((Dataset)datasets.get(i));
            }
            ArraySet fillIds = parcel.readTypedArraySet(null);
            int fillIdCount = fillIds != null ? fillIds.size() : 0;
            for (int i = 0; i < fillIdCount; ++i) {
                builder.addSavableFields((AutoFillId)fillIds.valueAt(i));
            }
            builder.setExtras((Bundle)parcel.readParcelable(null));
            builder.setAuthentication((IntentSender)parcel.readParcelable(null), (RemoteViews)parcel.readParcelable(null));
            return builder.build();
        }

        public FillResponse[] newArray(int size) {
            return new FillResponse[size];
        }
    };

    private FillResponse(Builder builder) {
        this.mDatasets = builder.mDatasets;
        this.mSavableIds = builder.mSavableIds;
        this.mExtras = builder.mExtras;
        this.mPresentation = builder.mPresentation;
        this.mAuthentication = builder.mAuthentication;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public ArrayList<Dataset> getDatasets() {
        return this.mDatasets;
    }

    public ArraySet<AutoFillId> getSavableIds() {
        return this.mSavableIds;
    }

    public RemoteViews getPresentation() {
        return this.mPresentation;
    }

    public IntentSender getAuthentication() {
        return this.mAuthentication;
    }

    public String toString() {
        return "FillResponse: [datasets=" + this.mDatasets + ", savableIds=" + this.mSavableIds + ", hasExtras=" + (this.mExtras != null) + ", hasPresentation=" + (this.mPresentation != null) + ", hasAuthentication=" + (this.mAuthentication != null);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeTypedArrayList(this.mDatasets, flags);
        parcel.writeTypedArraySet(this.mSavableIds, flags);
        parcel.writeParcelable(this.mExtras, flags);
        parcel.writeParcelable(this.mAuthentication, flags);
        parcel.writeParcelable(this.mPresentation, flags);
    }

    public static final class Builder {
        private ArrayList<Dataset> mDatasets;
        private ArraySet<AutoFillId> mSavableIds;
        private Bundle mExtras;
        private RemoteViews mPresentation;
        private IntentSender mAuthentication;
        private boolean mDestroyed;

        public Builder setAuthentication(IntentSender authentication, RemoteViews presentation) {
            this.throwIfDestroyed();
            if (authentication == null ^ presentation == null) {
                throw new IllegalArgumentException("authentication and presentation must be both non-null or null");
            }
            this.mAuthentication = authentication;
            this.mPresentation = presentation;
            return this;
        }

        public Builder addDataset(Dataset dataset) {
            this.throwIfDestroyed();
            if (dataset == null) {
                return this;
            }
            if (this.mDatasets == null) {
                this.mDatasets = new ArrayList();
            }
            if (!this.mDatasets.add(dataset)) {
                return this;
            }
            if (dataset.getFieldIds() != null) {
                int fieldCount = dataset.getFieldIds().size();
                for (int i = 0; i < fieldCount; ++i) {
                    AutoFillId id2 = dataset.getFieldIds().get(i);
                    if (this.mSavableIds == null) {
                        this.mSavableIds = new ArraySet();
                    }
                    this.mSavableIds.add(id2);
                }
            }
            return this;
        }

        public Builder addSavableFields(AutoFillId ... ids) {
            this.throwIfDestroyed();
            if (ids == null) {
                return this;
            }
            for (AutoFillId id2 : ids) {
                if (this.mSavableIds == null) {
                    this.mSavableIds = new ArraySet();
                }
                this.mSavableIds.add(id2);
            }
            return this;
        }

        public Builder setExtras(Bundle extras) {
            this.throwIfDestroyed();
            this.mExtras = extras;
            return this;
        }

        public FillResponse build() {
            this.throwIfDestroyed();
            if (this.mAuthentication == null && this.mDatasets == null && this.mSavableIds == null) {
                throw new IllegalArgumentException("need to provide at least one data set or savable ids or an authentication with a presentation");
            }
            this.mDestroyed = true;
            return new FillResponse(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }
    }
}

