/*
 * Decompiled with CFR 0.152.
 */
package android.service.gatekeeper;

import android.os.Parcel;
import android.os.Parcelable;

public final class GateKeeperResponse
implements Parcelable {
    public static final int RESPONSE_ERROR = -1;
    public static final int RESPONSE_OK = 0;
    public static final int RESPONSE_RETRY = 1;
    private final int mResponseCode;
    private int mTimeout;
    private byte[] mPayload;
    private boolean mShouldReEnroll;
    public static final Parcelable.Creator<GateKeeperResponse> CREATOR = new Parcelable.Creator<GateKeeperResponse>(){

        @Override
        public GateKeeperResponse createFromParcel(Parcel source) {
            GateKeeperResponse response;
            int responseCode = source.readInt();
            if (responseCode == 1) {
                response = GateKeeperResponse.createRetryResponse(source.readInt());
            } else if (responseCode == 0) {
                boolean shouldReEnroll = source.readInt() == 1;
                byte[] payload = null;
                int size = source.readInt();
                if (size > 0) {
                    payload = new byte[size];
                    source.readByteArray(payload);
                }
                response = GateKeeperResponse.createOkResponse(payload, shouldReEnroll);
            } else {
                response = GateKeeperResponse.createGenericResponse(responseCode);
            }
            return response;
        }

        public GateKeeperResponse[] newArray(int size) {
            return new GateKeeperResponse[size];
        }
    };

    private GateKeeperResponse(int responseCode) {
        this.mResponseCode = responseCode;
    }

    public static GateKeeperResponse createGenericResponse(int responseCode) {
        return new GateKeeperResponse(responseCode);
    }

    private static GateKeeperResponse createRetryResponse(int timeout) {
        GateKeeperResponse response = new GateKeeperResponse(1);
        response.mTimeout = timeout;
        return response;
    }

    public static GateKeeperResponse createOkResponse(byte[] payload, boolean shouldReEnroll) {
        GateKeeperResponse response = new GateKeeperResponse(0);
        response.mPayload = payload;
        response.mShouldReEnroll = shouldReEnroll;
        return response;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mResponseCode);
        if (this.mResponseCode == 1) {
            dest.writeInt(this.mTimeout);
        } else if (this.mResponseCode == 0) {
            dest.writeInt(this.mShouldReEnroll ? 1 : 0);
            if (this.mPayload != null) {
                dest.writeInt(this.mPayload.length);
                dest.writeByteArray(this.mPayload);
            }
        }
    }

    public byte[] getPayload() {
        return this.mPayload;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public boolean getShouldReEnroll() {
        return this.mShouldReEnroll;
    }

    public int getResponseCode() {
        return this.mResponseCode;
    }
}

