/*
 * Decompiled with CFR 0.152.
 */
package android.service.trust;

import android.annotation.IntDef;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.trust.ITrustAgentService;
import android.service.trust.ITrustAgentServiceCallback;
import android.util.Log;
import android.util.Slog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class TrustAgentService
extends Service {
    private final String TAG = TrustAgentService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
    private static final boolean DEBUG = false;
    public static final String SERVICE_INTERFACE = "android.service.trust.TrustAgentService";
    public static final String TRUST_AGENT_META_DATA = "android.service.trust.trustagent";
    public static final int FLAG_GRANT_TRUST_INITIATED_BY_USER = 1;
    public static final int FLAG_GRANT_TRUST_DISMISS_KEYGUARD = 2;
    public static final int TOKEN_STATE_ACTIVE = 1;
    public static final int TOKEN_STATE_INACTIVE = 0;
    private static final int MSG_UNLOCK_ATTEMPT = 1;
    private static final int MSG_CONFIGURE = 2;
    private static final int MSG_TRUST_TIMEOUT = 3;
    private static final int MSG_DEVICE_LOCKED = 4;
    private static final int MSG_DEVICE_UNLOCKED = 5;
    private static final int MSG_UNLOCK_LOCKOUT = 6;
    private static final int MSG_ESCROW_TOKEN_ADDED = 7;
    private static final int MSG_ESCROW_TOKEN_STATE_RECEIVED = 8;
    private static final int MSG_ESCROW_TOKEN_REMOVED = 9;
    private static final String EXTRA_TOKEN = "token";
    private static final String EXTRA_TOKEN_HANDLE = "token_handle";
    private static final String EXTRA_USER_HANDLE = "user_handle";
    private static final String EXTRA_TOKEN_STATE = "token_state";
    private static final String EXTRA_TOKEN_REMOVED_RESULT = "token_removed_result";
    private ITrustAgentServiceCallback mCallback;
    private Runnable mPendingGrantTrustTask;
    private boolean mManagingTrust;
    private final Object mLock = new Object();
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    TrustAgentService.this.onUnlockAttempt(msg.arg1 != 0);
                    return;
                }
                case 6: {
                    TrustAgentService.this.onDeviceUnlockLockout(msg.arg1);
                    return;
                }
                case 2: {
                    ConfigurationData data = (ConfigurationData)msg.obj;
                    boolean result = TrustAgentService.this.onConfigure(data.options);
                    if (data.token == null) return;
                    try {
                        Object object = TrustAgentService.this.mLock;
                        synchronized (object) {
                            TrustAgentService.this.mCallback.onConfigureCompleted(result, data.token);
                            return;
                        }
                    }
                    catch (RemoteException e) {
                        TrustAgentService.this.onError("calling onSetTrustAgentFeaturesEnabledCompleted()");
                    }
                    return;
                }
                case 3: {
                    TrustAgentService.this.onTrustTimeout();
                    return;
                }
                case 4: {
                    TrustAgentService.this.onDeviceLocked();
                    return;
                }
                case 5: {
                    TrustAgentService.this.onDeviceUnlocked();
                    return;
                }
                case 7: {
                    Bundle data = msg.getData();
                    byte[] token = data.getByteArray(TrustAgentService.EXTRA_TOKEN);
                    long handle = data.getLong(TrustAgentService.EXTRA_TOKEN_HANDLE);
                    UserHandle user = (UserHandle)data.getParcelable(TrustAgentService.EXTRA_USER_HANDLE);
                    TrustAgentService.this.onEscrowTokenAdded(token, handle, user);
                    return;
                }
                case 8: {
                    Bundle data = msg.getData();
                    long handle = data.getLong(TrustAgentService.EXTRA_TOKEN_HANDLE);
                    int tokenState = data.getInt(TrustAgentService.EXTRA_TOKEN_STATE, 0);
                    TrustAgentService.this.onEscrowTokenStateReceived(handle, tokenState);
                    return;
                }
                case 9: {
                    Bundle data = msg.getData();
                    long handle = data.getLong(TrustAgentService.EXTRA_TOKEN_HANDLE);
                    boolean success = data.getBoolean(TrustAgentService.EXTRA_TOKEN_REMOVED_RESULT);
                    TrustAgentService.this.onEscrowTokenRemoved(handle, success);
                    return;
                }
            }
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        ComponentName component = new ComponentName((Context)this, this.getClass());
        try {
            ServiceInfo serviceInfo = this.getPackageManager().getServiceInfo(component, 0);
            if (!"android.permission.BIND_TRUST_AGENT".equals(serviceInfo.permission)) {
                throw new IllegalStateException(component.flattenToShortString() + " is not declared with the permission " + "\"" + "android.permission.BIND_TRUST_AGENT" + "\"");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(this.TAG, "Can't get ServiceInfo for " + component.toShortString());
        }
    }

    public void onUnlockAttempt(boolean successful) {
    }

    public void onTrustTimeout() {
    }

    public void onDeviceLocked() {
    }

    public void onDeviceUnlocked() {
    }

    public void onDeviceUnlockLockout(long timeoutMs) {
    }

    public void onEscrowTokenAdded(byte[] token, long handle, UserHandle user) {
    }

    public void onEscrowTokenStateReceived(long handle, int tokenState) {
    }

    public void onEscrowTokenRemoved(long handle, boolean successful) {
    }

    private void onError(String msg) {
        Slog.v(this.TAG, "Remote exception while " + msg);
    }

    public boolean onConfigure(List<PersistableBundle> options) {
        return false;
    }

    @Deprecated
    public final void grantTrust(CharSequence message, long durationMs, boolean initiatedByUser) {
        this.grantTrust(message, durationMs, initiatedByUser ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void grantTrust(final CharSequence message, final long durationMs, final int flags) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mManagingTrust) {
                throw new IllegalStateException("Cannot grant trust if agent is not managing trust. Call setManagingTrust(true) first.");
            }
            if (this.mCallback != null) {
                try {
                    this.mCallback.grantTrust(message.toString(), durationMs, flags);
                }
                catch (RemoteException e) {
                    this.onError("calling enableTrust()");
                }
            } else {
                this.mPendingGrantTrustTask = new Runnable(){

                    @Override
                    public void run() {
                        TrustAgentService.this.grantTrust(message, durationMs, flags);
                    }
                };
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void revokeTrust() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingGrantTrustTask != null) {
                this.mPendingGrantTrustTask = null;
            }
            if (this.mCallback != null) {
                try {
                    this.mCallback.revokeTrust();
                }
                catch (RemoteException e) {
                    this.onError("calling revokeTrust()");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setManagingTrust(boolean managingTrust) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mManagingTrust != managingTrust) {
                this.mManagingTrust = managingTrust;
                if (this.mCallback != null) {
                    try {
                        this.mCallback.setManagingTrust(managingTrust);
                    }
                    catch (RemoteException e) {
                        this.onError("calling setManagingTrust()");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEscrowToken(byte[] token, UserHandle user) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallback == null) {
                Slog.w(this.TAG, "Cannot add escrow token if the agent is not connecting to framework");
                throw new IllegalStateException("Trust agent is not connected");
            }
            try {
                this.mCallback.addEscrowToken(token, user.getIdentifier());
            }
            catch (RemoteException e) {
                this.onError("calling addEscrowToken");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void isEscrowTokenActive(long handle, UserHandle user) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallback == null) {
                Slog.w(this.TAG, "Cannot add escrow token if the agent is not connecting to framework");
                throw new IllegalStateException("Trust agent is not connected");
            }
            try {
                this.mCallback.isEscrowTokenActive(handle, user.getIdentifier());
            }
            catch (RemoteException e) {
                this.onError("calling isEscrowTokenActive");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeEscrowToken(long handle, UserHandle user) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallback == null) {
                Slog.w(this.TAG, "Cannot add escrow token if the agent is not connecting to framework");
                throw new IllegalStateException("Trust agent is not connected");
            }
            try {
                this.mCallback.removeEscrowToken(handle, user.getIdentifier());
            }
            catch (RemoteException e) {
                this.onError("callling removeEscrowToken");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlockUserWithToken(long handle, byte[] token, UserHandle user) {
        UserManager um = (UserManager)this.getSystemService("user");
        if (um.isUserUnlocked()) {
            Slog.i(this.TAG, "User already unlocked");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallback == null) {
                Slog.w(this.TAG, "Cannot add escrow token if the agent is not connecting to framework");
                throw new IllegalStateException("Trust agent is not connected");
            }
            try {
                this.mCallback.unlockUserWithToken(handle, token, user.getIdentifier());
            }
            catch (RemoteException e) {
                this.onError("calling unlockUserWithToken");
            }
        }
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new TrustAgentServiceWrapper();
    }

    private final class TrustAgentServiceWrapper
    extends ITrustAgentService.Stub {
        private TrustAgentServiceWrapper() {
        }

        @Override
        public void onUnlockAttempt(boolean successful) {
            TrustAgentService.this.mHandler.obtainMessage(1, successful ? 1 : 0, 0).sendToTarget();
        }

        @Override
        public void onUnlockLockout(int timeoutMs) {
            TrustAgentService.this.mHandler.obtainMessage(6, timeoutMs, 0).sendToTarget();
        }

        @Override
        public void onTrustTimeout() {
            TrustAgentService.this.mHandler.sendEmptyMessage(3);
        }

        @Override
        public void onConfigure(List<PersistableBundle> args, IBinder token) {
            TrustAgentService.this.mHandler.obtainMessage(2, new ConfigurationData(args, token)).sendToTarget();
        }

        @Override
        public void onDeviceLocked() throws RemoteException {
            TrustAgentService.this.mHandler.obtainMessage(4).sendToTarget();
        }

        @Override
        public void onDeviceUnlocked() throws RemoteException {
            TrustAgentService.this.mHandler.obtainMessage(5).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCallback(ITrustAgentServiceCallback callback) {
            Object object = TrustAgentService.this.mLock;
            synchronized (object) {
                TrustAgentService.this.mCallback = callback;
                if (TrustAgentService.this.mManagingTrust) {
                    try {
                        TrustAgentService.this.mCallback.setManagingTrust(TrustAgentService.this.mManagingTrust);
                    }
                    catch (RemoteException e) {
                        TrustAgentService.this.onError("calling setManagingTrust()");
                    }
                }
                if (TrustAgentService.this.mPendingGrantTrustTask != null) {
                    TrustAgentService.this.mPendingGrantTrustTask.run();
                    TrustAgentService.this.mPendingGrantTrustTask = null;
                }
            }
        }

        @Override
        public void onEscrowTokenAdded(byte[] token, long handle, UserHandle user) {
            Message msg = TrustAgentService.this.mHandler.obtainMessage(7);
            msg.getData().putByteArray(TrustAgentService.EXTRA_TOKEN, token);
            msg.getData().putLong(TrustAgentService.EXTRA_TOKEN_HANDLE, handle);
            msg.getData().putParcelable(TrustAgentService.EXTRA_USER_HANDLE, user);
            msg.sendToTarget();
        }

        @Override
        public void onTokenStateReceived(long handle, int tokenState) {
            Message msg = TrustAgentService.this.mHandler.obtainMessage(8);
            msg.getData().putLong(TrustAgentService.EXTRA_TOKEN_HANDLE, handle);
            msg.getData().putInt(TrustAgentService.EXTRA_TOKEN_STATE, tokenState);
            msg.sendToTarget();
        }

        @Override
        public void onEscrowTokenRemoved(long handle, boolean successful) {
            Message msg = TrustAgentService.this.mHandler.obtainMessage(9);
            msg.getData().putLong(TrustAgentService.EXTRA_TOKEN_HANDLE, handle);
            msg.getData().putBoolean(TrustAgentService.EXTRA_TOKEN_REMOVED_RESULT, successful);
            msg.sendToTarget();
        }
    }

    private static final class ConfigurationData {
        final IBinder token;
        final List<PersistableBundle> options;

        ConfigurationData(List<PersistableBundle> opts, IBinder t) {
            this.options = opts;
            this.token = t;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 0L})
    public static @interface TokenState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 2L})
    public static @interface GrantTrustFlags {
    }
}

