/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.ConditionVariable;
import android.speech.tts.PlaybackQueueItem;
import android.speech.tts.TextToSpeechService;
import android.util.Log;

class AudioPlaybackQueueItem
extends PlaybackQueueItem {
    private static final String TAG = "TTS.AudioQueueItem";
    private final Context mContext;
    private final Uri mUri;
    private final TextToSpeechService.AudioOutputParams mAudioParams;
    private final ConditionVariable mDone;
    private MediaPlayer mPlayer;
    private volatile boolean mFinished;

    AudioPlaybackQueueItem(TextToSpeechService.UtteranceProgressDispatcher dispatcher, Object callerIdentity, Context context, Uri uri, TextToSpeechService.AudioOutputParams audioParams) {
        super(dispatcher, callerIdentity);
        this.mContext = context;
        this.mUri = uri;
        this.mAudioParams = audioParams;
        this.mDone = new ConditionVariable();
        this.mPlayer = null;
        this.mFinished = false;
    }

    @Override
    public void run() {
        TextToSpeechService.UtteranceProgressDispatcher dispatcher = this.getDispatcher();
        dispatcher.dispatchOnStart();
        int sessionId = this.mAudioParams.mSessionId;
        this.mPlayer = MediaPlayer.create(this.mContext, this.mUri, null, this.mAudioParams.mAudioAttributes, sessionId > 0 ? sessionId : 0);
        if (this.mPlayer == null) {
            dispatcher.dispatchOnError(-5);
            return;
        }
        try {
            this.mPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                @Override
                public boolean onError(MediaPlayer mp, int what, int extra) {
                    Log.w(AudioPlaybackQueueItem.TAG, "Audio playback error: " + what + ", " + extra);
                    AudioPlaybackQueueItem.this.mDone.open();
                    return true;
                }
            });
            this.mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                @Override
                public void onCompletion(MediaPlayer mp) {
                    AudioPlaybackQueueItem.this.mFinished = true;
                    AudioPlaybackQueueItem.this.mDone.open();
                }
            });
            AudioPlaybackQueueItem.setupVolume(this.mPlayer, this.mAudioParams.mVolume, this.mAudioParams.mPan);
            this.mPlayer.start();
            this.mDone.block();
            this.finish();
        }
        catch (IllegalArgumentException ex) {
            Log.w(TAG, "MediaPlayer failed", ex);
            this.mDone.open();
        }
        if (this.mFinished) {
            dispatcher.dispatchOnSuccess();
        } else {
            dispatcher.dispatchOnStop();
        }
    }

    private static void setupVolume(MediaPlayer player, float volume, float pan) {
        float vol = AudioPlaybackQueueItem.clip(volume, 0.0f, 1.0f);
        float panning = AudioPlaybackQueueItem.clip(pan, -1.0f, 1.0f);
        float volLeft = vol;
        float volRight = vol;
        if (panning > 0.0f) {
            volLeft *= 1.0f - panning;
        } else if (panning < 0.0f) {
            volRight *= 1.0f + panning;
        }
        player.setVolume(volLeft, volRight);
    }

    private static final float clip(float value, float min, float max) {
        return value < min ? min : (value < max ? value : max);
    }

    private void finish() {
        try {
            this.mPlayer.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.mPlayer.release();
    }

    @Override
    void stop(int errorCode) {
        this.mDone.open();
    }
}

