/*
 * Decompiled with CFR 0.152.
 */
package android.telecom.Logging;

import android.telecom.Log;
import android.telecom.Logging.EventManager$$Lambda$66;
import android.telecom.Logging.SessionManager;
import android.telecom.Logging.TimedEvent;
import android.text.TextUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class EventManager {
    public static final String TAG = "Logging.Events";
    public static final int DEFAULT_EVENTS_TO_CACHE = 10;
    private final Map<Loggable, EventRecord> mCallEventRecordMap = new HashMap<Loggable, EventRecord>();
    private LinkedBlockingQueue<EventRecord> mEventRecords = new LinkedBlockingQueue(10);
    private List<EventListener> mEventListeners = new ArrayList<EventListener>();
    private SessionManager.ISessionIdQueryHandler mSessionIdHandler;
    private final Map<String, List<TimedEventPair>> requestResponsePairs = new HashMap<String, List<TimedEventPair>>();
    private static final Object mSync = new Object();

    public void addRequestResponsePair(TimedEventPair p) {
        if (this.requestResponsePairs.containsKey(p.mRequest)) {
            this.requestResponsePairs.get(p.mRequest).add(p);
        } else {
            ArrayList<TimedEventPair> responses = new ArrayList<TimedEventPair>();
            responses.add(p);
            this.requestResponsePairs.put(p.mRequest, responses);
        }
    }

    public EventManager(SessionManager.ISessionIdQueryHandler l) {
        this.mSessionIdHandler = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(Loggable recordEntry, String event, Object data) {
        String currentSessionID = this.mSessionIdHandler.getSessionId();
        if (recordEntry == null) {
            Log.i(TAG, "Non-call EVENT: %s, %s", event, data);
            return;
        }
        LinkedBlockingQueue<EventRecord> linkedBlockingQueue = this.mEventRecords;
        synchronized (linkedBlockingQueue) {
            if (!this.mCallEventRecordMap.containsKey(recordEntry)) {
                EventRecord newRecord = new EventRecord(recordEntry);
                this.addEventRecord(newRecord);
            }
            EventRecord record = this.mCallEventRecordMap.get(recordEntry);
            record.addEvent(event, currentSessionID, data);
        }
    }

    public void event(Loggable recordEntry, String event, String format, Object ... args) {
        String msg;
        try {
            msg = args == null || args.length == 0 ? format : String.format(Locale.US, format, args);
        }
        catch (IllegalFormatException ife) {
            Log.e(this, (Throwable)ife, "IllegalFormatException: formatString='%s' numArgs=%d", format, args.length);
            msg = format + " (An error occurred while formatting the message.)";
        }
        this.event(recordEntry, event, msg);
    }

    public void dumpEvents(IndentingPrintWriter pw) {
        pw.println("Historical Events:");
        pw.increaseIndent();
        for (EventRecord eventRecord : this.mEventRecords) {
            eventRecord.dump(pw);
        }
        pw.decreaseIndent();
    }

    public void changeEventCacheSize(int newSize) {
        LinkedBlockingQueue<EventRecord> oldEventLog = this.mEventRecords;
        this.mEventRecords = new LinkedBlockingQueue(newSize);
        this.mCallEventRecordMap.clear();
        oldEventLog.forEach(EventManager$$Lambda$66.get$Lambda(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(EventListener e) {
        if (e != null) {
            Object object = mSync;
            synchronized (object) {
                this.mEventListeners.add(e);
            }
        }
    }

    public LinkedBlockingQueue<EventRecord> getEventRecords() {
        return this.mEventRecords;
    }

    public Map<Loggable, EventRecord> getCallEventRecordMap() {
        return this.mCallEventRecordMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEventRecord(EventRecord newRecord) {
        EventRecord record;
        Loggable recordEntry = newRecord.getRecordEntry();
        if (this.mEventRecords.remainingCapacity() == 0 && (record = this.mEventRecords.poll()) != null) {
            this.mCallEventRecordMap.remove(record.getRecordEntry());
        }
        this.mEventRecords.add(newRecord);
        this.mCallEventRecordMap.put(recordEntry, newRecord);
        Object object = mSync;
        synchronized (object) {
            for (EventListener l : this.mEventListeners) {
                l.eventRecordAdded(newRecord);
            }
        }
    }

    final /* synthetic */ void lambda$changeEventCacheSize$66$EventManager(EventRecord newRecord) {
        EventRecord record;
        Loggable recordEntry = newRecord.getRecordEntry();
        if (this.mEventRecords.remainingCapacity() == 0 && (record = this.mEventRecords.poll()) != null) {
            this.mCallEventRecordMap.remove(record.getRecordEntry());
        }
        this.mEventRecords.add(newRecord);
        this.mCallEventRecordMap.put(recordEntry, newRecord);
    }

    public class EventRecord {
        private final DateFormat sDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        private final List<Event> mEvents = new LinkedList<Event>();
        private final Loggable mRecordEntry;

        public EventRecord(Loggable recordEntry) {
            this.mRecordEntry = recordEntry;
        }

        public Loggable getRecordEntry() {
            return this.mRecordEntry;
        }

        public void addEvent(String event, String sessionId, Object data) {
            this.mEvents.add(new Event(event, sessionId, System.currentTimeMillis(), data));
            Log.i("Event", "RecordEntry %s: %s, %s", this.mRecordEntry.getId(), event, data);
        }

        public List<Event> getEvents() {
            return this.mEvents;
        }

        public List<EventTiming> extractEventTimings() {
            if (this.mEvents == null) {
                return Collections.emptyList();
            }
            LinkedList<EventTiming> result = new LinkedList<EventTiming>();
            HashMap<String, PendingResponse> pendingResponses = new HashMap<String, PendingResponse>();
            for (Event event : this.mEvents) {
                long elapsedTime;
                PendingResponse pendingResponse;
                if (EventManager.this.requestResponsePairs.containsKey(event.eventId)) {
                    for (TimedEventPair p : (List)EventManager.this.requestResponsePairs.get(event.eventId)) {
                        pendingResponses.put(p.mResponse, new PendingResponse(event.eventId, event.time, p.mTimeoutMillis, p.mName));
                    }
                }
                if ((pendingResponse = (PendingResponse)pendingResponses.remove(event.eventId)) == null || (elapsedTime = event.time - pendingResponse.requestEventTimeMillis) >= pendingResponse.timeoutMillis) continue;
                result.add(new EventTiming(pendingResponse.name, elapsedTime));
            }
            return result;
        }

        public void dump(IndentingPrintWriter pw) {
            pw.print(this.mRecordEntry.getDescription());
            pw.increaseIndent();
            for (Event event : this.mEvents) {
                pw.print(this.sDateFormat.format(new Date(event.time)));
                pw.print(" - ");
                pw.print(event.eventId);
                if (event.data != null) {
                    EventRecord record;
                    pw.print(" (");
                    Object data = event.data;
                    if (data instanceof Loggable && (record = (EventRecord)EventManager.this.mCallEventRecordMap.get(data)) != null) {
                        data = "RecordEntry " + record.mRecordEntry.getId();
                    }
                    pw.print(data);
                    pw.print(")");
                }
                if (!TextUtils.isEmpty(event.sessionId)) {
                    pw.print(":");
                    pw.print(event.sessionId);
                }
                pw.println();
            }
            pw.println("Timings (average for this call, milliseconds):");
            pw.increaseIndent();
            Map avgEventTimings = EventTiming.averageTimings(this.extractEventTimings());
            ArrayList eventNames = new ArrayList(avgEventTimings.keySet());
            Collections.sort(eventNames);
            for (String eventName : eventNames) {
                pw.printf("%s: %.2f\n", eventName, avgEventTimings.get(eventName));
            }
            pw.decreaseIndent();
            pw.decreaseIndent();
        }

        private class PendingResponse {
            String requestEventId;
            long requestEventTimeMillis;
            long timeoutMillis;
            String name;

            public PendingResponse(String requestEventId, long requestEventTimeMillis, long timeoutMillis, String name) {
                this.requestEventId = requestEventId;
                this.requestEventTimeMillis = requestEventTimeMillis;
                this.timeoutMillis = timeoutMillis;
                this.name = name;
            }
        }

        public class EventTiming
        extends TimedEvent<String> {
            public String name;
            public long time;

            public EventTiming(String name, long time) {
                this.name = name;
                this.time = time;
            }

            @Override
            public String getKey() {
                return this.name;
            }

            @Override
            public long getTime() {
                return this.time;
            }
        }
    }

    public static class Event {
        public String eventId;
        public String sessionId;
        public long time;
        public Object data;

        public Event(String eventId, String sessionId, long time, Object data) {
            this.eventId = eventId;
            this.sessionId = sessionId;
            this.time = time;
            this.data = data;
        }
    }

    public static class TimedEventPair {
        private static final long DEFAULT_TIMEOUT = 3000L;
        String mRequest;
        String mResponse;
        String mName;
        long mTimeoutMillis = 3000L;

        public TimedEventPair(String request, String response, String name) {
            this.mRequest = request;
            this.mResponse = response;
            this.mName = name;
        }

        public TimedEventPair(String request, String response, String name, long timeoutMillis) {
            this.mRequest = request;
            this.mResponse = response;
            this.mName = name;
            this.mTimeoutMillis = timeoutMillis;
        }
    }

    public static interface EventListener {
        public void eventRecordAdded(EventRecord var1);
    }

    public static interface Loggable {
        public String getId();

        public String getDescription();
    }
}

