/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.ImsServiceBase;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.MMTelFeature;
import android.telephony.ims.feature.RcsFeature;
import android.util.Log;
import android.util.SparseArray;
import com.android.ims.ImsCallProfile;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsCallSessionListener;
import com.android.ims.internal.IImsConfig;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsRegistrationListener;
import com.android.ims.internal.IImsServiceController;
import com.android.ims.internal.IImsUt;

public abstract class ImsService
extends ImsServiceBase {
    private static final String LOG_TAG = "ImsService";
    public static final String SERVICE_INTERFACE = "android.telephony.ims.ImsService";
    private final SparseArray<SparseArray<ImsFeature>> mFeatures = new SparseArray();
    protected final IBinder mImsServiceController = new IImsServiceController.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createImsFeature(int slotId, int feature, IImsFeatureStatusCallback c) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                ImsService.this.onCreateImsFeatureInternal(slotId, feature, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeImsFeature(int slotId, int feature) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                ImsService.this.onRemoveImsFeatureInternal(slotId, feature);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startSession(int slotId, int featureType, PendingIntent incomingCallIntent, IImsRegistrationListener listener) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    return feature.startSession(incomingCallIntent, listener);
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endSession(int slotId, int featureType, int sessionId) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    feature.endSession(sessionId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isConnected(int slotId, int featureType, int callSessionType, int callType) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    return feature.isConnected(callSessionType, callType);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isOpened(int slotId, int featureType) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    return feature.isOpened();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getFeatureStatus(int slotId, int featureType) throws RemoteException {
            int status = 0;
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                ImsFeature feature;
                SparseArray featureMap = (SparseArray)ImsService.this.mFeatures.get(slotId);
                if (featureMap != null && (feature = ImsService.this.getImsFeatureFromType(featureMap, featureType)) != null) {
                    status = feature.getFeatureState();
                }
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRegistrationListener(int slotId, int featureType, IImsRegistrationListener listener) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    feature.addRegistrationListener(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRegistrationListener(int slotId, int featureType, IImsRegistrationListener listener) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    feature.removeRegistrationListener(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImsCallProfile createCallProfile(int slotId, int featureType, int sessionId, int callSessionType, int callType) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    return feature.createCallProfile(sessionId, callSessionType, callType);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImsCallSession createCallSession(int slotId, int featureType, int sessionId, ImsCallProfile profile, IImsCallSessionListener listener) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    return feature.createCallSession(sessionId, profile, listener);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImsCallSession getPendingCallSession(int slotId, int featureType, int sessionId, String callId) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    return feature.getPendingCallSession(sessionId, callId);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImsUt getUtInterface(int slotId, int featureType) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    return feature.getUtInterface();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImsConfig getConfigInterface(int slotId, int featureType) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    return feature.getConfigInterface();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void turnOnIms(int slotId, int featureType) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    feature.turnOnIms();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void turnOffIms(int slotId, int featureType) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    feature.turnOffIms();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImsEcbm getEcbmInterface(int slotId, int featureType) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    return feature.getEcbmInterface();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUiTTYMode(int slotId, int featureType, int uiTtyMode, Message onComplete) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    feature.setUiTTYMode(uiTtyMode, onComplete);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImsMultiEndpoint getMultiEndpointInterface(int slotId, int featureType) throws RemoteException {
            SparseArray sparseArray = ImsService.this.mFeatures;
            synchronized (sparseArray) {
                MMTelFeature feature = ImsService.this.resolveMMTelFeature(slotId, featureType);
                if (feature != null) {
                    return feature.getMultiEndpointInterface();
                }
            }
            return null;
        }
    };

    @Override
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mImsServiceController;
        }
        return null;
    }

    private void onCreateImsFeatureInternal(int slotId, int featureType, IImsFeatureStatusCallback c) {
        ImsFeature f;
        SparseArray<ImsFeature> featureMap = this.mFeatures.get(slotId);
        if (featureMap == null) {
            featureMap = new SparseArray();
            this.mFeatures.put(slotId, featureMap);
        }
        if ((f = this.makeImsFeature(slotId, featureType)) != null) {
            f.setImsFeatureStatusCallback(c);
            featureMap.put(featureType, f);
        }
    }

    private void onRemoveImsFeatureInternal(int slotId, int featureType) {
        SparseArray<ImsFeature> featureMap = this.mFeatures.get(slotId);
        if (featureMap == null) {
            return;
        }
        ImsFeature featureToRemove = this.getImsFeatureFromType(featureMap, featureType);
        if (featureToRemove != null) {
            featureMap.remove(featureType);
            featureToRemove.notifyFeatureRemoved(slotId);
            featureToRemove.setImsFeatureStatusCallback(null);
        }
    }

    private MMTelFeature resolveMMTelFeature(int slotId, int featureType) {
        SparseArray<ImsFeature> features = this.getImsFeatureMap(slotId);
        MMTelFeature feature = null;
        if (features != null) {
            feature = this.resolveImsFeature(features, featureType, MMTelFeature.class);
        }
        return feature;
    }

    private <T extends ImsFeature> T resolveImsFeature(SparseArray<ImsFeature> set, int featureType, Class<T> className) {
        ImsFeature feature = this.getImsFeatureFromType(set, featureType);
        if (feature == null) {
            return null;
        }
        try {
            return (T)((ImsFeature)className.cast(feature));
        }
        catch (ClassCastException e) {
            Log.e(LOG_TAG, "Can not cast ImsFeature! Exception: " + e.getMessage());
            return null;
        }
    }

    public SparseArray<ImsFeature> getImsFeatureMap(int slotId) {
        return this.mFeatures.get(slotId);
    }

    public ImsFeature getImsFeatureFromType(SparseArray<ImsFeature> set, int featureType) {
        return set.get(featureType);
    }

    private ImsFeature makeImsFeature(int slotId, int feature) {
        switch (feature) {
            case 0: {
                return this.onCreateEmergencyMMTelImsFeature(slotId);
            }
            case 1: {
                return this.onCreateMMTelImsFeature(slotId);
            }
            case 2: {
                return this.onCreateRcsFeature(slotId);
            }
        }
        return null;
    }

    public abstract MMTelFeature onCreateEmergencyMMTelImsFeature(int var1);

    public abstract MMTelFeature onCreateMMTelImsFeature(int var1);

    public abstract RcsFeature onCreateRcsFeature(int var1);
}

