/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.annotation.IntDef;
import android.os.RemoteException;
import android.telephony.ims.feature.ImsFeature$$Lambda$33;
import android.util.Log;
import com.android.ims.internal.IImsFeatureStatusCallback;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public abstract class ImsFeature {
    private static final String LOG_TAG = "ImsFeature";
    public static final int INVALID = -1;
    public static final int EMERGENCY_MMTEL = 0;
    public static final int MMTEL = 1;
    public static final int RCS = 2;
    public static final int MAX = 3;
    public static final int STATE_NOT_AVAILABLE = 0;
    public static final int STATE_INITIALIZING = 1;
    public static final int STATE_READY = 2;
    private List<INotifyFeatureRemoved> mRemovedListeners = new ArrayList<INotifyFeatureRemoved>();
    private IImsFeatureStatusCallback mStatusCallback;
    private int mState = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatureRemovedListener(INotifyFeatureRemoved listener) {
        List<INotifyFeatureRemoved> list = this.mRemovedListeners;
        synchronized (list) {
            this.mRemovedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatureRemovedListener(INotifyFeatureRemoved listener) {
        List<INotifyFeatureRemoved> list = this.mRemovedListeners;
        synchronized (list) {
            this.mRemovedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFeatureRemoved(int slotId) {
        List<INotifyFeatureRemoved> list = this.mRemovedListeners;
        synchronized (list) {
            this.mRemovedListeners.forEach(ImsFeature$$Lambda$33.get$Lambda(slotId));
            this.onFeatureRemoved();
        }
    }

    public int getFeatureState() {
        return this.mState;
    }

    protected final void setFeatureState(int state) {
        if (this.mState != state) {
            this.mState = state;
            this.notifyFeatureState(state);
        }
    }

    public void setImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        this.mStatusCallback = c;
        this.notifyFeatureState(this.mState);
    }

    private void notifyFeatureState(int state) {
        if (this.mStatusCallback != null) {
            try {
                Log.i(LOG_TAG, "notifying ImsFeatureState");
                this.mStatusCallback.notifyImsFeatureStatus(state);
            }
            catch (RemoteException e) {
                this.mStatusCallback = null;
                Log.w(LOG_TAG, "Couldn't notify feature state: " + e.getMessage());
            }
        }
    }

    public abstract void onFeatureRemoved();

    static final /* synthetic */ void lambda$notifyFeatureRemoved$69$ImsFeature(int n, INotifyFeatureRemoved l) {
        l.onFeatureRemoved(n);
    }

    public static interface INotifyFeatureRemoved {
        public void onFeatureRemoved(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={0L, 1L, 2L})
    public static @interface ImsState {
    }
}

