/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FontConfig
implements Parcelable {
    private final List<Family> mFamilies = new ArrayList<Family>();
    private final List<Alias> mAliases = new ArrayList<Alias>();
    public static final Parcelable.Creator<FontConfig> CREATOR = new Parcelable.Creator(){

        public FontConfig createFromParcel(Parcel in) {
            return new FontConfig(in);
        }

        public FontConfig[] newArray(int size) {
            return new FontConfig[size];
        }
    };

    public FontConfig() {
    }

    public FontConfig(FontConfig config) {
        for (int i = 0; i < config.mFamilies.size(); ++i) {
            this.mFamilies.add(new Family(config.mFamilies.get(i)));
        }
        this.mAliases.addAll(config.mAliases);
    }

    public List<Family> getFamilies() {
        return this.mFamilies;
    }

    public List<Alias> getAliases() {
        return this.mAliases;
    }

    public FontConfig(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public void writeToParcel(Parcel out, int flag) {
        int i;
        out.writeInt(this.mFamilies.size());
        for (i = 0; i < this.mFamilies.size(); ++i) {
            this.mFamilies.get(i).writeToParcel(out, flag);
        }
        out.writeInt(this.mAliases.size());
        for (i = 0; i < this.mAliases.size(); ++i) {
            this.mAliases.get(i).writeToParcel(out, flag);
        }
    }

    public void readFromParcel(Parcel in) {
        int i;
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            this.mFamilies.add(new Family(in));
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            this.mAliases.add(new Alias(in));
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final class Family
    implements Parcelable {
        private final String mName;
        private final List<Font> mFonts;
        private final String mLanguage;
        private final String mVariant;
        private final String mProviderAuthority;
        private final String mQuery;
        public static final Parcelable.Creator<Family> CREATOR = new Parcelable.Creator<Family>(){

            @Override
            public Family createFromParcel(Parcel in) {
                return new Family(in);
            }

            public Family[] newArray(int size) {
                return new Family[size];
            }
        };

        public Family(String name, List<Font> fonts, String language, String variant) {
            this.mName = name;
            this.mFonts = fonts;
            this.mLanguage = language;
            this.mVariant = variant;
            this.mProviderAuthority = null;
            this.mQuery = null;
        }

        public Family(String providerAuthority, String query) {
            this.mName = null;
            this.mFonts = null;
            this.mLanguage = null;
            this.mVariant = null;
            this.mProviderAuthority = providerAuthority;
            this.mQuery = query;
        }

        public Family(Family origin) {
            this.mName = origin.mName;
            this.mLanguage = origin.mLanguage;
            this.mVariant = origin.mVariant;
            this.mFonts = new ArrayList<Font>();
            for (int i = 0; i < origin.mFonts.size(); ++i) {
                this.mFonts.add(new Font(origin.mFonts.get(i)));
            }
            this.mProviderAuthority = origin.mProviderAuthority;
            this.mQuery = origin.mQuery;
        }

        public String getName() {
            return this.mName;
        }

        public List<Font> getFonts() {
            return this.mFonts;
        }

        public String getLanguage() {
            return this.mLanguage;
        }

        public String getVariant() {
            return this.mVariant;
        }

        public String getProviderAuthority() {
            return this.mProviderAuthority;
        }

        public String getQuery() {
            return this.mQuery;
        }

        public Family(Parcel in) {
            this.mName = in.readString();
            int size = in.readInt();
            this.mFonts = new ArrayList<Font>();
            for (int i = 0; i < size; ++i) {
                this.mFonts.add(new Font(in));
            }
            this.mLanguage = in.readString();
            this.mVariant = in.readString();
            this.mProviderAuthority = in.readInt() == 1 ? in.readString() : null;
            this.mQuery = in.readInt() == 1 ? in.readString() : null;
        }

        @Override
        public void writeToParcel(Parcel out, int flag) {
            out.writeString(this.mName);
            out.writeInt(this.mFonts.size());
            for (int i = 0; i < this.mFonts.size(); ++i) {
                this.mFonts.get(i).writeToParcel(out, flag);
            }
            out.writeString(this.mLanguage);
            out.writeString(this.mVariant);
            out.writeInt(this.mProviderAuthority == null ? 0 : 1);
            if (this.mProviderAuthority != null) {
                out.writeString(this.mProviderAuthority);
            }
            out.writeInt(this.mQuery == null ? 0 : 1);
            if (this.mQuery != null) {
                out.writeString(this.mQuery);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static final class Alias
    implements Parcelable {
        private final String mName;
        private final String mToName;
        private final int mWeight;
        public static final Parcelable.Creator<Alias> CREATOR = new Parcelable.Creator<Alias>(){

            @Override
            public Alias createFromParcel(Parcel in) {
                return new Alias(in);
            }

            public Alias[] newArray(int size) {
                return new Alias[size];
            }
        };

        public Alias(String name, String toName, int weight) {
            this.mName = name;
            this.mToName = toName;
            this.mWeight = weight;
        }

        public String getName() {
            return this.mName;
        }

        public String getToName() {
            return this.mToName;
        }

        public int getWeight() {
            return this.mWeight;
        }

        public Alias(Parcel in) {
            this.mName = in.readString();
            this.mToName = in.readString();
            this.mWeight = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel out, int flag) {
            out.writeString(this.mName);
            out.writeString(this.mToName);
            out.writeInt(this.mWeight);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static final class Font
    implements Parcelable {
        private String mFontName;
        private final int mTtcIndex;
        private final List<Axis> mAxes;
        private final int mWeight;
        private final boolean mIsItalic;
        private ParcelFileDescriptor mFd;
        private final int mResourceId;
        public static final Parcelable.Creator<Font> CREATOR = new Parcelable.Creator<Font>(){

            @Override
            public Font createFromParcel(Parcel in) {
                return new Font(in);
            }

            public Font[] newArray(int size) {
                return new Font[size];
            }
        };

        public Font(String fontName, int ttcIndex, List<Axis> axes, int weight, boolean isItalic, int resourceId) {
            this.mFontName = fontName;
            this.mTtcIndex = ttcIndex;
            this.mAxes = axes;
            this.mWeight = weight;
            this.mIsItalic = isItalic;
            this.mFd = null;
            this.mResourceId = resourceId;
        }

        public Font(String fontName, int ttcIndex, List<Axis> axes, int weight, boolean isItalic) {
            this(fontName, ttcIndex, axes, weight, isItalic, 0);
        }

        public Font(Font origin) {
            this.mFontName = origin.mFontName;
            this.mTtcIndex = origin.mTtcIndex;
            this.mAxes = new ArrayList<Axis>(origin.mAxes);
            this.mWeight = origin.mWeight;
            this.mIsItalic = origin.mIsItalic;
            if (origin.mFd != null) {
                try {
                    this.mFd = origin.mFd.dup();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.mResourceId = origin.mResourceId;
        }

        public String getFontName() {
            return this.mFontName;
        }

        public void setFontName(String fontName) {
            this.mFontName = fontName;
        }

        public int getTtcIndex() {
            return this.mTtcIndex;
        }

        public List<Axis> getAxes() {
            return this.mAxes;
        }

        public int getWeight() {
            return this.mWeight;
        }

        public boolean isItalic() {
            return this.mIsItalic;
        }

        public ParcelFileDescriptor getFd() {
            return this.mFd;
        }

        public void setFd(ParcelFileDescriptor fd) {
            this.mFd = fd;
        }

        public int getResourceId() {
            return this.mResourceId;
        }

        public Font(Parcel in) {
            this.mFontName = in.readString();
            this.mTtcIndex = in.readInt();
            int numAxes = in.readInt();
            this.mAxes = new ArrayList<Axis>();
            for (int i = 0; i < numAxes; ++i) {
                this.mAxes.add(new Axis(in));
            }
            this.mWeight = in.readInt();
            this.mIsItalic = in.readInt() == 1;
            this.mFd = in.readInt() == 1 ? ParcelFileDescriptor.CREATOR.createFromParcel(in) : null;
            this.mResourceId = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel out, int flag) {
            out.writeString(this.mFontName);
            out.writeInt(this.mTtcIndex);
            out.writeInt(this.mAxes.size());
            for (int i = 0; i < this.mAxes.size(); ++i) {
                this.mAxes.get(i).writeToParcel(out, flag);
            }
            out.writeInt(this.mWeight);
            out.writeInt(this.mIsItalic ? 1 : 0);
            out.writeInt(this.mFd == null ? 0 : 1);
            if (this.mFd != null) {
                this.mFd.writeToParcel(out, flag);
            }
            out.writeInt(this.mResourceId);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static final class Axis
    implements Parcelable {
        private final int mTag;
        private final float mStyleValue;
        public static final Parcelable.Creator<Axis> CREATOR = new Parcelable.Creator<Axis>(){

            @Override
            public Axis createFromParcel(Parcel in) {
                return new Axis(in);
            }

            public Axis[] newArray(int size) {
                return new Axis[size];
            }
        };

        public Axis(int tag, float styleValue) {
            this.mTag = tag;
            this.mStyleValue = styleValue;
        }

        public int getTag() {
            return this.mTag;
        }

        public float getStyleValue() {
            return this.mStyleValue;
        }

        public Axis(Parcel in) {
            this.mTag = in.readInt();
            this.mStyleValue = in.readFloat();
        }

        @Override
        public void writeToParcel(Parcel out, int flag) {
            out.writeInt(this.mTag);
            out.writeFloat(this.mStyleValue);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }
}

