/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.method.NumberKeyListener;
import com.android.internal.annotations.GuardedBy;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;

public class TimeKeyListener
extends NumberKeyListener {
    private static final String SYMBOLS_TO_IGNORE = "ahHKkms";
    private static final String SKELETON_12HOUR = "hms";
    private static final String SKELETON_24HOUR = "Hms";
    public static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'm', 'p', ':'};
    private final char[] mCharacters;
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static final HashMap<Locale, TimeKeyListener> sInstanceCache = new HashMap();

    @Override
    public int getInputType() {
        return 36;
    }

    @Override
    protected char[] getAcceptedChars() {
        return this.mCharacters;
    }

    @Deprecated
    public TimeKeyListener() {
        this(null);
    }

    public TimeKeyListener(Locale locale) {
        LinkedHashSet<Character> chars = new LinkedHashSet<Character>();
        boolean success = NumberKeyListener.addDigits(chars, locale) && NumberKeyListener.addAmPmChars(chars, locale) && NumberKeyListener.addFormatCharsFromSkeleton(chars, locale, SKELETON_12HOUR, SYMBOLS_TO_IGNORE) && NumberKeyListener.addFormatCharsFromSkeleton(chars, locale, SKELETON_24HOUR, SYMBOLS_TO_IGNORE);
        this.mCharacters = success ? NumberKeyListener.collectionToArray(chars) : CHARACTERS;
    }

    @Deprecated
    public static TimeKeyListener getInstance() {
        return TimeKeyListener.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeKeyListener getInstance(Locale locale) {
        TimeKeyListener instance;
        Object object = sLock;
        synchronized (object) {
            instance = sInstanceCache.get(locale);
            if (instance == null) {
                instance = new TimeKeyListener(locale);
                sInstanceCache.put(locale, instance);
            }
        }
        return instance;
    }
}

