/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Path;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.view.View;

class TranslationAnimationCreator {
    TranslationAnimationCreator() {
    }

    static Animator createAnimation(View view, TransitionValues values, int viewPosX, int viewPosY, float startX, float startY, float endX, float endY, TimeInterpolator interpolator2, Transition transition2) {
        float terminalX = view.getTranslationX();
        float terminalY = view.getTranslationY();
        int[] startPosition = (int[])values.view.getTag(16909375);
        if (startPosition != null) {
            startX = (float)(startPosition[0] - viewPosX) + terminalX;
            startY = (float)(startPosition[1] - viewPosY) + terminalY;
        }
        int startPosX = viewPosX + Math.round(startX - terminalX);
        int startPosY = viewPosY + Math.round(startY - terminalY);
        view.setTranslationX(startX);
        view.setTranslationY(startY);
        if (startX == endX && startY == endY) {
            return null;
        }
        Path path = new Path();
        path.moveTo(startX, startY);
        path.lineTo(endX, endY);
        ObjectAnimator anim2 = ObjectAnimator.ofFloat(view, View.TRANSLATION_X, View.TRANSLATION_Y, path);
        TransitionPositionListener listener = new TransitionPositionListener(view, values.view, startPosX, startPosY, terminalX, terminalY);
        transition2.addListener(listener);
        anim2.addListener(listener);
        anim2.addPauseListener(listener);
        anim2.setInterpolator(interpolator2);
        return anim2;
    }

    private static class TransitionPositionListener
    extends AnimatorListenerAdapter
    implements Transition.TransitionListener {
        private final View mViewInHierarchy;
        private final View mMovingView;
        private final int mStartX;
        private final int mStartY;
        private int[] mTransitionPosition;
        private float mPausedX;
        private float mPausedY;
        private final float mTerminalX;
        private final float mTerminalY;

        private TransitionPositionListener(View movingView, View viewInHierarchy, int startX, int startY, float terminalX, float terminalY) {
            this.mMovingView = movingView;
            this.mViewInHierarchy = viewInHierarchy;
            this.mStartX = startX - Math.round(this.mMovingView.getTranslationX());
            this.mStartY = startY - Math.round(this.mMovingView.getTranslationY());
            this.mTerminalX = terminalX;
            this.mTerminalY = terminalY;
            this.mTransitionPosition = (int[])this.mViewInHierarchy.getTag(16909375);
            if (this.mTransitionPosition != null) {
                this.mViewInHierarchy.setTagInternal(16909375, null);
            }
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            if (this.mTransitionPosition == null) {
                this.mTransitionPosition = new int[2];
            }
            this.mTransitionPosition[0] = Math.round((float)this.mStartX + this.mMovingView.getTranslationX());
            this.mTransitionPosition[1] = Math.round((float)this.mStartY + this.mMovingView.getTranslationY());
            this.mViewInHierarchy.setTagInternal(16909375, this.mTransitionPosition);
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
        }

        @Override
        public void onAnimationPause(Animator animator2) {
            this.mPausedX = this.mMovingView.getTranslationX();
            this.mPausedY = this.mMovingView.getTranslationY();
            this.mMovingView.setTranslationX(this.mTerminalX);
            this.mMovingView.setTranslationY(this.mTerminalY);
        }

        @Override
        public void onAnimationResume(Animator animator2) {
            this.mMovingView.setTranslationX(this.mPausedX);
            this.mMovingView.setTranslationY(this.mPausedY);
        }

        @Override
        public void onTransitionStart(Transition transition2) {
        }

        @Override
        public void onTransitionEnd(Transition transition2) {
            this.mMovingView.setTranslationX(this.mTerminalX);
            this.mMovingView.setTranslationY(this.mTerminalY);
            transition2.removeListener(this);
        }

        @Override
        public void onTransitionCancel(Transition transition2) {
        }

        @Override
        public void onTransitionPause(Transition transition2) {
        }

        @Override
        public void onTransitionResume(Transition transition2) {
        }
    }
}

