/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.ByteStringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class PackageUtils {
    private PackageUtils() {
    }

    public static String computePackageCertSha256Digest(PackageManager packageManager, String packageName, int userId) {
        PackageInfo packageInfo;
        try {
            packageInfo = packageManager.getPackageInfoAsUser(packageName, 64, userId);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        return PackageUtils.computeCertSha256Digest(packageInfo.signatures[0]);
    }

    public static String computeCertSha256Digest(Signature signature) {
        return PackageUtils.computeSha256Digest(signature.toByteArray());
    }

    public static String computeSha256Digest(byte[] data) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        messageDigest.update(data);
        return ByteStringUtils.toHexString(messageDigest.digest());
    }
}

