/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.view.ViewRootImpl;
import java.text.BreakIterator;
import java.util.Locale;

public final class AccessibilityIterators {

    static class ParagraphTextSegmentIterator
    extends AbstractTextSegmentIterator {
        private static ParagraphTextSegmentIterator sInstance;

        ParagraphTextSegmentIterator() {
        }

        public static ParagraphTextSegmentIterator getInstance() {
            if (sInstance == null) {
                sInstance = new ParagraphTextSegmentIterator();
            }
            return sInstance;
        }

        @Override
        public int[] following(int offset) {
            int end;
            int textLength = this.mText.length();
            if (textLength <= 0) {
                return null;
            }
            if (offset >= textLength) {
                return null;
            }
            int start = offset;
            if (start < 0) {
                start = 0;
            }
            while (start < textLength && this.mText.charAt(start) == '\n' && !this.isStartBoundary(start)) {
                ++start;
            }
            if (start >= textLength) {
                return null;
            }
            for (end = start + 1; end < textLength && !this.isEndBoundary(end); ++end) {
            }
            return this.getRange(start, end);
        }

        @Override
        public int[] preceding(int offset) {
            int start;
            int textLength = this.mText.length();
            if (textLength <= 0) {
                return null;
            }
            if (offset <= 0) {
                return null;
            }
            int end = offset;
            if (end > textLength) {
                end = textLength;
            }
            while (end > 0 && this.mText.charAt(end - 1) == '\n' && !this.isEndBoundary(end)) {
                --end;
            }
            if (end <= 0) {
                return null;
            }
            for (start = end - 1; start > 0 && !this.isStartBoundary(start); --start) {
            }
            return this.getRange(start, end);
        }

        private boolean isStartBoundary(int index) {
            return this.mText.charAt(index) != '\n' && (index == 0 || this.mText.charAt(index - 1) == '\n');
        }

        private boolean isEndBoundary(int index) {
            return index > 0 && this.mText.charAt(index - 1) != '\n' && (index == this.mText.length() || this.mText.charAt(index) == '\n');
        }
    }

    static class WordTextSegmentIterator
    extends CharacterTextSegmentIterator {
        private static WordTextSegmentIterator sInstance;

        public static WordTextSegmentIterator getInstance(Locale locale) {
            if (sInstance == null) {
                sInstance = new WordTextSegmentIterator(locale);
            }
            return sInstance;
        }

        private WordTextSegmentIterator(Locale locale) {
            super(locale);
        }

        @Override
        protected void onLocaleChanged(Locale locale) {
            this.mImpl = BreakIterator.getWordInstance(locale);
        }

        @Override
        public int[] following(int offset) {
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset >= this.mText.length()) {
                return null;
            }
            int start = offset;
            if (start < 0) {
                start = 0;
            }
            while (!this.isLetterOrDigit(start) && !this.isStartBoundary(start)) {
                if ((start = this.mImpl.following(start)) != -1) continue;
                return null;
            }
            int end = this.mImpl.following(start);
            if (end == -1 || !this.isEndBoundary(end)) {
                return null;
            }
            return this.getRange(start, end);
        }

        @Override
        public int[] preceding(int offset) {
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset <= 0) {
                return null;
            }
            int end = offset;
            if (end > textLegth) {
                end = textLegth;
            }
            while (end > 0 && !this.isLetterOrDigit(end - 1) && !this.isEndBoundary(end)) {
                if ((end = this.mImpl.preceding(end)) != -1) continue;
                return null;
            }
            int start = this.mImpl.preceding(end);
            if (start == -1 || !this.isStartBoundary(start)) {
                return null;
            }
            return this.getRange(start, end);
        }

        private boolean isStartBoundary(int index) {
            return this.isLetterOrDigit(index) && (index == 0 || !this.isLetterOrDigit(index - 1));
        }

        private boolean isEndBoundary(int index) {
            return index > 0 && this.isLetterOrDigit(index - 1) && (index == this.mText.length() || !this.isLetterOrDigit(index));
        }

        private boolean isLetterOrDigit(int index) {
            if (index >= 0 && index < this.mText.length()) {
                int codePoint = this.mText.codePointAt(index);
                return Character.isLetterOrDigit(codePoint);
            }
            return false;
        }
    }

    static class CharacterTextSegmentIterator
    extends AbstractTextSegmentIterator
    implements ComponentCallbacks {
        private static CharacterTextSegmentIterator sInstance;
        private Locale mLocale;
        protected BreakIterator mImpl;

        public static CharacterTextSegmentIterator getInstance(Locale locale) {
            if (sInstance == null) {
                sInstance = new CharacterTextSegmentIterator(locale);
            }
            return sInstance;
        }

        private CharacterTextSegmentIterator(Locale locale) {
            this.mLocale = locale;
            this.onLocaleChanged(locale);
            ViewRootImpl.addConfigCallback(this);
        }

        @Override
        public void initialize(String text) {
            super.initialize(text);
            this.mImpl.setText(text);
        }

        @Override
        public int[] following(int offset) {
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset >= textLegth) {
                return null;
            }
            int start = offset;
            if (start < 0) {
                start = 0;
            }
            while (!this.mImpl.isBoundary(start)) {
                if ((start = this.mImpl.following(start)) != -1) continue;
                return null;
            }
            int end = this.mImpl.following(start);
            if (end == -1) {
                return null;
            }
            return this.getRange(start, end);
        }

        @Override
        public int[] preceding(int offset) {
            int textLegth = this.mText.length();
            if (textLegth <= 0) {
                return null;
            }
            if (offset <= 0) {
                return null;
            }
            int end = offset;
            if (end > textLegth) {
                end = textLegth;
            }
            while (!this.mImpl.isBoundary(end)) {
                if ((end = this.mImpl.preceding(end)) != -1) continue;
                return null;
            }
            int start = this.mImpl.preceding(end);
            if (start == -1) {
                return null;
            }
            return this.getRange(start, end);
        }

        @Override
        public void onConfigurationChanged(Configuration newConfig) {
            Locale locale = newConfig.locale;
            if (!this.mLocale.equals(locale)) {
                this.mLocale = locale;
                this.onLocaleChanged(locale);
            }
        }

        @Override
        public void onLowMemory() {
        }

        protected void onLocaleChanged(Locale locale) {
            this.mImpl = BreakIterator.getCharacterInstance(locale);
        }
    }

    public static abstract class AbstractTextSegmentIterator
    implements TextSegmentIterator {
        protected String mText;
        private final int[] mSegment = new int[2];

        public void initialize(String text) {
            this.mText = text;
        }

        protected int[] getRange(int start, int end) {
            if (start < 0 || end < 0 || start == end) {
                return null;
            }
            this.mSegment[0] = start;
            this.mSegment[1] = end;
            return this.mSegment;
        }
    }

    public static interface TextSegmentIterator {
        public int[] following(int var1);

        public int[] preceding(int var1);
    }
}

