/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.IntDef;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Trace;
import android.util.Log;
import android.view.Choreographer;
import android.view.DisplayListCanvas;
import android.view.FrameMetricsObserver;
import android.view.HardwareLayer;
import android.view.IGraphicsStats;
import android.view.IGraphicsStatsCallback;
import android.view.RenderNode;
import android.view.Surface;
import android.view.View;
import com.android.internal.R;
import com.android.internal.util.VirtualRefBasePtr;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ThreadedRenderer {
    private static final String LOG_TAG = "ThreadedRenderer";
    private static final String CACHE_PATH_SHADERS = "com.android.opengl.shaders_cache";
    public static final String PROFILE_PROPERTY = "debug.hwui.profile";
    public static final String PROFILE_PROPERTY_VISUALIZE_BARS = "visual_bars";
    static final String PROFILE_MAXFRAMES_PROPERTY = "debug.hwui.profile.maxframes";
    static final String PRINT_CONFIG_PROPERTY = "debug.hwui.print_config";
    public static final String DEBUG_DIRTY_REGIONS_PROPERTY = "debug.hwui.show_dirty_regions";
    public static final String DEBUG_SHOW_LAYERS_UPDATES_PROPERTY = "debug.hwui.show_layers_updates";
    public static final String DEBUG_OVERDRAW_PROPERTY = "debug.hwui.overdraw";
    public static final String OVERDRAW_PROPERTY_SHOW = "show";
    public static final String DEBUG_RENDERER_PROPERTY = "debug.hwui.renderer";
    public static final String DEBUG_SHOW_NON_RECTANGULAR_CLIP_PROPERTY = "debug.hwui.show_non_rect_clip";
    public static boolean sRendererDisabled = false;
    public static boolean sSystemRendererDisabled = false;
    public static boolean sTrimForeground = false;
    private static boolean sSupportsOpenGL = ThreadedRenderer.nSupportsOpenGL();
    private static final int SYNC_OK = 0;
    private static final int SYNC_INVALIDATE_REQUIRED = 1;
    private static final int SYNC_LOST_SURFACE_REWARD_IF_FOUND = 2;
    private static final int SYNC_CONTEXT_IS_STOPPED = 4;
    private static final String[] VISUALIZERS = new String[]{"visual_bars"};
    private static final int FLAG_DUMP_FRAMESTATS = 1;
    private static final int FLAG_DUMP_RESET = 2;
    private int mWidth;
    private int mHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mInsetTop;
    private int mInsetLeft;
    private boolean mHasInsets;
    private final float mLightY;
    private final float mLightZ;
    private final float mLightRadius;
    private final int mAmbientShadowAlpha;
    private final int mSpotShadowAlpha;
    private long mNativeProxy;
    private boolean mInitialized = false;
    private RenderNode mRootNode;
    private Choreographer mChoreographer;
    private boolean mRootNodeNeedsUpdate;
    private boolean mEnabled;
    private boolean mRequested = true;

    public static void disable(boolean system) {
        sRendererDisabled = true;
        if (system) {
            sSystemRendererDisabled = true;
        }
    }

    public static void enableForegroundTrimming() {
        sTrimForeground = true;
    }

    private static native boolean nSupportsOpenGL();

    public static boolean isAvailable() {
        return sSupportsOpenGL;
    }

    public static void setupDiskCache(File cacheDir) {
        ThreadedRenderer.setupShadersDiskCache(new File(cacheDir, CACHE_PATH_SHADERS).getAbsolutePath());
    }

    public static ThreadedRenderer create(Context context, boolean translucent, String name) {
        ThreadedRenderer renderer = null;
        if (ThreadedRenderer.isAvailable()) {
            renderer = new ThreadedRenderer(context, translucent, name);
        }
        return renderer;
    }

    public static void trimMemory(int level) {
        ThreadedRenderer.nTrimMemory(level);
    }

    public static void overrideProperty(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name and value must be non-null");
        }
        ThreadedRenderer.nOverrideProperty(name, value);
    }

    ThreadedRenderer(Context context, boolean translucent, String name) {
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
        this.mLightY = a.getDimension(3, 0.0f);
        this.mLightZ = a.getDimension(4, 0.0f);
        this.mLightRadius = a.getDimension(2, 0.0f);
        this.mAmbientShadowAlpha = (int)(255.0f * a.getFloat(0, 0.0f) + 0.5f);
        this.mSpotShadowAlpha = (int)(255.0f * a.getFloat(1, 0.0f) + 0.5f);
        a.recycle();
        long rootNodePtr = ThreadedRenderer.nCreateRootRenderNode();
        this.mRootNode = RenderNode.adopt(rootNodePtr);
        this.mRootNode.setClipToBounds(false);
        this.mNativeProxy = ThreadedRenderer.nCreateProxy(translucent, rootNodePtr);
        ThreadedRenderer.nSetName(this.mNativeProxy, name);
        ProcessInitializer.sInstance.init(context, this.mNativeProxy);
        this.loadSystemProperties();
    }

    void destroy() {
        this.mInitialized = false;
        this.updateEnabledState(null);
        ThreadedRenderer.nDestroy(this.mNativeProxy, this.mRootNode.mNativeRenderNode);
    }

    boolean isEnabled() {
        return this.mEnabled;
    }

    void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    boolean isRequested() {
        return this.mRequested;
    }

    void setRequested(boolean requested) {
        this.mRequested = requested;
    }

    private void updateEnabledState(Surface surface) {
        if (surface == null || !surface.isValid()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.mInitialized);
        }
    }

    boolean initialize(Surface surface) throws Surface.OutOfResourcesException {
        boolean status = !this.mInitialized;
        this.mInitialized = true;
        this.updateEnabledState(surface);
        ThreadedRenderer.nInitialize(this.mNativeProxy, surface);
        return status;
    }

    boolean initializeIfNeeded(int width, int height, View.AttachInfo attachInfo, Surface surface, Rect surfaceInsets) throws Surface.OutOfResourcesException {
        if (this.isRequested() && !this.isEnabled() && this.initialize(surface)) {
            this.setup(width, height, attachInfo, surfaceInsets);
            return true;
        }
        return false;
    }

    void updateSurface(Surface surface) throws Surface.OutOfResourcesException {
        this.updateEnabledState(surface);
        ThreadedRenderer.nUpdateSurface(this.mNativeProxy, surface);
    }

    boolean pauseSurface(Surface surface) {
        return ThreadedRenderer.nPauseSurface(this.mNativeProxy, surface);
    }

    void setStopped(boolean stopped) {
        ThreadedRenderer.nSetStopped(this.mNativeProxy, stopped);
    }

    void destroyHardwareResources(View view) {
        ThreadedRenderer.destroyResources(view);
        ThreadedRenderer.nDestroyHardwareResources(this.mNativeProxy);
    }

    private static void destroyResources(View view) {
        view.destroyHardwareResources();
    }

    void detachSurfaceTexture(long hardwareLayer) {
        ThreadedRenderer.nDetachSurfaceTexture(this.mNativeProxy, hardwareLayer);
    }

    void setup(int width, int height, View.AttachInfo attachInfo, Rect surfaceInsets) {
        this.mWidth = width;
        this.mHeight = height;
        if (surfaceInsets != null && (surfaceInsets.left != 0 || surfaceInsets.right != 0 || surfaceInsets.top != 0 || surfaceInsets.bottom != 0)) {
            this.mHasInsets = true;
            this.mInsetLeft = surfaceInsets.left;
            this.mInsetTop = surfaceInsets.top;
            this.mSurfaceWidth = width + this.mInsetLeft + surfaceInsets.right;
            this.mSurfaceHeight = height + this.mInsetTop + surfaceInsets.bottom;
            this.setOpaque(false);
        } else {
            this.mHasInsets = false;
            this.mInsetLeft = 0;
            this.mInsetTop = 0;
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
        }
        this.mRootNode.setLeftTopRightBottom(-this.mInsetLeft, -this.mInsetTop, this.mSurfaceWidth, this.mSurfaceHeight);
        ThreadedRenderer.nSetup(this.mNativeProxy, this.mLightRadius, this.mAmbientShadowAlpha, this.mSpotShadowAlpha);
        this.setLightCenter(attachInfo);
    }

    void setLightCenter(View.AttachInfo attachInfo) {
        Point displaySize = attachInfo.mPoint;
        attachInfo.mDisplay.getRealSize(displaySize);
        float lightX = (float)displaySize.x / 2.0f - (float)attachInfo.mWindowLeft;
        float lightY = this.mLightY - (float)attachInfo.mWindowTop;
        ThreadedRenderer.nSetLightCenter(this.mNativeProxy, lightX, lightY, this.mLightZ);
    }

    void setOpaque(boolean opaque) {
        ThreadedRenderer.nSetOpaque(this.mNativeProxy, opaque && !this.mHasInsets);
    }

    int getWidth() {
        return this.mWidth;
    }

    int getHeight() {
        return this.mHeight;
    }

    void dumpGfxInfo(PrintWriter pw, FileDescriptor fd, String[] args) {
        pw.flush();
        int flags = 0;
        block8: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "framestats": {
                    flags |= 1;
                    continue block8;
                }
                case "reset": {
                    flags |= 2;
                }
            }
        }
        ThreadedRenderer.nDumpProfileInfo(this.mNativeProxy, fd, flags);
    }

    boolean loadSystemProperties() {
        boolean changed = ThreadedRenderer.nLoadSystemProperties(this.mNativeProxy);
        if (changed) {
            this.invalidateRoot();
        }
        return changed;
    }

    private void updateViewTreeDisplayList(View view) {
        view.mPrivateFlags |= 0x20;
        view.mRecreateDisplayList = (view.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        view.mPrivateFlags &= Integer.MAX_VALUE;
        view.updateDisplayListIfDirty();
        view.mRecreateDisplayList = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRootDisplayList(View view, DrawCallbacks callbacks) {
        Trace.traceBegin(8L, "Record View#draw()");
        this.updateViewTreeDisplayList(view);
        if (this.mRootNodeNeedsUpdate || !this.mRootNode.isValid()) {
            DisplayListCanvas canvas = this.mRootNode.start(this.mSurfaceWidth, this.mSurfaceHeight);
            try {
                int saveCount = canvas.save();
                canvas.translate(this.mInsetLeft, this.mInsetTop);
                callbacks.onPreDraw(canvas);
                canvas.insertReorderBarrier();
                canvas.drawRenderNode(view.updateDisplayListIfDirty());
                canvas.insertInorderBarrier();
                callbacks.onPostDraw(canvas);
                canvas.restoreToCount(saveCount);
                this.mRootNodeNeedsUpdate = false;
            }
            finally {
                this.mRootNode.end(canvas);
            }
        }
        Trace.traceEnd(8L);
    }

    public void addRenderNode(RenderNode node, boolean placeFront) {
        ThreadedRenderer.nAddRenderNode(this.mNativeProxy, node.mNativeRenderNode, placeFront);
    }

    public void removeRenderNode(RenderNode node) {
        ThreadedRenderer.nRemoveRenderNode(this.mNativeProxy, node.mNativeRenderNode);
    }

    public void drawRenderNode(RenderNode node) {
        ThreadedRenderer.nDrawRenderNode(this.mNativeProxy, node.mNativeRenderNode);
    }

    public void setContentDrawBounds(int left, int top, int right, int bottom) {
        ThreadedRenderer.nSetContentDrawBounds(this.mNativeProxy, left, top, right, bottom);
    }

    void invalidateRoot() {
        this.mRootNodeNeedsUpdate = true;
    }

    void draw(View view, View.AttachInfo attachInfo, DrawCallbacks callbacks) {
        long[] frameInfo;
        int syncResult;
        attachInfo.mIgnoreDirtyState = true;
        Choreographer choreographer = attachInfo.mViewRootImpl.mChoreographer;
        choreographer.mFrameInfo.markDrawStart();
        this.updateRootDisplayList(view, callbacks);
        attachInfo.mIgnoreDirtyState = false;
        if (attachInfo.mPendingAnimatingRenderNodes != null) {
            int count = attachInfo.mPendingAnimatingRenderNodes.size();
            for (int i = 0; i < count; ++i) {
                this.registerAnimatingRenderNode(attachInfo.mPendingAnimatingRenderNodes.get(i));
            }
            attachInfo.mPendingAnimatingRenderNodes.clear();
            attachInfo.mPendingAnimatingRenderNodes = null;
        }
        if (((syncResult = ThreadedRenderer.nSyncAndDrawFrame(this.mNativeProxy, frameInfo = choreographer.mFrameInfo.mFrameInfo, frameInfo.length)) & 2) != 0) {
            this.setEnabled(false);
            attachInfo.mViewRootImpl.mSurface.release();
            attachInfo.mViewRootImpl.invalidate();
        }
        if ((syncResult & 1) != 0) {
            attachInfo.mViewRootImpl.invalidate();
        }
    }

    static void invokeFunctor(long functor, boolean waitForCompletion) {
        ThreadedRenderer.nInvokeFunctor(functor, waitForCompletion);
    }

    HardwareLayer createTextureLayer() {
        long layer = ThreadedRenderer.nCreateTextureLayer(this.mNativeProxy);
        return HardwareLayer.adoptTextureLayer(this, layer);
    }

    void buildLayer(RenderNode node) {
        ThreadedRenderer.nBuildLayer(this.mNativeProxy, node.getNativeDisplayList());
    }

    boolean copyLayerInto(HardwareLayer layer, Bitmap bitmap) {
        return ThreadedRenderer.nCopyLayerInto(this.mNativeProxy, layer.getDeferredLayerUpdater(), bitmap);
    }

    void pushLayerUpdate(HardwareLayer layer) {
        ThreadedRenderer.nPushLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    void onLayerDestroyed(HardwareLayer layer) {
        ThreadedRenderer.nCancelLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    void fence() {
        ThreadedRenderer.nFence(this.mNativeProxy);
    }

    void stopDrawing() {
        ThreadedRenderer.nStopDrawing(this.mNativeProxy);
    }

    public void notifyFramePending() {
        ThreadedRenderer.nNotifyFramePending(this.mNativeProxy);
    }

    void registerAnimatingRenderNode(RenderNode animator2) {
        ThreadedRenderer.nRegisterAnimatingRenderNode(this.mRootNode.mNativeRenderNode, animator2.mNativeRenderNode);
    }

    void registerVectorDrawableAnimator(AnimatedVectorDrawable.VectorDrawableAnimatorRT animator2) {
        ThreadedRenderer.nRegisterVectorDrawableAnimator(this.mRootNode.mNativeRenderNode, animator2.getAnimatorNativePtr());
    }

    public void serializeDisplayListTree() {
        ThreadedRenderer.nSerializeDisplayListTree(this.mNativeProxy);
    }

    public static int copySurfaceInto(Surface surface, Rect srcRect, Bitmap bitmap) {
        if (srcRect == null) {
            return ThreadedRenderer.nCopySurfaceInto(surface, 0, 0, 0, 0, bitmap);
        }
        return ThreadedRenderer.nCopySurfaceInto(surface, srcRect.left, srcRect.top, srcRect.right, srcRect.bottom, bitmap);
    }

    protected void finalize() throws Throwable {
        try {
            ThreadedRenderer.nDeleteProxy(this.mNativeProxy);
            this.mNativeProxy = 0L;
        }
        finally {
            super.finalize();
        }
    }

    void addFrameMetricsObserver(FrameMetricsObserver observer) {
        long nativeObserver = ThreadedRenderer.nAddFrameMetricsObserver(this.mNativeProxy, observer);
        observer.mNative = new VirtualRefBasePtr(nativeObserver);
    }

    void removeFrameMetricsObserver(FrameMetricsObserver observer) {
        ThreadedRenderer.nRemoveFrameMetricsObserver(this.mNativeProxy, observer.mNative.get());
        observer.mNative = null;
    }

    static native void setupShadersDiskCache(String var0);

    private static native void nRotateProcessStatsBuffer();

    private static native void nSetProcessStatsBuffer(int var0);

    private static native int nGetRenderThreadTid(long var0);

    private static native long nCreateRootRenderNode();

    private static native long nCreateProxy(boolean var0, long var1);

    private static native void nDeleteProxy(long var0);

    private static native boolean nLoadSystemProperties(long var0);

    private static native void nSetName(long var0, String var2);

    private static native void nInitialize(long var0, Surface var2);

    private static native void nUpdateSurface(long var0, Surface var2);

    private static native boolean nPauseSurface(long var0, Surface var2);

    private static native void nSetStopped(long var0, boolean var2);

    private static native void nSetup(long var0, float var2, int var3, int var4);

    private static native void nSetLightCenter(long var0, float var2, float var3, float var4);

    private static native void nSetOpaque(long var0, boolean var2);

    private static native int nSyncAndDrawFrame(long var0, long[] var2, int var3);

    private static native void nDestroy(long var0, long var2);

    private static native void nRegisterAnimatingRenderNode(long var0, long var2);

    private static native void nRegisterVectorDrawableAnimator(long var0, long var2);

    private static native void nInvokeFunctor(long var0, boolean var2);

    private static native long nCreateTextureLayer(long var0);

    private static native void nBuildLayer(long var0, long var2);

    private static native boolean nCopyLayerInto(long var0, long var2, Bitmap var4);

    private static native void nPushLayerUpdate(long var0, long var2);

    private static native void nCancelLayerUpdate(long var0, long var2);

    private static native void nDetachSurfaceTexture(long var0, long var2);

    private static native void nDestroyHardwareResources(long var0);

    private static native void nTrimMemory(int var0);

    private static native void nOverrideProperty(String var0, String var1);

    private static native void nFence(long var0);

    private static native void nStopDrawing(long var0);

    private static native void nNotifyFramePending(long var0);

    private static native void nSerializeDisplayListTree(long var0);

    private static native void nDumpProfileInfo(long var0, FileDescriptor var2, int var3);

    private static native void nAddRenderNode(long var0, long var2, boolean var4);

    private static native void nRemoveRenderNode(long var0, long var2);

    private static native void nDrawRenderNode(long var0, long var2);

    private static native void nSetContentDrawBounds(long var0, int var2, int var3, int var4, int var5);

    private static native long nAddFrameMetricsObserver(long var0, FrameMetricsObserver var2);

    private static native void nRemoveFrameMetricsObserver(long var0, long var2);

    private static native int nCopySurfaceInto(Surface var0, int var1, int var2, int var3, int var4, Bitmap var5);

    private static class ProcessInitializer {
        static ProcessInitializer sInstance = new ProcessInitializer();
        private boolean mInitialized = false;
        private Context mAppContext;
        private IGraphicsStats mGraphicsStatsService;
        private IGraphicsStatsCallback mGraphicsStatsCallback = new IGraphicsStatsCallback.Stub(){

            @Override
            public void onRotateGraphicsStatsBuffer() throws RemoteException {
                this.rotateBuffer();
            }
        };

        private ProcessInitializer() {
        }

        synchronized void init(Context context, long renderProxy) {
            if (this.mInitialized) {
                return;
            }
            this.mInitialized = true;
            this.mAppContext = context.getApplicationContext();
            this.initSched(context, renderProxy);
            this.initGraphicsStats();
        }

        private void initSched(Context context, long renderProxy) {
            try {
                int tid = ThreadedRenderer.nGetRenderThreadTid(renderProxy);
                ActivityManager.getService().setRenderThread(tid);
            }
            catch (Throwable t) {
                Log.w(ThreadedRenderer.LOG_TAG, "Failed to set scheduler for RenderThread", t);
            }
        }

        private void initGraphicsStats() {
            try {
                IBinder binder = ServiceManager.getService("graphicsstats");
                if (binder == null) {
                    return;
                }
                this.mGraphicsStatsService = IGraphicsStats.Stub.asInterface(binder);
                this.requestBuffer();
            }
            catch (Throwable t) {
                Log.w(ThreadedRenderer.LOG_TAG, "Could not acquire gfx stats buffer", t);
            }
        }

        private void rotateBuffer() {
            ThreadedRenderer.nRotateProcessStatsBuffer();
            this.requestBuffer();
        }

        private void requestBuffer() {
            try {
                String pkg = this.mAppContext.getApplicationInfo().packageName;
                ParcelFileDescriptor pfd = this.mGraphicsStatsService.requestBufferForProcess(pkg, this.mGraphicsStatsCallback);
                ThreadedRenderer.nSetProcessStatsBuffer(pfd.getFd());
                pfd.close();
            }
            catch (Throwable t) {
                Log.w(ThreadedRenderer.LOG_TAG, "Could not acquire gfx stats buffer", t);
            }
        }
    }

    static interface DrawCallbacks {
        public void onPreDraw(DisplayListCanvas var1);

        public void onPostDraw(DisplayListCanvas var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 2L})
    public static @interface DumpFlags {
    }
}

