/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.LayoutTransition;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pools;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.ActionMode;
import android.view.Display;
import android.view.DragEvent;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroupOverlay;
import android.view.ViewHierarchyEncoder;
import android.view.ViewManager;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.ViewStructure;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.view.animation.Transformation;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public abstract class ViewGroup
extends View
implements ViewParent,
ViewManager {
    private static final String TAG = "ViewGroup";
    private static final boolean DBG = false;
    protected ArrayList<View> mDisappearingChildren;
    protected OnHierarchyChangeListener mOnHierarchyChangeListener;
    private View mFocused;
    private View mDefaultFocus;
    private View mFocusedInCluster;
    private Transformation mChildTransformation;
    RectF mInvalidateRegion;
    Transformation mInvalidationTransformation;
    private View mCurrentDragChild;
    private DragEvent mCurrentDragStartEvent;
    private boolean mIsInterestedInDrag;
    private HashSet<View> mChildrenInterestedInDrag;
    private PointF mLocalPoint;
    private float[] mTempPoint;
    private LayoutAnimationController mLayoutAnimationController;
    private Animation.AnimationListener mAnimationListener;
    private TouchTarget mFirstTouchTarget;
    @ViewDebug.ExportedProperty(category="events")
    private long mLastTouchDownTime;
    @ViewDebug.ExportedProperty(category="events")
    private int mLastTouchDownIndex = -1;
    @ViewDebug.ExportedProperty(category="events")
    private float mLastTouchDownX;
    @ViewDebug.ExportedProperty(category="events")
    private float mLastTouchDownY;
    private HoverTarget mFirstHoverTarget;
    private boolean mHoveredSelf;
    private View mTooltipHoverTarget;
    private boolean mTooltipHoveredSelf;
    @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=1, equals=1, name="CLIP_CHILDREN"), @ViewDebug.FlagToString(mask=2, equals=2, name="CLIP_TO_PADDING"), @ViewDebug.FlagToString(mask=32, equals=32, name="PADDING_NOT_NULL")}, formatToHexString=true)
    protected int mGroupFlags;
    private int mLayoutMode = -1;
    static final int FLAG_CLIP_CHILDREN = 1;
    private static final int FLAG_CLIP_TO_PADDING = 2;
    static final int FLAG_INVALIDATE_REQUIRED = 4;
    private static final int FLAG_RUN_ANIMATION = 8;
    static final int FLAG_ANIMATION_DONE = 16;
    private static final int FLAG_PADDING_NOT_NULL = 32;
    @Deprecated
    private static final int FLAG_ANIMATION_CACHE = 64;
    static final int FLAG_OPTIMIZE_INVALIDATE = 128;
    static final int FLAG_CLEAR_TRANSFORMATION = 256;
    private static final int FLAG_NOTIFY_ANIMATION_LISTENER = 512;
    protected static final int FLAG_USE_CHILD_DRAWING_ORDER = 1024;
    protected static final int FLAG_SUPPORT_STATIC_TRANSFORMATIONS = 2048;
    private static final int FLAG_ADD_STATES_FROM_CHILDREN = 8192;
    @Deprecated
    private static final int FLAG_ALWAYS_DRAWN_WITH_CACHE = 16384;
    @Deprecated
    private static final int FLAG_CHILDREN_DRAWN_WITH_CACHE = 32768;
    private static final int FLAG_NOTIFY_CHILDREN_ON_DRAWABLE_STATE_CHANGE = 65536;
    private static final int FLAG_MASK_FOCUSABILITY = 393216;
    public static final int FOCUS_BEFORE_DESCENDANTS = 131072;
    public static final int FOCUS_AFTER_DESCENDANTS = 262144;
    public static final int FOCUS_BLOCK_DESCENDANTS = 393216;
    private static final int[] DESCENDANT_FOCUSABILITY_FLAGS = new int[]{131072, 262144, 393216};
    protected static final int FLAG_DISALLOW_INTERCEPT = 524288;
    private static final int FLAG_SPLIT_MOTION_EVENTS = 0x200000;
    private static final int FLAG_PREVENT_DISPATCH_ATTACHED_TO_WINDOW = 0x400000;
    private static final int FLAG_LAYOUT_MODE_WAS_EXPLICITLY_SET = 0x800000;
    static final int FLAG_IS_TRANSITION_GROUP = 0x1000000;
    static final int FLAG_IS_TRANSITION_GROUP_SET = 0x2000000;
    static final int FLAG_TOUCHSCREEN_BLOCKS_FOCUS = 0x4000000;
    private static final int FLAG_START_ACTION_MODE_FOR_CHILD_IS_TYPED = 0x8000000;
    private static final int FLAG_START_ACTION_MODE_FOR_CHILD_IS_NOT_TYPED = 0x10000000;
    private static final int FLAG_SHOW_CONTEXT_MENU_WITH_COORDS = 0x20000000;
    protected int mPersistentDrawingCache;
    public static final int PERSISTENT_NO_CACHE = 0;
    public static final int PERSISTENT_ANIMATION_CACHE = 1;
    public static final int PERSISTENT_SCROLLING_CACHE = 2;
    public static final int PERSISTENT_ALL_CACHES = 3;
    private static final int LAYOUT_MODE_UNDEFINED = -1;
    public static final int LAYOUT_MODE_CLIP_BOUNDS = 0;
    public static final int LAYOUT_MODE_OPTICAL_BOUNDS = 1;
    public static int LAYOUT_MODE_DEFAULT = 0;
    protected static final int CLIP_TO_PADDING_MASK = 34;
    private static final int CHILD_LEFT_INDEX = 0;
    private static final int CHILD_TOP_INDEX = 1;
    private View[] mChildren;
    private int mChildrenCount;
    boolean mSuppressLayout = false;
    private boolean mLayoutCalledWhileSuppressed = false;
    private static final int ARRAY_INITIAL_CAPACITY = 12;
    private static final int ARRAY_CAPACITY_INCREMENT = 12;
    private static float[] sDebugLines;
    Paint mCachePaint;
    private LayoutTransition mTransition;
    private ArrayList<View> mTransitioningViews;
    private ArrayList<View> mVisibilityChangingChildren;
    private ArrayList<View> mPreSortedChildren;
    @ViewDebug.ExportedProperty(category="layout")
    private int mChildCountWithTransientState = 0;
    private int mNestedScrollAxes;
    private List<Integer> mTransientIndices = null;
    private List<View> mTransientViews = null;
    private static final ActionMode SENTINEL_ACTION_MODE;
    private LayoutTransition.TransitionListener mLayoutTransitionListener = new LayoutTransition.TransitionListener(){

        @Override
        public void startTransition(LayoutTransition transition2, ViewGroup container, View view, int transitionType) {
            if (transitionType == 3) {
                ViewGroup.this.startViewTransition(view);
            }
        }

        @Override
        public void endTransition(LayoutTransition transition2, ViewGroup container, View view, int transitionType) {
            if (ViewGroup.this.mLayoutCalledWhileSuppressed && !transition2.isChangingLayout()) {
                ViewGroup.this.requestLayout();
                ViewGroup.this.mLayoutCalledWhileSuppressed = false;
            }
            if (transitionType == 3 && ViewGroup.this.mTransitioningViews != null) {
                ViewGroup.this.endViewTransition(view);
            }
        }
    };

    public ViewGroup(Context context) {
        this(context, null);
    }

    public ViewGroup(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ViewGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ViewGroup(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initViewGroup();
        this.initFromAttributes(context, attrs, defStyleAttr, defStyleRes);
    }

    private void initViewGroup() {
        if (!this.debugDraw()) {
            this.setFlags(128, 128);
        }
        this.mGroupFlags |= 1;
        this.mGroupFlags |= 2;
        this.mGroupFlags |= 0x10;
        this.mGroupFlags |= 0x40;
        this.mGroupFlags |= 0x4000;
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 11) {
            this.mGroupFlags |= 0x200000;
        }
        this.setDescendantFocusability(131072);
        this.mChildren = new View[12];
        this.mChildrenCount = 0;
        this.mPersistentDrawingCache = 2;
    }

    private void initFromAttributes(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewGroup, defStyleAttr, defStyleRes);
        int N = a.getIndexCount();
        block15: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 0: {
                    this.setClipChildren(a.getBoolean(attr2, true));
                    continue block15;
                }
                case 1: {
                    this.setClipToPadding(a.getBoolean(attr2, true));
                    continue block15;
                }
                case 3: {
                    this.setAnimationCacheEnabled(a.getBoolean(attr2, true));
                    continue block15;
                }
                case 4: {
                    this.setPersistentDrawingCache(a.getInt(attr2, 2));
                    continue block15;
                }
                case 6: {
                    this.setAddStatesFromChildren(a.getBoolean(attr2, false));
                    continue block15;
                }
                case 5: {
                    this.setAlwaysDrawnWithCacheEnabled(a.getBoolean(attr2, true));
                    continue block15;
                }
                case 2: {
                    int id2 = a.getResourceId(attr2, -1);
                    if (id2 <= 0) continue block15;
                    this.setLayoutAnimation(AnimationUtils.loadLayoutAnimation(this.mContext, id2));
                    continue block15;
                }
                case 7: {
                    this.setDescendantFocusability(DESCENDANT_FOCUSABILITY_FLAGS[a.getInt(attr2, 0)]);
                    continue block15;
                }
                case 8: {
                    this.setMotionEventSplittingEnabled(a.getBoolean(attr2, false));
                    continue block15;
                }
                case 9: {
                    boolean animateLayoutChanges = a.getBoolean(attr2, false);
                    if (!animateLayoutChanges) continue block15;
                    this.setLayoutTransition(new LayoutTransition());
                    continue block15;
                }
                case 10: {
                    this.setLayoutMode(a.getInt(attr2, -1));
                    continue block15;
                }
                case 11: {
                    this.setTransitionGroup(a.getBoolean(attr2, false));
                    continue block15;
                }
                case 12: {
                    this.setTouchscreenBlocksFocus(a.getBoolean(attr2, false));
                }
            }
        }
        a.recycle();
    }

    @ViewDebug.ExportedProperty(category="focus", mapping={@ViewDebug.IntToString(from=131072, to="FOCUS_BEFORE_DESCENDANTS"), @ViewDebug.IntToString(from=262144, to="FOCUS_AFTER_DESCENDANTS"), @ViewDebug.IntToString(from=393216, to="FOCUS_BLOCK_DESCENDANTS")})
    public int getDescendantFocusability() {
        return this.mGroupFlags & 0x60000;
    }

    public void setDescendantFocusability(int focusability) {
        switch (focusability) {
            case 131072: 
            case 262144: 
            case 393216: {
                break;
            }
            default: {
                throw new IllegalArgumentException("must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS");
            }
        }
        this.mGroupFlags &= 0xFFF9FFFF;
        this.mGroupFlags |= focusability & 0x60000;
    }

    @Override
    void handleFocusGainInternal(int direction, Rect previouslyFocusedRect) {
        if (this.mFocused != null) {
            this.mFocused.unFocus(this);
            this.mFocused = null;
            this.mFocusedInCluster = null;
        }
        super.handleFocusGainInternal(direction, previouslyFocusedRect);
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        super.unFocus(focused);
        if (this.mFocused != child) {
            if (this.mFocused != null) {
                this.mFocused.unFocus(focused);
            }
            this.mFocused = child;
        }
        if (this.mParent != null) {
            this.mParent.requestChildFocus(this, focused);
        }
    }

    void setDefaultFocus(View child) {
        if (this.mDefaultFocus != null && this.mDefaultFocus.isFocusedByDefault()) {
            return;
        }
        this.mDefaultFocus = child;
        if (this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).setDefaultFocus(this);
        }
    }

    void clearDefaultFocus(View child) {
        if (this.mDefaultFocus != child && this.mDefaultFocus != null && this.mDefaultFocus.isFocusedByDefault()) {
            return;
        }
        this.mDefaultFocus = null;
        for (int i = 0; i < this.mChildrenCount; ++i) {
            View sibling = this.mChildren[i];
            if (sibling.isFocusedByDefault()) {
                this.mDefaultFocus = sibling;
                return;
            }
            if (this.mDefaultFocus != null || !sibling.hasDefaultFocus()) continue;
            this.mDefaultFocus = sibling;
        }
        if (this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).clearDefaultFocus(this);
        }
    }

    @Override
    boolean hasDefaultFocus() {
        return this.mDefaultFocus != null || super.hasDefaultFocus();
    }

    void setFocusInCluster(View child) {
        if (child.isKeyboardNavigationCluster()) {
            return;
        }
        this.mFocusedInCluster = child;
        if (this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).setFocusInCluster(this);
        }
    }

    void clearFocusInCluster(View child) {
        if (this.mFocusedInCluster != child) {
            return;
        }
        if (child.isKeyboardNavigationCluster()) {
            return;
        }
        this.mFocusedInCluster = null;
        if (this.mParent instanceof ViewGroup) {
            ((ViewGroup)this.mParent).clearFocusInCluster(this);
        }
    }

    @Override
    public void focusableViewAvailable(View v) {
        if (!(this.mParent == null || this.getDescendantFocusability() == 393216 || !this.isFocusableInTouchMode() && this.shouldBlockFocusForTouchscreen() || this.isFocused() && this.getDescendantFocusability() != 262144)) {
            this.mParent.focusableViewAvailable(v);
        }
    }

    @Override
    public boolean showContextMenuForChild(View originalView) {
        if (this.isShowingContextMenuWithCoords()) {
            return false;
        }
        return this.mParent != null && this.mParent.showContextMenuForChild(originalView);
    }

    public final boolean isShowingContextMenuWithCoords() {
        return (this.mGroupFlags & 0x20000000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean showContextMenuForChild(View originalView, float x, float y) {
        try {
            this.mGroupFlags |= 0x20000000;
            if (this.showContextMenuForChild(originalView)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.mGroupFlags &= 0xDFFFFFFF;
        }
        return this.mParent != null && this.mParent.showContextMenuForChild(originalView, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback) {
        if ((this.mGroupFlags & 0x8000000) == 0) {
            try {
                this.mGroupFlags |= 0x10000000;
                ActionMode actionMode = this.startActionModeForChild(originalView, callback, 0);
                return actionMode;
            }
            finally {
                this.mGroupFlags &= 0xEFFFFFFF;
            }
        }
        return SENTINEL_ACTION_MODE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback, int type) {
        if ((this.mGroupFlags & 0x10000000) == 0 && type == 0) {
            ActionMode mode;
            try {
                this.mGroupFlags |= 0x8000000;
                mode = this.startActionModeForChild(originalView, callback);
            }
            finally {
                this.mGroupFlags &= 0xF7FFFFFF;
            }
            if (mode != SENTINEL_ACTION_MODE) {
                return mode;
            }
        }
        if (this.mParent != null) {
            try {
                return this.mParent.startActionModeForChild(originalView, callback, type);
            }
            catch (AbstractMethodError ame) {
                return this.mParent.startActionModeForChild(originalView, callback);
            }
        }
        return null;
    }

    @Override
    public boolean dispatchActivityResult(String who, int requestCode, int resultCode, Intent data) {
        if (super.dispatchActivityResult(who, requestCode, resultCode, data)) {
            return true;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!child.dispatchActivityResult(who, requestCode, resultCode, data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public View focusSearch(View focused, int direction) {
        if (this.isRootNamespace()) {
            return FocusFinder.getInstance().findNextFocus(this, focused, direction);
        }
        if (this.mParent != null) {
            return this.mParent.focusSearch(focused, direction);
        }
        return null;
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        return false;
    }

    @Override
    public boolean requestSendAccessibilityEvent(View child, AccessibilityEvent event) {
        ViewParent parent = this.mParent;
        if (parent == null) {
            return false;
        }
        boolean propagate = this.onRequestSendAccessibilityEvent(child, event);
        if (!propagate) {
            return false;
        }
        return parent.requestSendAccessibilityEvent(this, event);
    }

    public boolean onRequestSendAccessibilityEvent(View child, AccessibilityEvent event) {
        if (this.mAccessibilityDelegate != null) {
            return this.mAccessibilityDelegate.onRequestSendAccessibilityEvent(this, child, event);
        }
        return this.onRequestSendAccessibilityEventInternal(child, event);
    }

    public boolean onRequestSendAccessibilityEventInternal(View child, AccessibilityEvent event) {
        return true;
    }

    @Override
    public void childHasTransientStateChanged(View child, boolean childHasTransientState) {
        boolean oldHasTransientState = this.hasTransientState();
        this.mChildCountWithTransientState = childHasTransientState ? ++this.mChildCountWithTransientState : --this.mChildCountWithTransientState;
        boolean newHasTransientState = this.hasTransientState();
        if (this.mParent != null && oldHasTransientState != newHasTransientState) {
            try {
                this.mParent.childHasTransientStateChanged(this, newHasTransientState);
            }
            catch (AbstractMethodError e) {
                Log.e(TAG, this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", e);
            }
        }
    }

    @Override
    public boolean hasTransientState() {
        return this.mChildCountWithTransientState > 0 || super.hasTransientState();
    }

    @Override
    public boolean dispatchUnhandledMove(View focused, int direction) {
        return this.mFocused != null && this.mFocused.dispatchUnhandledMove(focused, direction);
    }

    @Override
    public void clearChildFocus(View child) {
        this.mFocused = null;
        if (this.mParent != null) {
            this.mParent.clearChildFocus(this);
        }
    }

    @Override
    public void clearFocus() {
        if (this.mFocused == null) {
            super.clearFocus();
        } else {
            View focused = this.mFocused;
            this.mFocused = null;
            focused.clearFocus();
        }
    }

    @Override
    void unFocus(View focused) {
        if (this.mFocused == null) {
            super.unFocus(focused);
        } else {
            this.mFocused.unFocus(focused);
            this.mFocused = null;
        }
    }

    public View getFocusedChild() {
        return this.mFocused;
    }

    View getDeepestFocusedChild() {
        ViewGroup v = this;
        while (v != null) {
            if (v.isFocused()) {
                return v;
            }
            v = v instanceof ViewGroup ? v.getFocusedChild() : null;
        }
        return null;
    }

    @Override
    public boolean hasFocus() {
        return (this.mPrivateFlags & 2) != 0 || this.mFocused != null;
    }

    @Override
    public View findFocus() {
        if (this.isFocused()) {
            return this;
        }
        if (this.mFocused != null) {
            return this.mFocused.findFocus();
        }
        return null;
    }

    @Override
    boolean hasFocusable(boolean allowAutoFocus, boolean dispatchExplicit) {
        if ((this.mViewFlags & 0xC) != 0) {
            return false;
        }
        if ((allowAutoFocus || this.getFocusable() != 16) && this.isFocusable()) {
            return true;
        }
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability != 393216) {
            int count = this.mChildrenCount;
            View[] children = this.mChildren;
            for (int i = 0; i < count; ++i) {
                View child = children[i];
                if ((!dispatchExplicit || !child.hasExplicitFocusable()) && (dispatchExplicit || !child.hasFocusable())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        int i;
        boolean focusSelf;
        int focusableCount = views.size();
        int descendantFocusability = this.getDescendantFocusability();
        boolean bl = focusSelf = this.isFocusableInTouchMode() || !this.shouldBlockFocusForTouchscreen();
        if (descendantFocusability == 393216) {
            if (focusSelf) {
                super.addFocusables(views, direction, focusableMode);
            }
            return;
        }
        if (this.shouldBlockFocusForTouchscreen()) {
            focusableMode |= 1;
        }
        if (descendantFocusability == 131072 && focusSelf) {
            super.addFocusables(views, direction, focusableMode);
        }
        int count = 0;
        View[] children = new View[this.mChildrenCount];
        for (i = 0; i < this.mChildrenCount; ++i) {
            View child = this.mChildren[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            children[count++] = child;
        }
        Arrays.sort(children, 0, count, FocusFinder.getFocusComparator(this, false));
        for (i = 0; i < count; ++i) {
            children[i].addFocusables(views, direction, focusableMode);
        }
        if (descendantFocusability == 262144 && focusSelf && focusableCount == views.size()) {
            super.addFocusables(views, direction, focusableMode);
        }
    }

    @Override
    public void addKeyboardNavigationClusters(Collection<View> views, int direction) {
        int focusableCount = views.size();
        super.addKeyboardNavigationClusters(views, direction);
        if (focusableCount != views.size()) {
            return;
        }
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            child.addKeyboardNavigationClusters(views, direction);
        }
    }

    public void setTouchscreenBlocksFocus(boolean touchscreenBlocksFocus) {
        if (touchscreenBlocksFocus) {
            View newFocus;
            View focusedChild;
            this.mGroupFlags |= 0x4000000;
            if (this.hasFocus() && !(focusedChild = this.getDeepestFocusedChild()).isFocusableInTouchMode() && (newFocus = this.focusSearch(2)) != null) {
                newFocus.requestFocus();
            }
        } else {
            this.mGroupFlags &= 0xFBFFFFFF;
        }
    }

    public boolean getTouchscreenBlocksFocus() {
        return (this.mGroupFlags & 0x4000000) != 0;
    }

    boolean shouldBlockFocusForTouchscreen() {
        return this.getTouchscreenBlocksFocus() && this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
    }

    @Override
    public void findViewsWithText(ArrayList<View> outViews, CharSequence text, int flags) {
        super.findViewsWithText(outViews, text, flags);
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < childrenCount; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 || (child.mPrivateFlags & 8) != 0) continue;
            child.findViewsWithText(outViews, text, flags);
        }
    }

    public View findViewByAccessibilityIdTraversal(int accessibilityId) {
        Object foundView = super.findViewByAccessibilityIdTraversal(accessibilityId);
        if (foundView != null) {
            return foundView;
        }
        if (this.getAccessibilityNodeProvider() != null) {
            return null;
        }
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < childrenCount; ++i) {
            View child = children[i];
            foundView = child.findViewByAccessibilityIdTraversal(accessibilityId);
            if (foundView == null) continue;
            return foundView;
        }
        return null;
    }

    @Override
    public void dispatchWindowFocusChanged(boolean hasFocus) {
        super.dispatchWindowFocusChanged(hasFocus);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchWindowFocusChanged(hasFocus);
        }
    }

    @Override
    public void addTouchables(ArrayList<View> views) {
        super.addTouchables(views);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0) continue;
            child.addTouchables(views);
        }
    }

    @Override
    public void makeOptionalFitsSystemWindows() {
        super.makeOptionalFitsSystemWindows();
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].makeOptionalFitsSystemWindows();
        }
    }

    @Override
    public void dispatchDisplayHint(int hint) {
        super.dispatchDisplayHint(hint);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchDisplayHint(hint);
        }
    }

    protected void onChildVisibilityChanged(View child, int oldVisibility, int newVisibility) {
        if (this.mTransition != null) {
            if (newVisibility == 0) {
                this.mTransition.showChild(this, child, oldVisibility);
            } else {
                this.mTransition.hideChild(this, child, newVisibility);
                if (this.mTransitioningViews != null && this.mTransitioningViews.contains(child)) {
                    if (this.mVisibilityChangingChildren == null) {
                        this.mVisibilityChangingChildren = new ArrayList();
                    }
                    this.mVisibilityChangingChildren.add(child);
                    this.addDisappearingView(child);
                }
            }
        }
        if (newVisibility == 0 && this.mCurrentDragStartEvent != null && !this.mChildrenInterestedInDrag.contains(child)) {
            this.notifyChildOfDragStart(child);
        }
    }

    @Override
    protected void dispatchVisibilityChanged(View changedView, int visibility) {
        super.dispatchVisibilityChanged(changedView, visibility);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchVisibilityChanged(changedView, visibility);
        }
    }

    @Override
    public void dispatchWindowVisibilityChanged(int visibility) {
        super.dispatchWindowVisibilityChanged(visibility);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchWindowVisibilityChanged(visibility);
        }
    }

    @Override
    boolean dispatchVisibilityAggregated(boolean isVisible) {
        isVisible = super.dispatchVisibilityAggregated(isVisible);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            if (children[i].getVisibility() != 0) continue;
            children[i].dispatchVisibilityAggregated(isVisible);
        }
        return isVisible;
    }

    @Override
    public void dispatchConfigurationChanged(Configuration newConfig) {
        super.dispatchConfigurationChanged(newConfig);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchConfigurationChanged(newConfig);
        }
    }

    @Override
    public void recomputeViewAttributes(View child) {
        ViewParent parent;
        if (this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes && (parent = this.mParent) != null) {
            parent.recomputeViewAttributes(this);
        }
    }

    @Override
    void dispatchCollectViewAttributes(View.AttachInfo attachInfo, int visibility) {
        if ((visibility & 0xC) == 0) {
            super.dispatchCollectViewAttributes(attachInfo, visibility);
            int count = this.mChildrenCount;
            View[] children = this.mChildren;
            for (int i = 0; i < count; ++i) {
                View child = children[i];
                child.dispatchCollectViewAttributes(attachInfo, visibility | child.mViewFlags & 0xC);
            }
        }
    }

    @Override
    public void bringChildToFront(View child) {
        int index = this.indexOfChild(child);
        if (index >= 0) {
            this.removeFromArray(index);
            this.addInArray(child, this.mChildrenCount);
            child.mParent = this;
            this.requestLayout();
            this.invalidate();
        }
    }

    private PointF getLocalPoint() {
        if (this.mLocalPoint == null) {
            this.mLocalPoint = new PointF();
        }
        return this.mLocalPoint;
    }

    @Override
    boolean dispatchDragEnterExitInPreN(DragEvent event) {
        if (event.mAction == 6 && this.mCurrentDragChild != null) {
            this.mCurrentDragChild.dispatchDragEnterExitInPreN(event);
            this.mCurrentDragChild = null;
        }
        return this.mIsInterestedInDrag && super.dispatchDragEnterExitInPreN(event);
    }

    @Override
    public boolean dispatchDragEvent(DragEvent event) {
        boolean retval = false;
        float tx = event.mX;
        float ty = event.mY;
        ClipData td = event.mClipData;
        PointF localPoint = this.getLocalPoint();
        switch (event.mAction) {
            case 1: {
                this.mCurrentDragChild = null;
                this.mCurrentDragStartEvent = DragEvent.obtain(event);
                if (this.mChildrenInterestedInDrag == null) {
                    this.mChildrenInterestedInDrag = new HashSet();
                } else {
                    this.mChildrenInterestedInDrag.clear();
                }
                int count = this.mChildrenCount;
                View[] children = this.mChildren;
                for (int i = 0; i < count; ++i) {
                    View child = children[i];
                    child.mPrivateFlags2 &= 0xFFFFFFFC;
                    if (child.getVisibility() != 0 || !this.notifyChildOfDragStart(children[i])) continue;
                    retval = true;
                }
                this.mIsInterestedInDrag = super.dispatchDragEvent(event);
                if (this.mIsInterestedInDrag) {
                    retval = true;
                }
                if (retval) break;
                this.mCurrentDragStartEvent.recycle();
                this.mCurrentDragStartEvent = null;
                break;
            }
            case 4: {
                HashSet<View> childrenInterestedInDrag = this.mChildrenInterestedInDrag;
                if (childrenInterestedInDrag != null) {
                    for (View child : childrenInterestedInDrag) {
                        if (!child.dispatchDragEvent(event)) continue;
                        retval = true;
                    }
                    childrenInterestedInDrag.clear();
                }
                if (this.mCurrentDragStartEvent != null) {
                    this.mCurrentDragStartEvent.recycle();
                    this.mCurrentDragStartEvent = null;
                }
                if (!this.mIsInterestedInDrag) break;
                if (super.dispatchDragEvent(event)) {
                    retval = true;
                }
                this.mIsInterestedInDrag = false;
                break;
            }
            case 2: 
            case 3: {
                View target = this.findFrontmostDroppableChildAt(event.mX, event.mY, localPoint);
                if (target != this.mCurrentDragChild) {
                    if (sCascadedDragDrop) {
                        int action = event.mAction;
                        event.mX = 0.0f;
                        event.mY = 0.0f;
                        event.mClipData = null;
                        if (this.mCurrentDragChild != null) {
                            event.mAction = 6;
                            this.mCurrentDragChild.dispatchDragEnterExitInPreN(event);
                        }
                        if (target != null) {
                            event.mAction = 5;
                            target.dispatchDragEnterExitInPreN(event);
                        }
                        event.mAction = action;
                        event.mX = tx;
                        event.mY = ty;
                        event.mClipData = td;
                    }
                    this.mCurrentDragChild = target;
                }
                if (target == null && this.mIsInterestedInDrag) {
                    target = this;
                }
                if (target == null) break;
                if (target != this) {
                    boolean eventWasConsumed;
                    event.mX = localPoint.x;
                    event.mY = localPoint.y;
                    retval = target.dispatchDragEvent(event);
                    event.mX = tx;
                    event.mY = ty;
                    if (!this.mIsInterestedInDrag || (eventWasConsumed = sCascadedDragDrop ? retval : event.mEventHandlerWasCalled)) break;
                    retval = super.dispatchDragEvent(event);
                    break;
                }
                retval = super.dispatchDragEvent(event);
            }
        }
        return retval;
    }

    View findFrontmostDroppableChildAt(float x, float y, PointF outLocalPoint) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = count - 1; i >= 0; --i) {
            View child = children[i];
            if (!child.canAcceptDrag() || !this.isTransformedTouchPointInView(x, y, child, outLocalPoint)) continue;
            return child;
        }
        return null;
    }

    boolean notifyChildOfDragStart(View child) {
        float tx = this.mCurrentDragStartEvent.mX;
        float ty = this.mCurrentDragStartEvent.mY;
        float[] point = this.getTempPoint();
        point[0] = tx;
        point[1] = ty;
        this.transformPointToViewLocal(point, child);
        this.mCurrentDragStartEvent.mX = point[0];
        this.mCurrentDragStartEvent.mY = point[1];
        boolean canAccept = child.dispatchDragEvent(this.mCurrentDragStartEvent);
        this.mCurrentDragStartEvent.mX = tx;
        this.mCurrentDragStartEvent.mY = ty;
        this.mCurrentDragStartEvent.mEventHandlerWasCalled = false;
        if (canAccept) {
            this.mChildrenInterestedInDrag.add(child);
            if (!child.canAcceptDrag()) {
                child.mPrivateFlags2 |= 1;
                child.refreshDrawableState();
            }
        }
        return canAccept;
    }

    @Override
    public void dispatchWindowSystemUiVisiblityChanged(int visible) {
        super.dispatchWindowSystemUiVisiblityChanged(visible);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            child.dispatchWindowSystemUiVisiblityChanged(visible);
        }
    }

    @Override
    public void dispatchSystemUiVisibilityChanged(int visible) {
        super.dispatchSystemUiVisibilityChanged(visible);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            child.dispatchSystemUiVisibilityChanged(visible);
        }
    }

    @Override
    boolean updateLocalSystemUiVisibility(int localValue, int localChanges) {
        boolean changed = super.updateLocalSystemUiVisibility(localValue, localChanges);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            changed |= child.updateLocalSystemUiVisibility(localValue, localChanges);
        }
        return changed;
    }

    @Override
    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyEventPreIme(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchKeyEventPreIme(event);
        }
        return false;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onKeyEvent(event, 1);
        }
        if ((this.mPrivateFlags & 0x12) == 18 ? super.dispatchKeyEvent(event) : this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16 && this.mFocused.dispatchKeyEvent(event)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 1);
        }
        return false;
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchKeyShortcutEvent(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchKeyShortcutEvent(event);
        }
        return false;
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent event) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTrackballEvent(event, 1);
        }
        if ((this.mPrivateFlags & 0x12) == 18 ? super.dispatchTrackballEvent(event) : this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16 && this.mFocused.dispatchTrackballEvent(event)) {
            return true;
        }
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(event, 1);
        }
        return false;
    }

    @Override
    public boolean dispatchCapturedPointerEvent(MotionEvent event) {
        return (this.mPrivateFlags & 0x12) == 18 ? super.dispatchCapturedPointerEvent(event) : this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16 && this.mFocused.dispatchCapturedPointerEvent(event);
    }

    @Override
    public void dispatchPointerCaptureChanged(boolean hasCapture) {
        this.exitHoverTargets();
        super.dispatchPointerCaptureChanged(hasCapture);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchPointerCaptureChanged(hasCapture);
        }
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        float y;
        float x = event.getX(pointerIndex);
        if (this.isOnScrollbarThumb(x, y = event.getY(pointerIndex)) || this.isDraggingScrollBar()) {
            return PointerIcon.getSystemIcon(this.mContext, 1000);
        }
        int childrenCount = this.mChildrenCount;
        if (childrenCount != 0) {
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = childrenCount - 1; i >= 0; --i) {
                PointerIcon pointerIcon;
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null) || (pointerIcon = this.dispatchResolvePointerIcon(event, pointerIndex, child)) == null) continue;
                if (preorderedList != null) {
                    preorderedList.clear();
                }
                return pointerIcon;
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    private PointerIcon dispatchResolvePointerIcon(MotionEvent event, int pointerIndex, View child) {
        PointerIcon pointerIcon;
        if (!child.hasIdentityMatrix()) {
            MotionEvent transformedEvent = this.getTransformedMotionEvent(event, child);
            pointerIcon = child.onResolvePointerIcon(transformedEvent, pointerIndex);
            transformedEvent.recycle();
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            event.offsetLocation(offsetX, offsetY);
            pointerIcon = child.onResolvePointerIcon(event, pointerIndex);
            event.offsetLocation(-offsetX, -offsetY);
        }
        return pointerIcon;
    }

    private int getAndVerifyPreorderedIndex(int childrenCount, int i, boolean customOrder) {
        int childIndex;
        if (customOrder) {
            int childIndex1 = this.getChildDrawingOrder(childrenCount, i);
            if (childIndex1 >= childrenCount) {
                throw new IndexOutOfBoundsException("getChildDrawingOrder() returned invalid index " + childIndex1 + " (child count is " + childrenCount + ")");
            }
            childIndex = childIndex1;
        } else {
            childIndex = i;
        }
        return childIndex;
    }

    @Override
    protected boolean dispatchHoverEvent(MotionEvent event) {
        boolean newHoveredSelf;
        int action = event.getAction();
        boolean interceptHover = this.onInterceptHoverEvent(event);
        event.setAction(action);
        MotionEvent eventNoHistory = event;
        boolean handled = false;
        HoverTarget firstOldHoverTarget = this.mFirstHoverTarget;
        this.mFirstHoverTarget = null;
        if (!interceptHover && action != 10) {
            float x = event.getX();
            float y = event.getY();
            int childrenCount = this.mChildrenCount;
            if (childrenCount != 0) {
                ArrayList<View> preorderedList = this.buildOrderedChildList();
                boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
                View[] children = this.mChildren;
                HoverTarget lastHoverTarget = null;
                for (int i = childrenCount - 1; i >= 0; --i) {
                    boolean wasHovered;
                    int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                    View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                    if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null)) continue;
                    HoverTarget hoverTarget = firstOldHoverTarget;
                    HoverTarget predecessor = null;
                    while (true) {
                        if (hoverTarget == null) {
                            hoverTarget = HoverTarget.obtain(child);
                            wasHovered = false;
                            break;
                        }
                        if (hoverTarget.child == child) {
                            if (predecessor != null) {
                                predecessor.next = hoverTarget.next;
                            } else {
                                firstOldHoverTarget = hoverTarget.next;
                            }
                            hoverTarget.next = null;
                            wasHovered = true;
                            break;
                        }
                        predecessor = hoverTarget;
                        hoverTarget = hoverTarget.next;
                    }
                    if (lastHoverTarget != null) {
                        lastHoverTarget.next = hoverTarget;
                    } else {
                        this.mFirstHoverTarget = hoverTarget;
                    }
                    lastHoverTarget = hoverTarget;
                    if (action == 9) {
                        if (!wasHovered) {
                            handled |= this.dispatchTransformedGenericPointerEvent(event, child);
                        }
                    } else if (action == 7) {
                        if (!wasHovered) {
                            eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                            eventNoHistory.setAction(9);
                            handled |= this.dispatchTransformedGenericPointerEvent(eventNoHistory, child);
                            eventNoHistory.setAction(action);
                            handled |= this.dispatchTransformedGenericPointerEvent(eventNoHistory, child);
                        } else {
                            handled |= this.dispatchTransformedGenericPointerEvent(event, child);
                        }
                    }
                    if (handled) break;
                }
                if (preorderedList != null) {
                    preorderedList.clear();
                }
            }
        }
        while (firstOldHoverTarget != null) {
            View child = firstOldHoverTarget.child;
            if (action == 10) {
                handled |= this.dispatchTransformedGenericPointerEvent(event, child);
            } else {
                if (action == 7) {
                    boolean hoverExitPending = event.isHoverExitPending();
                    event.setHoverExitPending(true);
                    this.dispatchTransformedGenericPointerEvent(event, child);
                    event.setHoverExitPending(hoverExitPending);
                }
                eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                eventNoHistory.setAction(10);
                this.dispatchTransformedGenericPointerEvent(eventNoHistory, child);
                eventNoHistory.setAction(action);
            }
            HoverTarget nextOldHoverTarget = firstOldHoverTarget.next;
            firstOldHoverTarget.recycle();
            firstOldHoverTarget = nextOldHoverTarget;
        }
        boolean bl = newHoveredSelf = !handled && action != 10 && !event.isHoverExitPending();
        if (newHoveredSelf == this.mHoveredSelf) {
            if (newHoveredSelf) {
                handled |= super.dispatchHoverEvent(event);
            }
        } else {
            if (this.mHoveredSelf) {
                if (action == 10) {
                    handled |= super.dispatchHoverEvent(event);
                } else {
                    if (action == 7) {
                        super.dispatchHoverEvent(event);
                    }
                    eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                    eventNoHistory.setAction(10);
                    super.dispatchHoverEvent(eventNoHistory);
                    eventNoHistory.setAction(action);
                }
                this.mHoveredSelf = false;
            }
            if (newHoveredSelf) {
                if (action == 9) {
                    handled |= super.dispatchHoverEvent(event);
                    this.mHoveredSelf = true;
                } else if (action == 7) {
                    eventNoHistory = ViewGroup.obtainMotionEventNoHistoryOrSelf(eventNoHistory);
                    eventNoHistory.setAction(9);
                    handled |= super.dispatchHoverEvent(eventNoHistory);
                    eventNoHistory.setAction(action);
                    handled |= super.dispatchHoverEvent(eventNoHistory);
                    this.mHoveredSelf = true;
                }
            }
        }
        if (eventNoHistory != event) {
            eventNoHistory.recycle();
        }
        return handled;
    }

    private void exitHoverTargets() {
        if (this.mHoveredSelf || this.mFirstHoverTarget != null) {
            long now = SystemClock.uptimeMillis();
            MotionEvent event = MotionEvent.obtain(now, now, 10, 0.0f, 0.0f, 0);
            event.setSource(4098);
            this.dispatchHoverEvent(event);
            event.recycle();
        }
    }

    private void cancelHoverTarget(View view) {
        HoverTarget predecessor = null;
        HoverTarget target = this.mFirstHoverTarget;
        while (target != null) {
            HoverTarget next = target.next;
            if (target.child == view) {
                if (predecessor == null) {
                    this.mFirstHoverTarget = next;
                } else {
                    predecessor.next = next;
                }
                target.recycle();
                long now = SystemClock.uptimeMillis();
                MotionEvent event = MotionEvent.obtain(now, now, 10, 0.0f, 0.0f, 0);
                event.setSource(4098);
                view.dispatchHoverEvent(event);
                event.recycle();
                return;
            }
            predecessor = target;
            target = next;
        }
    }

    @Override
    boolean dispatchTooltipHoverEvent(MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 9: {
                break;
            }
            case 7: {
                View newTarget = null;
                int childrenCount = this.mChildrenCount;
                if (childrenCount != 0) {
                    float x = event.getX();
                    float y = event.getY();
                    ArrayList<View> preorderedList = this.buildOrderedChildList();
                    boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
                    View[] children = this.mChildren;
                    for (int i = childrenCount - 1; i >= 0; --i) {
                        int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                        View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                        if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null) || !this.dispatchTooltipHoverEvent(event, child)) continue;
                        newTarget = child;
                        break;
                    }
                    if (preorderedList != null) {
                        preorderedList.clear();
                    }
                }
                if (this.mTooltipHoverTarget != newTarget) {
                    if (this.mTooltipHoverTarget != null) {
                        event.setAction(10);
                        this.mTooltipHoverTarget.dispatchTooltipHoverEvent(event);
                        event.setAction(action);
                    }
                    this.mTooltipHoverTarget = newTarget;
                }
                if (this.mTooltipHoverTarget != null) {
                    if (this.mTooltipHoveredSelf) {
                        this.mTooltipHoveredSelf = false;
                        event.setAction(10);
                        super.dispatchTooltipHoverEvent(event);
                        event.setAction(action);
                    }
                    return true;
                }
                this.mTooltipHoveredSelf = super.dispatchTooltipHoverEvent(event);
                return this.mTooltipHoveredSelf;
            }
            case 10: {
                if (this.mTooltipHoverTarget != null) {
                    this.mTooltipHoverTarget.dispatchTooltipHoverEvent(event);
                    this.mTooltipHoverTarget = null;
                    break;
                }
                if (!this.mTooltipHoveredSelf) break;
                super.dispatchTooltipHoverEvent(event);
                this.mTooltipHoveredSelf = false;
            }
        }
        return false;
    }

    private boolean dispatchTooltipHoverEvent(MotionEvent event, View child) {
        boolean result;
        if (!child.hasIdentityMatrix()) {
            MotionEvent transformedEvent = this.getTransformedMotionEvent(event, child);
            result = child.dispatchTooltipHoverEvent(transformedEvent);
            transformedEvent.recycle();
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            event.offsetLocation(offsetX, offsetY);
            result = child.dispatchTooltipHoverEvent(event);
            event.offsetLocation(-offsetX, -offsetY);
        }
        return result;
    }

    private void exitTooltipHoverTargets() {
        if (this.mTooltipHoveredSelf || this.mTooltipHoverTarget != null) {
            long now = SystemClock.uptimeMillis();
            MotionEvent event = MotionEvent.obtain(now, now, 10, 0.0f, 0.0f, 0);
            event.setSource(4098);
            this.dispatchTooltipHoverEvent(event);
            event.recycle();
        }
    }

    @Override
    protected boolean hasHoveredChild() {
        return this.mFirstHoverTarget != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildrenForAccessibility(ArrayList<View> outChildren) {
        if (this.getAccessibilityNodeProvider() != null) {
            return;
        }
        ChildListForAccessibility children = ChildListForAccessibility.obtain(this, true);
        try {
            int childrenCount = children.getChildCount();
            for (int i = 0; i < childrenCount; ++i) {
                View child = children.getChildAt(i);
                if ((child.mViewFlags & 0xC) != 0) continue;
                if (child.includeForAccessibility()) {
                    outChildren.add(child);
                    continue;
                }
                child.addChildrenForAccessibility(outChildren);
            }
        }
        finally {
            children.recycle();
        }
    }

    public boolean onInterceptHoverEvent(MotionEvent event) {
        if (event.isFromSource(8194)) {
            int action = event.getAction();
            float x = event.getX();
            float y = event.getY();
            if ((action == 7 || action == 9) && this.isOnScrollbar(x, y)) {
                return true;
            }
        }
        return false;
    }

    private static MotionEvent obtainMotionEventNoHistoryOrSelf(MotionEvent event) {
        if (event.getHistorySize() == 0) {
            return event;
        }
        return MotionEvent.obtainNoHistory(event);
    }

    @Override
    protected boolean dispatchGenericPointerEvent(MotionEvent event) {
        int childrenCount = this.mChildrenCount;
        if (childrenCount != 0) {
            float x = event.getX();
            float y = event.getY();
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = childrenCount - 1; i >= 0; --i) {
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null) || !this.dispatchTransformedGenericPointerEvent(event, child)) continue;
                if (preorderedList != null) {
                    preorderedList.clear();
                }
                return true;
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
        return super.dispatchGenericPointerEvent(event);
    }

    @Override
    protected boolean dispatchGenericFocusedEvent(MotionEvent event) {
        if ((this.mPrivateFlags & 0x12) == 18) {
            return super.dispatchGenericFocusedEvent(event);
        }
        if (this.mFocused != null && (this.mFocused.mPrivateFlags & 0x10) == 16) {
            return this.mFocused.dispatchGenericMotionEvent(event);
        }
        return false;
    }

    private boolean dispatchTransformedGenericPointerEvent(MotionEvent event, View child) {
        boolean handled;
        if (!child.hasIdentityMatrix()) {
            MotionEvent transformedEvent = this.getTransformedMotionEvent(event, child);
            handled = child.dispatchGenericMotionEvent(transformedEvent);
            transformedEvent.recycle();
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            event.offsetLocation(offsetX, offsetY);
            handled = child.dispatchGenericMotionEvent(event);
            event.offsetLocation(-offsetX, -offsetY);
        }
        return handled;
    }

    private MotionEvent getTransformedMotionEvent(MotionEvent event, View child) {
        float offsetX = this.mScrollX - child.mLeft;
        float offsetY = this.mScrollY - child.mTop;
        MotionEvent transformedEvent = MotionEvent.obtain(event);
        transformedEvent.offsetLocation(offsetX, offsetY);
        if (!child.hasIdentityMatrix()) {
            transformedEvent.transform(child.getInverseMatrix());
        }
        return transformedEvent;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTouchEvent(ev, 1);
        }
        if (ev.isTargetAccessibilityFocus() && this.isAccessibilityFocusedViewOrHost()) {
            ev.setTargetAccessibilityFocus(false);
        }
        boolean handled = false;
        if (this.onFilterTouchEventForSecurity(ev)) {
            boolean intercepted;
            int action = ev.getAction();
            int actionMasked = action & 0xFF;
            if (actionMasked == 0) {
                this.cancelAndClearTouchTargets(ev);
                this.resetTouchState();
            }
            if (actionMasked == 0 || this.mFirstTouchTarget != null) {
                boolean disallowIntercept;
                boolean bl = disallowIntercept = (this.mGroupFlags & 0x80000) != 0;
                if (!disallowIntercept) {
                    intercepted = this.onInterceptTouchEvent(ev);
                    ev.setAction(action);
                } else {
                    intercepted = false;
                }
            } else {
                intercepted = true;
            }
            if (intercepted || this.mFirstTouchTarget != null) {
                ev.setTargetAccessibilityFocus(false);
            }
            boolean canceled = ViewGroup.resetCancelNextUpFlag(this) || actionMasked == 3;
            boolean split = (this.mGroupFlags & 0x200000) != 0;
            TouchTarget newTouchTarget = null;
            boolean alreadyDispatchedToNewTouchTarget = false;
            if (!canceled && !intercepted) {
                View childWithAccessibilityFocus;
                View view = childWithAccessibilityFocus = ev.isTargetAccessibilityFocus() ? this.findChildWithAccessibilityFocus() : null;
                if (actionMasked == 0 || split && actionMasked == 5 || actionMasked == 7) {
                    int actionIndex = ev.getActionIndex();
                    int idBitsToAssign = split ? 1 << ev.getPointerId(actionIndex) : -1;
                    this.removePointersFromTouchTargets(idBitsToAssign);
                    int childrenCount = this.mChildrenCount;
                    if (newTouchTarget == null && childrenCount != 0) {
                        float x = ev.getX(actionIndex);
                        float y = ev.getY(actionIndex);
                        ArrayList<View> preorderedList = this.buildTouchDispatchChildList();
                        boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
                        View[] children = this.mChildren;
                        for (int i = childrenCount - 1; i >= 0; --i) {
                            int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                            View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                            if (childWithAccessibilityFocus != null) {
                                if (childWithAccessibilityFocus != child) continue;
                                childWithAccessibilityFocus = null;
                                i = childrenCount - 1;
                            }
                            if (!ViewGroup.canViewReceivePointerEvents(child) || !this.isTransformedTouchPointInView(x, y, child, null)) {
                                ev.setTargetAccessibilityFocus(false);
                                continue;
                            }
                            newTouchTarget = this.getTouchTarget(child);
                            if (newTouchTarget != null) {
                                newTouchTarget.pointerIdBits |= idBitsToAssign;
                                break;
                            }
                            ViewGroup.resetCancelNextUpFlag(child);
                            if (this.dispatchTransformedTouchEvent(ev, false, child, idBitsToAssign)) {
                                this.mLastTouchDownTime = ev.getDownTime();
                                if (preorderedList != null) {
                                    for (int j = 0; j < childrenCount; ++j) {
                                        if (children[childIndex] != this.mChildren[j]) continue;
                                        this.mLastTouchDownIndex = j;
                                        break;
                                    }
                                } else {
                                    this.mLastTouchDownIndex = childIndex;
                                }
                                this.mLastTouchDownX = ev.getX();
                                this.mLastTouchDownY = ev.getY();
                                newTouchTarget = this.addTouchTarget(child, idBitsToAssign);
                                alreadyDispatchedToNewTouchTarget = true;
                                break;
                            }
                            ev.setTargetAccessibilityFocus(false);
                        }
                        if (preorderedList != null) {
                            preorderedList.clear();
                        }
                    }
                    if (newTouchTarget == null && this.mFirstTouchTarget != null) {
                        newTouchTarget = this.mFirstTouchTarget;
                        while (newTouchTarget.next != null) {
                            newTouchTarget = newTouchTarget.next;
                        }
                        newTouchTarget.pointerIdBits |= idBitsToAssign;
                    }
                }
            }
            if (this.mFirstTouchTarget == null) {
                handled = this.dispatchTransformedTouchEvent(ev, canceled, null, -1);
            } else {
                TouchTarget predecessor = null;
                TouchTarget target = this.mFirstTouchTarget;
                while (target != null) {
                    TouchTarget next = target.next;
                    if (alreadyDispatchedToNewTouchTarget && target == newTouchTarget) {
                        handled = true;
                    } else {
                        boolean cancelChild;
                        boolean bl = cancelChild = ViewGroup.resetCancelNextUpFlag(target.child) || intercepted;
                        if (this.dispatchTransformedTouchEvent(ev, cancelChild, target.child, target.pointerIdBits)) {
                            handled = true;
                        }
                        if (cancelChild) {
                            if (predecessor == null) {
                                this.mFirstTouchTarget = next;
                            } else {
                                predecessor.next = next;
                            }
                            target.recycle();
                            target = next;
                            continue;
                        }
                    }
                    predecessor = target;
                    target = next;
                }
            }
            if (canceled || actionMasked == 1 || actionMasked == 7) {
                this.resetTouchState();
            } else if (split && actionMasked == 6) {
                int actionIndex = ev.getActionIndex();
                int idBitsToRemove = 1 << ev.getPointerId(actionIndex);
                this.removePointersFromTouchTargets(idBitsToRemove);
            }
        }
        if (!handled && this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(ev, 1);
        }
        return handled;
    }

    public ArrayList<View> buildTouchDispatchChildList() {
        return this.buildOrderedChildList();
    }

    private View findChildWithAccessibilityFocus() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return null;
        }
        View current = viewRoot.getAccessibilityFocusedHost();
        if (current == null) {
            return null;
        }
        ViewParent parent = current.getParent();
        while (parent instanceof View) {
            if (parent == this) {
                return current;
            }
            current = (View)((Object)parent);
            parent = current.getParent();
        }
        return null;
    }

    private void resetTouchState() {
        this.clearTouchTargets();
        ViewGroup.resetCancelNextUpFlag(this);
        this.mGroupFlags &= 0xFFF7FFFF;
        this.mNestedScrollAxes = 0;
    }

    private static boolean resetCancelNextUpFlag(View view) {
        if ((view.mPrivateFlags & 0x4000000) != 0) {
            view.mPrivateFlags &= 0xFBFFFFFF;
            return true;
        }
        return false;
    }

    private void clearTouchTargets() {
        TouchTarget target = this.mFirstTouchTarget;
        if (target != null) {
            TouchTarget next;
            do {
                next = target.next;
                target.recycle();
            } while ((target = next) != null);
            this.mFirstTouchTarget = null;
        }
    }

    private void cancelAndClearTouchTargets(MotionEvent event) {
        if (this.mFirstTouchTarget != null) {
            boolean syntheticEvent = false;
            if (event == null) {
                long now = SystemClock.uptimeMillis();
                event = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
                event.setSource(4098);
                syntheticEvent = true;
            }
            TouchTarget target = this.mFirstTouchTarget;
            while (target != null) {
                ViewGroup.resetCancelNextUpFlag(target.child);
                this.dispatchTransformedTouchEvent(event, true, target.child, target.pointerIdBits);
                target = target.next;
            }
            this.clearTouchTargets();
            if (syntheticEvent) {
                event.recycle();
            }
        }
    }

    private TouchTarget getTouchTarget(View child) {
        TouchTarget target = this.mFirstTouchTarget;
        while (target != null) {
            if (target.child == child) {
                return target;
            }
            target = target.next;
        }
        return null;
    }

    private TouchTarget addTouchTarget(View child, int pointerIdBits) {
        TouchTarget target = TouchTarget.obtain(child, pointerIdBits);
        target.next = this.mFirstTouchTarget;
        this.mFirstTouchTarget = target;
        return target;
    }

    private void removePointersFromTouchTargets(int pointerIdBits) {
        TouchTarget predecessor = null;
        TouchTarget target = this.mFirstTouchTarget;
        while (target != null) {
            TouchTarget next = target.next;
            if ((target.pointerIdBits & pointerIdBits) != 0) {
                target.pointerIdBits &= ~pointerIdBits;
                if (target.pointerIdBits == 0) {
                    if (predecessor == null) {
                        this.mFirstTouchTarget = next;
                    } else {
                        predecessor.next = next;
                    }
                    target.recycle();
                    target = next;
                    continue;
                }
            }
            predecessor = target;
            target = next;
        }
    }

    private void cancelTouchTarget(View view) {
        TouchTarget predecessor = null;
        TouchTarget target = this.mFirstTouchTarget;
        while (target != null) {
            TouchTarget next = target.next;
            if (target.child == view) {
                if (predecessor == null) {
                    this.mFirstTouchTarget = next;
                } else {
                    predecessor.next = next;
                }
                target.recycle();
                long now = SystemClock.uptimeMillis();
                MotionEvent event = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
                event.setSource(4098);
                view.dispatchTouchEvent(event);
                event.recycle();
                return;
            }
            predecessor = target;
            target = next;
        }
    }

    private static boolean canViewReceivePointerEvents(View child) {
        return (child.mViewFlags & 0xC) == 0 || child.getAnimation() != null;
    }

    private float[] getTempPoint() {
        if (this.mTempPoint == null) {
            this.mTempPoint = new float[2];
        }
        return this.mTempPoint;
    }

    protected boolean isTransformedTouchPointInView(float x, float y, View child, PointF outLocalPoint) {
        float[] point = this.getTempPoint();
        point[0] = x;
        point[1] = y;
        this.transformPointToViewLocal(point, child);
        boolean isInView = child.pointInView(point[0], point[1]);
        if (isInView && outLocalPoint != null) {
            outLocalPoint.set(point[0], point[1]);
        }
        return isInView;
    }

    public void transformPointToViewLocal(float[] point, View child) {
        point[0] = point[0] + (float)(this.mScrollX - child.mLeft);
        point[1] = point[1] + (float)(this.mScrollY - child.mTop);
        if (!child.hasIdentityMatrix()) {
            child.getInverseMatrix().mapPoints(point);
        }
    }

    private boolean dispatchTransformedTouchEvent(MotionEvent event, boolean cancel, View child, int desiredPointerIdBits) {
        boolean handled;
        MotionEvent transformedEvent;
        int oldAction = event.getAction();
        if (cancel || oldAction == 3) {
            event.setAction(3);
            boolean handled2 = child == null ? super.dispatchTouchEvent(event) : child.dispatchTouchEvent(event);
            event.setAction(oldAction);
            return handled2;
        }
        int oldPointerIdBits = event.getPointerIdBits();
        int newPointerIdBits = oldPointerIdBits & desiredPointerIdBits;
        if (newPointerIdBits == 0) {
            return false;
        }
        if (newPointerIdBits == oldPointerIdBits) {
            if (child == null || child.hasIdentityMatrix()) {
                boolean handled3;
                if (child == null) {
                    handled3 = super.dispatchTouchEvent(event);
                } else {
                    float offsetX = this.mScrollX - child.mLeft;
                    float offsetY = this.mScrollY - child.mTop;
                    event.offsetLocation(offsetX, offsetY);
                    handled3 = child.dispatchTouchEvent(event);
                    event.offsetLocation(-offsetX, -offsetY);
                }
                return handled3;
            }
            transformedEvent = MotionEvent.obtain(event);
        } else {
            transformedEvent = event.split(newPointerIdBits);
        }
        if (child == null) {
            handled = super.dispatchTouchEvent(transformedEvent);
        } else {
            float offsetX = this.mScrollX - child.mLeft;
            float offsetY = this.mScrollY - child.mTop;
            transformedEvent.offsetLocation(offsetX, offsetY);
            if (!child.hasIdentityMatrix()) {
                transformedEvent.transform(child.getInverseMatrix());
            }
            handled = child.dispatchTouchEvent(transformedEvent);
        }
        transformedEvent.recycle();
        return handled;
    }

    public void setMotionEventSplittingEnabled(boolean split) {
        this.mGroupFlags = split ? (this.mGroupFlags |= 0x200000) : (this.mGroupFlags &= 0xFFDFFFFF);
    }

    public boolean isMotionEventSplittingEnabled() {
        return (this.mGroupFlags & 0x200000) == 0x200000;
    }

    public boolean isTransitionGroup() {
        if ((this.mGroupFlags & 0x2000000) != 0) {
            return (this.mGroupFlags & 0x1000000) != 0;
        }
        ViewOutlineProvider outlineProvider = this.getOutlineProvider();
        return this.getBackground() != null || this.getTransitionName() != null || outlineProvider != null && outlineProvider != ViewOutlineProvider.BACKGROUND;
    }

    public void setTransitionGroup(boolean isTransitionGroup) {
        this.mGroupFlags |= 0x2000000;
        this.mGroupFlags = isTransitionGroup ? (this.mGroupFlags |= 0x1000000) : (this.mGroupFlags &= 0xFEFFFFFF);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept == ((this.mGroupFlags & 0x80000) != 0)) {
            return;
        }
        this.mGroupFlags = disallowIntercept ? (this.mGroupFlags |= 0x80000) : (this.mGroupFlags &= 0xFFF7FFFF);
        if (this.mParent != null) {
            this.mParent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return ev.isFromSource(8194) && ev.getAction() == 0 && ev.isButtonPressed(1) && this.isOnScrollbarThumb(ev.getX(), ev.getY());
    }

    @Override
    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        int descendantFocusability = this.getDescendantFocusability();
        switch (descendantFocusability) {
            case 393216: {
                return super.requestFocus(direction, previouslyFocusedRect);
            }
            case 131072: {
                boolean took = super.requestFocus(direction, previouslyFocusedRect);
                return took ? took : this.onRequestFocusInDescendants(direction, previouslyFocusedRect);
            }
            case 262144: {
                boolean took = this.onRequestFocusInDescendants(direction, previouslyFocusedRect);
                return took ? took : super.requestFocus(direction, previouslyFocusedRect);
            }
        }
        throw new IllegalStateException("descendant focusability must be one of FOCUS_BEFORE_DESCENDANTS, FOCUS_AFTER_DESCENDANTS, FOCUS_BLOCK_DESCENDANTS but is " + descendantFocusability);
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        int end;
        int increment;
        int index;
        int count = this.mChildrenCount;
        if ((direction & 2) != 0) {
            index = 0;
            increment = 1;
            end = count;
        } else {
            index = count - 1;
            increment = -1;
            end = -1;
        }
        View[] children = this.mChildren;
        for (int i = index; i != end; i += increment) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 || !child.requestFocus(direction, previouslyFocusedRect)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean restoreDefaultFocus() {
        if (this.mDefaultFocus != null && this.getDescendantFocusability() != 393216 && (this.mDefaultFocus.mViewFlags & 0xC) == 0 && this.mDefaultFocus.restoreDefaultFocus()) {
            return true;
        }
        return super.restoreDefaultFocus();
    }

    @Override
    public boolean restoreFocusInCluster(int direction) {
        if (this.mFocusedInCluster != null && !this.mFocusedInCluster.isKeyboardNavigationCluster() && this.getDescendantFocusability() != 393216 && (this.mFocusedInCluster.mViewFlags & 0xC) == 0 && this.mFocusedInCluster.restoreFocusInCluster(direction)) {
            return true;
        }
        return super.restoreFocusInCluster(direction);
    }

    @Override
    public boolean restoreFocusNotInCluster() {
        if (this.mFocusedInCluster != null) {
            return this.restoreFocusInCluster(130);
        }
        if (this.isKeyboardNavigationCluster()) {
            return false;
        }
        int descendentFocusability = this.getDescendantFocusability();
        if (descendentFocusability == 393216) {
            return super.requestFocus(130, null);
        }
        if (descendentFocusability == 131072 && super.requestFocus(130, null)) {
            return true;
        }
        for (int i = 0; i < this.mChildrenCount; ++i) {
            View child = this.mChildren[i];
            if (child.isKeyboardNavigationCluster() || !child.restoreFocusNotInCluster()) continue;
            return true;
        }
        if (descendentFocusability == 262144) {
            return super.requestFocus(130, null);
        }
        return false;
    }

    @Override
    public void dispatchStartTemporaryDetach() {
        super.dispatchStartTemporaryDetach();
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchStartTemporaryDetach();
        }
    }

    @Override
    public void dispatchFinishTemporaryDetach() {
        super.dispatchFinishTemporaryDetach();
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchFinishTemporaryDetach();
        }
    }

    @Override
    void dispatchAttachedToWindow(View.AttachInfo info, int visibility) {
        this.mGroupFlags |= 0x400000;
        super.dispatchAttachedToWindow(info, visibility);
        this.mGroupFlags &= 0xFFBFFFFF;
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            child.dispatchAttachedToWindow(info, this.combineVisibility(visibility, child.getVisibility()));
        }
        int transientCount = this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
        for (int i = 0; i < transientCount; ++i) {
            View view = this.mTransientViews.get(i);
            view.dispatchAttachedToWindow(info, this.combineVisibility(visibility, view.getVisibility()));
        }
    }

    @Override
    void dispatchScreenStateChanged(int screenState) {
        super.dispatchScreenStateChanged(screenState);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchScreenStateChanged(screenState);
        }
    }

    @Override
    void dispatchMovedToDisplay(Display display) {
        super.dispatchMovedToDisplay(display);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchMovedToDisplay(display);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        boolean handled = false;
        if (this.includeForAccessibility() && (handled = super.dispatchPopulateAccessibilityEventInternal(event))) {
            return handled;
        }
        ChildListForAccessibility children = ChildListForAccessibility.obtain(this, true);
        try {
            int childCount = children.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = children.getChildAt(i);
                if ((child.mViewFlags & 0xC) != 0 || !(handled = child.dispatchPopulateAccessibilityEvent(event))) continue;
                boolean bl = handled;
                return bl;
            }
        }
        finally {
            children.recycle();
        }
        return false;
    }

    @Override
    public void dispatchProvideStructure(ViewStructure structure) {
        super.dispatchProvideStructure(structure);
        this.dispatchProvideStructureForAssistOrAutoFill(structure, false);
    }

    @Override
    public void dispatchProvideAutoFillStructure(ViewStructure structure, int flags) {
        super.dispatchProvideAutoFillStructure(structure, flags);
        this.dispatchProvideStructureForAssistOrAutoFill(structure, true);
    }

    private void dispatchProvideStructureForAssistOrAutoFill(ViewStructure structure, boolean forAutoFill) {
        int childrenCount;
        boolean blocked;
        boolean bl = blocked = forAutoFill ? this.isAutoFillBlocked() : this.isAssistBlocked();
        if (!blocked && structure.getChildCount() == 0 && (childrenCount = this.getChildCount()) > 0) {
            structure.setChildCount(childrenCount);
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = 0; i < childrenCount; ++i) {
                int childIndex;
                try {
                    childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                }
                catch (IndexOutOfBoundsException e) {
                    childIndex = i;
                    if (this.mContext.getApplicationInfo().targetSdkVersion < 23) {
                        Log.w(TAG, "Bad getChildDrawingOrder while collecting assist @ " + i + " of " + childrenCount, e);
                        customOrder = false;
                        if (i > 0) {
                            int j;
                            int[] permutation = new int[childrenCount];
                            SparseBooleanArray usedIndices = new SparseBooleanArray();
                            for (int j2 = 0; j2 < i; ++j2) {
                                permutation[j2] = this.getChildDrawingOrder(childrenCount, j2);
                                usedIndices.put(permutation[j2], true);
                            }
                            int nextIndex = 0;
                            for (j = i; j < childrenCount; ++j) {
                                while (usedIndices.get(nextIndex, false)) {
                                    ++nextIndex;
                                }
                                permutation[j] = nextIndex++;
                            }
                            preorderedList = new ArrayList(childrenCount);
                            for (j = 0; j < childrenCount; ++j) {
                                preorderedList.add(children[permutation[j]]);
                            }
                        }
                    }
                    throw e;
                }
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                ViewStructure cstructure = structure.newChild(i);
                if (forAutoFill) {
                    child.dispatchProvideAutoFillStructure(cstructure, 0);
                    continue;
                }
                child.dispatchProvideStructure(cstructure);
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
    }

    private static View getAndVerifyPreorderedView(ArrayList<View> preorderedList, View[] children, int childIndex) {
        View child;
        if (preorderedList != null) {
            child = preorderedList.get(childIndex);
            if (child == null) {
                throw new RuntimeException("Invalid preorderedList contained null child at index " + childIndex);
            }
        } else {
            child = children[childIndex];
        }
        return child;
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.getAccessibilityNodeProvider() != null) {
            return;
        }
        if (this.mAttachInfo != null) {
            ArrayList<View> childrenForAccessibility = this.mAttachInfo.mTempArrayList;
            childrenForAccessibility.clear();
            this.addChildrenForAccessibility(childrenForAccessibility);
            int childrenForAccessibilityCount = childrenForAccessibility.size();
            for (int i = 0; i < childrenForAccessibilityCount; ++i) {
                View child = childrenForAccessibility.get(i);
                info.addChildUnchecked(child);
            }
            childrenForAccessibility.clear();
        }
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return ViewGroup.class.getName();
    }

    @Override
    public void notifySubtreeAccessibilityStateChanged(View child, View source, int changeType) {
        if (this.getAccessibilityLiveRegion() != 0) {
            this.notifyViewAccessibilityStateChangedIfNeeded(changeType);
        } else if (this.mParent != null) {
            try {
                this.mParent.notifySubtreeAccessibilityStateChanged(this, source, changeType);
            }
            catch (AbstractMethodError e) {
                Log.e("View", this.mParent.getClass().getSimpleName() + " does not fully implement ViewParent", e);
            }
        }
    }

    @Override
    public void notifySubtreeAccessibilityStateChangedIfNeeded() {
        ViewParent a11yParent;
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled() || this.mAttachInfo == null) {
            return;
        }
        if (this.getImportantForAccessibility() != 4 && !this.isImportantForAccessibility() && this.getChildCount() > 0 && (a11yParent = this.getParentForAccessibility()) instanceof View) {
            ((View)((Object)a11yParent)).notifySubtreeAccessibilityStateChangedIfNeeded();
            return;
        }
        super.notifySubtreeAccessibilityStateChangedIfNeeded();
    }

    @Override
    void resetSubtreeAccessibilityStateChanged() {
        super.resetSubtreeAccessibilityStateChanged();
        View[] children = this.mChildren;
        int childCount = this.mChildrenCount;
        for (int i = 0; i < childCount; ++i) {
            children[i].resetSubtreeAccessibilityStateChanged();
        }
    }

    int getNumChildrenForAccessibility() {
        int numChildrenForAccessibility = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.includeForAccessibility()) {
                ++numChildrenForAccessibility;
                continue;
            }
            if (!(child instanceof ViewGroup)) continue;
            numChildrenForAccessibility += ((ViewGroup)child).getNumChildrenForAccessibility();
        }
        return numChildrenForAccessibility;
    }

    @Override
    public boolean onNestedPrePerformAccessibilityAction(View target, int action, Bundle args) {
        return false;
    }

    @Override
    void dispatchDetachedFromWindow() {
        this.cancelAndClearTouchTargets(null);
        this.exitHoverTargets();
        this.exitTooltipHoverTargets();
        this.mLayoutCalledWhileSuppressed = false;
        this.mChildrenInterestedInDrag = null;
        this.mIsInterestedInDrag = false;
        if (this.mCurrentDragStartEvent != null) {
            this.mCurrentDragStartEvent.recycle();
            this.mCurrentDragStartEvent = null;
        }
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchDetachedFromWindow();
        }
        this.clearDisappearingChildren();
        int transientCount = this.mTransientViews == null ? 0 : this.mTransientIndices.size();
        for (int i = 0; i < transientCount; ++i) {
            View view = this.mTransientViews.get(i);
            view.dispatchDetachedFromWindow();
        }
        super.dispatchDetachedFromWindow();
    }

    @Override
    protected void internalSetPadding(int left, int top, int right, int bottom) {
        super.internalSetPadding(left, top, right, bottom);
        this.mGroupFlags = (this.mPaddingLeft | this.mPaddingTop | this.mPaddingRight | this.mPaddingBottom) != 0 ? (this.mGroupFlags |= 0x20) : (this.mGroupFlags &= 0xFFFFFFDF);
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        super.dispatchSaveInstanceState(container);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View c = children[i];
            if ((c.mViewFlags & 0x20000000) == 0x20000000) continue;
            c.dispatchSaveInstanceState(container);
        }
    }

    protected void dispatchFreezeSelfOnly(SparseArray<Parcelable> container) {
        super.dispatchSaveInstanceState(container);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        super.dispatchRestoreInstanceState(container);
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View c = children[i];
            if ((c.mViewFlags & 0x20000000) == 0x20000000) continue;
            c.dispatchRestoreInstanceState(container);
        }
    }

    protected void dispatchThawSelfOnly(SparseArray<Parcelable> container) {
        super.dispatchRestoreInstanceState(container);
    }

    protected void setChildrenDrawingCacheEnabled(boolean enabled) {
        if (enabled || (this.mPersistentDrawingCache & 3) != 3) {
            View[] children = this.mChildren;
            int count = this.mChildrenCount;
            for (int i = 0; i < count; ++i) {
                children[i].setDrawingCacheEnabled(enabled);
            }
        }
    }

    @Override
    public Bitmap createSnapshot(Bitmap.Config quality, int backgroundColor, boolean skipChildren) {
        int count = this.mChildrenCount;
        int[] visibilities = null;
        if (skipChildren) {
            visibilities = new int[count];
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                visibilities[i] = child.getVisibility();
                if (visibilities[i] != 0) continue;
                child.mViewFlags = child.mViewFlags & 0xFFFFFFF3 | 4;
            }
        }
        Bitmap b = super.createSnapshot(quality, backgroundColor, skipChildren);
        if (skipChildren) {
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                child.mViewFlags = child.mViewFlags & 0xFFFFFFF3 | visibilities[i] & 0xC;
            }
        }
        return b;
    }

    boolean isLayoutModeOptical() {
        return this.mLayoutMode == 1;
    }

    @Override
    Insets computeOpticalInsets() {
        if (this.isLayoutModeOptical()) {
            int left = 0;
            int top = 0;
            int right = 0;
            int bottom = 0;
            for (int i = 0; i < this.mChildrenCount; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                Insets insets = child.getOpticalInsets();
                left = Math.max(left, insets.left);
                top = Math.max(top, insets.top);
                right = Math.max(right, insets.right);
                bottom = Math.max(bottom, insets.bottom);
            }
            return Insets.of(left, top, right, bottom);
        }
        return Insets.NONE;
    }

    private static void fillRect(Canvas canvas, Paint paint, int x1, int y1, int x2, int y2) {
        if (x1 != x2 && y1 != y2) {
            int tmp;
            if (x1 > x2) {
                tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (y1 > y2) {
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            canvas.drawRect(x1, y1, x2, y2, paint);
        }
    }

    private static int sign(int x) {
        return x >= 0 ? 1 : -1;
    }

    private static void drawCorner(Canvas c, Paint paint, int x1, int y1, int dx, int dy, int lw) {
        ViewGroup.fillRect(c, paint, x1, y1, x1 + dx, y1 + lw * ViewGroup.sign(dy));
        ViewGroup.fillRect(c, paint, x1, y1, x1 + lw * ViewGroup.sign(dx), y1 + dy);
    }

    private static void drawRectCorners(Canvas canvas, int x1, int y1, int x2, int y2, Paint paint, int lineLength, int lineWidth) {
        ViewGroup.drawCorner(canvas, paint, x1, y1, lineLength, lineLength, lineWidth);
        ViewGroup.drawCorner(canvas, paint, x1, y2, lineLength, -lineLength, lineWidth);
        ViewGroup.drawCorner(canvas, paint, x2, y1, -lineLength, lineLength, lineWidth);
        ViewGroup.drawCorner(canvas, paint, x2, y2, -lineLength, -lineLength, lineWidth);
    }

    private static void fillDifference(Canvas canvas, int x2, int y2, int x3, int y3, int dx1, int dy1, int dx2, int dy2, Paint paint) {
        int x1 = x2 - dx1;
        int y1 = y2 - dy1;
        int x4 = x3 + dx2;
        int y4 = y3 + dy2;
        ViewGroup.fillRect(canvas, paint, x1, y1, x4, y2);
        ViewGroup.fillRect(canvas, paint, x1, y2, x2, y3);
        ViewGroup.fillRect(canvas, paint, x3, y2, x4, y3);
        ViewGroup.fillRect(canvas, paint, x1, y3, x4, y4);
    }

    protected void onDebugDrawMargins(Canvas canvas, Paint paint) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View c = this.getChildAt(i);
            c.getLayoutParams().onDebugDraw(c, canvas, paint);
        }
    }

    protected void onDebugDraw(Canvas canvas) {
        Paint paint = ViewGroup.getDebugPaint();
        paint.setColor(-65536);
        paint.setStyle(Paint.Style.STROKE);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View c = this.getChildAt(i);
            if (c.getVisibility() == 8) continue;
            Insets insets = c.getOpticalInsets();
            ViewGroup.drawRect(canvas, paint, c.getLeft() + insets.left, c.getTop() + insets.top, c.getRight() - insets.right - 1, c.getBottom() - insets.bottom - 1);
        }
        paint.setColor(Color.argb(63, 255, 0, 255));
        paint.setStyle(Paint.Style.FILL);
        this.onDebugDrawMargins(canvas, paint);
        paint.setColor(DEBUG_CORNERS_COLOR);
        paint.setStyle(Paint.Style.FILL);
        int lineLength = this.dipsToPixels(8);
        int lineWidth = this.dipsToPixels(1);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View c = this.getChildAt(i);
            if (c.getVisibility() == 8) continue;
            ViewGroup.drawRectCorners(canvas, c.getLeft(), c.getTop(), c.getRight(), c.getBottom(), paint, lineLength, lineWidth);
        }
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        boolean clipToPadding;
        boolean usingRenderNodeProperties = canvas.isRecordingFor(this.mRenderNode);
        int childrenCount = this.mChildrenCount;
        View[] children = this.mChildren;
        int flags = this.mGroupFlags;
        if ((flags & 8) != 0 && this.canAnimate()) {
            boolean buildCache = !this.isHardwareAccelerated();
            for (int i = 0; i < childrenCount; ++i) {
                View child = children[i];
                if ((child.mViewFlags & 0xC) != 0) continue;
                LayoutParams params = child.getLayoutParams();
                this.attachLayoutAnimationParameters(child, params, i, childrenCount);
                this.bindLayoutAnimation(child);
            }
            LayoutAnimationController controller = this.mLayoutAnimationController;
            if (controller.willOverlap()) {
                this.mGroupFlags |= 0x80;
            }
            controller.start();
            this.mGroupFlags &= 0xFFFFFFF7;
            this.mGroupFlags &= 0xFFFFFFEF;
            if (this.mAnimationListener != null) {
                this.mAnimationListener.onAnimationStart(controller.getAnimation());
            }
        }
        int clipSaveCount = 0;
        boolean bl = clipToPadding = (flags & 0x22) == 34;
        if (clipToPadding) {
            clipSaveCount = canvas.save(2);
            canvas.clipRect(this.mScrollX + this.mPaddingLeft, this.mScrollY + this.mPaddingTop, this.mScrollX + this.mRight - this.mLeft - this.mPaddingRight, this.mScrollY + this.mBottom - this.mTop - this.mPaddingBottom);
        }
        this.mPrivateFlags &= 0xFFFFFFBF;
        this.mGroupFlags &= 0xFFFFFFFB;
        boolean more = false;
        long drawingTime = this.getDrawingTime();
        if (usingRenderNodeProperties) {
            canvas.insertReorderBarrier();
        }
        int transientCount = this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
        int transientIndex = transientCount != 0 ? 0 : -1;
        ArrayList<View> preorderedList = usingRenderNodeProperties ? null : this.buildOrderedChildList();
        boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
        for (int i = 0; i < childrenCount; ++i) {
            while (transientIndex >= 0 && this.mTransientIndices.get(transientIndex) == i) {
                View transientChild = this.mTransientViews.get(transientIndex);
                if ((transientChild.mViewFlags & 0xC) == 0 || transientChild.getAnimation() != null) {
                    more |= this.drawChild(canvas, transientChild, drawingTime);
                }
                if (++transientIndex < transientCount) continue;
                transientIndex = -1;
            }
            int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
            View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
            if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null) continue;
            more |= this.drawChild(canvas, child, drawingTime);
        }
        while (transientIndex >= 0) {
            View transientChild = this.mTransientViews.get(transientIndex);
            if ((transientChild.mViewFlags & 0xC) == 0 || transientChild.getAnimation() != null) {
                more |= this.drawChild(canvas, transientChild, drawingTime);
            }
            if (++transientIndex < transientCount) continue;
            break;
        }
        if (preorderedList != null) {
            preorderedList.clear();
        }
        if (this.mDisappearingChildren != null) {
            int disappearingCount;
            ArrayList<View> disappearingChildren = this.mDisappearingChildren;
            for (int i = disappearingCount = disappearingChildren.size() - 1; i >= 0; --i) {
                View child = disappearingChildren.get(i);
                more |= this.drawChild(canvas, child, drawingTime);
            }
        }
        if (usingRenderNodeProperties) {
            canvas.insertInorderBarrier();
        }
        if (this.debugDraw()) {
            this.onDebugDraw(canvas);
        }
        if (clipToPadding) {
            canvas.restoreToCount(clipSaveCount);
        }
        if (((flags = this.mGroupFlags) & 4) == 4) {
            this.invalidate(true);
        }
        if ((flags & 0x10) == 0 && (flags & 0x200) == 0 && this.mLayoutAnimationController.isDone() && !more) {
            this.mGroupFlags |= 0x200;
            Runnable end = new Runnable(){

                @Override
                public void run() {
                    ViewGroup.this.notifyAnimationListener();
                }
            };
            this.post(end);
        }
    }

    @Override
    public ViewGroupOverlay getOverlay() {
        if (this.mOverlay == null) {
            this.mOverlay = new ViewGroupOverlay(this.mContext, this);
        }
        return (ViewGroupOverlay)this.mOverlay;
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        return i;
    }

    private boolean hasChildWithZ() {
        for (int i = 0; i < this.mChildrenCount; ++i) {
            if (this.mChildren[i].getZ() == 0.0f) continue;
            return true;
        }
        return false;
    }

    ArrayList<View> buildOrderedChildList() {
        int childrenCount = this.mChildrenCount;
        if (childrenCount <= 1 || !this.hasChildWithZ()) {
            return null;
        }
        if (this.mPreSortedChildren == null) {
            this.mPreSortedChildren = new ArrayList(childrenCount);
        } else {
            this.mPreSortedChildren.clear();
            this.mPreSortedChildren.ensureCapacity(childrenCount);
        }
        boolean customOrder = this.isChildrenDrawingOrderEnabled();
        for (int i = 0; i < childrenCount; ++i) {
            int insertIndex;
            int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
            View nextChild = this.mChildren[childIndex];
            float currentZ = nextChild.getZ();
            for (insertIndex = i; insertIndex > 0 && this.mPreSortedChildren.get(insertIndex - 1).getZ() > currentZ; --insertIndex) {
            }
            this.mPreSortedChildren.add(insertIndex, nextChild);
        }
        return this.mPreSortedChildren;
    }

    private void notifyAnimationListener() {
        this.mGroupFlags &= 0xFFFFFDFF;
        this.mGroupFlags |= 0x10;
        if (this.mAnimationListener != null) {
            Runnable end = new Runnable(){

                @Override
                public void run() {
                    ViewGroup.this.mAnimationListener.onAnimationEnd(ViewGroup.this.mLayoutAnimationController.getAnimation());
                }
            };
            this.post(end);
        }
        this.invalidate(true);
    }

    @Override
    protected void dispatchGetDisplayList() {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null) continue;
            this.recreateChildDisplayList(child);
        }
        if (this.mOverlay != null) {
            ViewGroup overlayView = this.mOverlay.getOverlayView();
            this.recreateChildDisplayList(overlayView);
        }
        if (this.mDisappearingChildren != null) {
            ArrayList<View> disappearingChildren = this.mDisappearingChildren;
            int disappearingCount = disappearingChildren.size();
            for (int i = 0; i < disappearingCount; ++i) {
                View child = disappearingChildren.get(i);
                this.recreateChildDisplayList(child);
            }
        }
    }

    private void recreateChildDisplayList(View child) {
        child.mRecreateDisplayList = (child.mPrivateFlags & Integer.MIN_VALUE) != 0;
        child.mPrivateFlags &= Integer.MAX_VALUE;
        child.updateDisplayListIfDirty();
        child.mRecreateDisplayList = false;
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        return child.draw(canvas, this, drawingTime);
    }

    @Override
    void getScrollIndicatorBounds(Rect out) {
        boolean clipToPadding;
        super.getScrollIndicatorBounds(out);
        boolean bl = clipToPadding = (this.mGroupFlags & 0x22) == 34;
        if (clipToPadding) {
            out.left += this.mPaddingLeft;
            out.right -= this.mPaddingRight;
            out.top += this.mPaddingTop;
            out.bottom -= this.mPaddingBottom;
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean getClipChildren() {
        return (this.mGroupFlags & 1) != 0;
    }

    public void setClipChildren(boolean clipChildren) {
        boolean previousValue;
        boolean bl = previousValue = (this.mGroupFlags & 1) == 1;
        if (clipChildren != previousValue) {
            this.setBooleanFlag(1, clipChildren);
            for (int i = 0; i < this.mChildrenCount; ++i) {
                View child = this.getChildAt(i);
                if (child.mRenderNode == null) continue;
                child.mRenderNode.setClipToBounds(clipChildren);
            }
            this.invalidate(true);
        }
    }

    public void setClipToPadding(boolean clipToPadding) {
        if (this.hasBooleanFlag(2) != clipToPadding) {
            this.setBooleanFlag(2, clipToPadding);
            this.invalidate(true);
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean getClipToPadding() {
        return this.hasBooleanFlag(2);
    }

    @Override
    public void dispatchSetSelected(boolean selected) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].setSelected(selected);
        }
    }

    @Override
    public void dispatchSetActivated(boolean activated) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].setActivated(activated);
        }
    }

    @Override
    protected void dispatchSetPressed(boolean pressed) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            View child = children[i];
            if (pressed && (child.isClickable() || child.isLongClickable())) continue;
            child.setPressed(pressed);
        }
    }

    @Override
    public void dispatchDrawableHotspotChanged(float x, float y) {
        int count = this.mChildrenCount;
        if (count == 0) {
            return;
        }
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            boolean duplicatesState;
            View child = children[i];
            boolean nonActionable = !child.isClickable() && !child.isLongClickable();
            boolean bl = duplicatesState = (child.mViewFlags & 0x400000) != 0;
            if (!nonActionable && !duplicatesState) continue;
            float[] point = this.getTempPoint();
            point[0] = x;
            point[1] = y;
            this.transformPointToViewLocal(point, child);
            child.drawableHotspotChanged(point[0], point[1]);
        }
    }

    @Override
    void dispatchCancelPendingInputEvents() {
        super.dispatchCancelPendingInputEvents();
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].dispatchCancelPendingInputEvents();
        }
    }

    protected void setStaticTransformationsEnabled(boolean enabled) {
        this.setBooleanFlag(2048, enabled);
    }

    protected boolean getChildStaticTransformation(View child, Transformation t) {
        return false;
    }

    Transformation getChildTransformation() {
        if (this.mChildTransformation == null) {
            this.mChildTransformation = new Transformation();
        }
        return this.mChildTransformation;
    }

    @Override
    protected <T extends View> T findViewTraversal(int id2) {
        if (id2 == this.mID) {
            return (T)this;
        }
        View[] where = this.mChildren;
        int len = this.mChildrenCount;
        for (int i = 0; i < len; ++i) {
            View v = where[i];
            if ((v.mPrivateFlags & 8) != 0 || (v = v.findViewById(id2)) == null) continue;
            return (T)v;
        }
        return null;
    }

    @Override
    protected <T extends View> T findViewWithTagTraversal(Object tag) {
        if (tag != null && tag.equals(this.mTag)) {
            return (T)this;
        }
        View[] where = this.mChildren;
        int len = this.mChildrenCount;
        for (int i = 0; i < len; ++i) {
            View v = where[i];
            if ((v.mPrivateFlags & 8) != 0 || (v = v.findViewWithTag(tag)) == null) continue;
            return (T)v;
        }
        return null;
    }

    @Override
    protected <T extends View> T findViewByPredicateTraversal(Predicate<View> predicate, View childToSkip) {
        if (predicate.test(this)) {
            return (T)this;
        }
        View[] where = this.mChildren;
        int len = this.mChildrenCount;
        for (int i = 0; i < len; ++i) {
            View v = where[i];
            if (v == childToSkip || (v.mPrivateFlags & 8) != 0 || (v = v.findViewByPredicate(predicate)) == null) continue;
            return (T)v;
        }
        return null;
    }

    public void addTransientView(View view, int index) {
        int oldSize;
        if (index < 0) {
            return;
        }
        if (this.mTransientIndices == null) {
            this.mTransientIndices = new ArrayList<Integer>();
            this.mTransientViews = new ArrayList<View>();
        }
        if ((oldSize = this.mTransientIndices.size()) > 0) {
            int insertionIndex;
            for (insertionIndex = 0; insertionIndex < oldSize && index >= this.mTransientIndices.get(insertionIndex); ++insertionIndex) {
            }
            this.mTransientIndices.add(insertionIndex, index);
            this.mTransientViews.add(insertionIndex, view);
        } else {
            this.mTransientIndices.add(index);
            this.mTransientViews.add(view);
        }
        view.mParent = this;
        view.dispatchAttachedToWindow(this.mAttachInfo, this.mViewFlags & 0xC);
        this.invalidate(true);
    }

    public void removeTransientView(View view) {
        if (this.mTransientViews == null) {
            return;
        }
        int size = this.mTransientViews.size();
        for (int i = 0; i < size; ++i) {
            if (view != this.mTransientViews.get(i)) continue;
            this.mTransientViews.remove(i);
            this.mTransientIndices.remove(i);
            view.mParent = null;
            view.dispatchDetachedFromWindow();
            this.invalidate(true);
            return;
        }
    }

    public int getTransientViewCount() {
        return this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
    }

    public int getTransientViewIndex(int position) {
        if (position < 0 || this.mTransientIndices == null || position >= this.mTransientIndices.size()) {
            return -1;
        }
        return this.mTransientIndices.get(position);
    }

    public View getTransientView(int position) {
        if (this.mTransientViews == null || position >= this.mTransientViews.size()) {
            return null;
        }
        return this.mTransientViews.get(position);
    }

    public void addView(View child) {
        this.addView(child, -1);
    }

    public void addView(View child, int index) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot add a null child view to a ViewGroup");
        }
        LayoutParams params = child.getLayoutParams();
        if (params == null && (params = this.generateDefaultLayoutParams()) == null) {
            throw new IllegalArgumentException("generateDefaultLayoutParams() cannot return null");
        }
        this.addView(child, index, params);
    }

    public void addView(View child, int width, int height) {
        LayoutParams params = this.generateDefaultLayoutParams();
        params.width = width;
        params.height = height;
        this.addView(child, -1, params);
    }

    @Override
    public void addView(View child, LayoutParams params) {
        this.addView(child, -1, params);
    }

    public void addView(View child, int index, LayoutParams params) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot add a null child view to a ViewGroup");
        }
        this.requestLayout();
        this.invalidate(true);
        this.addViewInner(child, index, params, false);
    }

    @Override
    public void updateViewLayout(View view, LayoutParams params) {
        if (!this.checkLayoutParams(params)) {
            throw new IllegalArgumentException("Invalid LayoutParams supplied to " + this);
        }
        if (view.mParent != this) {
            throw new IllegalArgumentException("Given view not a child of " + this);
        }
        view.setLayoutParams(params);
    }

    protected boolean checkLayoutParams(LayoutParams p) {
        return p != null;
    }

    public void setOnHierarchyChangeListener(OnHierarchyChangeListener listener) {
        this.mOnHierarchyChangeListener = listener;
    }

    void dispatchViewAdded(View child) {
        this.onViewAdded(child);
        if (this.mOnHierarchyChangeListener != null) {
            this.mOnHierarchyChangeListener.onChildViewAdded(this, child);
        }
    }

    public void onViewAdded(View child) {
    }

    void dispatchViewRemoved(View child) {
        this.onViewRemoved(child);
        if (this.mOnHierarchyChangeListener != null) {
            this.mOnHierarchyChangeListener.onChildViewRemoved(this, child);
        }
    }

    public void onViewRemoved(View child) {
    }

    private void clearCachedLayoutMode() {
        if (!this.hasBooleanFlag(0x800000)) {
            this.mLayoutMode = -1;
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.clearCachedLayoutMode();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clearCachedLayoutMode();
    }

    @Override
    protected void destroyHardwareResources() {
        super.destroyHardwareResources();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.getChildAt(i).destroyHardwareResources();
        }
    }

    protected boolean addViewInLayout(View child, int index, LayoutParams params) {
        return this.addViewInLayout(child, index, params, false);
    }

    protected boolean addViewInLayout(View child, int index, LayoutParams params, boolean preventRequestLayout) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot add a null child view to a ViewGroup");
        }
        child.mParent = null;
        this.addViewInner(child, index, params, preventRequestLayout);
        child.mPrivateFlags = child.mPrivateFlags & 0xFF9FFFFF | 0x20;
        return true;
    }

    protected void cleanupLayoutState(View child) {
        child.mPrivateFlags &= 0xFFFFEFFF;
    }

    private void addViewInner(View child, int index, LayoutParams params, boolean preventRequestLayout) {
        View.AttachInfo ai;
        if (this.mTransition != null) {
            this.mTransition.cancel(3);
        }
        if (child.getParent() != null) {
            throw new IllegalStateException("The specified child already has a parent. You must call removeView() on the child's parent first.");
        }
        if (this.mTransition != null) {
            this.mTransition.addChild(this, child);
        }
        if (!this.checkLayoutParams(params)) {
            params = this.generateLayoutParams(params);
        }
        if (preventRequestLayout) {
            child.mLayoutParams = params;
        } else {
            child.setLayoutParams(params);
        }
        if (index < 0) {
            index = this.mChildrenCount;
        }
        this.addInArray(child, index);
        if (preventRequestLayout) {
            child.assignParent(this);
        } else {
            child.mParent = this;
        }
        if (child.hasFocus()) {
            this.requestChildFocus(child, child.findFocus());
        }
        if ((ai = this.mAttachInfo) != null && (this.mGroupFlags & 0x400000) == 0) {
            boolean lastKeepOn = ai.mKeepScreenOn;
            ai.mKeepScreenOn = false;
            child.dispatchAttachedToWindow(this.mAttachInfo, this.mViewFlags & 0xC);
            if (ai.mKeepScreenOn) {
                this.needGlobalAttributesUpdate(true);
            }
            ai.mKeepScreenOn = lastKeepOn;
        }
        if (child.isLayoutDirectionInherited()) {
            child.resetRtlProperties();
        }
        this.dispatchViewAdded(child);
        if ((child.mViewFlags & 0x400000) == 0x400000) {
            this.mGroupFlags |= 0x10000;
        }
        if (child.hasTransientState()) {
            this.childHasTransientStateChanged(child, true);
        }
        if (child.getVisibility() != 8) {
            this.notifySubtreeAccessibilityStateChangedIfNeeded();
        }
        if (this.mTransientIndices != null) {
            int transientCount = this.mTransientIndices.size();
            for (int i = 0; i < transientCount; ++i) {
                int oldIndex = this.mTransientIndices.get(i);
                if (index > oldIndex) continue;
                this.mTransientIndices.set(i, oldIndex + 1);
            }
        }
        if (this.mCurrentDragStartEvent != null && child.getVisibility() == 0) {
            this.notifyChildOfDragStart(child);
        }
        if (child.hasDefaultFocus()) {
            this.setDefaultFocus(child);
        }
    }

    private void addInArray(View child, int index) {
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        int size = children.length;
        if (index == count) {
            if (size == count) {
                this.mChildren = new View[size + 12];
                System.arraycopy(children, 0, this.mChildren, 0, size);
                children = this.mChildren;
            }
            children[this.mChildrenCount++] = child;
        } else if (index < count) {
            if (size == count) {
                this.mChildren = new View[size + 12];
                System.arraycopy(children, 0, this.mChildren, 0, index);
                System.arraycopy(children, index, this.mChildren, index + 1, count - index);
                children = this.mChildren;
            } else {
                System.arraycopy(children, index, children, index + 1, count - index);
            }
            children[index] = child;
            ++this.mChildrenCount;
            if (this.mLastTouchDownIndex >= index) {
                ++this.mLastTouchDownIndex;
            }
        } else {
            throw new IndexOutOfBoundsException("index=" + index + " count=" + count);
        }
    }

    private void removeFromArray(int index) {
        int count;
        View[] children = this.mChildren;
        if (this.mTransitioningViews == null || !this.mTransitioningViews.contains(children[index])) {
            children[index].mParent = null;
        }
        if (index == (count = this.mChildrenCount--) - 1) {
            children[this.mChildrenCount] = null;
        } else if (index >= 0 && index < count) {
            System.arraycopy(children, index + 1, children, index, count - index - 1);
            children[--this.mChildrenCount] = null;
        } else {
            throw new IndexOutOfBoundsException();
        }
        if (this.mLastTouchDownIndex == index) {
            this.mLastTouchDownTime = 0L;
            this.mLastTouchDownIndex = -1;
        } else if (this.mLastTouchDownIndex > index) {
            --this.mLastTouchDownIndex;
        }
    }

    private void removeFromArray(int start, int count) {
        int end;
        View[] children = this.mChildren;
        int childrenCount = this.mChildrenCount;
        if ((start = Math.max(0, start)) == (end = Math.min(childrenCount, start + count))) {
            return;
        }
        if (end == childrenCount) {
            for (int i = start; i < end; ++i) {
                children[i].mParent = null;
                children[i] = null;
            }
        } else {
            int i;
            for (i = start; i < end; ++i) {
                children[i].mParent = null;
            }
            System.arraycopy(children, end, children, start, childrenCount - end);
            for (i = childrenCount - (end - start); i < childrenCount; ++i) {
                children[i] = null;
            }
        }
        this.mChildrenCount -= end - start;
    }

    private void bindLayoutAnimation(View child) {
        Animation a = this.mLayoutAnimationController.getAnimationForView(child);
        child.setAnimation(a);
    }

    protected void attachLayoutAnimationParameters(View child, LayoutParams params, int index, int count) {
        LayoutAnimationController.AnimationParameters animationParams = params.layoutAnimationParameters;
        if (animationParams == null) {
            params.layoutAnimationParameters = animationParams = new LayoutAnimationController.AnimationParameters();
        }
        animationParams.count = count;
        animationParams.index = index;
    }

    @Override
    public void removeView(View view) {
        if (this.removeViewInternal(view)) {
            this.requestLayout();
            this.invalidate(true);
        }
    }

    public void removeViewInLayout(View view) {
        this.removeViewInternal(view);
    }

    public void removeViewsInLayout(int start, int count) {
        this.removeViewsInternal(start, count);
    }

    public void removeViewAt(int index) {
        this.removeViewInternal(index, this.getChildAt(index));
        this.requestLayout();
        this.invalidate(true);
    }

    public void removeViews(int start, int count) {
        this.removeViewsInternal(start, count);
        this.requestLayout();
        this.invalidate(true);
    }

    private boolean removeViewInternal(View view) {
        int index = this.indexOfChild(view);
        if (index >= 0) {
            this.removeViewInternal(index, view);
            return true;
        }
        return false;
    }

    private void removeViewInternal(int index, View view) {
        if (this.mTransition != null) {
            this.mTransition.removeChild(this, view);
        }
        boolean clearChildFocus = false;
        if (view == this.mFocused) {
            view.unFocus(null);
            clearChildFocus = true;
        }
        if (view == this.mFocusedInCluster) {
            this.clearFocusInCluster(view);
        }
        view.clearAccessibilityFocus();
        this.cancelTouchTarget(view);
        this.cancelHoverTarget(view);
        if (view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
            this.addDisappearingView(view);
        } else if (view.mAttachInfo != null) {
            view.dispatchDetachedFromWindow();
        }
        if (view.hasTransientState()) {
            this.childHasTransientStateChanged(view, false);
        }
        this.needGlobalAttributesUpdate(false);
        this.removeFromArray(index);
        if (view == this.mDefaultFocus) {
            this.clearDefaultFocus(view);
        }
        if (clearChildFocus) {
            this.clearChildFocus(view);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(this);
            }
        }
        this.dispatchViewRemoved(view);
        if (view.getVisibility() != 8) {
            this.notifySubtreeAccessibilityStateChangedIfNeeded();
        }
        int transientCount = this.mTransientIndices == null ? 0 : this.mTransientIndices.size();
        for (int i = 0; i < transientCount; ++i) {
            int oldIndex = this.mTransientIndices.get(i);
            if (index >= oldIndex) continue;
            this.mTransientIndices.set(i, oldIndex - 1);
        }
        if (this.mCurrentDragStartEvent != null) {
            this.mChildrenInterestedInDrag.remove(view);
        }
    }

    public void setLayoutTransition(LayoutTransition transition2) {
        if (this.mTransition != null) {
            LayoutTransition previousTransition = this.mTransition;
            previousTransition.cancel();
            previousTransition.removeTransitionListener(this.mLayoutTransitionListener);
        }
        this.mTransition = transition2;
        if (this.mTransition != null) {
            this.mTransition.addTransitionListener(this.mLayoutTransitionListener);
        }
    }

    public LayoutTransition getLayoutTransition() {
        return this.mTransition;
    }

    private void removeViewsInternal(int start, int count) {
        int end = start + count;
        if (start < 0 || count < 0 || end > this.mChildrenCount) {
            throw new IndexOutOfBoundsException();
        }
        View focused = this.mFocused;
        boolean detach = this.mAttachInfo != null;
        boolean clearChildFocus = false;
        View clearDefaultFocus = null;
        View[] children = this.mChildren;
        for (int i = start; i < end; ++i) {
            View view = children[i];
            if (this.mTransition != null) {
                this.mTransition.removeChild(this, view);
            }
            if (view == focused) {
                view.unFocus(null);
                clearChildFocus = true;
            }
            if (view == this.mDefaultFocus) {
                clearDefaultFocus = view;
            }
            if (view == this.mFocusedInCluster) {
                this.clearFocusInCluster(view);
            }
            view.clearAccessibilityFocus();
            this.cancelTouchTarget(view);
            this.cancelHoverTarget(view);
            if (view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
                this.addDisappearingView(view);
            } else if (detach) {
                view.dispatchDetachedFromWindow();
            }
            if (view.hasTransientState()) {
                this.childHasTransientStateChanged(view, false);
            }
            this.needGlobalAttributesUpdate(false);
            this.dispatchViewRemoved(view);
        }
        this.removeFromArray(start, count);
        if (clearDefaultFocus != null) {
            this.clearDefaultFocus(clearDefaultFocus);
        }
        if (clearChildFocus) {
            this.clearChildFocus(focused);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(focused);
            }
        }
    }

    public void removeAllViews() {
        this.removeAllViewsInLayout();
        this.requestLayout();
        this.invalidate(true);
    }

    public void removeAllViewsInLayout() {
        int count = this.mChildrenCount;
        if (count <= 0) {
            return;
        }
        View[] children = this.mChildren;
        this.mChildrenCount = 0;
        View focused = this.mFocused;
        boolean detach = this.mAttachInfo != null;
        boolean clearChildFocus = false;
        this.needGlobalAttributesUpdate(false);
        for (int i = count - 1; i >= 0; --i) {
            View view = children[i];
            if (this.mTransition != null) {
                this.mTransition.removeChild(this, view);
            }
            if (view == focused) {
                view.unFocus(null);
                clearChildFocus = true;
            }
            view.clearAccessibilityFocus();
            this.cancelTouchTarget(view);
            this.cancelHoverTarget(view);
            if (view.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(view)) {
                this.addDisappearingView(view);
            } else if (detach) {
                view.dispatchDetachedFromWindow();
            }
            if (view.hasTransientState()) {
                this.childHasTransientStateChanged(view, false);
            }
            this.dispatchViewRemoved(view);
            view.mParent = null;
            children[i] = null;
        }
        if (this.mDefaultFocus != null) {
            this.clearDefaultFocus(this.mDefaultFocus);
        }
        if (clearChildFocus) {
            this.clearChildFocus(focused);
            if (!this.rootViewRequestFocus()) {
                this.notifyGlobalFocusCleared(focused);
            }
        }
    }

    protected void removeDetachedView(View child, boolean animate) {
        if (this.mTransition != null) {
            this.mTransition.removeChild(this, child);
        }
        if (child == this.mFocused) {
            child.clearFocus();
        }
        if (child == this.mDefaultFocus) {
            this.clearDefaultFocus(child);
        }
        if (child == this.mFocusedInCluster) {
            this.clearFocusInCluster(child);
        }
        child.clearAccessibilityFocus();
        this.cancelTouchTarget(child);
        this.cancelHoverTarget(child);
        if (animate && child.getAnimation() != null || this.mTransitioningViews != null && this.mTransitioningViews.contains(child)) {
            this.addDisappearingView(child);
        } else if (child.mAttachInfo != null) {
            child.dispatchDetachedFromWindow();
        }
        if (child.hasTransientState()) {
            this.childHasTransientStateChanged(child, false);
        }
        this.dispatchViewRemoved(child);
    }

    protected void attachViewToParent(View child, int index, LayoutParams params) {
        child.mLayoutParams = params;
        if (index < 0) {
            index = this.mChildrenCount;
        }
        this.addInArray(child, index);
        child.mParent = this;
        child.mPrivateFlags = child.mPrivateFlags & 0xFF9FFFFF & 0xFFFF7FFF | 0x20 | Integer.MIN_VALUE;
        this.mPrivateFlags |= Integer.MIN_VALUE;
        if (child.hasFocus()) {
            this.requestChildFocus(child, child.findFocus());
        }
        this.dispatchVisibilityAggregated(this.isAttachedToWindow() && this.getWindowVisibility() == 0 && this.isShown());
    }

    protected void detachViewFromParent(View child) {
        this.removeFromArray(this.indexOfChild(child));
    }

    protected void detachViewFromParent(int index) {
        this.removeFromArray(index);
    }

    protected void detachViewsFromParent(int start, int count) {
        this.removeFromArray(start, count);
    }

    protected void detachAllViewsFromParent() {
        int count = this.mChildrenCount;
        if (count <= 0) {
            return;
        }
        View[] children = this.mChildren;
        this.mChildrenCount = 0;
        for (int i = count - 1; i >= 0; --i) {
            children[i].mParent = null;
            children[i] = null;
        }
    }

    @Override
    public void onDescendantInvalidated(View child, View target) {
        this.mPrivateFlags |= target.mPrivateFlags & 0x40;
        if ((target.mPrivateFlags & 0xFF9FFFFF) != 0) {
            this.mPrivateFlags = this.mPrivateFlags & 0xFF9FFFFF | 0x200000;
            this.mPrivateFlags &= 0xFFFF7FFF;
        }
        if (this.mLayerType == 1) {
            this.mPrivateFlags |= 0x80200000;
            target = this;
        }
        if (this.mParent != null) {
            this.mParent.onDescendantInvalidated(this, target);
        }
    }

    @Override
    @Deprecated
    public final void invalidateChild(View child, Rect dirty) {
        View.AttachInfo attachInfo = this.mAttachInfo;
        if (attachInfo != null && attachInfo.mHardwareAccelerated) {
            this.onDescendantInvalidated(child, child);
            return;
        }
        ViewParent parent = this;
        if (attachInfo != null) {
            int opaqueFlag;
            boolean drawAnimation = (child.mPrivateFlags & 0x40) != 0;
            Matrix childMatrix = child.getMatrix();
            boolean isOpaque = child.isOpaque() && !drawAnimation && child.getAnimation() == null && childMatrix.isIdentity();
            int n = opaqueFlag = isOpaque ? 0x400000 : 0x200000;
            if (child.mLayerType != 0) {
                this.mPrivateFlags |= Integer.MIN_VALUE;
                this.mPrivateFlags &= 0xFFFF7FFF;
            }
            int[] location = attachInfo.mInvalidateChildLocation;
            location[0] = child.mLeft;
            location[1] = child.mTop;
            if (!childMatrix.isIdentity() || (this.mGroupFlags & 0x800) != 0) {
                Matrix transformMatrix;
                RectF boundingRect = attachInfo.mTmpTransformRect;
                boundingRect.set(dirty);
                if ((this.mGroupFlags & 0x800) != 0) {
                    Transformation t = attachInfo.mTmpTransformation;
                    boolean transformed = this.getChildStaticTransformation(child, t);
                    if (transformed) {
                        transformMatrix = attachInfo.mTmpMatrix;
                        transformMatrix.set(t.getMatrix());
                        if (!childMatrix.isIdentity()) {
                            transformMatrix.preConcat(childMatrix);
                        }
                    } else {
                        transformMatrix = childMatrix;
                    }
                } else {
                    transformMatrix = childMatrix;
                }
                transformMatrix.mapRect(boundingRect);
                dirty.set((int)Math.floor(boundingRect.left), (int)Math.floor(boundingRect.top), (int)Math.ceil(boundingRect.right), (int)Math.ceil(boundingRect.bottom));
            }
            do {
                Matrix m;
                View view = null;
                if (parent instanceof View) {
                    view = parent;
                }
                if (drawAnimation) {
                    if (view != null) {
                        view.mPrivateFlags |= 0x40;
                    } else if (parent instanceof ViewRootImpl) {
                        ((ViewRootImpl)parent).mIsAnimating = true;
                    }
                }
                if (view != null) {
                    if ((view.mViewFlags & 0x3000) != 0 && view.getSolidColor() == 0) {
                        opaqueFlag = 0x200000;
                    }
                    if ((view.mPrivateFlags & 0x600000) != 0x200000) {
                        view.mPrivateFlags = view.mPrivateFlags & 0xFF9FFFFF | opaqueFlag;
                    }
                }
                parent = parent.invalidateChildInParent(location, dirty);
                if (view == null || (m = view.getMatrix()).isIdentity()) continue;
                RectF boundingRect = attachInfo.mTmpTransformRect;
                boundingRect.set(dirty);
                m.mapRect(boundingRect);
                dirty.set((int)Math.floor(boundingRect.left), (int)Math.floor(boundingRect.top), (int)Math.ceil(boundingRect.right), (int)Math.ceil(boundingRect.bottom));
            } while (parent != null);
        }
    }

    @Override
    @Deprecated
    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        if ((this.mPrivateFlags & 0x8020) != 0) {
            if ((this.mGroupFlags & 0x90) != 128) {
                dirty.offset(location[0] - this.mScrollX, location[1] - this.mScrollY);
                if ((this.mGroupFlags & 1) == 0) {
                    dirty.union(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                }
                int left = this.mLeft;
                int top = this.mTop;
                if ((this.mGroupFlags & 1) == 1 && !dirty.intersect(0, 0, this.mRight - left, this.mBottom - top)) {
                    dirty.setEmpty();
                }
                location[0] = left;
                location[1] = top;
            } else {
                if ((this.mGroupFlags & 1) == 1) {
                    dirty.set(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                } else {
                    dirty.union(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                }
                location[0] = this.mLeft;
                location[1] = this.mTop;
                this.mPrivateFlags &= 0xFFFFFFDF;
            }
            this.mPrivateFlags &= 0xFFFF7FFF;
            if (this.mLayerType != 0) {
                this.mPrivateFlags |= Integer.MIN_VALUE;
            }
            return this.mParent;
        }
        return null;
    }

    protected ViewParent damageChildInParent(int left, int top, Rect dirty) {
        if ((this.mPrivateFlags & 0x20) != 0 || (this.mPrivateFlags & 0x8000) != 0) {
            dirty.offset(left - this.mScrollX, top - this.mScrollY);
            if ((this.mGroupFlags & 1) == 0) {
                dirty.union(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
            }
            if ((this.mGroupFlags & 1) == 0 || dirty.intersect(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop)) {
                if (!this.getMatrix().isIdentity()) {
                    this.transformRect(dirty);
                }
                return this.mParent;
            }
        }
        return null;
    }

    public final void offsetDescendantRectToMyCoords(View descendant, Rect rect) {
        this.offsetRectBetweenParentAndChild(descendant, rect, true, false);
    }

    public final void offsetRectIntoDescendantCoords(View descendant, Rect rect) {
        this.offsetRectBetweenParentAndChild(descendant, rect, false, false);
    }

    void offsetRectBetweenParentAndChild(View descendant, Rect rect, boolean offsetFromChildToParent, boolean clipToBounds) {
        if (descendant == this) {
            return;
        }
        ViewParent theParent = descendant.mParent;
        while (theParent != null && theParent instanceof View && theParent != this) {
            boolean intersected;
            View p;
            if (offsetFromChildToParent) {
                rect.offset(descendant.mLeft - descendant.mScrollX, descendant.mTop - descendant.mScrollY);
                if (clipToBounds) {
                    p = (View)((Object)theParent);
                    intersected = rect.intersect(0, 0, p.mRight - p.mLeft, p.mBottom - p.mTop);
                    if (!intersected) {
                        rect.setEmpty();
                    }
                }
            } else {
                if (clipToBounds) {
                    p = (View)((Object)theParent);
                    intersected = rect.intersect(0, 0, p.mRight - p.mLeft, p.mBottom - p.mTop);
                    if (!intersected) {
                        rect.setEmpty();
                    }
                }
                rect.offset(descendant.mScrollX - descendant.mLeft, descendant.mScrollY - descendant.mTop);
            }
            descendant = (View)((Object)theParent);
            theParent = descendant.mParent;
        }
        if (theParent == this) {
            if (offsetFromChildToParent) {
                rect.offset(descendant.mLeft - descendant.mScrollX, descendant.mTop - descendant.mScrollY);
            } else {
                rect.offset(descendant.mScrollX - descendant.mLeft, descendant.mScrollY - descendant.mTop);
            }
        } else {
            throw new IllegalArgumentException("parameter must be a descendant of this view");
        }
    }

    public void offsetChildrenTopAndBottom(int offset) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        boolean invalidate = false;
        for (int i = 0; i < count; ++i) {
            View v = children[i];
            v.mTop += offset;
            v.mBottom += offset;
            if (v.mRenderNode == null) continue;
            invalidate = true;
            v.mRenderNode.offsetTopAndBottom(offset);
        }
        if (invalidate) {
            this.invalidateViewProperty(false, false);
        }
        this.notifySubtreeAccessibilityStateChangedIfNeeded();
    }

    @Override
    public boolean getChildVisibleRect(View child, Rect r, Point offset) {
        return this.getChildVisibleRect(child, r, offset, false);
    }

    public boolean getChildVisibleRect(View child, Rect r, Point offset, boolean forceParentCheck) {
        RectF rect = this.mAttachInfo != null ? this.mAttachInfo.mTmpTransformRect : new RectF();
        rect.set(r);
        if (!child.hasIdentityMatrix()) {
            child.getMatrix().mapRect(rect);
        }
        int dx = child.mLeft - this.mScrollX;
        int dy = child.mTop - this.mScrollY;
        rect.offset(dx, dy);
        if (offset != null) {
            if (!child.hasIdentityMatrix()) {
                float[] position = this.mAttachInfo != null ? this.mAttachInfo.mTmpTransformLocation : new float[2];
                position[0] = offset.x;
                position[1] = offset.y;
                child.getMatrix().mapPoints(position);
                offset.x = Math.round(position[0]);
                offset.y = Math.round(position[1]);
            }
            offset.x += dx;
            offset.y += dy;
        }
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        boolean rectIsVisible = true;
        if (this.mParent == null || this.mParent instanceof ViewGroup && ((ViewGroup)this.mParent).getClipChildren()) {
            rectIsVisible = rect.intersect(0.0f, 0.0f, width, height);
        }
        if ((forceParentCheck || rectIsVisible) && (this.mGroupFlags & 0x22) == 34) {
            rectIsVisible = rect.intersect(this.mPaddingLeft, this.mPaddingTop, width - this.mPaddingRight, height - this.mPaddingBottom);
        }
        if ((forceParentCheck || rectIsVisible) && this.mClipBounds != null) {
            rectIsVisible = rect.intersect(this.mClipBounds.left, this.mClipBounds.top, this.mClipBounds.right, this.mClipBounds.bottom);
        }
        r.set((int)Math.floor(rect.left), (int)Math.floor(rect.top), (int)Math.ceil(rect.right), (int)Math.ceil(rect.bottom));
        if ((forceParentCheck || rectIsVisible) && this.mParent != null) {
            rectIsVisible = this.mParent instanceof ViewGroup ? ((ViewGroup)this.mParent).getChildVisibleRect(this, r, offset, forceParentCheck) : this.mParent.getChildVisibleRect(this, r, offset);
        }
        return rectIsVisible;
    }

    @Override
    public final void layout(int l, int t, int r, int b) {
        if (!(this.mSuppressLayout || this.mTransition != null && this.mTransition.isChangingLayout())) {
            if (this.mTransition != null) {
                this.mTransition.layoutChange(this);
            }
            super.layout(l, t, r, b);
        } else {
            this.mLayoutCalledWhileSuppressed = true;
        }
    }

    @Override
    protected abstract void onLayout(boolean var1, int var2, int var3, int var4, int var5);

    protected boolean canAnimate() {
        return this.mLayoutAnimationController != null;
    }

    public void startLayoutAnimation() {
        if (this.mLayoutAnimationController != null) {
            this.mGroupFlags |= 8;
            this.requestLayout();
        }
    }

    public void scheduleLayoutAnimation() {
        this.mGroupFlags |= 8;
    }

    public void setLayoutAnimation(LayoutAnimationController controller) {
        this.mLayoutAnimationController = controller;
        if (this.mLayoutAnimationController != null) {
            this.mGroupFlags |= 8;
        }
    }

    public LayoutAnimationController getLayoutAnimation() {
        return this.mLayoutAnimationController;
    }

    @Deprecated
    public boolean isAnimationCacheEnabled() {
        return (this.mGroupFlags & 0x40) == 64;
    }

    @Deprecated
    public void setAnimationCacheEnabled(boolean enabled) {
        this.setBooleanFlag(64, enabled);
    }

    @Deprecated
    public boolean isAlwaysDrawnWithCacheEnabled() {
        return (this.mGroupFlags & 0x4000) == 16384;
    }

    @Deprecated
    public void setAlwaysDrawnWithCacheEnabled(boolean always) {
        this.setBooleanFlag(16384, always);
    }

    @Deprecated
    protected boolean isChildrenDrawnWithCacheEnabled() {
        return (this.mGroupFlags & 0x8000) == 32768;
    }

    @Deprecated
    protected void setChildrenDrawnWithCacheEnabled(boolean enabled) {
        this.setBooleanFlag(32768, enabled);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    protected boolean isChildrenDrawingOrderEnabled() {
        return (this.mGroupFlags & 0x400) == 1024;
    }

    protected void setChildrenDrawingOrderEnabled(boolean enabled) {
        this.setBooleanFlag(1024, enabled);
    }

    private boolean hasBooleanFlag(int flag) {
        return (this.mGroupFlags & flag) == flag;
    }

    private void setBooleanFlag(int flag, boolean value) {
        this.mGroupFlags = value ? (this.mGroupFlags |= flag) : (this.mGroupFlags &= ~flag);
    }

    @ViewDebug.ExportedProperty(category="drawing", mapping={@ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=1, to="ANIMATION"), @ViewDebug.IntToString(from=2, to="SCROLLING"), @ViewDebug.IntToString(from=3, to="ALL")})
    public int getPersistentDrawingCache() {
        return this.mPersistentDrawingCache;
    }

    public void setPersistentDrawingCache(int drawingCacheToKeep) {
        this.mPersistentDrawingCache = drawingCacheToKeep & 3;
    }

    private void setLayoutMode(int layoutMode, boolean explicitly) {
        this.mLayoutMode = layoutMode;
        this.setBooleanFlag(0x800000, explicitly);
    }

    @Override
    void invalidateInheritedLayoutMode(int layoutModeOfRoot) {
        if (this.mLayoutMode == -1 || this.mLayoutMode == layoutModeOfRoot || this.hasBooleanFlag(0x800000)) {
            return;
        }
        this.setLayoutMode(-1, false);
        int N = this.getChildCount();
        for (int i = 0; i < N; ++i) {
            this.getChildAt(i).invalidateInheritedLayoutMode(layoutModeOfRoot);
        }
    }

    public int getLayoutMode() {
        if (this.mLayoutMode == -1) {
            int inheritedLayoutMode = this.mParent instanceof ViewGroup ? ((ViewGroup)this.mParent).getLayoutMode() : LAYOUT_MODE_DEFAULT;
            this.setLayoutMode(inheritedLayoutMode, false);
        }
        return this.mLayoutMode;
    }

    public void setLayoutMode(int layoutMode) {
        if (this.mLayoutMode != layoutMode) {
            this.invalidateInheritedLayoutMode(layoutMode);
            this.setLayoutMode(layoutMode, layoutMode != -1);
            this.requestLayout();
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(LayoutParams p) {
        return p;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    protected void debug(int depth) {
        String output;
        super.debug(depth);
        if (this.mFocused != null) {
            output = ViewGroup.debugIndent(depth);
            output = output + "mFocused";
            Log.d("View", output);
            this.mFocused.debug(depth + 1);
        }
        if (this.mDefaultFocus != null) {
            output = ViewGroup.debugIndent(depth);
            output = output + "mDefaultFocus";
            Log.d("View", output);
            this.mDefaultFocus.debug(depth + 1);
        }
        if (this.mFocusedInCluster != null) {
            output = ViewGroup.debugIndent(depth);
            output = output + "mFocusedInCluster";
            Log.d("View", output);
            this.mFocusedInCluster.debug(depth + 1);
        }
        if (this.mChildrenCount != 0) {
            output = ViewGroup.debugIndent(depth);
            output = output + "{";
            Log.d("View", output);
        }
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            View child = this.mChildren[i];
            child.debug(depth + 1);
        }
        if (this.mChildrenCount != 0) {
            output = ViewGroup.debugIndent(depth);
            output = output + "}";
            Log.d("View", output);
        }
    }

    public int indexOfChild(View child) {
        int count = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < count; ++i) {
            if (children[i] != child) continue;
            return i;
        }
        return -1;
    }

    public int getChildCount() {
        return this.mChildrenCount;
    }

    public View getChildAt(int index) {
        if (index < 0 || index >= this.mChildrenCount) {
            return null;
        }
        return this.mChildren[index];
    }

    protected void measureChildren(int widthMeasureSpec, int heightMeasureSpec) {
        int size = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < size; ++i) {
            View child = children[i];
            if ((child.mViewFlags & 0xC) == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight, lp.width);
        int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        MarginLayoutParams lp = (MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec(parentWidthMeasureSpec, this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    public static int getChildMeasureSpec(int spec, int padding, int childDimension) {
        int specMode = View.MeasureSpec.getMode(spec);
        int specSize = View.MeasureSpec.getSize(spec);
        int size = Math.max(0, specSize - padding);
        int resultSize = 0;
        int resultMode = 0;
        switch (specMode) {
            case 0x40000000: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case -2147483648: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = Integer.MIN_VALUE;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = Integer.MIN_VALUE;
                break;
            }
            case 0: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = 0x40000000;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = View.sUseZeroUnspecifiedMeasureSpec ? 0 : size;
                    resultMode = 0;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = View.sUseZeroUnspecifiedMeasureSpec ? 0 : size;
                resultMode = 0;
            }
        }
        return View.MeasureSpec.makeMeasureSpec(resultSize, resultMode);
    }

    public void clearDisappearingChildren() {
        ArrayList<View> disappearingChildren = this.mDisappearingChildren;
        if (disappearingChildren != null) {
            int count = disappearingChildren.size();
            for (int i = 0; i < count; ++i) {
                View view = disappearingChildren.get(i);
                if (view.mAttachInfo != null) {
                    view.dispatchDetachedFromWindow();
                }
                view.clearAnimation();
            }
            disappearingChildren.clear();
            this.invalidate();
        }
    }

    private void addDisappearingView(View v) {
        ArrayList<View> disappearingChildren = this.mDisappearingChildren;
        if (disappearingChildren == null) {
            disappearingChildren = this.mDisappearingChildren = new ArrayList();
        }
        disappearingChildren.add(v);
    }

    void finishAnimatingView(View view, Animation animation) {
        ArrayList<View> disappearingChildren = this.mDisappearingChildren;
        if (disappearingChildren != null && disappearingChildren.contains(view)) {
            disappearingChildren.remove(view);
            if (view.mAttachInfo != null) {
                view.dispatchDetachedFromWindow();
            }
            view.clearAnimation();
            this.mGroupFlags |= 4;
        }
        if (animation != null && !animation.getFillAfter()) {
            view.clearAnimation();
        }
        if ((view.mPrivateFlags & 0x10000) == 65536) {
            view.onAnimationEnd();
            view.mPrivateFlags &= 0xFFFEFFFF;
            this.mGroupFlags |= 4;
        }
    }

    boolean isViewTransitioning(View view) {
        return this.mTransitioningViews != null && this.mTransitioningViews.contains(view);
    }

    public void startViewTransition(View view) {
        if (view.mParent == this) {
            if (this.mTransitioningViews == null) {
                this.mTransitioningViews = new ArrayList();
            }
            this.mTransitioningViews.add(view);
        }
    }

    public void endViewTransition(View view) {
        if (this.mTransitioningViews != null) {
            this.mTransitioningViews.remove(view);
            ArrayList<View> disappearingChildren = this.mDisappearingChildren;
            if (disappearingChildren != null && disappearingChildren.contains(view)) {
                disappearingChildren.remove(view);
                if (this.mVisibilityChangingChildren != null && this.mVisibilityChangingChildren.contains(view)) {
                    this.mVisibilityChangingChildren.remove(view);
                } else {
                    if (view.mAttachInfo != null) {
                        view.dispatchDetachedFromWindow();
                    }
                    if (view.mParent != null) {
                        view.mParent = null;
                    }
                }
                this.invalidate();
            }
        }
    }

    public void suppressLayout(boolean suppress) {
        this.mSuppressLayout = suppress;
        if (!suppress && this.mLayoutCalledWhileSuppressed) {
            this.requestLayout();
            this.mLayoutCalledWhileSuppressed = false;
        }
    }

    public boolean isLayoutSuppressed() {
        return this.mSuppressLayout;
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        boolean meOpaque;
        boolean bl = meOpaque = (this.mPrivateFlags & 0x200) == 0;
        if (meOpaque && region == null) {
            return true;
        }
        super.gatherTransparentRegion(region);
        int childrenCount = this.mChildrenCount;
        boolean noneOfTheChildrenAreTransparent = true;
        if (childrenCount > 0) {
            ArrayList<View> preorderedList = this.buildOrderedChildList();
            boolean customOrder = preorderedList == null && this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = 0; i < childrenCount; ++i) {
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(preorderedList, children, childIndex);
                if ((child.mViewFlags & 0xC) != 0 && child.getAnimation() == null || child.gatherTransparentRegion(region)) continue;
                noneOfTheChildrenAreTransparent = false;
            }
            if (preorderedList != null) {
                preorderedList.clear();
            }
        }
        return meOpaque || noneOfTheChildrenAreTransparent;
    }

    @Override
    public void requestTransparentRegion(View child) {
        if (child != null) {
            child.mPrivateFlags |= 0x200;
            if (this.mParent != null) {
                this.mParent.requestTransparentRegion(this);
            }
        }
    }

    @Override
    public WindowInsets dispatchApplyWindowInsets(WindowInsets insets) {
        if (!(insets = super.dispatchApplyWindowInsets(insets)).isConsumed()) {
            int count = this.getChildCount();
            for (int i = 0; i < count && !(insets = this.getChildAt(i).dispatchApplyWindowInsets(insets)).isConsumed(); ++i) {
            }
        }
        return insets;
    }

    public Animation.AnimationListener getLayoutAnimationListener() {
        return this.mAnimationListener;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if ((this.mGroupFlags & 0x10000) != 0) {
            if ((this.mGroupFlags & 0x2000) != 0) {
                throw new IllegalStateException("addStateFromChildren cannot be enabled if a child has duplicateParentState set to true");
            }
            View[] children = this.mChildren;
            int count = this.mChildrenCount;
            for (int i = 0; i < count; ++i) {
                View child = children[i];
                if ((child.mViewFlags & 0x400000) == 0) continue;
                child.refreshDrawableState();
            }
        }
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        View[] children = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            children[i].jumpDrawablesToCurrentState();
        }
    }

    @Override
    protected int[] onCreateDrawableState(int extraSpace) {
        if ((this.mGroupFlags & 0x2000) == 0) {
            return super.onCreateDrawableState(extraSpace);
        }
        int need = 0;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            int[] childState = this.getChildAt(i).getDrawableState();
            if (childState == null) continue;
            need += childState.length;
        }
        int[] state = super.onCreateDrawableState(extraSpace + need);
        for (int i = 0; i < n; ++i) {
            int[] childState = this.getChildAt(i).getDrawableState();
            if (childState == null) continue;
            state = ViewGroup.mergeDrawableStates(state, childState);
        }
        return state;
    }

    public void setAddStatesFromChildren(boolean addsStates) {
        this.mGroupFlags = addsStates ? (this.mGroupFlags |= 0x2000) : (this.mGroupFlags &= 0xFFFFDFFF);
        this.refreshDrawableState();
    }

    public boolean addStatesFromChildren() {
        return (this.mGroupFlags & 0x2000) != 0;
    }

    @Override
    public void childDrawableStateChanged(View child) {
        if ((this.mGroupFlags & 0x2000) != 0) {
            this.refreshDrawableState();
        }
    }

    public void setLayoutAnimationListener(Animation.AnimationListener animationListener) {
        this.mAnimationListener = animationListener;
    }

    public void requestTransitionStart(LayoutTransition transition2) {
        ViewRootImpl viewAncestor = this.getViewRootImpl();
        if (viewAncestor != null) {
            viewAncestor.requestTransitionStart(transition2);
        }
    }

    @Override
    public boolean resolveRtlPropertiesIfNeeded() {
        boolean result = super.resolveRtlPropertiesIfNeeded();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isLayoutDirectionInherited()) continue;
                child.resolveRtlPropertiesIfNeeded();
            }
        }
        return result;
    }

    @Override
    public boolean resolveLayoutDirection() {
        boolean result = super.resolveLayoutDirection();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isLayoutDirectionInherited()) continue;
                child.resolveLayoutDirection();
            }
        }
        return result;
    }

    @Override
    public boolean resolveTextDirection() {
        boolean result = super.resolveTextDirection();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isTextDirectionInherited()) continue;
                child.resolveTextDirection();
            }
        }
        return result;
    }

    @Override
    public boolean resolveTextAlignment() {
        boolean result = super.resolveTextAlignment();
        if (result) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!child.isTextAlignmentInherited()) continue;
                child.resolveTextAlignment();
            }
        }
        return result;
    }

    @Override
    public void resolvePadding() {
        super.resolvePadding();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited() || child.isPaddingResolved()) continue;
            child.resolvePadding();
        }
    }

    @Override
    protected void resolveDrawables() {
        super.resolveDrawables();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited() || child.areDrawablesResolved()) continue;
            child.resolveDrawables();
        }
    }

    @Override
    public void resolveLayoutParams() {
        super.resolveLayoutParams();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.resolveLayoutParams();
        }
    }

    @Override
    public void resetResolvedLayoutDirection() {
        super.resetResolvedLayoutDirection();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited()) continue;
            child.resetResolvedLayoutDirection();
        }
    }

    @Override
    public void resetResolvedTextDirection() {
        super.resetResolvedTextDirection();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isTextDirectionInherited()) continue;
            child.resetResolvedTextDirection();
        }
    }

    @Override
    public void resetResolvedTextAlignment() {
        super.resetResolvedTextAlignment();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isTextAlignmentInherited()) continue;
            child.resetResolvedTextAlignment();
        }
    }

    @Override
    public void resetResolvedPadding() {
        super.resetResolvedPadding();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited()) continue;
            child.resetResolvedPadding();
        }
    }

    @Override
    protected void resetResolvedDrawables() {
        super.resetResolvedDrawables();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutDirectionInherited()) continue;
            child.resetResolvedDrawables();
        }
    }

    public boolean shouldDelayChildPressedState() {
        return true;
    }

    @Override
    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return false;
    }

    @Override
    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.mNestedScrollAxes = axes;
    }

    @Override
    public void onStopNestedScroll(View child) {
        this.stopNestedScroll();
        this.mNestedScrollAxes = 0;
    }

    @Override
    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, null);
    }

    @Override
    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        this.dispatchNestedPreScroll(dx, dy, consumed, null);
    }

    @Override
    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    @Override
    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollAxes;
    }

    protected void onSetLayoutParams(View child, LayoutParams layoutParams) {
    }

    @Override
    public void captureTransitioningViews(List<View> transitioningViews) {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.isTransitionGroup()) {
            transitioningViews.add(this);
        } else {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                child.captureTransitioningViews(transitioningViews);
            }
        }
    }

    @Override
    public void findNamedViews(Map<String, View> namedElements) {
        if (this.getVisibility() != 0 && this.mGhostView == null) {
            return;
        }
        super.findNamedViews(namedElements);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.findNamedViews(namedElements);
        }
    }

    private static void drawRect(Canvas canvas, Paint paint, int x1, int y1, int x2, int y2) {
        if (sDebugLines == null) {
            sDebugLines = new float[16];
        }
        ViewGroup.sDebugLines[0] = x1;
        ViewGroup.sDebugLines[1] = y1;
        ViewGroup.sDebugLines[2] = x2;
        ViewGroup.sDebugLines[3] = y1;
        ViewGroup.sDebugLines[4] = x2;
        ViewGroup.sDebugLines[5] = y1;
        ViewGroup.sDebugLines[6] = x2;
        ViewGroup.sDebugLines[7] = y2;
        ViewGroup.sDebugLines[8] = x2;
        ViewGroup.sDebugLines[9] = y2;
        ViewGroup.sDebugLines[10] = x1;
        ViewGroup.sDebugLines[11] = y2;
        ViewGroup.sDebugLines[12] = x1;
        ViewGroup.sDebugLines[13] = y2;
        ViewGroup.sDebugLines[14] = x1;
        ViewGroup.sDebugLines[15] = y1;
        canvas.drawLines(sDebugLines, paint);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("focus:descendantFocusability", this.getDescendantFocusability());
        encoder.addProperty("drawing:clipChildren", this.getClipChildren());
        encoder.addProperty("drawing:clipToPadding", this.getClipToPadding());
        encoder.addProperty("drawing:childrenDrawingOrderEnabled", this.isChildrenDrawingOrderEnabled());
        encoder.addProperty("drawing:persistentDrawingCache", this.getPersistentDrawingCache());
        int n = this.getChildCount();
        encoder.addProperty("meta:__childCount__", (short)n);
        for (int i = 0; i < n; ++i) {
            encoder.addPropertyKey("meta:__child__" + i);
            this.getChildAt(i).encode(encoder);
        }
    }

    static {
        SENTINEL_ACTION_MODE = new ActionMode(){

            @Override
            public void setTitle(CharSequence title) {
            }

            @Override
            public void setTitle(int resId) {
            }

            @Override
            public void setSubtitle(CharSequence subtitle) {
            }

            @Override
            public void setSubtitle(int resId) {
            }

            @Override
            public void setCustomView(View view) {
            }

            @Override
            public void invalidate() {
            }

            @Override
            public void finish() {
            }

            @Override
            public Menu getMenu() {
                return null;
            }

            @Override
            public CharSequence getTitle() {
                return null;
            }

            @Override
            public CharSequence getSubtitle() {
                return null;
            }

            @Override
            public View getCustomView() {
                return null;
            }

            @Override
            public MenuInflater getMenuInflater() {
                return null;
            }
        };
    }

    static class ViewLocationHolder
    implements Comparable<ViewLocationHolder> {
        private static final int MAX_POOL_SIZE = 32;
        private static final Pools.SynchronizedPool<ViewLocationHolder> sPool = new Pools.SynchronizedPool(32);
        public static final int COMPARISON_STRATEGY_STRIPE = 1;
        public static final int COMPARISON_STRATEGY_LOCATION = 2;
        private static int sComparisonStrategy = 1;
        private final Rect mLocation = new Rect();
        public View mView;
        private int mLayoutDirection;

        ViewLocationHolder() {
        }

        public static ViewLocationHolder obtain(ViewGroup root, View view) {
            ViewLocationHolder holder = sPool.acquire();
            if (holder == null) {
                holder = new ViewLocationHolder();
            }
            holder.init(root, view);
            return holder;
        }

        public static void setComparisonStrategy(int strategy) {
            sComparisonStrategy = strategy;
        }

        public void recycle() {
            this.clear();
            sPool.release(this);
        }

        @Override
        public int compareTo(ViewLocationHolder another) {
            int topDifference;
            if (another == null) {
                return 1;
            }
            if (sComparisonStrategy == 1) {
                if (this.mLocation.bottom - another.mLocation.top <= 0) {
                    return -1;
                }
                if (this.mLocation.top - another.mLocation.bottom >= 0) {
                    return 1;
                }
            }
            if (this.mLayoutDirection == 0) {
                int leftDifference = this.mLocation.left - another.mLocation.left;
                if (leftDifference != 0) {
                    return leftDifference;
                }
            } else {
                int rightDifference = this.mLocation.right - another.mLocation.right;
                if (rightDifference != 0) {
                    return -rightDifference;
                }
            }
            if ((topDifference = this.mLocation.top - another.mLocation.top) != 0) {
                return topDifference;
            }
            int heightDiference = this.mLocation.height() - another.mLocation.height();
            if (heightDiference != 0) {
                return -heightDiference;
            }
            int widthDiference = this.mLocation.width() - another.mLocation.width();
            if (widthDiference != 0) {
                return -widthDiference;
            }
            return this.mView.getAccessibilityViewId() - another.mView.getAccessibilityViewId();
        }

        private void init(ViewGroup root, View view) {
            Rect viewLocation = this.mLocation;
            view.getDrawingRect(viewLocation);
            root.offsetDescendantRectToMyCoords(view, viewLocation);
            this.mView = view;
            this.mLayoutDirection = root.getLayoutDirection();
        }

        private void clear() {
            this.mView = null;
            this.mLocation.set(0, 0, 0, 0);
        }
    }

    static class ChildListForAccessibility {
        private static final int MAX_POOL_SIZE = 32;
        private static final Pools.SynchronizedPool<ChildListForAccessibility> sPool = new Pools.SynchronizedPool(32);
        private final ArrayList<View> mChildren = new ArrayList();
        private final ArrayList<ViewLocationHolder> mHolders = new ArrayList();

        ChildListForAccessibility() {
        }

        public static ChildListForAccessibility obtain(ViewGroup parent, boolean sort) {
            ChildListForAccessibility list = sPool.acquire();
            if (list == null) {
                list = new ChildListForAccessibility();
            }
            list.init(parent, sort);
            return list;
        }

        public void recycle() {
            this.clear();
            sPool.release(this);
        }

        public int getChildCount() {
            return this.mChildren.size();
        }

        public View getChildAt(int index) {
            return this.mChildren.get(index);
        }

        public int getChildIndex(View child) {
            return this.mChildren.indexOf(child);
        }

        private void init(ViewGroup parent, boolean sort) {
            ArrayList<View> children = this.mChildren;
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = parent.getChildAt(i);
                children.add(child);
            }
            if (sort) {
                int i;
                ArrayList<ViewLocationHolder> holders = this.mHolders;
                for (i = 0; i < childCount; ++i) {
                    View child = children.get(i);
                    ViewLocationHolder holder = ViewLocationHolder.obtain(parent, child);
                    holders.add(holder);
                }
                this.sort(holders);
                for (i = 0; i < childCount; ++i) {
                    ViewLocationHolder holder = holders.get(i);
                    children.set(i, holder.mView);
                    holder.recycle();
                }
                holders.clear();
            }
        }

        private void sort(ArrayList<ViewLocationHolder> holders) {
            try {
                ViewLocationHolder.setComparisonStrategy(1);
                Collections.sort(holders);
            }
            catch (IllegalArgumentException iae) {
                ViewLocationHolder.setComparisonStrategy(2);
                Collections.sort(holders);
            }
        }

        private void clear() {
            this.mChildren.clear();
        }
    }

    private static final class HoverTarget {
        private static final int MAX_RECYCLED = 32;
        private static final Object sRecycleLock = new Object[0];
        private static HoverTarget sRecycleBin;
        private static int sRecycledCount;
        public View child;
        public HoverTarget next;

        private HoverTarget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static HoverTarget obtain(View child) {
            HoverTarget target;
            if (child == null) {
                throw new IllegalArgumentException("child must be non-null");
            }
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycleBin == null) {
                    target = new HoverTarget();
                } else {
                    target = sRecycleBin;
                    sRecycleBin = target.next;
                    --sRecycledCount;
                    target.next = null;
                }
            }
            target.child = child;
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            if (this.child == null) {
                throw new IllegalStateException("already recycled once");
            }
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycledCount < 32) {
                    this.next = sRecycleBin;
                    sRecycleBin = this;
                    ++sRecycledCount;
                } else {
                    this.next = null;
                }
                this.child = null;
            }
        }
    }

    private static final class TouchTarget {
        private static final int MAX_RECYCLED = 32;
        private static final Object sRecycleLock = new Object[0];
        private static TouchTarget sRecycleBin;
        private static int sRecycledCount;
        public static final int ALL_POINTER_IDS = -1;
        public View child;
        public int pointerIdBits;
        public TouchTarget next;

        private TouchTarget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TouchTarget obtain(View child, int pointerIdBits) {
            TouchTarget target;
            if (child == null) {
                throw new IllegalArgumentException("child must be non-null");
            }
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycleBin == null) {
                    target = new TouchTarget();
                } else {
                    target = sRecycleBin;
                    sRecycleBin = target.next;
                    --sRecycledCount;
                    target.next = null;
                }
            }
            target.child = child;
            target.pointerIdBits = pointerIdBits;
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            if (this.child == null) {
                throw new IllegalStateException("already recycled once");
            }
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycledCount < 32) {
                    this.next = sRecycleBin;
                    sRecycleBin = this;
                    ++sRecycledCount;
                } else {
                    this.next = null;
                }
                this.child = null;
            }
        }
    }

    public static class MarginLayoutParams
    extends LayoutParams {
        @ViewDebug.ExportedProperty(category="layout")
        public int leftMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int topMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int rightMargin;
        @ViewDebug.ExportedProperty(category="layout")
        public int bottomMargin;
        @ViewDebug.ExportedProperty(category="layout")
        private int startMargin = Integer.MIN_VALUE;
        @ViewDebug.ExportedProperty(category="layout")
        private int endMargin = Integer.MIN_VALUE;
        public static final int DEFAULT_MARGIN_RELATIVE = Integer.MIN_VALUE;
        @ViewDebug.ExportedProperty(category="layout", flagMapping={@ViewDebug.FlagToString(mask=3, equals=3, name="LAYOUT_DIRECTION"), @ViewDebug.FlagToString(mask=4, equals=4, name="LEFT_MARGIN_UNDEFINED_MASK"), @ViewDebug.FlagToString(mask=8, equals=8, name="RIGHT_MARGIN_UNDEFINED_MASK"), @ViewDebug.FlagToString(mask=16, equals=16, name="RTL_COMPATIBILITY_MODE_MASK"), @ViewDebug.FlagToString(mask=32, equals=32, name="NEED_RESOLUTION_MASK")}, formatToHexString=true)
        byte mMarginFlags;
        private static final int LAYOUT_DIRECTION_MASK = 3;
        private static final int LEFT_MARGIN_UNDEFINED_MASK = 4;
        private static final int RIGHT_MARGIN_UNDEFINED_MASK = 8;
        private static final int RTL_COMPATIBILITY_MODE_MASK = 16;
        private static final int NEED_RESOLUTION_MASK = 32;
        private static final int DEFAULT_MARGIN_RESOLVED = 0;
        private static final int UNDEFINED_MARGIN = Integer.MIN_VALUE;

        public MarginLayoutParams(Context c, AttributeSet attrs) {
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ViewGroup_MarginLayout);
            this.setBaseAttributes(a, 0, 1);
            int margin = a.getDimensionPixelSize(2, -1);
            if (margin >= 0) {
                this.leftMargin = margin;
                this.topMargin = margin;
                this.rightMargin = margin;
                this.bottomMargin = margin;
            } else {
                int horizontalMargin = a.getDimensionPixelSize(9, -1);
                int verticalMargin = a.getDimensionPixelSize(10, -1);
                if (horizontalMargin >= 0) {
                    this.leftMargin = horizontalMargin;
                    this.rightMargin = horizontalMargin;
                } else {
                    this.leftMargin = a.getDimensionPixelSize(3, Integer.MIN_VALUE);
                    if (this.leftMargin == Integer.MIN_VALUE) {
                        this.mMarginFlags = (byte)(this.mMarginFlags | 4);
                        this.leftMargin = 0;
                    }
                    this.rightMargin = a.getDimensionPixelSize(5, Integer.MIN_VALUE);
                    if (this.rightMargin == Integer.MIN_VALUE) {
                        this.mMarginFlags = (byte)(this.mMarginFlags | 8);
                        this.rightMargin = 0;
                    }
                    this.startMargin = a.getDimensionPixelSize(7, Integer.MIN_VALUE);
                    this.endMargin = a.getDimensionPixelSize(8, Integer.MIN_VALUE);
                }
                if (verticalMargin >= 0) {
                    this.topMargin = verticalMargin;
                    this.bottomMargin = verticalMargin;
                } else {
                    this.topMargin = a.getDimensionPixelSize(4, 0);
                    this.bottomMargin = a.getDimensionPixelSize(6, 0);
                }
                if (this.isMarginRelative()) {
                    this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
                }
            }
            boolean hasRtlSupport = c.getApplicationInfo().hasRtlSupport();
            int targetSdkVersion = c.getApplicationInfo().targetSdkVersion;
            if (targetSdkVersion < 17 || !hasRtlSupport) {
                this.mMarginFlags = (byte)(this.mMarginFlags | 0x10);
            }
            this.mMarginFlags = (byte)(this.mMarginFlags | 0);
            a.recycle();
        }

        public MarginLayoutParams(int width, int height) {
            super(width, height);
            this.mMarginFlags = (byte)(this.mMarginFlags | 4);
            this.mMarginFlags = (byte)(this.mMarginFlags | 8);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFDF);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFEF);
        }

        public MarginLayoutParams(MarginLayoutParams source) {
            this.width = source.width;
            this.height = source.height;
            this.leftMargin = source.leftMargin;
            this.topMargin = source.topMargin;
            this.rightMargin = source.rightMargin;
            this.bottomMargin = source.bottomMargin;
            this.startMargin = source.startMargin;
            this.endMargin = source.endMargin;
            this.mMarginFlags = source.mMarginFlags;
        }

        public MarginLayoutParams(LayoutParams source) {
            super(source);
            this.mMarginFlags = (byte)(this.mMarginFlags | 4);
            this.mMarginFlags = (byte)(this.mMarginFlags | 8);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFDF);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFEF);
        }

        public final void copyMarginsFrom(MarginLayoutParams source) {
            this.leftMargin = source.leftMargin;
            this.topMargin = source.topMargin;
            this.rightMargin = source.rightMargin;
            this.bottomMargin = source.bottomMargin;
            this.startMargin = source.startMargin;
            this.endMargin = source.endMargin;
            this.mMarginFlags = source.mMarginFlags;
        }

        public void setMargins(int left, int top, int right, int bottom) {
            this.leftMargin = left;
            this.topMargin = top;
            this.rightMargin = right;
            this.bottomMargin = bottom;
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFFB);
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFF7);
            this.mMarginFlags = this.isMarginRelative() ? (byte)(this.mMarginFlags | 0x20) : (byte)(this.mMarginFlags & 0xFFFFFFDF);
        }

        public void setMarginsRelative(int start, int top, int end, int bottom) {
            this.startMargin = start;
            this.topMargin = top;
            this.endMargin = end;
            this.bottomMargin = bottom;
            this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
        }

        public void setMarginStart(int start) {
            this.startMargin = start;
            this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
        }

        public int getMarginStart() {
            if (this.startMargin != Integer.MIN_VALUE) {
                return this.startMargin;
            }
            if ((this.mMarginFlags & 0x20) == 32) {
                this.doResolveMargins();
            }
            switch (this.mMarginFlags & 3) {
                case 1: {
                    return this.rightMargin;
                }
            }
            return this.leftMargin;
        }

        public void setMarginEnd(int end) {
            this.endMargin = end;
            this.mMarginFlags = (byte)(this.mMarginFlags | 0x20);
        }

        public int getMarginEnd() {
            if (this.endMargin != Integer.MIN_VALUE) {
                return this.endMargin;
            }
            if ((this.mMarginFlags & 0x20) == 32) {
                this.doResolveMargins();
            }
            switch (this.mMarginFlags & 3) {
                case 1: {
                    return this.leftMargin;
                }
            }
            return this.rightMargin;
        }

        public boolean isMarginRelative() {
            return this.startMargin != Integer.MIN_VALUE || this.endMargin != Integer.MIN_VALUE;
        }

        public void setLayoutDirection(int layoutDirection) {
            if (layoutDirection != 0 && layoutDirection != 1) {
                return;
            }
            if (layoutDirection != (this.mMarginFlags & 3)) {
                this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFFC);
                this.mMarginFlags = (byte)(this.mMarginFlags | layoutDirection & 3);
                this.mMarginFlags = this.isMarginRelative() ? (byte)(this.mMarginFlags | 0x20) : (byte)(this.mMarginFlags & 0xFFFFFFDF);
            }
        }

        public int getLayoutDirection() {
            return this.mMarginFlags & 3;
        }

        @Override
        public void resolveLayoutDirection(int layoutDirection) {
            this.setLayoutDirection(layoutDirection);
            if (!this.isMarginRelative() || (this.mMarginFlags & 0x20) != 32) {
                return;
            }
            this.doResolveMargins();
        }

        private void doResolveMargins() {
            if ((this.mMarginFlags & 0x10) == 16) {
                if ((this.mMarginFlags & 4) == 4 && this.startMargin > Integer.MIN_VALUE) {
                    this.leftMargin = this.startMargin;
                }
                if ((this.mMarginFlags & 8) == 8 && this.endMargin > Integer.MIN_VALUE) {
                    this.rightMargin = this.endMargin;
                }
            } else {
                switch (this.mMarginFlags & 3) {
                    case 1: {
                        this.leftMargin = this.endMargin > Integer.MIN_VALUE ? this.endMargin : 0;
                        this.rightMargin = this.startMargin > Integer.MIN_VALUE ? this.startMargin : 0;
                        break;
                    }
                    default: {
                        this.leftMargin = this.startMargin > Integer.MIN_VALUE ? this.startMargin : 0;
                        this.rightMargin = this.endMargin > Integer.MIN_VALUE ? this.endMargin : 0;
                    }
                }
            }
            this.mMarginFlags = (byte)(this.mMarginFlags & 0xFFFFFFDF);
        }

        public boolean isLayoutRtl() {
            return (this.mMarginFlags & 3) == 1;
        }

        @Override
        public void onDebugDraw(View view, Canvas canvas, Paint paint) {
            Insets oi = View.isLayoutModeOptical(view.mParent) ? view.getOpticalInsets() : Insets.NONE;
            ViewGroup.fillDifference(canvas, view.getLeft() + oi.left, view.getTop() + oi.top, view.getRight() - oi.right, view.getBottom() - oi.bottom, this.leftMargin, this.topMargin, this.rightMargin, this.bottomMargin, paint);
        }

        @Override
        protected void encodeProperties(ViewHierarchyEncoder encoder) {
            super.encodeProperties(encoder);
            encoder.addProperty("leftMargin", this.leftMargin);
            encoder.addProperty("topMargin", this.topMargin);
            encoder.addProperty("rightMargin", this.rightMargin);
            encoder.addProperty("bottomMargin", this.bottomMargin);
            encoder.addProperty("startMargin", this.startMargin);
            encoder.addProperty("endMargin", this.endMargin);
        }
    }

    public static class LayoutParams {
        @Deprecated
        public static final int FILL_PARENT = -1;
        public static final int MATCH_PARENT = -1;
        public static final int WRAP_CONTENT = -2;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="MATCH_PARENT"), @ViewDebug.IntToString(from=-2, to="WRAP_CONTENT")})
        public int width;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="MATCH_PARENT"), @ViewDebug.IntToString(from=-2, to="WRAP_CONTENT")})
        public int height;
        public LayoutAnimationController.AnimationParameters layoutAnimationParameters;

        public LayoutParams(Context c, AttributeSet attrs) {
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ViewGroup_Layout);
            this.setBaseAttributes(a, 0, 1);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public LayoutParams(LayoutParams source) {
            this.width = source.width;
            this.height = source.height;
        }

        LayoutParams() {
        }

        protected void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.getLayoutDimension(widthAttr, "layout_width");
            this.height = a.getLayoutDimension(heightAttr, "layout_height");
        }

        public void resolveLayoutDirection(int layoutDirection) {
        }

        public String debug(String output) {
            return output + "ViewGroup.LayoutParams={ width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " }";
        }

        public void onDebugDraw(View view, Canvas canvas, Paint paint) {
        }

        protected static String sizeToString(int size) {
            if (size == -2) {
                return "wrap-content";
            }
            if (size == -1) {
                return "match-parent";
            }
            return String.valueOf(size);
        }

        void encode(ViewHierarchyEncoder encoder) {
            encoder.beginObject(this);
            this.encodeProperties(encoder);
            encoder.endObject();
        }

        protected void encodeProperties(ViewHierarchyEncoder encoder) {
            encoder.addProperty("width", this.width);
            encoder.addProperty("height", this.height);
        }
    }

    public static interface OnHierarchyChangeListener {
        public void onChildViewAdded(View var1, View var2);

        public void onChildViewRemoved(View var1, View var2);
    }
}

