/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import android.view.IWindow;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class AccessibilityManager {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManager";
    public static final int STATE_FLAG_ACCESSIBILITY_ENABLED = 1;
    public static final int STATE_FLAG_TOUCH_EXPLORATION_ENABLED = 2;
    public static final int STATE_FLAG_HIGH_TEXT_CONTRAST_ENABLED = 4;
    public static final int DALTONIZER_DISABLED = -1;
    public static final int DALTONIZER_SIMULATE_MONOCHROMACY = 0;
    public static final int DALTONIZER_CORRECT_DEUTERANOMALY = 12;
    public static final int AUTOCLICK_DELAY_DEFAULT = 600;
    static final Object sInstanceSync = new Object();
    private static AccessibilityManager sInstance;
    private final Object mLock = new Object();
    private IAccessibilityManager mService;
    final int mUserId;
    final Handler mHandler;
    boolean mIsEnabled;
    boolean mIsTouchExplorationEnabled;
    boolean mIsHighTextContrastEnabled;
    private final CopyOnWriteArrayList<AccessibilityStateChangeListener> mAccessibilityStateChangeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TouchExplorationStateChangeListener> mTouchExplorationStateChangeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<HighTextContrastChangeListener> mHighTextContrastStateChangeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<AccessibilityServicesStateChangeListener> mServicesStateChangeListeners = new CopyOnWriteArrayList();
    private final IAccessibilityManagerClient.Stub mClient = new IAccessibilityManagerClient.Stub(){

        @Override
        public void setState(int state) {
            AccessibilityManager.this.mHandler.obtainMessage(4, state, 0).sendToTarget();
        }

        @Override
        public void notifyServicesStateChanged() {
            AccessibilityManager.this.mHandler.obtainMessage(5).sendToTarget();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityManager getInstance(Context context) {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                int userId = Binder.getCallingUid() == 1000 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS") == 0 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0 ? -2 : UserHandle.myUserId();
                sInstance = new AccessibilityManager(context, null, userId);
            }
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityManager(Context context, IAccessibilityManager service, int userId) {
        this.mHandler = new MyHandler(context.getMainLooper());
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.tryConnectToServiceLocked(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityManager(Handler handler, IAccessibilityManager service, int userId) {
        this.mHandler = handler;
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.tryConnectToServiceLocked(service);
        }
    }

    public IAccessibilityManagerClient getClient() {
        return this.mClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTouchExplorationEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsTouchExplorationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHighTextContrastEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsHighTextContrastEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAccessibilityEvent(AccessibilityEvent event) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            if (!this.mIsEnabled) {
                Looper myLooper = Looper.myLooper();
                if (myLooper == Looper.getMainLooper()) {
                    throw new IllegalStateException("Accessibility off. Did you forget to check that?");
                }
                Log.e(LOG_TAG, "AccessibilityEvent sent with accessibility disabled");
                return;
            }
            userId = this.mUserId;
        }
        try {
            event.setEventTime(SystemClock.uptimeMillis());
            long identityToken = Binder.clearCallingIdentity();
            service.sendAccessibilityEvent(event, userId);
            Binder.restoreCallingIdentity(identityToken);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error during sending " + event + " ", re);
        }
        finally {
            event.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            if (!this.mIsEnabled) {
                Looper myLooper = Looper.myLooper();
                if (myLooper == Looper.getMainLooper()) {
                    throw new IllegalStateException("Accessibility off. Did you forget to check that?");
                }
                Log.e(LOG_TAG, "Interrupt called with accessibility disabled");
                return;
            }
            userId = this.mUserId;
        }
        try {
            service.interrupt(userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while requesting interrupt from all services. ", re);
        }
    }

    @Deprecated
    public List<ServiceInfo> getAccessibilityServiceList() {
        List<AccessibilityServiceInfo> infos = this.getInstalledAccessibilityServiceList();
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        int infoCount = infos.size();
        for (int i = 0; i < infoCount; ++i) {
            AccessibilityServiceInfo info = infos.get(i);
            services.add(info.getResolveInfo().serviceInfo);
        }
        return Collections.unmodifiableList(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getInstalledAccessibilityServiceList(userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getEnabledAccessibilityServiceList(feedbackTypeFlags, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    public boolean addAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        return this.mAccessibilityStateChangeListeners.add(listener);
    }

    public boolean removeAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        return this.mAccessibilityStateChangeListeners.remove(listener);
    }

    public boolean addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        return this.mTouchExplorationStateChangeListeners.add(listener);
    }

    public boolean removeTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        return this.mTouchExplorationStateChangeListeners.remove(listener);
    }

    public boolean addAccessibilityServicesStateChangeListener(AccessibilityServicesStateChangeListener listener) {
        return this.mServicesStateChangeListeners.add(listener);
    }

    public boolean removeAccessibilityServicesStateChangeListener(AccessibilityServicesStateChangeListener listener) {
        return this.mServicesStateChangeListeners.remove(listener);
    }

    public boolean addHighTextContrastStateChangeListener(HighTextContrastChangeListener listener) {
        return this.mHighTextContrastStateChangeListeners.add(listener);
    }

    public boolean removeHighTextContrastStateChangeListener(HighTextContrastChangeListener listener) {
        return this.mHighTextContrastStateChangeListeners.remove(listener);
    }

    public boolean isAccessibilityVolumeStreamActive() {
        List<AccessibilityServiceInfo> serviceInfos = this.getEnabledAccessibilityServiceList(-1);
        for (int i = 0; i < serviceInfos.size(); ++i) {
            if ((serviceInfos.get((int)i).flags & 0x80) == 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFingerprintGesture(int keyCode) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.sendFingerprintGesture(keyCode);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private void setStateLocked(int stateFlags) {
        boolean enabled = (stateFlags & 1) != 0;
        boolean touchExplorationEnabled = (stateFlags & 2) != 0;
        boolean highTextContrastEnabled = (stateFlags & 4) != 0;
        boolean wasEnabled = this.mIsEnabled;
        boolean wasTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
        boolean wasHighTextContrastEnabled = this.mIsHighTextContrastEnabled;
        this.mIsEnabled = enabled;
        this.mIsTouchExplorationEnabled = touchExplorationEnabled;
        this.mIsHighTextContrastEnabled = highTextContrastEnabled;
        if (wasEnabled != enabled) {
            this.mHandler.sendEmptyMessage(1);
        }
        if (wasTouchExplorationEnabled != touchExplorationEnabled) {
            this.mHandler.sendEmptyMessage(2);
        }
        if (wasHighTextContrastEnabled != highTextContrastEnabled) {
            this.mHandler.sendEmptyMessage(3);
        }
    }

    public AccessibilityServiceInfo getInstalledServiceInfoWithComponentName(ComponentName componentName) {
        List<AccessibilityServiceInfo> installedServiceInfos = this.getInstalledAccessibilityServiceList();
        if (installedServiceInfos == null || componentName == null) {
            return null;
        }
        for (int i = 0; i < installedServiceInfos.size(); ++i) {
            if (!componentName.equals(installedServiceInfos.get(i).getComponentName())) continue;
            return installedServiceInfos.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAccessibilityInteractionConnection(IWindow windowToken, IAccessibilityInteractionConnection connection) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return -1;
            }
            userId = this.mUserId;
        }
        try {
            return service.addAccessibilityInteractionConnection(windowToken, connection, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while adding an accessibility interaction connection. ", re);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessibilityInteractionConnection(IWindow windowToken) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.removeAccessibilityInteractionConnection(windowToken);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while removing an accessibility interaction connection. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAccessibilityShortcut() {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.performAccessibilityShortcut();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error performing accessibility shortcut. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAccessibilityButtonClicked() {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonClicked();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while dispatching accessibility button click", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAccessibilityButtonAvailabilityChanged(boolean available) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonAvailabilityChanged(available);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while dispatching accessibility button availability change", re);
        }
    }

    private IAccessibilityManager getServiceLocked() {
        if (this.mService == null) {
            this.tryConnectToServiceLocked(null);
        }
        return this.mService;
    }

    private void tryConnectToServiceLocked(IAccessibilityManager service) {
        if (service == null) {
            IBinder iBinder = ServiceManager.getService("accessibility");
            if (iBinder == null) {
                return;
            }
            service = IAccessibilityManager.Stub.asInterface(iBinder);
        }
        try {
            int stateFlags = service.addClient(this.mClient, this.mUserId);
            this.setStateLocked(stateFlags);
            this.mService = service;
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "AccessibilityManagerService is dead", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifyAccessibilityStateChanged() {
        boolean isEnabled;
        Iterator<AccessibilityStateChangeListener> iterator = this.mLock;
        synchronized (iterator) {
            isEnabled = this.mIsEnabled;
        }
        for (AccessibilityStateChangeListener listener : this.mAccessibilityStateChangeListeners) {
            listener.onAccessibilityStateChanged(isEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifyTouchExplorationStateChanged() {
        boolean isTouchExplorationEnabled;
        Iterator<TouchExplorationStateChangeListener> iterator = this.mLock;
        synchronized (iterator) {
            isTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
        }
        for (TouchExplorationStateChangeListener listener : this.mTouchExplorationStateChangeListeners) {
            listener.onTouchExplorationStateChanged(isTouchExplorationEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotifyHighTextContrastStateChanged() {
        boolean isHighTextContrastEnabled;
        Iterator<HighTextContrastChangeListener> iterator = this.mLock;
        synchronized (iterator) {
            isHighTextContrastEnabled = this.mIsHighTextContrastEnabled;
        }
        for (HighTextContrastChangeListener listener : this.mHighTextContrastStateChangeListeners) {
            listener.onHighTextContrastStateChanged(isHighTextContrastEnabled);
        }
    }

    private void handleNotifyServicesStateChanged() {
        for (AccessibilityServicesStateChangeListener listener : this.mServicesStateChangeListeners) {
            listener.onAccessibilityServicesStateChanged();
        }
    }

    private final class MyHandler
    extends Handler {
        public static final int MSG_NOTIFY_ACCESSIBILITY_STATE_CHANGED = 1;
        public static final int MSG_NOTIFY_EXPLORATION_STATE_CHANGED = 2;
        public static final int MSG_NOTIFY_HIGH_TEXT_CONTRAST_STATE_CHANGED = 3;
        public static final int MSG_SET_STATE = 4;
        public static final int MSG_NOTIFY_SERVICES_STATE_CHANGED = 5;

        public MyHandler(Looper looper) {
            super(looper, null, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    AccessibilityManager.this.handleNotifyAccessibilityStateChanged();
                    break;
                }
                case 2: {
                    AccessibilityManager.this.handleNotifyTouchExplorationStateChanged();
                    break;
                }
                case 3: {
                    AccessibilityManager.this.handleNotifyHighTextContrastStateChanged();
                    break;
                }
                case 5: {
                    AccessibilityManager.this.handleNotifyServicesStateChanged();
                    break;
                }
                case 4: {
                    int state = message.arg1;
                    Object object = AccessibilityManager.this.mLock;
                    synchronized (object) {
                        AccessibilityManager.this.setStateLocked(state);
                        break;
                    }
                }
            }
        }
    }

    public static interface HighTextContrastChangeListener {
        public void onHighTextContrastStateChanged(boolean var1);
    }

    public static interface AccessibilityServicesStateChangeListener {
        public void onAccessibilityServicesStateChanged();
    }

    public static interface TouchExplorationStateChangeListener {
        public void onTouchExplorationStateChanged(boolean var1);
    }

    public static interface AccessibilityStateChangeListener {
        public void onAccessibilityStateChanged(boolean var1);
    }
}

