/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.os.Parcel;
import android.os.Parcelable;

public final class AutoFillId
implements Parcelable {
    private int mViewId;
    private boolean mVirtual;
    private int mVirtualId;
    public static final Parcelable.Creator<AutoFillId> CREATOR = new Parcelable.Creator<AutoFillId>(){

        @Override
        public AutoFillId createFromParcel(Parcel source) {
            return new AutoFillId(source);
        }

        public AutoFillId[] newArray(int size) {
            return new AutoFillId[size];
        }
    };

    public AutoFillId(int id2) {
        this.mVirtual = false;
        this.mViewId = id2;
    }

    public AutoFillId(AutoFillId parent, int virtualChildId) {
        this.mVirtual = true;
        this.mViewId = parent.mViewId;
        this.mVirtualId = virtualChildId;
    }

    public AutoFillId(int parentId, int virtualChildId) {
        this.mVirtual = true;
        this.mViewId = parentId;
        this.mVirtualId = virtualChildId;
    }

    public int getViewId() {
        return this.mViewId;
    }

    public int getVirtualChildId() {
        return this.mVirtualId;
    }

    public boolean isVirtual() {
        return this.mVirtual;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mViewId;
        result = 31 * result + this.mVirtualId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoFillId other = (AutoFillId)obj;
        if (this.mViewId != other.mViewId) {
            return false;
        }
        return this.mVirtualId == other.mVirtualId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.mViewId);
        if (this.mVirtual) {
            builder.append(":").append(this.mVirtualId);
        }
        return builder.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mViewId);
        parcel.writeInt(this.mVirtual ? 1 : 0);
        parcel.writeInt(this.mVirtualId);
    }

    private AutoFillId(Parcel parcel) {
        this.mViewId = parcel.readInt();
        this.mVirtual = parcel.readInt() == 1;
        this.mVirtualId = parcel.readInt();
    }
}

