/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.view.autofill.AutoFillId;
import android.view.autofill.AutoFillManager$AutoFillManagerClient$$Lambda$38;
import android.view.autofill.AutoFillManager$AutoFillManagerClient$$Lambda$39;
import android.view.autofill.AutoFillManager$AutoFillManagerClient$$Lambda$40;
import android.view.autofill.AutoFillValue;
import android.view.autofill.IAutoFillManager;
import android.view.autofill.IAutoFillManagerClient;
import java.lang.ref.WeakReference;
import java.util.List;

public final class AutoFillManager {
    private static final String TAG = "AutoFillManager";
    public static final String EXTRA_ASSIST_STRUCTURE = "android.view.autofill.extra.ASSIST_STRUCTURE";
    public static final String EXTRA_AUTHENTICATION_RESULT = "android.view.autofill.extra.AUTHENTICATION_RESULT";
    public static final int FLAG_START_SESSION = 1;
    public static final int FLAG_FOCUS_GAINED = 2;
    public static final int FLAG_FOCUS_LOST = 4;
    public static final int FLAG_VALUE_CHANGED = 8;
    private final Rect mTempRect = new Rect();
    private final IAutoFillManager mService;
    private IAutoFillManagerClient mServiceClient;
    private Context mContext;
    private boolean mHasSession;
    private boolean mEnabled;

    public AutoFillManager(Context context, IAutoFillManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public void focusChanged(View view, boolean gainFocus) {
        this.ensureServiceClientAddedIfNeeded();
        if (!this.mEnabled) {
            return;
        }
        Rect bounds = this.mTempRect;
        view.getBoundsOnScreen(bounds);
        AutoFillId id2 = this.getAutoFillId(view);
        AutoFillValue value = view.getAutoFillValue();
        if (!this.mHasSession) {
            if (gainFocus) {
                this.startSession(id2, bounds, value);
            }
        } else {
            this.updateSession(id2, bounds, value, gainFocus ? 2 : 4);
        }
    }

    public void virtualFocusChanged(View parent, int childId, Rect bounds, boolean gainFocus) {
        this.ensureServiceClientAddedIfNeeded();
        if (!this.mEnabled) {
            return;
        }
        AutoFillId id2 = this.getAutoFillId(parent, childId);
        if (!this.mHasSession) {
            if (gainFocus) {
                this.startSession(id2, bounds, null);
            }
        } else {
            this.updateSession(id2, bounds, null, gainFocus ? 2 : 4);
        }
    }

    public void valueChanged(View view) {
        if (!this.mEnabled || !this.mHasSession) {
            return;
        }
        AutoFillId id2 = this.getAutoFillId(view);
        AutoFillValue value = view.getAutoFillValue();
        this.updateSession(id2, null, value, 8);
    }

    public void virtualValueChanged(View parent, int childId, AutoFillValue value) {
        if (!this.mEnabled || !this.mHasSession) {
            return;
        }
        AutoFillId id2 = this.getAutoFillId(parent, childId);
        this.updateSession(id2, null, value, 8);
    }

    public void reset() {
        if (!this.mEnabled && !this.mHasSession) {
            return;
        }
        this.finishSession();
    }

    private AutoFillClient getClient() {
        if (this.mContext instanceof AutoFillClient) {
            return (AutoFillClient)((Object)this.mContext);
        }
        return null;
    }

    public void onAuthenticationResult(Intent data) {
        Log.d(TAG, "onAuthenticationResult(): d=" + data);
        if (data == null) {
            return;
        }
        Object result = data.getParcelableExtra(EXTRA_AUTHENTICATION_RESULT);
        Bundle responseData = new Bundle();
        responseData.putParcelable(EXTRA_AUTHENTICATION_RESULT, (Parcelable)result);
        try {
            this.mService.setAuthenticationResult(responseData, this.mContext.getActivityToken(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error delivering authentication result", e);
        }
    }

    private AutoFillId getAutoFillId(View view) {
        return new AutoFillId(view.getAccessibilityViewId());
    }

    private AutoFillId getAutoFillId(View parent, int childId) {
        return new AutoFillId(parent.getAccessibilityViewId(), childId);
    }

    private void startSession(AutoFillId id2, Rect bounds, AutoFillValue value) {
        Log.v(TAG, "startSession(): id=" + id2 + ", bounds=" + bounds + ", value=" + value);
        try {
            this.mService.startSession(this.mContext.getActivityToken(), this.mServiceClient.asBinder(), id2, bounds, value, this.mContext.getUserId());
            AutoFillClient client = this.getClient();
            if (client != null) {
                client.resetableStateAvailable();
            }
            this.mHasSession = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void finishSession() {
        Log.v(TAG, "finishSession()");
        this.mHasSession = false;
        try {
            this.mService.finishSession(this.mContext.getActivityToken(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void updateSession(AutoFillId id2, Rect bounds, AutoFillValue value, int flags) {
        Log.v(TAG, "updateSession(): id=" + id2 + ", bounds=" + bounds + ", value=" + value + ", flags=" + flags);
        try {
            this.mService.updateSession(this.mContext.getActivityToken(), id2, bounds, value, flags, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void ensureServiceClientAddedIfNeeded() {
        if (this.getClient() == null) {
            return;
        }
        if (this.mServiceClient == null) {
            this.mServiceClient = new AutoFillManagerClient(this);
            try {
                this.mEnabled = this.mService.addClient(this.mServiceClient, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private static final class AutoFillManagerClient
    extends IAutoFillManagerClient.Stub {
        private final WeakReference<AutoFillManager> mAutoFillManager;

        AutoFillManagerClient(AutoFillManager autoFillManager) {
            this.mAutoFillManager = new WeakReference<AutoFillManager>(autoFillManager);
        }

        @Override
        public void setState(boolean enabled) {
            AutoFillManager autoFillManager = (AutoFillManager)this.mAutoFillManager.get();
            if (autoFillManager != null) {
                autoFillManager.mContext.getMainThreadHandler().post(AutoFillManager$AutoFillManagerClient$$Lambda$38.get$Lambda(autoFillManager, enabled));
            }
        }

        @Override
        public void autoFill(List<AutoFillId> ids, List<AutoFillValue> values) {
            AutoFillManager autoFillManager = (AutoFillManager)this.mAutoFillManager.get();
            if (autoFillManager != null) {
                autoFillManager.mContext.getMainThreadHandler().post(AutoFillManager$AutoFillManagerClient$$Lambda$39.get$Lambda(autoFillManager, ids, values));
            }
        }

        @Override
        public void authenticate(IntentSender intent, Intent fillInIntent) {
            AutoFillManager autoFillManager = (AutoFillManager)this.mAutoFillManager.get();
            if (autoFillManager != null) {
                autoFillManager.mContext.getMainThreadHandler().post(AutoFillManager$AutoFillManagerClient$$Lambda$40.get$Lambda(autoFillManager, intent, fillInIntent));
            }
        }

        static final /* synthetic */ void lambda$authenticate$4$AutoFillManager$AutoFillManagerClient(AutoFillManager autoFillManager, IntentSender intentSender, Intent intent) {
            if (autoFillManager.getClient() != null) {
                autoFillManager.getClient().authenticate(intentSender, intent);
            }
        }

        static final /* synthetic */ void lambda$autoFill$3$AutoFillManager$AutoFillManagerClient(AutoFillManager autoFillManager, List list, List list2) {
            if (autoFillManager.getClient() != null) {
                autoFillManager.getClient().autoFill(list, list2);
            }
        }

        static final /* synthetic */ void lambda$setState$2$AutoFillManager$AutoFillManagerClient(AutoFillManager autoFillManager, boolean bl) {
            autoFillManager.mEnabled = bl;
        }
    }

    public static interface AutoFillClient {
        public void autoFill(List<AutoFillId> var1, List<AutoFillValue> var2);

        public void authenticate(IntentSender var1, Intent var2);

        public void resetableStateAvailable();
    }
}

