/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.os.Parcel;
import android.os.Parcelable;

public final class AutoFillType
implements Parcelable {
    private static final int TYPE_TEXT = 1;
    private static final int TYPE_TOGGLE = 2;
    private static final int TYPE_LIST = 3;
    private final int mType;
    private final int mSubType;
    public static final Parcelable.Creator<AutoFillType> CREATOR = new Parcelable.Creator<AutoFillType>(){

        @Override
        public AutoFillType createFromParcel(Parcel source) {
            return new AutoFillType(source);
        }

        public AutoFillType[] newArray(int size) {
            return new AutoFillType[size];
        }
    };

    private AutoFillType(int type, int subType) {
        this.mType = type;
        this.mSubType = subType;
    }

    public boolean isText() {
        return this.mType == 1;
    }

    public boolean isToggle() {
        return this.mType == 2;
    }

    public boolean isList() {
        return this.mType == 3;
    }

    public int getSubType() {
        return this.mSubType;
    }

    public String toString() {
        return "AutoFillType [type=" + this.mType + ", subType=" + this.mSubType + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mSubType;
        result = 31 * result + this.mType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoFillType other = (AutoFillType)obj;
        if (this.mSubType != other.mSubType) {
            return false;
        }
        return this.mType == other.mType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mSubType);
    }

    private AutoFillType(Parcel parcel) {
        this.mType = parcel.readInt();
        this.mSubType = parcel.readInt();
    }

    public static AutoFillType forText(int inputType) {
        return new AutoFillType(1, inputType);
    }

    public static AutoFillType forToggle() {
        return DefaultTypesHolder.TOGGLE;
    }

    public static AutoFillType forList() {
        return DefaultTypesHolder.LIST;
    }

    private static class DefaultTypesHolder {
        static final AutoFillType TOGGLE = new AutoFillType(2, 0);
        static final AutoFillType LIST = new AutoFillType(3, 0);

        private DefaultTypesHolder() {
        }
    }
}

