/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.os.Parcel;
import android.os.Parcelable;

public final class AutoFillValue
implements Parcelable {
    private final String mText;
    private final int mListIndex;
    private final boolean mToggle;
    public static final Parcelable.Creator<AutoFillValue> CREATOR = new Parcelable.Creator<AutoFillValue>(){

        @Override
        public AutoFillValue createFromParcel(Parcel source) {
            return new AutoFillValue(source);
        }

        public AutoFillValue[] newArray(int size) {
            return new AutoFillValue[size];
        }
    };

    private AutoFillValue(CharSequence text, int listIndex, boolean toggle) {
        this.mText = text == null ? null : text.toString();
        this.mListIndex = listIndex;
        this.mToggle = toggle;
    }

    public CharSequence getTextValue() {
        return this.mText;
    }

    public boolean getToggleValue() {
        return this.mToggle;
    }

    public int getListValue() {
        return this.mListIndex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mListIndex;
        result = 31 * result + (this.mText == null ? 0 : this.mText.hashCode());
        result = 31 * result + (this.mToggle ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoFillValue other = (AutoFillValue)obj;
        if (this.mListIndex != other.mListIndex) {
            return false;
        }
        if (this.mText == null ? other.mText != null : !this.mText.equals(other.mText)) {
            return false;
        }
        return this.mToggle == other.mToggle;
    }

    public String coerceToString() {
        return this.mText;
    }

    public String toString() {
        if (this.mText != null) {
            return this.mText.length() + "_chars";
        }
        return "[listIndex=" + this.mListIndex + ", toggle=" + this.mToggle + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mText);
        parcel.writeInt(this.mListIndex);
        parcel.writeInt(this.mToggle ? 1 : 0);
    }

    private AutoFillValue(Parcel parcel) {
        this.mText = parcel.readString();
        this.mListIndex = parcel.readInt();
        this.mToggle = parcel.readInt() == 1;
    }

    public static AutoFillValue forText(CharSequence value) {
        return value == null ? null : new AutoFillValue(value, 0, false);
    }

    public static AutoFillValue forToggle(boolean value) {
        return new AutoFillValue(null, 0, value);
    }

    public static AutoFillValue forList(int value) {
        return new AutoFillValue(null, value, false);
    }
}

