/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.view.textclassifier.EntityConfidence$$Lambda$43;
import android.view.textclassifier.EntityConfidence$$Lambda$44;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class EntityConfidence<T> {
    private final Map<T, Float> mEntityConfidence = new HashMap<T, Float>();
    private final Comparator<T> mEntityComparator;

    EntityConfidence() {
        this.mEntityComparator = EntityConfidence$$Lambda$43.get$Lambda(this);
    }

    EntityConfidence(EntityConfidence<T> source) {
        this.mEntityComparator = EntityConfidence$$Lambda$44.get$Lambda(this);
        Preconditions.checkNotNull(source);
        this.mEntityConfidence.putAll(source.mEntityConfidence);
    }

    public void setEntityType(T type, float confidenceScore) {
        Preconditions.checkNotNull(type);
        if (confidenceScore > 0.0f) {
            this.mEntityConfidence.put(type, Float.valueOf(Math.min(1.0f, confidenceScore)));
        } else {
            this.mEntityConfidence.remove(type);
        }
    }

    public List<T> getEntities() {
        ArrayList<T> entities = new ArrayList<T>(this.mEntityConfidence.size());
        entities.addAll(this.mEntityConfidence.keySet());
        entities.sort(this.mEntityComparator);
        return Collections.unmodifiableList(entities);
    }

    public float getConfidenceScore(T entity) {
        if (this.mEntityConfidence.containsKey(entity)) {
            return this.mEntityConfidence.get(entity).floatValue();
        }
        return 0.0f;
    }

    public String toString() {
        return this.mEntityConfidence.toString();
    }

    final /* synthetic */ int lambda$new$20$EntityConfidence(Object e1, Object e2) {
        float score2;
        float score1 = this.mEntityConfidence.get(e1).floatValue();
        if (score1 > (score2 = this.mEntityConfidence.get(e2).floatValue())) {
            return 1;
        }
        if (score1 < score2) {
            return -1;
        }
        return 0;
    }
}

