/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.textclassifier.LangId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierImpl;
import android.view.textclassifier.TextLanguage;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class TextClassificationManager {
    private static final String LOG_TAG = "TextClassificationManager";
    private final Object mTextClassifierLock = new Object();
    private final Object mLangIdLock = new Object();
    private final Context mContext;
    private ParcelFileDescriptor mSmartSelectionFd;
    private ParcelFileDescriptor mLangIdFd;
    private TextClassifier mDefault;
    private LangId mLangId;

    public TextClassificationManager(Context context) {
        this.mContext = Preconditions.checkNotNull(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextClassifier getDefaultTextClassifier() {
        Object object = this.mTextClassifierLock;
        synchronized (object) {
            if (this.mDefault == null) {
                try {
                    this.mSmartSelectionFd = ParcelFileDescriptor.open(new File("/etc/assistant/smart-selection.model"), 0x10000000);
                    this.mDefault = new TextClassifierImpl(this.mContext, this.mSmartSelectionFd);
                }
                catch (FileNotFoundException e) {
                    Log.e(LOG_TAG, "Error accessing 'text classifier selection' model file.", e);
                    this.mDefault = TextClassifier.NO_OP;
                }
            }
            return this.mDefault;
        }
    }

    public List<TextLanguage> detectLanguages(CharSequence text) {
        Preconditions.checkArgument(text != null);
        try {
            if (text.length() > 0) {
                String language = this.getLanguageDetector().findLanguage(text.toString());
                Locale locale = new Locale.Builder().setLanguageTag(language).build();
                return Collections.unmodifiableList(Arrays.asList(new TextLanguage.Builder(0, text.length()).setLanguage(locale, 1.0f).build()));
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error detecting languages for text. Returning empty result.", t);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LangId getLanguageDetector() throws FileNotFoundException {
        Object object = this.mLangIdLock;
        synchronized (object) {
            if (this.mLangId == null) {
                this.mLangIdFd = ParcelFileDescriptor.open(new File("/etc/assistant/lang-id.model"), 0x10000000);
                this.mLangId = new LangId(this.mLangIdFd.getFd());
            }
            return this.mLangId;
        }
    }
}

