/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.WordIterator;
import android.text.style.ClickableSpan;
import android.util.Log;
import android.view.View;
import android.view.textclassifier.LinksInfo;
import android.view.textclassifier.SmartSelection;
import android.view.textclassifier.TextClassificationResult;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierImpl$LinksInfoFactory$$Lambda$47;
import android.view.textclassifier.TextSelection;
import com.android.internal.util.Preconditions;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

final class TextClassifierImpl
implements TextClassifier {
    private static final String LOG_TAG = "TextClassifierImpl";
    private final Object mSmartSelectionLock = new Object();
    private final Context mContext;
    private final ParcelFileDescriptor mFd;
    private SmartSelection mSmartSelection;

    TextClassifierImpl(Context context, ParcelFileDescriptor fd) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mFd = Preconditions.checkNotNull(fd);
    }

    @Override
    public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex) {
        TextClassifierImpl.validateInput(text, selectionStartIndex, selectionEndIndex);
        try {
            if (text.length() > 0) {
                String string2 = text.toString();
                int[] startEnd = this.getSmartSelection().suggest(string2, selectionStartIndex, selectionEndIndex);
                int start = startEnd[0];
                int end = startEnd[1];
                if (start >= 0 && end <= string2.length() && start <= end) {
                    String type = this.getSmartSelection().classifyText(string2, start, end);
                    return new TextSelection.Builder(start, end).setEntityType(type, 1.0f).build();
                }
                Log.d(LOG_TAG, "Got bad indices for input text. Ignoring result.");
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error suggesting selection for text. No changes to selection suggested.", t);
        }
        return TextClassifier.NO_OP.suggestSelection(text, selectionStartIndex, selectionEndIndex);
    }

    @Override
    public TextClassificationResult getTextClassificationResult(CharSequence text, int startIndex, int endIndex) {
        TextClassifierImpl.validateInput(text, startIndex, endIndex);
        try {
            if (text.length() > 0) {
                CharSequence classified = text.subSequence(startIndex, endIndex);
                String type = this.getSmartSelection().classifyText(text.toString(), startIndex, endIndex);
                if (!TextUtils.isEmpty(type)) {
                    type = type.toLowerCase(Locale.ENGLISH).trim();
                    Log.d(LOG_TAG, String.format("Classification type: %s", type));
                    return this.createClassificationResult(type, classified);
                }
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error getting assist info.", t);
        }
        return TextClassifier.NO_OP.getTextClassificationResult(text, startIndex, endIndex);
    }

    @Override
    public LinksInfo getLinks(CharSequence text, int linkMask) {
        Preconditions.checkArgument(text != null);
        try {
            return LinksInfoFactory.create(this.mContext, this.getSmartSelection(), text.toString(), linkMask);
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error getting links info.", t);
            return TextClassifier.NO_OP.getLinks(text, linkMask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmartSelection getSmartSelection() throws FileNotFoundException {
        Object object = this.mSmartSelectionLock;
        synchronized (object) {
            if (this.mSmartSelection == null) {
                this.mSmartSelection = new SmartSelection(this.mFd.getFd());
            }
            return this.mSmartSelection;
        }
    }

    private TextClassificationResult createClassificationResult(String type, CharSequence text) {
        ResolveInfo resolveInfo;
        PackageManager pm;
        TextClassificationResult.Builder builder = new TextClassificationResult.Builder().setText(text.toString()).setEntityType(type, 1.0f);
        Intent intent = IntentFactory.create(this.mContext, type, text.toString());
        if (intent != null) {
            pm = this.mContext.getPackageManager();
            resolveInfo = pm.resolveActivity(intent, 0);
        } else {
            pm = null;
            resolveInfo = null;
        }
        if (resolveInfo != null && resolveInfo.activityInfo != null) {
            builder.setIntent(intent).setOnClickListener(TextClassificationResult.createStartActivityOnClickListener(this.mContext, intent));
            String packageName = resolveInfo.activityInfo.packageName;
            if ("android".equals(packageName)) {
                builder.setLabel(IntentFactory.getLabel(this.mContext, type));
            } else {
                intent.setComponent(new ComponentName(packageName, resolveInfo.activityInfo.name));
                Drawable icon = resolveInfo.activityInfo.loadIcon(pm);
                if (icon == null) {
                    icon = resolveInfo.loadIcon(pm);
                }
                builder.setIcon(icon);
                CharSequence label = resolveInfo.activityInfo.loadLabel(pm);
                if (label == null) {
                    label = resolveInfo.loadLabel(pm);
                }
                builder.setLabel(label != null ? label.toString() : null);
            }
        }
        return builder.build();
    }

    private static void validateInput(CharSequence text, int startIndex, int endIndex) {
        Preconditions.checkArgument(text != null);
        Preconditions.checkArgument(startIndex >= 0);
        Preconditions.checkArgument(endIndex <= text.length());
        Preconditions.checkArgument(endIndex >= startIndex);
    }

    private static final class IntentFactory {
        private IntentFactory() {
        }

        public static Intent create(Context context, String type, String text) {
            switch (type) {
                case "email": {
                    return new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("mailto:%s", text)));
                }
                case "phone": {
                    return new Intent("android.intent.action.DIAL").setData(Uri.parse(String.format("tel:%s", text)));
                }
                case "address": {
                    return new Intent("android.intent.action.VIEW").setData(Uri.parse(String.format("geo:0,0?q=%s", text)));
                }
                case "url": {
                    return new Intent("android.intent.action.VIEW", Uri.parse(text)).putExtra("com.android.browser.application_id", context.getPackageName());
                }
            }
            return null;
        }

        public static String getLabel(Context context, String type) {
            switch (type) {
                case "email": {
                    return context.getString(17039770);
                }
                case "phone": {
                    return context.getString(17039740);
                }
                case "address": {
                    return context.getString(17040123);
                }
                case "url": {
                    return context.getString(17039553);
                }
            }
            return null;
        }
    }

    private static final class LinksInfoFactory {
        private LinksInfoFactory() {
        }

        public static LinksInfo create(Context context, SmartSelection smartSelection, String text, int linkMask) {
            int end;
            WordIterator wordIterator = new WordIterator();
            wordIterator.setCharSequence(text, 0, text.length());
            ArrayList<SpanSpec> spans = new ArrayList<SpanSpec>();
            int start = 0;
            while ((end = wordIterator.nextBoundary(start)) != -1) {
                Intent intent;
                String type;
                String token = text.substring(start, end);
                if (TextUtils.isEmpty(token)) continue;
                int[] selection = smartSelection.suggest(text, start, end);
                int selectionStart = selection[0];
                int selectionEnd = selection[1];
                if (selectionStart >= 0 && selectionEnd <= text.length() && selectionStart <= selectionEnd && LinksInfoFactory.matches(type = smartSelection.classifyText(text, selectionStart, selectionEnd), linkMask) && LinksInfoFactory.hasActivityHandler(context, intent = IntentFactory.create(context, type, text.substring(selectionStart, selectionEnd)))) {
                    ClickableSpan span = LinksInfoFactory.createSpan(context, intent);
                    spans.add(new SpanSpec(selectionStart, selectionEnd, span));
                }
                start = end;
            }
            return new LinksInfoImpl(text, LinksInfoFactory.avoidOverlaps(spans, text));
        }

        private static boolean matches(String type, int linkMask) {
            if ((linkMask & 4) != 0 && "phone".equals(type)) {
                return true;
            }
            if ((linkMask & 2) != 0 && "email".equals(type)) {
                return true;
            }
            if ((linkMask & 8) != 0 && "address".equals(type)) {
                return true;
            }
            return (linkMask & 1) != 0 && "url".equals(type);
        }

        private static List<SpanSpec> avoidOverlaps(List<SpanSpec> spans, String text) {
            Collections.sort(spans, Comparator.comparingInt(TextClassifierImpl$LinksInfoFactory$$Lambda$47.get$Lambda()));
            LinkedHashMap<Integer, SpanSpec> reps = new LinkedHashMap<Integer, SpanSpec>();
            int size = spans.size();
            for (int i = 0; i < size; ++i) {
                SpanSpec span = spans.get(i);
                SpanSpec rep = (SpanSpec)reps.get(span.mStart);
                if (rep != null && rep.mEnd >= span.mEnd) continue;
                reps.put(span.mStart, span);
            }
            LinkedList<SpanSpec> result = new LinkedList<SpanSpec>();
            for (SpanSpec rep : reps.values()) {
                if (result.isEmpty()) {
                    result.add(rep);
                    continue;
                }
                SpanSpec last = result.getLast();
                if (rep.mStart < last.mEnd) {
                    if (rep.mEnd - rep.mStart <= last.mEnd - last.mStart) continue;
                    result.set(result.size() - 1, rep);
                    continue;
                }
                result.add(rep);
            }
            return result;
        }

        private static ClickableSpan createSpan(final Context context, final Intent intent) {
            return new ClickableSpan(){

                @Override
                public void onClick(View widget) {
                    context.startActivity(intent);
                }
            };
        }

        private static boolean hasActivityHandler(Context context, Intent intent) {
            if (intent == null) {
                return false;
            }
            ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 0);
            return resolveInfo != null && resolveInfo.activityInfo != null;
        }

        static final /* synthetic */ int lambda$avoidOverlaps$39$TextClassifierImpl$LinksInfoFactory(SpanSpec span) {
            return span.mStart;
        }

        private static final class SpanSpec {
            private final int mStart;
            private final int mEnd;
            private final ClickableSpan mSpan;

            SpanSpec(int start, int end, ClickableSpan span) {
                this.mStart = start;
                this.mEnd = end;
                this.mSpan = span;
            }
        }

        private static final class LinksInfoImpl
        implements LinksInfo {
            private final CharSequence mOriginalText;
            private final List<SpanSpec> mSpans;

            LinksInfoImpl(CharSequence originalText, List<SpanSpec> spans) {
                this.mOriginalText = originalText;
                this.mSpans = spans;
            }

            @Override
            public boolean apply(CharSequence text) {
                Preconditions.checkArgument(text != null);
                if (text instanceof Spannable && this.mOriginalText.toString().equals(text.toString())) {
                    Spannable spannable = (Spannable)text;
                    int size = this.mSpans.size();
                    for (int i = 0; i < size; ++i) {
                        SpanSpec span = this.mSpans.get(i);
                        spannable.setSpan(span.mSpan, span.mStart, span.mEnd, 0);
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

