/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.view.textclassifier.EntityConfidence;
import com.android.internal.util.Preconditions;
import java.util.List;

public final class TextSelection {
    private final int mStartIndex;
    private final int mEndIndex;
    private final EntityConfidence<String> mEntityConfidence;
    private final List<String> mEntities;

    private TextSelection(int startIndex, int endIndex, EntityConfidence<String> entityConfidence) {
        this.mStartIndex = startIndex;
        this.mEndIndex = endIndex;
        this.mEntityConfidence = new EntityConfidence<String>(entityConfidence);
        this.mEntities = this.mEntityConfidence.getEntities();
    }

    public int getSelectionStartIndex() {
        return this.mStartIndex;
    }

    public int getSelectionEndIndex() {
        return this.mEndIndex;
    }

    public int getEntityCount() {
        return this.mEntities.size();
    }

    public String getEntity(int index) {
        return this.mEntities.get(index);
    }

    public float getConfidenceScore(String entity) {
        return this.mEntityConfidence.getConfidenceScore(entity);
    }

    public String toString() {
        return String.format("TextSelection {%d, %d, %s}", this.mStartIndex, this.mEndIndex, this.mEntityConfidence);
    }

    public static final class Builder {
        private final int mStartIndex;
        private final int mEndIndex;
        private final EntityConfidence<String> mEntityConfidence = new EntityConfidence();

        public Builder(int startIndex, int endIndex) {
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex > startIndex);
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
        }

        public Builder setEntityType(String type, float confidenceScore) {
            this.mEntityConfidence.setEntityType(type, confidenceScore);
            return this;
        }

        public TextSelection build() {
            return new TextSelection(this.mStartIndex, this.mEndIndex, this.mEntityConfidence);
        }
    }
}

